////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <process.h>

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

extern int __WD_Present;

int
	program_argc;

char
	**program_argv,
	*program_filename,
	*program_path;

FILE
	*boot_log;

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void text_mode (void)
{
	union REGS
		r;

	r.x.ax = 0x0003;
	int86 (0x10, &r, &r);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void display_help_information (void)
{
	FILE
		*fp;

	int
		line;

	char
		buffer[1000];

	fp = fopen ("go.hlp", "rb");

	if (fp)
	{
		line = 0;
	
		while (fgets (buffer, 1000, fp))
		{
			printf (buffer);
			line ++;
			if (line == 22)
			{
				_bios_keybrd (0);
				line = 0;
			}
		}

		fclose (fp);
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void major_error (void)
{
	printf ("Major Error - please contact technical support.\n\n");

	exit (1);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void open_boot_log (void)
{
	char
		buffer[100];

	sprintf (buffer, "%s%s", program_path, "boot.log");

	boot_log = fopen (buffer, "w");

	if (boot_log == 0)
	{
		printf ("Bad Boot");

		major_error ();
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void checksum_file (char *filename)
{
	FILE
		*fp;
	char
		buffer[1024];
	int
		sum,
		count,
		loop;

	sum = 0;

	fp = fopen (filename, "rb");
	if (fp)
	{
		do
		{
			count = fread (buffer, 1, 1024, fp);
			for (loop = 0; loop < count; loop ++)
			{
				sum ^= buffer[loop];
			}
		}
		while (count);

		fprintf (boot_log, "Check Sum = %04x\n\n", sum);

		fclose (fp);
	}
	else
	{
		fprintf (boot_log, "Invalid Executable\n\n");
		major_error ();
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void setup_the_environment (void)
{
	char
		*old_dos4gvm_env;

	char
		buffer[100];

	old_dos4gvm_env = getenv ("DOS4GVM");

	if (old_dos4gvm_env)
	{
		old_dos4gvm_env = strdup (old_dos4gvm_env);
	}

	if (setenv ("DOS4GVM", "virtualsize#24576 MINMEM#6144 DELETESWAP SWAPNAME#.\\apache.swp", 1) != 0)
	{
		fprintf (boot_log, "Out of environment spaec");
		major_error ();
	}

	fprintf (boot_log, "DOS4G=%s\n", getenv ("DOS4G"));
	fprintf (boot_log, "DOS4GVM=%s\n", getenv ("DOS4GVM"));
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void load_main_program (void)
{
	int
		loop;
	char
		*arguments[20];

	arguments[0] = "go.ovl";

	for (loop = 1; loop < program_argc; loop ++)
	{
		if (loop < 19)
		{
			arguments[loop] = program_argv[loop];
		}
	}

	arguments[loop] = 0;

	fprintf (boot_log, "\nRunning\n\n");
	
	for (loop = 0; loop < 20; loop ++)
	{
		if (arguments[loop] == 0)
		{
			break;
		}
		fprintf (boot_log, "%d: %s\n", loop, arguments[loop]);
	}
	fprintf (boot_log, "\n");

	fclose (boot_log);

	spawnvp (P_WAIT, arguments[0], (char **) arguments);

	printf ("\nThankyou\n\n");
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void check_command_line_arguments (int argc, char **argv)
{
	char
		*s;

	while (-- argc)
	{
		s = * ++ argv;

		switch ( * ( s + 1 ) )
		{
			case '?':
			{
				display_help_information ();

				exit (EXIT_SUCCESS);
			}

			////////////////////////////////////////
			default:
			////////////////////////////////////////
			{
				break;
			}
		}
	}
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void main (int argc, char **argv)
{
	char
		*av[4],
		cmdline[128],
		*ptr;

	text_mode ();

	printf ("DOS/4GW Professional Protected Mode Run-Time Version 1.97\n");
	printf ("Copyright (c) Rational Systems, Inc. 1990-1994\n\n");

	printf ("Loading Apache Gunship 95...\n(%s)\n", __DATE__);

	program_argc = argc;
	program_argv = argv;

	if (__WD_Present)
	{
		argv[0] = "E:\\apache\\go.ovl";
	}

	program_filename = argv[0];
	program_path = strdup (argv[0]);

	ptr = strrchr (program_path, '\\');
	if (*ptr)
	{
		ptr ++;
		*ptr = 0;
	}

	open_boot_log ();

	check_command_line_arguments (argc, argv);

	checksum_file (program_filename);
	
	setup_the_environment ();

	load_main_program ();
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
