	.386

	.MODEL	flat,stdcall

EXTERN C g_addr:PTR DWORD
EXTERN C SCR_PTR:PTR DWORD
EXTERN C draw_line_tb:PTR DWORD
EXTERN C draw_line1:PTR DWORD
EXTERN C draw_line2:PTR DWORD
EXTERN C scaletab:PTR DWORD
EXTERN C depth_tab:PTR DWORD
EXTERN C interpol_tab:PTR DWORD

ACB		STRUCT

	s_xsize	       	SWORD	1
	s_scr_xpos     	SWORD	1
	s_scr_ypos     	SWORD	1
	s_xscale       	DWORD	1
	s_yscale       	DWORD	1
	s_xloop	       	SWORD	1
	s_yloop	       	SWORD	1
	s_init_xscale  	DWORD	1
	s_init_yscale  	DWORD	1
	s_dataoff      	DWORD	1
	s_ylines      	SWORD	1

ACB		ENDS

;	INCLUDE	aglobals.h

	.DATA

SCRWID	EQU	320

rorcnt		dw	0
ediadd		dword	0
esiadd		dword	0
xloop		dw	0
xloops		dw	0
yloop		dw	0
ylines1		dword	0
ylines2		dword	0
xstart		sword	0
ystart		sword	0
xscale		dword	0
yscale		dword	0
yscales		dword	0
scale_x		dword	0
scale_y		dword	0
scale		sword	0
yscaleadd	dword	0
whole		dword	0
xsize		dword	0
sesi		dword	0
sedi		dword	0
depth_ptr	dword	0
frac		sword	0
yadd1		dword	0
yadd2		dword	0

	.CODE

; Values go into EAX, EDX, EBX, ECX.
; After these four, values get pushed onto the stack.

;*************************************************************
;* Shrink sprite routine (less than x1/4) without depth cue. *
;*************************************************************

spr_14_ndc_	PROC C PUBLIC

	pushad

	movzx	edx,[eax+acb.s_scr_ypos]	; Get sprite X pos.
	movzx	ecx,[eax+acb.s_scr_xpos]       	; Get sprite Y pos.

	imul	edx,SCRWID                     	; Screen width.

	mov 	edi,SCR_PTR                  	;
	add	ecx,edx                         ; Get sprite screen address.
	add	edi,ecx                         ;

	mov	esi,g_addr         	; Graphics address.
	add	esi,[eax+acb.s_dataoff]		;

	mov	ecx,[eax+acb.s_init_yscale]	; Y clipped scale value.
	mov	yscale,ecx                      ;

	mov	ecx,[eax+acb.s_yscale]         	; Store Y scale.
	mov	scale_y,ecx                     ;

	mov	cx,[eax+acb.s_xloop]           	; X loop.
	mov	xloops,cx                       ;

	mov	cx,[eax+acb.s_yloop]          	; Y loop.
	mov	yloop,cx                        ;

	movzx	ecx,[eax+acb.s_xsize]        	; Sprite X size.
	mov	xsize,ecx                       ;

@@yloop:
	mov	ebp,edi			; Store screen address.

	mov	ah,BYTE PTR xloops	; Setup X-loop count.

	mov	edx,OFFSET scaletab	; Graphics offset table.
@@xloop:
	mov	ebx,[edx]		; Get graphics offset.

	mov	al,[esi+ebx]            ;
	or	al,al                   ; Get pixel and test for see through.
	jz	@@noplot                ;

	mov	[edi],al		; Store pixel.

@@noplot:
	add	edx,4		; Get to next graphics offset.
	inc	edi            	; Next screen pixel.

	dec	ah		; Draw whole row.
	jnz	@@xloop		;

	mov	edi,ebp		; Restore screen address.

 	mov	eax,yscale      ;
	and	eax,0ffffh      ;
	add	eax,scale_y     ; Calculate new Y scale value.
	mov	yscale,eax      ;
	shr	eax,16          ;

	mov	ecx,xsize       ;
	imul	eax,ecx         ; Next graphic data line.
	add	esi,eax       	;

	add	edi,SCRWID	; Next screen line.

	dec	yloop		; Draw whole sprite.
	jnz	@@yloop         ;

@@sp14_end:

	popad
	ret

spr_14_ndc_	ENDP

;*****************************************
;* Shrink sprite routine with depth cue. *
;*****************************************

spr_14_	PROC C PUBLIC

	pushad

	movzx	edx,[eax+acb.s_scr_ypos]	; Get sprite X pos.
	movzx	ecx,[eax+acb.s_scr_xpos]       	; Get sprite Y pos.

	imul	edx,SCRWID                     	; Screen width.

	mov 	edi,SCR_PTR                  	;
	add	ecx,edx                         ; Get sprite screen address.
	add	edi,ecx                         ;

	mov	esi,g_addr         	; Graphics address.
	add	esi,[eax+acb.s_dataoff]		;

	mov	ecx,[eax+acb.s_init_yscale]	; Y clipped scale value.
	mov	yscale,ecx                      ;

	mov	ecx,[eax+acb.s_yscale]         	; Store Y scale.
	mov	scale_y,ecx                     ;

	mov	cx,[eax+acb.s_xloop]           	; X loop.
	mov	xloops,cx                       ;

	mov	cx,[eax+acb.s_yloop]          	; Y loop.
	mov	yloop,cx                        ;

	movzx	ecx,[eax+acb.s_xsize]        	; Sprite X size.
	mov	xsize,ecx                       ;

	mov	ebx,depth_tab
@@yloop:
	mov	sedi,edi    		; Store screen address.

	mov	ah,BYTE PTR xloops	; Setup X-loop count.

	mov	edx,OFFSET scaletab	; Graphics offset table.
@@xloop:
	mov	ebp,[edx]		; Get graphics offset.

	mov	al,[esi+ebp]            ;
	or	al,al                   ; Get pixel and test for see through.
	jz	@@noplot                ;

	xlatb				; Get depth que value.
	mov	[edi],al		; Store pixel.

@@noplot:
	add	edx,4		; Get to next graphics offset.
	inc	edi            	; Next screen pixel.

	dec	ah		; Draw whole row.
	jnz	@@xloop		;

	mov	edi,sedi	; Restore screen address.

 	mov	eax,yscale      ;
	and	eax,0ffffh      ;
	add	eax,scale_y     ; Calculate new Y scale value.
	mov	yscale,eax      ;
	shr	eax,16          ;

	mov	ecx,xsize       ;
	imul	eax,ecx         ; Next graphic data line.
	add	esi,eax       	;

	add	edi,SCRWID	; Next screen line.

	dec	yloop		; Draw whole sprite.
	jnz	@@yloop         ;

@@sp14_end:

	popad
	ret

spr_14_	ENDP

;*************************************************************
;* Shrink sprite routine with transparency and no depth que. *
;*************************************************************

spr_14_trans_ndc_	PROC C PUBLIC

	pushad

	movzx	edx,[eax+acb.s_scr_ypos]	; Get sprite X pos.
	movzx	ecx,[eax+acb.s_scr_xpos]       	; Get sprite Y pos.

	imul	edx,SCRWID                     	; Screen width.

	mov 	edi,SCR_PTR                  	;
	add	ecx,edx                         ; Get sprite screen address.
	add	edi,ecx                         ;

	mov	esi,g_addr         	; Graphics address.
	add	esi,[eax+acb.s_dataoff]		;

	mov	ecx,[eax+acb.s_init_yscale]	; Y clipped scale value.
	mov	yscale,ecx                      ;

	mov	ecx,[eax+acb.s_yscale]         	; Store Y scale.
	mov	scale_y,ecx                     ;

	mov	cx,[eax+acb.s_xloop]           	; X loop.
	mov	xloops,cx                       ;

	mov	cx,[eax+acb.s_yloop]          	; Y loop.
	mov	yloop,cx                        ;

	movzx	ecx,[eax+acb.s_xsize]        	; Sprite X size.
	mov	xsize,ecx                       ;

@@yloop:
	mov	sedi,edi    		; Store screen address.

	mov	ah,BYTE PTR xloops	; Setup X-loop count.

	mov	edx,OFFSET scaletab	; Graphics offset table.
@@xloop:
	mov	ebp,[edx]		; Get graphics offset.

	mov	al,[esi+ebp]            ;
	or	al,al                   ; Get pixel and test for see through.
	jz	@@noplot                ;

	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
;	add	ebx,OFFSET interpol_tab     	;
	add	ebx,interpol_tab     	;

	xlatb				; Get depth que value.
	mov	[edi],al		; Store pixel.

@@noplot:
	add	edx,4		; Get to next graphics offset.
	inc	edi            	; Next screen pixel.

	dec	ah		; Draw whole row.
	jnz	@@xloop		;

	mov	edi,sedi	; Restore screen address.

 	mov	eax,yscale      ;
	and	eax,0ffffh      ;
	add	eax,scale_y     ; Calculate new Y scale value.
	mov	yscale,eax      ;
	shr	eax,16          ;

	mov	ecx,xsize       ;
	imul	eax,ecx         ; Next graphic data line.
	add	esi,eax       	;

	add	edi,SCRWID	; Next screen line.

	dec	yloop		; Draw whole sprite.
	jnz	@@yloop         ;

@@sp14_end:

	popad
	ret

spr_14_trans_ndc_	ENDP

;**********************************************************
;* Shrink sprite routine with transparency and depth que. *
;**********************************************************

spr_14_trans_	PROC C PUBLIC

	pushad

	movzx	edx,[eax+acb.s_scr_ypos]	; Get sprite X pos.
	movzx	ecx,[eax+acb.s_scr_xpos]       	; Get sprite Y pos.

	imul	edx,SCRWID                     	; Screen width.

	mov 	edi,SCR_PTR                  	;
	add	ecx,edx                         ; Get sprite screen address.
	add	edi,ecx                         ;

	mov	esi,g_addr         	; Graphics address.
	add	esi,[eax+acb.s_dataoff]		;

	mov	ecx,[eax+acb.s_init_yscale]	; Y clipped scale value.
	mov	yscale,ecx                      ;

	mov	ecx,[eax+acb.s_yscale]         	; Store Y scale.
	mov	scale_y,ecx                     ;

	mov	cx,[eax+acb.s_xloop]           	; X loop.
	mov	xloops,cx                       ;

	mov	cx,[eax+acb.s_yloop]          	; Y loop.
	mov	yloop,cx                        ;

	movzx	ecx,[eax+acb.s_xsize]        	; Sprite X size.
	mov	xsize,ecx                       ;

@@yloop:
	mov	sedi,edi    		; Store screen address.

	mov	ah,BYTE PTR xloops	; Setup X-loop count.

	mov	edx,OFFSET scaletab	; Graphics offset table.
@@xloop:
	mov	ebp,[edx]		; Get graphics offset.

	mov	al,[esi+ebp]            ;
	or	al,al                   ; Get pixel and test for see through.
	jz	@@noplot                ;

	mov	ebx,depth_tab		; Get depth que value.
	xlatb                           ;

	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
;	add	ebx,OFFSET interpol_tab     	;
	add	ebx,interpol_tab     	;

	xlatb				; Get depth que value.
	mov	[edi],al		; Store pixel.

@@noplot:
	add	edx,4		; Get to next graphics offset.
	inc	edi            	; Next screen pixel.

	dec	ah		; Draw whole row.
	jnz	@@xloop		;

	mov	edi,sedi	; Restore screen address.

 	mov	eax,yscale      ;
	and	eax,0ffffh      ;
	add	eax,scale_y     ; Calculate new Y scale value.
	mov	yscale,eax      ;
	shr	eax,16          ;

	mov	ecx,xsize       ;
	imul	eax,ecx         ; Next graphic data line.
	add	esi,eax       	;

	add	edi,SCRWID	; Next screen line.

	dec	yloop		; Draw whole sprite.
	jnz	@@yloop         ;

@@sp14_end:

	popad
	ret

spr_14_trans_	ENDP

;**************************
;* Expand sprite routine. *
;**************************

size_sprite_	PROC C PUBLIC

	cld                             ; Clear direction flag.

	pushad                         	; Store all registers.

	movzx	ebx,[eax+acb.s_ylines]	; Minimum Y lines to draw.
	mov	ylines1,ebx
	mov	ebp,eax                 ; Store EAX.

	mov	edi,draw_line_tb 	; Create routine to draw tob/bottom line(s) of sprite.
 	call	create_draw_tb_line	;

	mov	eax,ebp			; Restore EAX.
	mov	edi,draw_line1

	mov	ebx,ylines1
	cmp	ebx,2
	jge	@@y2

@@y1:
	mov	yadd1,SCRWID
	mov	yadd2,SCRWID*2

 	call	create_draw_1line     	;
	mov	edi,draw_line2          ;
	mov	eax,ebp                 ; Create routines for x2 - x3 sprites.
	call	create_draw_2lines	;
	jmp	@@cdl_done              ;

@@y2:
	cmp	ebx,3
	jge	@@y3

	mov	yadd1,SCRWID*2
	mov	yadd2,SCRWID*3

 	call	create_draw_2lines     	;
	mov	edi,draw_line2          ;
	mov	eax,ebp                 ; Create routines for x2 - x3 sprites.
	call	create_draw_3lines      ;
	jmp	@@cdl_done              ;

@@y3:
	cmp	ebx,4
	jge	@@y4

	mov	yadd1,SCRWID*3
	mov	yadd2,SCRWID*4

	call	create_draw_3lines      ;
	mov	edi,draw_line2          ;
	mov	eax,ebp                 ; Create routines for x3 - x4 sprites.
 	call	create_draw_4lines      ;
	jmp	@@cdl_done              ;

@@y4:
	cmp	ebx,5
	jge	@@y5

	mov	yadd1,SCRWID*4
	mov	yadd2,SCRWID*5

	call	create_draw_4lines     	;
	mov	edi,draw_line2          ;
	mov	eax,ebp                 ; Create routines for x4 - x5 sprites.
 	call	create_draw_5lines      ;
	jmp	@@cdl_done              ;

@@y5:
	mov	yadd1,SCRWID*5
	mov	yadd2,SCRWID*6

	call	create_draw_5lines  	;
	mov	edi,draw_line2          ;
	mov	eax,ebp                 ; Create routines for x5 - x6 sprites.
 	call	create_draw_6lines      ;

@@cdl_done:
	mov	eax,ebp                 	; Restore EAX.

	movzx	ecx,[eax+acb.s_scr_xpos] 	; Get screen X pos.
	movzx	edx,[eax+acb.s_scr_ypos]	; Get screen Y pos.

	imul	edx,SCRWID              	;
	mov 	edi,SCR_PTR          		;
	add	ecx,edx                 	; Get screen offset

	mov	esi,g_addr              	;
	add	esi,[eax+acb.s_dataoff]         ; Get graphics address.

	add	edi,ecx                 	; Add screen offset to screen address.

	mov	ebx,[eax+acb.s_yscale]     	;
	mov	scale,bx 	            	; Store Y scale.

	mov	ecx,[eax+acb.s_init_yscale] 	; Get clipped Y scale value.
	and	ecx,0ffffh                      ; Keep fraction.

	mov	bx,[eax+acb.s_yloop]
	mov	yloop,bx

	movzx	eax,[eax+acb.s_xsize]   ;
	mov	xsize,eax  		; Get sprite X size.

@@yloop:
	xor	eax,eax		; Set Y lines count to 0.
@@count:
	inc	eax		; Increase Y lines count.

	dec	yloop		; Decrease Y count.
	jz	@@last		;

	add   	cx,scale        ; Next graphic data line?
	jnc	@@count         ; No!

	cmp	eax,ylines1
	jl	@@singles
	je	@@dl1

@@dl2:
	mov	ebp,esi    	; Store esi.
	mov	sedi,edi       	; Store edi.

	call	draw_line2	; Draw a line of sprite.

	mov	edi,sedi    	; Restore edi.
	mov	esi,ebp		; Restore esi.

	add	edi,yadd2	; Next screen line.
	jmp	@@drawn

@@dl1:
	mov	ebp,esi    	; Store esi.
	mov	sedi,edi       	; Store edi.

	call	draw_line1	; Draw a line of sprite.

	mov	edi,sedi    	; Restore edi.
	mov	esi,ebp		; Restore esi.

	add	edi,yadd1	; Next screen line.
	jmp	@@drawn

@@singles:
	mov	bp,ax		; Setup loop count.

@@sloop:
 	mov	sesi,esi	; Store esi.
	mov	sedi,edi        ; Store edi.

	call	draw_line_tb   	; Draw line of sprite.

	mov	edi,sedi        ; Restore edi.
 	mov	esi,sesi        ; Restore esi.

	add	edi,SCRWID
	dec	bp              ; Decrease loop count....
	jnz	@@sloop       	; ...repeat until zero.

@@drawn:
	add	esi,xsize    	; Get next graphic data line.
	jmp	@@yloop       	; Do next line.

@@last:
	mov	bp,ax
@@lloop:
 	mov	sesi,esi
	mov	sedi,edi

	call	draw_line_tb

	mov	edi,sedi
	mov	esi,sesi

	add	edi,SCRWID

	dec	bp
	jnz	@@lloop
@@end:
	popad

	ret

;****************************************
;* Create draw tob/bottom line routine. *
;****************************************

create_draw_tb_line:
	mov	edx,[eax+acb.s_init_xscale]
	mov	ebx,[eax+acb.s_xscale]
	movzx	eax,[eax+acb.s_xloop]

@@11bytetb:
	rol	eax,16
	and	ax,3
	jnz	@@nolodsd1tb

	mov	ecx,slodsdend-slodsd
	mov	esi,slodsd
	rep	movsb
	jmp	@@noror1tb

@@nolodsd1tb:
	mov	ecx,3
	mov	esi,sror8
	rep	movsb

@@noror1tb:
	inc	ax
	rol	eax,16

	or	ax,ax
	jz	@@cd1l_endtb

	add	dx,bx
	jnc	@@12bytestb

@@11byteatb:
	sub	ax,1

	mov	ecx,tbplot_12-tbplot_11
	mov	esi,tbplot_11
	rep	movsb

	jmp	@@11bytetb

@@12bytestb:
	add	dx,bx
	jnc	@@13bytestb

@@12bytesatb:
	cmp	ax,2
	jl	@@11byteatb

	sub	ax,2
	mov	ecx,tbplot_13-tbplot_12
	mov	esi,tbplot_12
	rep	movsb

	jmp	@@11bytetb

@@13bytestb:
	add	dx,bx
	jnc	@@14bytestb

@@13bytesatb:
	cmp	ax,3
	jl	@@12bytesatb

	sub	ax,3
	mov	ecx,tbplot_14-tbplot_13
	mov	esi,tbplot_13
	rep	movsb

	jmp	@@11bytetb

@@14bytestb:
	add	dx,bx
	jnc	@@15bytestb

@@14bytesatb:
	cmp	ax,4
	jl 	@@13bytesatb

	sub	ax,4
	mov	ecx,tbplot_15-tbplot_14
	mov	esi,tbplot_14
	rep	movsb

	jmp	@@11bytetb

@@15bytestb:
	add	dx,bx
	jnc	@@16bytestb

@@15bytesatb:
	cmp	ax,5
	jl 	@@14bytesatb

	sub	ax,5
	mov	ecx,tbplot_16-tbplot_15
	mov	esi,tbplot_15
	rep	movsb

	jmp	@@11bytetb

@@16bytestb:
	add	dx,bx

	cmp	ax,6
	jl 	@@15bytesatb

	sub	ax,6
	mov	ecx,tbplot_1end-tbplot_16
	mov	esi,tbplot_16
	rep	movsb

	jmp	@@11bytetb

@@cd1l_endtb:
	mov	al,0c3h			; Return.
	mov	[edi],al		; Faster than a stosb!!

	ret

;*******************************************
;* Draw tob/bottom line of sprite modules. *
;*******************************************

tbplot_11:
	or	al,al
	jz	@@tbplot_11a

	mov	[edi],al

@@tbplot_11a:
	inc	edi

tbplot_12:
	or	al,al
	jz	@@tbplot_12a

	mov	bl,al
	mov	bh,al
	mov	[edi],bx

@@tbplot_12a:
	add	edi,2

tbplot_13:
	or	al,al
	jz	@@tbplot_13a

	mov	[edi],al
	mov	bl,al
  	mov	bh,al
 	mov	[edi+1],bx

@@tbplot_13a:
	add	edi,3

tbplot_14:
	or	al,al
	jz	@@tbplot_14a

     	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi],ebx


@@tbplot_14a:
	add	edi,4

tbplot_15:
	or	al,al
	jz	@@tbplot_15a

     	mov	bl,al
	mov	bh,al
	mov	[edi],bl
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+1],ebx


@@tbplot_15a:
	add	edi,5

tbplot_16:
	or	al,al
	jz	@@tbplot_16a

     	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+2],ebx

@@tbplot_16a:
	add	edi,6

tbplot_1end:

;******************************
;* Create draw_1line routine. *
;******************************

create_draw_1line:

	mov	edx,[eax+acb.s_init_xscale]
	mov	ebx,[eax+acb.s_xscale]
	movzx	eax,[eax+acb.s_xloop]

@@11byte:
	rol	eax,16
	and	ax,3
	jnz	@@nolodsd1

	mov	ecx,slodsdend-slodsd
	mov	esi,slodsd
	rep	movsb
	jmp	@@noror1

@@nolodsd1:
	mov	ecx,3
	mov	esi,sror8
	rep	movsb

@@noror1:
	inc	ax
	rol	eax,16

	or	ax,ax
	jz	@@cd1l_end

	add	dx,bx
	jnc	@@12bytes

@@11bytea:
	sub	ax,1

	mov	ecx,plot_12-plot_11
	mov	esi,plot_11
	rep	movsb

	jmp	@@11byte

@@12bytes:
	add	dx,bx

	cmp	ax,2
	jl	@@11bytea

	sub	ax,2
	mov	ecx,plot_1end-plot_12
	mov	esi,plot_12
	rep	movsb

	jmp	@@11byte

@@cd1l_end:
	mov	al,0c3h			; Return.
	mov	[edi],al		; Faster than a stosb!!

	ret

;*******************************
;* Create draw_2lines routine. *
;*******************************

create_draw_2lines:

	mov	edx,[eax+acb.s_init_xscale]
	mov	ebx,[eax+acb.s_xscale]
	movzx	eax,[eax+acb.s_xloop]

@@21byte:
	rol	eax,16
	and	ax,3
	jnz	@@nolodsd2

	mov	ecx,slodsdend-slodsd
	mov	esi,slodsd
	rep	movsb
	jmp	@@noror2

@@nolodsd2:
	mov	ecx,3
	mov	esi,sror8
	rep	movsb

@@noror2:
	inc	ax
	rol	eax,16

	or	ax,ax
	jz	@@cd2l_end

	add	dx,bx
	jnc	@@22bytes

@@21bytea:
  	sub	ax,1

	mov	ecx,plot_22-plot_21
	mov	esi,plot_21
	rep	movsb

	jmp	@@21byte

@@22bytes:
	add	dx,bx
	jnc	@@23bytes

@@22bytesa:
	cmp	ax,2
	jl	@@21bytea

	sub	ax,2
	mov	ecx,plot_23-plot_22
	mov	esi,plot_22
	rep	movsb

	jmp	@@21byte

@@23bytes:
	add	dx,bx

	cmp	ax,3
	jl	@@22bytesa

	sub	ax,3
	mov	ecx,plot_2end-plot_23
	mov	esi,plot_23
	rep	movsb

	jmp	@@21byte

@@cd2l_end:
	mov	al,0c3h			; Return.
	mov	[edi],al		; Faster than a stosb!!

	ret

;*******************************
;* Create draw_3lines routine. *
;*******************************

create_draw_3lines:

	mov	edx,[eax+acb.s_init_xscale]
	mov	ebx,[eax+acb.s_xscale]
	movzx	eax,[eax+acb.s_xloop]

@@31byte:
	rol	eax,16
	and	ax,3
	jnz	@@nolodsd3

	mov	ecx,slodsdend-slodsd
	mov	esi,slodsd
	rep	movsb
	jmp	@@noror3

@@nolodsd3:
	mov	ecx,3
	mov	esi,sror8
	rep	movsb

@@noror3:
	inc	ax
	rol	eax,16

	or	ax,ax
	jz	@@cd3l_end

	add	dx,bx
	jnc	@@32bytes

@@31bytea:
	sub	ax,1

	mov	ecx,plot_32-plot_31
	mov	esi,plot_31
	rep	movsb

	jmp	@@31byte

@@32bytes:
	add	dx,bx
	jnc	@@33bytes

@@32bytesa:
	cmp	ax,2
	jl	@@31bytea

	sub	ax,2
	mov	ecx,plot_33-plot_32
	mov	esi,plot_32
	rep	movsb

	jmp	@@31byte

@@33bytes:
	add	dx,bx
	jnc	@@34bytes

@@33bytesa:
	cmp	ax,3
	jl	@@32bytesa

	sub	ax,3
	mov	ecx,plot_34-plot_33
	mov	esi,plot_33
	rep	movsb

	jmp	@@31byte

@@34bytes:
	add	dx,bx

	cmp	ax,4
	jl	@@33bytesa

	sub	ax,4
	mov	ecx,plot_3end-plot_34
	mov	esi,plot_34
	rep	movsb

	jmp	@@31byte

@@cd3l_end:
	mov	al,0c3h			; Return.
	mov	[edi],al		; Faster than a stosb!!

	ret

;*******************************
;* Create draw_4lines routine. *
;*******************************

create_draw_4lines:
	mov	edx,[eax+acb.s_init_xscale]
	mov	ebx,[eax+acb.s_xscale]
	movzx	eax,[eax+acb.s_xloop]

@@41byte:
	rol	eax,16
	and	ax,3
	jnz	@@nolodsd4

	mov	ecx,slodsdend-slodsd
	mov	esi,slodsd
	rep	movsb
	jmp	@@noror4

@@nolodsd4:
	mov	ecx,3
	mov	esi,sror8
	rep	movsb

@@noror4:
	inc	ax
	rol	eax,16

	or	ax,ax
	jz	@@cd4l_end

	add	dx,bx
	jnc	@@42bytes

@@41bytea:
	dec	ax

	mov	ecx,plot_42-plot_41
	mov	esi,plot_41
	rep	movsb

	jmp	@@41byte

@@42bytes:
	add	dx,bx
	jnc	@@43bytes

@@42bytesa:
	cmp	ax,2
	jl	@@41bytea

	sub	ax,2
	mov	ecx,plot_43-plot_42
	mov	esi,plot_42
	rep	movsb

	jmp	@@41byte

@@43bytes:
	add	dx,bx
	jnc	@@44bytes

@@43bytesa:
	cmp	ax,3
	jl	@@42bytesa

	sub	ax,3
	mov	ecx,plot_44-plot_43
	mov	esi,plot_43
	rep	movsb

	jmp	@@41byte

@@44bytes:
	add	dx,bx
	jnc	@@45bytes

@@44bytesa:
	cmp	ax,4
	jl 	@@43bytesa

	sub	ax,4
	mov	ecx,plot_45-plot_44
	mov	esi,plot_44
	rep	movsb

	jmp	@@41byte

@@45bytes:
	add	dx,bx

	cmp	ax,5
	jl 	@@44bytesa

	sub	ax,5
	mov	ecx,plot_4end-plot_45
	mov	esi,plot_45
	rep	movsb

	jmp	@@41byte

@@cd4l_end:
	mov	al,0c3h			; Return.
	mov	[edi],al		; Faster than a stosb!!

	ret

;*******************************
;* Create draw_5lines routine. *
;*******************************

create_draw_5lines:
	mov	edx,[eax+acb.s_init_xscale]
	mov	ebx,[eax+acb.s_xscale]
	movzx	eax,[eax+acb.s_xloop]

@@51byte:
	rol	eax,16
	and	ax,3
	jnz	@@nolodsd5

	mov	ecx,slodsdend-slodsd
	mov	esi,slodsd
	rep	movsb
	jmp	@@noror5

@@nolodsd5:
	mov	ecx,3
	mov	esi,sror8
	rep	movsb

@@noror5:
	inc	ax
	rol	eax,16

	or	ax,ax
	jz	@@cd5l_end

	add	dx,bx
	jnc	@@52bytes

@@51bytea:
	dec	ax

	mov	ecx,plot_52-plot_51
	mov	esi,plot_51
	rep	movsb

	jmp	@@51byte

@@52bytes:
	add	dx,bx
	jnc	@@53bytes

@@52bytesa:
	cmp	ax,2
	jl	@@51bytea

	sub	ax,2
	mov	ecx,plot_53-plot_52
	mov	esi,plot_52
	rep	movsb

	jmp	@@51byte

@@53bytes:
	add	dx,bx
	jnc	@@54bytes

@@53bytesa:
	cmp	ax,3
	jl	@@52bytesa

	sub	ax,3
	mov	ecx,plot_54-plot_53
	mov	esi,plot_53
	rep	movsb

	jmp	@@51byte

@@54bytes:
	add	dx,bx
	jnc	@@55bytes

@@54bytesa:
	cmp	ax,4
	jl 	@@53bytesa

	sub	ax,4
	mov	ecx,plot_55-plot_54
	mov	esi,plot_54
	rep	movsb

	jmp	@@51byte

@@55bytes:
	add	dx,bx
	jnc	@@56bytes

@@55bytesa:
	cmp	ax,5
	jl 	@@54bytesa

	sub	ax,5
	mov	ecx,plot_56-plot_55
	mov	esi,plot_55
	rep	movsb

	jmp	@@51byte

@@56bytes:
	add	dx,bx

	cmp	ax,6
	jl 	@@55bytesa

	sub	ax,6
	mov	ecx,plot_5end-plot_56
	mov	esi,plot_56
	rep	movsb

	jmp	@@51byte

@@cd5l_end:
	mov	al,0c3h			; Return.
	mov	[edi],al		; Faster than a stosb!!

	ret

;*******************************
;* Create draw_6lines routine. *
;*******************************

create_draw_6lines:
	mov	edx,[eax+acb.s_init_xscale]
	mov	ebx,[eax+acb.s_xscale]
	movzx	eax,[eax+acb.s_xloop]

@@61byte:
	rol	eax,16
	and	ax,3
	jnz	@@nolodsd6

	mov	ecx,slodsdend-slodsd
	mov	esi,slodsd
	rep	movsb
	jmp	@@noror6

@@nolodsd6:
	mov	ecx,3
	mov	esi,sror8
	rep	movsb

@@noror6:
	inc	ax
	rol	eax,16

	or	ax,ax
	jz	@@cd6l_end

	add	dx,bx
	jnc	@@62bytes

@@61bytea:
	dec	ax

	mov	ecx,plot_62-plot_61
	mov	esi,plot_61
	rep	movsb

	jmp	@@61byte

@@62bytes:
	add	dx,bx
	jnc	@@63bytes

@@62bytesa:
	cmp	ax,2
	jl	@@61bytea

	sub	ax,2
	mov	ecx,plot_63-plot_62
	mov	esi,plot_62
	rep	movsb

	jmp	@@61byte

@@63bytes:
	add	dx,bx
	jnc	@@64bytes

@@63bytesa:
	cmp	ax,3
	jl	@@62bytesa

	sub	ax,3
	mov	ecx,plot_64-plot_63
	mov	esi,plot_63
	rep	movsb

	jmp	@@61byte

@@64bytes:
	add	dx,bx
	jnc	@@65bytes

@@64bytesa:
	cmp	ax,4
	jl 	@@63bytesa

	sub	ax,4
	mov	ecx,plot_65-plot_64
	mov	esi,plot_64
	rep	movsb

	jmp	@@61byte

@@65bytes:
	add	dx,bx
	jnc	@@66bytes

@@65bytesa:
	cmp	ax,5
	jl 	@@64bytesa

	sub	ax,5
	mov	ecx,plot_66-plot_65
	mov	esi,plot_65
	rep	movsb

	jmp	@@61byte

@@66bytes:
	add	dx,bx

	cmp	ax,6
	jl 	@@65bytesa

	sub	ax,6
	mov	ecx,plot_6end-plot_66
	mov	esi,plot_66
	rep	movsb

	jmp	@@61byte

@@cd6l_end:
	mov	al,0c3h			; Return.
	mov	[edi],al		; Faster than a stosb!!

	ret

;**********************************
;* Draw 1 line of sprite modules. *
;**********************************

plot_11:
	or	al,al
	jz	@@plot_11a
	mov	[edi],al

@@plot_11a:
	inc	edi

plot_12:
	or	al,al
	jz	@@plot_12a

	mov	bl,al
	mov	bh,al
	mov	[edi],bx

@@plot_12a:
	add	edi,2

plot_1end:

;***********************************
;* Draw 2 lines of sprite modules. *
;***********************************

plot_21:
	or	al,al
	jz	@@plot_21a

	mov	[edi],al
	mov	[edi+SCRWID],al

@@plot_21a:
	inc	edi

plot_22:
	or	al,al
	jz	@@plot_22a

	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx

@@plot_22a:
	add	edi,2

plot_23:
	or	al,al
	jz	@@plot_23a

	mov	[edi],al
 	mov	[edi+SCRWID],al
	mov	bl,al
	mov	bh,al
 	mov	[edi+1],bx
 	mov	[edi+1+SCRWID],bx

@@plot_23a:
	add	edi,3

plot_2end:

;***********************************
;* Draw 3 lines of sprite modules. *
;***********************************

plot_31:
	or	al,al
	jz	@@plot_31a

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al

@@plot_31a:
	inc	edi

plot_32:
	or	al,al
	jz	@@plot_32a

	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx
	mov	[edi+(SCRWID*2)],bx

@@plot_32a:
	add	edi,2

plot_33:
	or	al,al
	jz	@@plot_33a

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	bl,al
	mov	bh,al
 	mov	[edi+1],bx
 	mov	[edi+1+SCRWID],bx
 	mov	[edi+1+(SCRWID*2)],bx

@@plot_33a:
	add	edi,3

plot_34:
	or	al,al
	jz	@@plot_34a

	mov	bl,al
	mov	bh,al
	shl	ebx,16
	mov	bl,al
	mov	bh,al
	mov	[edi],ebx
	mov	[edi+SCRWID],ebx
	mov	[edi+(SCRWID*2)],ebx

@@plot_34a:
	add	edi,4

plot_3end:

;***********************************
;* Draw 4 lines of sprite modules. *
;***********************************

plot_41:
	or	al,al
	jz	@@plot_41a

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al

@@plot_41a:
	inc	edi

plot_42:
	or	al,al
	jz	@@plot_42a

	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx
	mov	[edi+(SCRWID*2)],bx
	mov	[edi+(SCRWID*3)],bx

@@plot_42a:
	add	edi,2

plot_43:
	or	al,al
	jz	@@plot_43a

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	bl,al
  	mov	bh,al
 	mov	[edi+1],bx
 	mov	[edi+1+SCRWID],bx
 	mov	[edi+1+(SCRWID*2)],bx
 	mov	[edi+1+(SCRWID*3)],bx

@@plot_43a:
	add	edi,3

plot_44:
	or	al,al
	jz	@@plot_44a

     	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi],ebx
	mov	[edi+SCRWID],ebx
	mov	[edi+(SCRWID*2)],ebx
	mov	[edi+(SCRWID*3)],ebx

@@plot_44a:
	add	edi,4

plot_45:
	or	al,al
	jz	@@plot_45a

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
     	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+1],ebx
	mov	[edi+1+SCRWID],ebx
	mov	[edi+1+(SCRWID*2)],ebx
	mov	[edi+1+(SCRWID*3)],ebx

@@plot_45a:
	add	edi,5

plot_4end:

;***********************************
;* Draw 5 lines of sprite modules. *
;***********************************

plot_51:
	or	al,al
	jz	@@plot_51a

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	[edi+(SCRWID*4)],al

@@plot_51a:
	inc	edi

plot_52:
	or	al,al
	jz	@@plot_52a

	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx
	mov	[edi+(SCRWID*2)],bx
	mov	[edi+(SCRWID*3)],bx
	mov	[edi+(SCRWID*4)],bx

@@plot_52a:
	add	edi,2

plot_53:
	or	al,al
	jz	@@plot_53a

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	[edi+(SCRWID*4)],al
	mov	bl,al
  	mov	bh,al
 	mov	[edi+1],bx
 	mov	[edi+1+SCRWID],bx
 	mov	[edi+1+(SCRWID*2)],bx
 	mov	[edi+1+(SCRWID*3)],bx
 	mov	[edi+1+(SCRWID*4)],bx

@@plot_53a:
	add	edi,3

plot_54:
	or	al,al
	jz	@@plot_54a

     	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi],ebx
	mov	[edi+SCRWID],ebx
	mov	[edi+(SCRWID*2)],ebx
	mov	[edi+(SCRWID*3)],ebx
	mov	[edi+(SCRWID*4)],ebx

@@plot_54a:
	add	edi,4

plot_55:
	or	al,al
	jz	@@plot_55a

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	[edi+(SCRWID*4)],al
     	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+1],ebx
	mov	[edi+1+SCRWID],ebx
	mov	[edi+1+(SCRWID*2)],ebx
	mov	[edi+1+(SCRWID*3)],ebx
	mov	[edi+1+(SCRWID*4)],ebx

@@plot_55a:
	add	edi,5

plot_56:
	or	al,al
	jz	@@plot_56a

    	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx
	mov	[edi+(SCRWID*2)],bx
	mov	[edi+(SCRWID*3)],bx
	mov	[edi+(SCRWID*4)],bx
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+2],ebx
	mov	[edi+2+SCRWID],ebx
	mov	[edi+2+(SCRWID*2)],ebx
	mov	[edi+2+(SCRWID*3)],ebx
	mov	[edi+2+(SCRWID*4)],ebx

@@plot_56a:
	add	edi,6

plot_5end:

;***********************************
;* Draw 6 lines of sprite modules. *
;***********************************

plot_61:
	or	al,al
	jz	@@plot_61a

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	[edi+(SCRWID*4)],al
	mov	[edi+(SCRWID*5)],al

@@plot_61a:
	inc	edi

plot_62:
	or	al,al
	jz	@@plot_62a

	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx
	mov	[edi+(SCRWID*2)],bx
	mov	[edi+(SCRWID*3)],bx
	mov	[edi+(SCRWID*4)],bx
	mov	[edi+(SCRWID*5)],bx

@@plot_62a:
	add	edi,2

plot_63:
	or	al,al
	jz	@@plot_63a

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	[edi+(SCRWID*4)],al
	mov	[edi+(SCRWID*5)],al
	mov	bl,al
  	mov	bh,al
 	mov	[edi+1],bx
 	mov	[edi+1+SCRWID],bx
 	mov	[edi+1+(SCRWID*2)],bx
 	mov	[edi+1+(SCRWID*3)],bx
 	mov	[edi+1+(SCRWID*4)],bx
 	mov	[edi+1+(SCRWID*5)],bx

@@plot_63a:
	add	edi,3

plot_64:
	or	al,al
	jz	@@plot_64a

     	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi],ebx
	mov	[edi+SCRWID],ebx
	mov	[edi+(SCRWID*2)],ebx
	mov	[edi+(SCRWID*3)],ebx
	mov	[edi+(SCRWID*4)],ebx
	mov	[edi+(SCRWID*5)],ebx

@@plot_64a:
	add	edi,4

plot_65:
	or	al,al
	jz	@@plot_65a

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	[edi+(SCRWID*4)],al
	mov	[edi+(SCRWID*5)],al
    	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+1],ebx
	mov	[edi+1+SCRWID],ebx
	mov	[edi+1+(SCRWID*2)],ebx
	mov	[edi+1+(SCRWID*3)],ebx
	mov	[edi+1+(SCRWID*4)],ebx
	mov	[edi+1+(SCRWID*5)],ebx

@@plot_65a:
	add	edi,5

plot_66:
	or	al,al
	jz	@@plot_66a

    	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx
	mov	[edi+(SCRWID*2)],bx
	mov	[edi+(SCRWID*3)],bx
	mov	[edi+(SCRWID*4)],bx
	mov	[edi+(SCRWID*5)],bx
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+2],ebx
	mov	[edi+2+SCRWID],ebx
	mov	[edi+2+(SCRWID*2)],ebx
	mov	[edi+2+(SCRWID*3)],ebx
	mov	[edi+2+(SCRWID*4)],ebx
	mov	[edi+2+(SCRWID*5)],ebx

@@plot_66a:
	add	edi,6

plot_6end:

sror8:
	ror	eax,8
slodsd:
	lodsd
slodsdend:

size_sprite_	ENDP

;********************************************
;* Expand sprite routine with transparancy. *
;********************************************

size_sprite_trans_	PROC C PUBLIC

	cld                             ; Clear direction flag.

	pushad                         	; Store all registers.

	movzx	ebx,[eax+acb.s_ylines]	; Minimum Y lines to draw.
	mov	ylines1,ebx
	mov	ebp,eax                 ; Store EAX.

	mov	edi,draw_line_tb 	; Create routine to draw tob/bottom line(s) of sprite.
 	call	create_draw_tb_tline	;

	mov	eax,ebp			; Restore EAX.
	mov	edi,draw_line1

	mov	ebx,ylines1
	cmp	ebx,2
	jge	@@y2

@@y1:
	mov	yadd1,SCRWID
	mov	yadd2,SCRWID*2

 	call	create_draw_1tline     	;
	mov	edi,draw_line2          ;
	mov	eax,ebp                 ; Create routines for x2 - x3 sprites.
	call	create_draw_2tlines	;
	jmp	@@cdl_done              ;

@@y2:
	cmp	ebx,3
	jge	@@y3

	mov	yadd1,SCRWID*2
	mov	yadd2,SCRWID*3

 	call	create_draw_2tlines     	;
	mov	edi,draw_line2          ;
	mov	eax,ebp                 ; Create routines for x2 - x3 sprites.
	call	create_draw_3tlines      ;
	jmp	@@cdl_done              ;

@@y3:
	cmp	ebx,4
	jge	@@y4

	mov	yadd1,SCRWID*3
	mov	yadd2,SCRWID*4

	call	create_draw_3tlines      ;
	mov	edi,draw_line2          ;
	mov	eax,ebp                 ; Create routines for x3 - x4 sprites.
 	call	create_draw_4tlines      ;
	jmp	@@cdl_done              ;

@@y4:
	cmp	ebx,5
	jge	@@y5

	mov	yadd1,SCRWID*4
	mov	yadd2,SCRWID*5

	call	create_draw_4tlines     	;
	mov	edi,draw_line2          ;
	mov	eax,ebp                 ; Create routines for x4 - x5 sprites.
 	call	create_draw_5tlines      ;
	jmp	@@cdl_done              ;

@@y5:
	mov	yadd1,SCRWID*5
	mov	yadd2,SCRWID*6

	call	create_draw_5tlines  	;
	mov	edi,draw_line2          ;
	mov	eax,ebp                 ; Create routines for x5 - x6 sprites.
 	call	create_draw_6tlines      ;

@@cdl_done:
	mov	eax,ebp                 	; Restore EAX.

	movzx	ecx,[eax+acb.s_scr_xpos] 	; Get screen X pos.
	movzx	edx,[eax+acb.s_scr_ypos]	; Get screen Y pos.

	imul	edx,SCRWID              	;
	mov 	edi,SCR_PTR          		;
	add	ecx,edx                 	; Get screen offset

	mov	esi,g_addr              	;
	add	esi,[eax+acb.s_dataoff]         ; Get graphics address.

	add	edi,ecx                 	; Add screen offset to screen address.

	mov	ebx,[eax+acb.s_yscale]     	;
	mov	scale,bx 	            	; Store Y scale.

	mov	ecx,[eax+acb.s_init_yscale] 	; Get clipped Y scale value.
	and	ecx,0ffffh                      ; Keep fraction.

	mov	bx,[eax+acb.s_yloop]
	mov	yloop,bx

	movzx	eax,[eax+acb.s_xsize]   ;
	mov	xsize,eax  		; Get sprite X size.

@@yloop:
	xor	eax,eax		; Set Y lines count to 0.
@@count:
	inc	eax		; Increase Y lines count.

	dec	yloop		; Decrease Y count.
	jz	@@last		;

	add   	cx,scale        ; Next graphic data line?
	jnc	@@count         ; No!

	cmp	eax,ylines1
	jl	@@singles
	je	@@dl1

@@dl2:
	mov	ebp,esi    	; Store esi.
	mov	sedi,edi       	; Store edi.

	call	draw_line2	; Draw a line of sprite.

	mov	edi,sedi    	; Restore edi.
	mov	esi,ebp		; Restore esi.

	add	edi,yadd2	; Next screen line.
	jmp	@@drawn

@@dl1:
	mov	ebp,esi    	; Store esi.
	mov	sedi,edi       	; Store edi.

	call	draw_line1	; Draw a line of sprite.

	mov	edi,sedi    	; Restore edi.
	mov	esi,ebp		; Restore esi.

	add	edi,yadd1	; Next screen line.
	jmp	@@drawn

@@singles:
	mov	bp,ax		; Setup loop count.

@@sloop:
 	mov	sesi,esi	; Store esi.
	mov	sedi,edi        ; Store edi.

	call	draw_line_tb   	; Draw line of sprite.

	mov	edi,sedi        ; Restore edi.
 	mov	esi,sesi        ; Restore esi.

	add	edi,SCRWID
	dec	bp              ; Decrease loop count....
	jnz	@@sloop       	; ...repeat until zero.

@@drawn:
	add	esi,xsize    	; Get next graphic data line.
	jmp	@@yloop       	; Do next line.

@@last:
	mov	bp,ax
@@lloop:
 	mov	sesi,esi
	mov	sedi,edi

	call	draw_line_tb

	mov	edi,sedi
	mov	esi,sesi

	add	edi,SCRWID

	dec	bp
	jnz	@@lloop
@@end:
	popad

	ret

;****************************************
;* Create draw tob/bottom line routine. *
;****************************************

create_draw_tb_tline:
	mov	edx,[eax+acb.s_init_xscale]
	mov	ebx,[eax+acb.s_xscale]
	movzx	eax,[eax+acb.s_xloop]

@@11bytetb:
	rol	eax,16
	and	ax,3
	jnz	@@nolodsd1tb

	mov	ecx,slodsdend-slodsd
	mov	esi,slodsd
	rep	movsb
	jmp	@@noror1tb

@@nolodsd1tb:
	mov	ecx,3
	mov	esi,sror8
	rep	movsb

@@noror1tb:
	inc	ax
	rol	eax,16

	or	ax,ax
	jz	@@cd1l_endtb

	add	dx,bx
	jnc	@@12bytestb

@@11byteatb:
	sub	ax,1

	mov	ecx,tbplot_12-tbplot_11
	mov	esi,tbplot_11
	rep	movsb

	jmp	@@11bytetb

@@12bytestb:
	add	dx,bx
	jnc	@@13bytestb

@@12bytesatb:
	cmp	ax,2
	jl	@@11byteatb

	sub	ax,2
	mov	ecx,tbplot_13-tbplot_12
	mov	esi,tbplot_12
	rep	movsb

	jmp	@@11bytetb

@@13bytestb:
	add	dx,bx
	jnc	@@14bytestb

@@13bytesatb:
	cmp	ax,3
	jl	@@12bytesatb

	sub	ax,3
	mov	ecx,tbplot_14-tbplot_13
	mov	esi,tbplot_13
	rep	movsb

	jmp	@@11bytetb

@@14bytestb:
	add	dx,bx
	jnc	@@15bytestb

@@14bytesatb:
	cmp	ax,4
	jl 	@@13bytesatb

	sub	ax,4
	mov	ecx,tbplot_15-tbplot_14
	mov	esi,tbplot_14
	rep	movsb

	jmp	@@11bytetb

@@15bytestb:
	add	dx,bx
	jnc	@@16bytestb

@@15bytesatb:
	cmp	ax,5
	jl 	@@14bytesatb

	sub	ax,5
	mov	ecx,tbplot_16-tbplot_15
	mov	esi,tbplot_15
	rep	movsb

	jmp	@@11bytetb

@@16bytestb:
	add	dx,bx

	cmp	ax,6
	jl 	@@15bytesatb

	sub	ax,6
	mov	ecx,tbplot_1end-tbplot_16
	mov	esi,tbplot_16
	rep	movsb

	jmp	@@11bytetb

@@cd1l_endtb:
	mov	al,0c3h			; Return.
	mov	[edi],al		; Faster than a stosb!!

	ret

;*******************************************
;* Draw tob/bottom line of sprite modules. *
;*******************************************

tbplot_11:
	or	al,al
	jz	@@tbplot_11a

  	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
;	add	ebx,OFFSET interpol_tab     	;
	add	ebx,interpol_tab     	;
	xlatb

 	mov	[edi],al

@@tbplot_11a:
	inc	edi

tbplot_12:
	or	al,al
	jz	@@tbplot_12a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	bl,al
	mov	bh,al
	mov	[edi],bx

@@tbplot_12a:
	add	edi,2

tbplot_13:
	or	al,al
	jz	@@tbplot_13a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
	mov	bl,al
  	mov	bh,al
 	mov	[edi+1],bx

@@tbplot_13a:
	add	edi,3

tbplot_14:
	or	al,al
	jz	@@tbplot_14a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

     	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi],ebx


@@tbplot_14a:
	add	edi,4

tbplot_15:
	or	al,al
	jz	@@tbplot_15a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

     	mov	bl,al
	mov	bh,al
	mov	[edi],bl
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+1],ebx


@@tbplot_15a:
	add	edi,5

tbplot_16:
	or	al,al
	jz	@@tbplot_16a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

     	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+2],ebx

@@tbplot_16a:
	add	edi,6

tbplot_1end:

;******************************
;* Create draw_1line routine. *
;******************************

create_draw_1tline:

	mov	edx,[eax+acb.s_init_xscale]
	mov	ebx,[eax+acb.s_xscale]
	movzx	eax,[eax+acb.s_xloop]

@@11byte:
	rol	eax,16
	and	ax,3
	jnz	@@nolodsd1

	mov	ecx,slodsdend-slodsd
	mov	esi,slodsd
	rep	movsb
	jmp	@@noror1

@@nolodsd1:
	mov	ecx,3
	mov	esi,sror8
	rep	movsb

@@noror1:
	inc	ax
	rol	eax,16

	or	ax,ax
	jz	@@cd1l_end

	add	dx,bx
	jnc	@@12bytes

@@11bytea:
	sub	ax,1

	mov	ecx,plot_12-plot_11
	mov	esi,plot_11
	rep	movsb

	jmp	@@11byte

@@12bytes:
	add	dx,bx

	cmp	ax,2
	jl	@@11bytea

	sub	ax,2
	mov	ecx,plot_1end-plot_12
	mov	esi,plot_12
	rep	movsb

	jmp	@@11byte

@@cd1l_end:
	mov	al,0c3h			; Return.
	mov	[edi],al		; Faster than a stosb!!

	ret

;*******************************
;* Create draw_2lines routine. *
;*******************************

create_draw_2tlines:

	mov	edx,[eax+acb.s_init_xscale]
	mov	ebx,[eax+acb.s_xscale]
	movzx	eax,[eax+acb.s_xloop]

@@21byte:
	rol	eax,16
	and	ax,3
	jnz	@@nolodsd2

	mov	ecx,slodsdend-slodsd
	mov	esi,slodsd
	rep	movsb
	jmp	@@noror2

@@nolodsd2:
	mov	ecx,3
	mov	esi,sror8
	rep	movsb

@@noror2:
	inc	ax
	rol	eax,16

	or	ax,ax
	jz	@@cd2l_end

	add	dx,bx
	jnc	@@22bytes

@@21bytea:
  	sub	ax,1

	mov	ecx,plot_22-plot_21
	mov	esi,plot_21
	rep	movsb

	jmp	@@21byte

@@22bytes:
	add	dx,bx
	jnc	@@23bytes

@@22bytesa:
	cmp	ax,2
	jl	@@21bytea

	sub	ax,2
	mov	ecx,plot_23-plot_22
	mov	esi,plot_22
	rep	movsb

	jmp	@@21byte

@@23bytes:
	add	dx,bx

	cmp	ax,3
	jl	@@22bytesa

	sub	ax,3
	mov	ecx,plot_2end-plot_23
	mov	esi,plot_23
	rep	movsb

	jmp	@@21byte

@@cd2l_end:
	mov	al,0c3h			; Return.
	mov	[edi],al		; Faster than a stosb!!

	ret

;*******************************
;* Create draw_3lines routine. *
;*******************************

create_draw_3tlines:

	mov	edx,[eax+acb.s_init_xscale]
	mov	ebx,[eax+acb.s_xscale]
	movzx	eax,[eax+acb.s_xloop]

@@31byte:
	rol	eax,16
	and	ax,3
	jnz	@@nolodsd3

	mov	ecx,slodsdend-slodsd
	mov	esi,slodsd
	rep	movsb
	jmp	@@noror3

@@nolodsd3:
	mov	ecx,3
	mov	esi,sror8
	rep	movsb

@@noror3:
	inc	ax
	rol	eax,16

	or	ax,ax
	jz	@@cd3l_end

	add	dx,bx
	jnc	@@32bytes

@@31bytea:
	sub	ax,1

	mov	ecx,plot_32-plot_31
	mov	esi,plot_31
	rep	movsb

	jmp	@@31byte

@@32bytes:
	add	dx,bx
	jnc	@@33bytes

@@32bytesa:
	cmp	ax,2
	jl	@@31bytea

	sub	ax,2
	mov	ecx,plot_33-plot_32
	mov	esi,plot_32
	rep	movsb

	jmp	@@31byte

@@33bytes:
	add	dx,bx
	jnc	@@34bytes

@@33bytesa:
	cmp	ax,3
	jl	@@32bytesa

	sub	ax,3
	mov	ecx,plot_34-plot_33
	mov	esi,plot_33
	rep	movsb

	jmp	@@31byte

@@34bytes:
	add	dx,bx

	cmp	ax,4
	jl	@@33bytesa

	sub	ax,4
	mov	ecx,plot_3end-plot_34
	mov	esi,plot_34
	rep	movsb

	jmp	@@31byte

@@cd3l_end:
	mov	al,0c3h			; Return.
	mov	[edi],al		; Faster than a stosb!!

	ret

;*******************************
;* Create draw_4lines routine. *
;*******************************

create_draw_4tlines:
	mov	edx,[eax+acb.s_init_xscale]
	mov	ebx,[eax+acb.s_xscale]
	movzx	eax,[eax+acb.s_xloop]

@@41byte:
	rol	eax,16
	and	ax,3
	jnz	@@nolodsd4

	mov	ecx,slodsdend-slodsd
	mov	esi,slodsd
	rep	movsb
	jmp	@@noror4

@@nolodsd4:
	mov	ecx,3
	mov	esi,sror8
	rep	movsb

@@noror4:
	inc	ax
	rol	eax,16

	or	ax,ax
	jz	@@cd4l_end

	add	dx,bx
	jnc	@@42bytes

@@41bytea:
	dec	ax

	mov	ecx,plot_42-plot_41
	mov	esi,plot_41
	rep	movsb

	jmp	@@41byte

@@42bytes:
	add	dx,bx
	jnc	@@43bytes

@@42bytesa:
	cmp	ax,2
	jl	@@41bytea

	sub	ax,2
	mov	ecx,plot_43-plot_42
	mov	esi,plot_42
	rep	movsb

	jmp	@@41byte

@@43bytes:
	add	dx,bx
	jnc	@@44bytes

@@43bytesa:
	cmp	ax,3
	jl	@@42bytesa

	sub	ax,3
	mov	ecx,plot_44-plot_43
	mov	esi,plot_43
	rep	movsb

	jmp	@@41byte

@@44bytes:
	add	dx,bx
	jnc	@@45bytes

@@44bytesa:
	cmp	ax,4
	jl 	@@43bytesa

	sub	ax,4
	mov	ecx,plot_45-plot_44
	mov	esi,plot_44
	rep	movsb

	jmp	@@41byte

@@45bytes:
	add	dx,bx

	cmp	ax,5
	jl 	@@44bytesa

	sub	ax,5
	mov	ecx,plot_4end-plot_45
	mov	esi,plot_45
	rep	movsb

	jmp	@@41byte

@@cd4l_end:
	mov	al,0c3h			; Return.
	mov	[edi],al		; Faster than a stosb!!

	ret

;*******************************
;* Create draw_5lines routine. *
;*******************************

create_draw_5tlines:
	mov	edx,[eax+acb.s_init_xscale]
	mov	ebx,[eax+acb.s_xscale]
	movzx	eax,[eax+acb.s_xloop]

@@51byte:
	rol	eax,16
	and	ax,3
	jnz	@@nolodsd5

	mov	ecx,slodsdend-slodsd
	mov	esi,slodsd
	rep	movsb
	jmp	@@noror5

@@nolodsd5:
	mov	ecx,3
	mov	esi,sror8
	rep	movsb

@@noror5:
	inc	ax
	rol	eax,16

	or	ax,ax
	jz	@@cd5l_end

	add	dx,bx
	jnc	@@52bytes

@@51bytea:
	dec	ax

	mov	ecx,plot_52-plot_51
	mov	esi,plot_51
	rep	movsb

	jmp	@@51byte

@@52bytes:
	add	dx,bx
	jnc	@@53bytes

@@52bytesa:
	cmp	ax,2
	jl	@@51bytea

	sub	ax,2
	mov	ecx,plot_53-plot_52
	mov	esi,plot_52
	rep	movsb

	jmp	@@51byte

@@53bytes:
	add	dx,bx
	jnc	@@54bytes

@@53bytesa:
	cmp	ax,3
	jl	@@52bytesa

	sub	ax,3
	mov	ecx,plot_54-plot_53
	mov	esi,plot_53
	rep	movsb

	jmp	@@51byte

@@54bytes:
	add	dx,bx
	jnc	@@55bytes

@@54bytesa:
	cmp	ax,4
	jl 	@@53bytesa

	sub	ax,4
	mov	ecx,plot_55-plot_54
	mov	esi,plot_54
	rep	movsb

	jmp	@@51byte

@@55bytes:
	add	dx,bx
	jnc	@@56bytes

@@55bytesa:
	cmp	ax,5
	jl 	@@54bytesa

	sub	ax,5
	mov	ecx,plot_56-plot_55
	mov	esi,plot_55
	rep	movsb

	jmp	@@51byte

@@56bytes:
	add	dx,bx

	cmp	ax,6
	jl 	@@55bytesa

	sub	ax,6
	mov	ecx,plot_5end-plot_56
	mov	esi,plot_56
	rep	movsb

	jmp	@@51byte

@@cd5l_end:
	mov	al,0c3h			; Return.
	mov	[edi],al		; Faster than a stosb!!

	ret

;*******************************
;* Create draw_6lines routine. *
;*******************************

create_draw_6tlines:
	mov	edx,[eax+acb.s_init_xscale]
	mov	ebx,[eax+acb.s_xscale]
	movzx	eax,[eax+acb.s_xloop]

@@61byte:
	rol	eax,16
	and	ax,3
	jnz	@@nolodsd6

	mov	ecx,slodsdend-slodsd
	mov	esi,slodsd
	rep	movsb
	jmp	@@noror6

@@nolodsd6:
	mov	ecx,3
	mov	esi,sror8
	rep	movsb

@@noror6:
	inc	ax
	rol	eax,16

	or	ax,ax
	jz	@@cd6l_end

	add	dx,bx
	jnc	@@62bytes

@@61bytea:
	dec	ax

	mov	ecx,plot_62-plot_61
	mov	esi,plot_61
	rep	movsb

	jmp	@@61byte

@@62bytes:
	add	dx,bx
	jnc	@@63bytes

@@62bytesa:
	cmp	ax,2
	jl	@@61bytea

	sub	ax,2
	mov	ecx,plot_63-plot_62
	mov	esi,plot_62
	rep	movsb

	jmp	@@61byte

@@63bytes:
	add	dx,bx
	jnc	@@64bytes

@@63bytesa:
	cmp	ax,3
	jl	@@62bytesa

	sub	ax,3
	mov	ecx,plot_64-plot_63
	mov	esi,plot_63
	rep	movsb

	jmp	@@61byte

@@64bytes:
	add	dx,bx
	jnc	@@65bytes

@@64bytesa:
	cmp	ax,4
	jl 	@@63bytesa

	sub	ax,4
	mov	ecx,plot_65-plot_64
	mov	esi,plot_64
	rep	movsb

	jmp	@@61byte

@@65bytes:
	add	dx,bx
	jnc	@@66bytes

@@65bytesa:
	cmp	ax,5
	jl 	@@64bytesa

	sub	ax,5
	mov	ecx,plot_66-plot_65
	mov	esi,plot_65
	rep	movsb

	jmp	@@61byte

@@66bytes:
	add	dx,bx

	cmp	ax,6
	jl 	@@65bytesa

	sub	ax,6
	mov	ecx,plot_6end-plot_66
	mov	esi,plot_66
	rep	movsb

	jmp	@@61byte

@@cd6l_end:
	mov	al,0c3h			; Return.
	mov	[edi],al		; Faster than a stosb!!

	ret

;**********************************
;* Draw 1 line of sprite modules. *
;**********************************

plot_11:
	or	al,al
	jz	@@plot_11a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al

@@plot_11a:
	inc	edi

plot_12:
	or	al,al
	jz	@@plot_12a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	bl,al
	mov	bh,al
	mov	[edi],bx

@@plot_12a:
	add	edi,2

plot_1end:

;***********************************
;* Draw 2 lines of sprite modules. *
;***********************************

plot_21:
	or	al,al
	jz	@@plot_21a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
	mov	[edi+SCRWID],al

@@plot_21a:
	inc	edi

plot_22:
	or	al,al
	jz	@@plot_22a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx

@@plot_22a:
	add	edi,2

plot_23:
	or	al,al
	jz	@@plot_23a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
 	mov	[edi+SCRWID],al
	mov	bl,al
	mov	bh,al
 	mov	[edi+1],bx
 	mov	[edi+1+SCRWID],bx

@@plot_23a:
	add	edi,3

plot_2end:

;***********************************
;* Draw 3 lines of sprite modules. *
;***********************************

plot_31:
	or	al,al
	jz	@@plot_31a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al

@@plot_31a:
	inc	edi

plot_32:
	or	al,al
	jz	@@plot_32a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx
	mov	[edi+(SCRWID*2)],bx

@@plot_32a:
	add	edi,2

plot_33:
	or	al,al
	jz	@@plot_33a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	bl,al
	mov	bh,al
 	mov	[edi+1],bx
 	mov	[edi+1+SCRWID],bx
 	mov	[edi+1+(SCRWID*2)],bx

@@plot_33a:
	add	edi,3

plot_34:
	or	al,al
	jz	@@plot_34a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	bl,al
	mov	bh,al
	shl	ebx,16
	mov	bl,al
	mov	bh,al
	mov	[edi],ebx
	mov	[edi+SCRWID],ebx
	mov	[edi+(SCRWID*2)],ebx

@@plot_34a:
	add	edi,4

plot_3end:

;***********************************
;* Draw 4 lines of sprite modules. *
;***********************************

plot_41:
	or	al,al
	jz	@@plot_41a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al

@@plot_41a:
	inc	edi

plot_42:
	or	al,al
	jz	@@plot_42a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx
	mov	[edi+(SCRWID*2)],bx
	mov	[edi+(SCRWID*3)],bx

@@plot_42a:
	add	edi,2

plot_43:
	or	al,al
	jz	@@plot_43a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	bl,al
  	mov	bh,al
 	mov	[edi+1],bx
 	mov	[edi+1+SCRWID],bx
 	mov	[edi+1+(SCRWID*2)],bx
 	mov	[edi+1+(SCRWID*3)],bx

@@plot_43a:
	add	edi,3

plot_44:
	or	al,al
	jz	@@plot_44a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

     	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi],ebx
	mov	[edi+SCRWID],ebx
	mov	[edi+(SCRWID*2)],ebx
	mov	[edi+(SCRWID*3)],ebx

@@plot_44a:
	add	edi,4

plot_45:
	or	al,al
	jz	@@plot_45a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
     	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+1],ebx
	mov	[edi+1+SCRWID],ebx
	mov	[edi+1+(SCRWID*2)],ebx
	mov	[edi+1+(SCRWID*3)],ebx

@@plot_45a:
	add	edi,5

plot_4end:

;***********************************
;* Draw 5 lines of sprite modules. *
;***********************************

plot_51:
	or	al,al
	jz	@@plot_51a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	[edi+(SCRWID*4)],al

@@plot_51a:
	inc	edi

plot_52:
	or	al,al
	jz	@@plot_52a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx
	mov	[edi+(SCRWID*2)],bx
	mov	[edi+(SCRWID*3)],bx
	mov	[edi+(SCRWID*4)],bx

@@plot_52a:
	add	edi,2

plot_53:
	or	al,al
	jz	@@plot_53a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	[edi+(SCRWID*4)],al
	mov	bl,al
  	mov	bh,al
 	mov	[edi+1],bx
 	mov	[edi+1+SCRWID],bx
 	mov	[edi+1+(SCRWID*2)],bx
 	mov	[edi+1+(SCRWID*3)],bx
 	mov	[edi+1+(SCRWID*4)],bx

@@plot_53a:
	add	edi,3

plot_54:
	or	al,al
	jz	@@plot_54a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

     	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi],ebx
	mov	[edi+SCRWID],ebx
	mov	[edi+(SCRWID*2)],ebx
	mov	[edi+(SCRWID*3)],ebx
	mov	[edi+(SCRWID*4)],ebx

@@plot_54a:
	add	edi,4

plot_55:
	or	al,al
	jz	@@plot_55a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	[edi+(SCRWID*4)],al
     	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+1],ebx
	mov	[edi+1+SCRWID],ebx
	mov	[edi+1+(SCRWID*2)],ebx
	mov	[edi+1+(SCRWID*3)],ebx
	mov	[edi+1+(SCRWID*4)],ebx

@@plot_55a:
	add	edi,5

plot_56:
	or	al,al
	jz	@@plot_56a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

    	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx
	mov	[edi+(SCRWID*2)],bx
	mov	[edi+(SCRWID*3)],bx
	mov	[edi+(SCRWID*4)],bx
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+2],ebx
	mov	[edi+2+SCRWID],ebx
	mov	[edi+2+(SCRWID*2)],ebx
	mov	[edi+2+(SCRWID*3)],ebx
	mov	[edi+2+(SCRWID*4)],ebx

@@plot_56a:
	add	edi,6

plot_5end:

;***********************************
;* Draw 6 lines of sprite modules. *
;***********************************

plot_61:
	or	al,al
	jz	@@plot_61a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	[edi+(SCRWID*4)],al
	mov	[edi+(SCRWID*5)],al

@@plot_61a:
	inc	edi

plot_62:
	or	al,al
	jz	@@plot_62a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx
	mov	[edi+(SCRWID*2)],bx
	mov	[edi+(SCRWID*3)],bx
	mov	[edi+(SCRWID*4)],bx
	mov	[edi+(SCRWID*5)],bx

@@plot_62a:
	add	edi,2

plot_63:
	or	al,al
	jz	@@plot_63a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	[edi+(SCRWID*4)],al
	mov	[edi+(SCRWID*5)],al
	mov	bl,al
  	mov	bh,al
 	mov	[edi+1],bx
 	mov	[edi+1+SCRWID],bx
 	mov	[edi+1+(SCRWID*2)],bx
 	mov	[edi+1+(SCRWID*3)],bx
 	mov	[edi+1+(SCRWID*4)],bx
 	mov	[edi+1+(SCRWID*5)],bx

@@plot_63a:
	add	edi,3

plot_64:
	or	al,al
	jz	@@plot_64a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

     	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi],ebx
	mov	[edi+SCRWID],ebx
	mov	[edi+(SCRWID*2)],ebx
	mov	[edi+(SCRWID*3)],ebx
	mov	[edi+(SCRWID*4)],ebx
	mov	[edi+(SCRWID*5)],ebx

@@plot_64a:
	add	edi,4

plot_65:
	or	al,al
	jz	@@plot_65a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	[edi+(SCRWID*4)],al
	mov	[edi+(SCRWID*5)],al
    	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+1],ebx
	mov	[edi+1+SCRWID],ebx
	mov	[edi+1+(SCRWID*2)],ebx
	mov	[edi+1+(SCRWID*3)],ebx
	mov	[edi+1+(SCRWID*4)],ebx
	mov	[edi+1+(SCRWID*5)],ebx

@@plot_65a:
	add	edi,5

plot_66:
	or	al,al
	jz	@@plot_66a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

    	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx
	mov	[edi+(SCRWID*2)],bx
	mov	[edi+(SCRWID*3)],bx
	mov	[edi+(SCRWID*4)],bx
	mov	[edi+(SCRWID*5)],bx
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+2],ebx
	mov	[edi+2+SCRWID],ebx
	mov	[edi+2+(SCRWID*2)],ebx
	mov	[edi+2+(SCRWID*3)],ebx
	mov	[edi+2+(SCRWID*4)],ebx
	mov	[edi+2+(SCRWID*5)],ebx

@@plot_66a:
	add	edi,6

plot_6end:

sror8:
	ror	eax,8
slodsd:
	lodsd
slodsdend:

size_sprite_trans_	ENDP

;**********************************
;* Expand flipped sprite routine. *
;**********************************

fsize_sprite_	PROC C PUBLIC

	cld                             ; Clear direction flag.

	pushad                         	; Store all registers.

	movzx	ebx,[eax+acb.s_ylines]	; Minimum Y lines to draw.
	mov	ylines1,ebx
	mov	ebp,eax                 ; Store EAX.

	mov	edi,draw_line_tb 	; Create routine to draw tob/bottom line(s) of sprite.
 	call	create_draw_tb_line	;

	mov	eax,ebp			; Restore EAX.
	mov	edi,draw_line1

	mov	ebx,ylines1
	cmp	ebx,2
	jge	@@y2

@@y1:
	mov	yadd1,SCRWID
	mov	yadd2,SCRWID*2

 	call	create_draw_1line     	;
	mov	edi,draw_line2          ;
	mov	eax,ebp                 ; Create routines for x2 - x3 sprites.
	call	create_draw_2lines	;
	jmp	@@cdl_done              ;

@@y2:
	cmp	ebx,3
	jge	@@y3

	mov	yadd1,SCRWID*2
	mov	yadd2,SCRWID*3

 	call	create_draw_2lines     	;
	mov	edi,draw_line2          ;
	mov	eax,ebp                 ; Create routines for x2 - x3 sprites.
	call	create_draw_3lines      ;
	jmp	@@cdl_done              ;

@@y3:
	cmp	ebx,4
	jge	@@y4

	mov	yadd1,SCRWID*3
	mov	yadd2,SCRWID*4

	call	create_draw_3lines      ;
	mov	edi,draw_line2          ;
	mov	eax,ebp                 ; Create routines for x3 - x4 sprites.
 	call	create_draw_4lines      ;
	jmp	@@cdl_done              ;

@@y4:
	cmp	ebx,5
	jge	@@y5

	mov	yadd1,SCRWID*4
	mov	yadd2,SCRWID*5

	call	create_draw_4lines     	;
	mov	edi,draw_line2          ;
	mov	eax,ebp                 ; Create routines for x4 - x5 sprites.
 	call	create_draw_5lines      ;
	jmp	@@cdl_done              ;

@@y5:
	mov	yadd1,SCRWID*5
	mov	yadd2,SCRWID*6

	call	create_draw_5lines  	;
	mov	edi,draw_line2          ;
	mov	eax,ebp                 ; Create routines for x5 - x6 sprites.
 	call	create_draw_6lines      ;

@@cdl_done:
	mov	eax,ebp                 	; Restore EAX.

	movzx	ecx,[eax+acb.s_scr_xpos] 	; Get screen X pos.
	movzx	edx,[eax+acb.s_scr_ypos]	; Get screen Y pos.

	imul	edx,SCRWID              	;
	mov 	edi,SCR_PTR          		;
	add	ecx,edx                 	; Get screen offset

	mov	esi,g_addr              	;
	add	esi,[eax+acb.s_dataoff]         ; Get graphics address.

	add	edi,ecx                 	; Add screen offset to screen address.

	mov	ebx,[eax+acb.s_yscale]     	;
	mov	scale,bx 	            	; Store Y scale.

	mov	ecx,[eax+acb.s_init_yscale] 	; Get clipped Y scale value.
	and	ecx,0ffffh                      ; Keep fraction.

	mov	bx,[eax+acb.s_yloop]
	mov	yloop,bx

	movzx	eax,[eax+acb.s_xsize]   ;
	mov	xsize,eax  		; Get sprite X size.

@@yloop:
	xor	eax,eax		; Set Y lines count to 0.
@@count:
	inc	eax		; Increase Y lines count.

	dec	yloop		; Decrease Y count.
	jz	@@last		;

	add   	cx,scale        ; Next graphic data line?
	jnc	@@count         ; No!

	cmp	eax,ylines1
	jl	@@singles
	je	@@dl1

@@dl2:
	mov	ebp,esi    	; Store esi.
	mov	sedi,edi       	; Store edi.

	call	draw_line2	; Draw a line of sprite.

	mov	edi,sedi    	; Restore edi.
	mov	esi,ebp		; Restore esi.

	add	edi,yadd2	; Next screen line.
	jmp	@@drawn

@@dl1:
	mov	ebp,esi    	; Store esi.
	mov	sedi,edi       	; Store edi.

	call	draw_line1	; Draw a line of sprite.

	mov	edi,sedi    	; Restore edi.
	mov	esi,ebp		; Restore esi.

	add	edi,yadd1	; Next screen line.
	jmp	@@drawn

@@singles:
	mov	bp,ax		; Setup loop count.

@@sloop:
 	mov	sesi,esi	; Store esi.
	mov	sedi,edi        ; Store edi.

	call	draw_line_tb   	; Draw line of sprite.

	mov	edi,sedi        ; Restore edi.
 	mov	esi,sesi        ; Restore esi.

	add	edi,SCRWID
	dec	bp              ; Decrease loop count....
	jnz	@@sloop       	; ...repeat until zero.

@@drawn:
	add	esi,xsize    	; Get next graphic data line.
	jmp	@@yloop       	; Do next line.

@@last:
	mov	bp,ax
@@lloop:
 	mov	sesi,esi
	mov	sedi,edi

	call	draw_line_tb

	mov	edi,sedi
	mov	esi,sesi

	add	edi,SCRWID

	dec	bp
	jnz	@@lloop
@@end:
	popad

	ret

;****************************************
;* Create draw tob/bottom line routine. *
;****************************************

create_draw_tb_line:
	mov	edx,OFFSET scaletab	; Graphics offset table.
	movzx	eax,[eax+acb.s_xloop]

@@11bytetb:
	mov	ecx,slodsdend-slodsd	;
	mov	esi,slodsd              ; Read a byte of data.
	rep	movsb                   ;

	or	ax,ax                  	; X loop over?
	jz	@@cd1l_endtb            ;

	mov	ebx,[edx]               ;
	add	edx,4                   ; Get data offset into EBX.

	cmp	ebx,[edx]		;
	je	@@12bytestb             ; Next X?

@@11byteatb:
	sub	ax,1

	mov	ecx,tbplot_12-tbplot_11	;
	mov	esi,tbplot_11           ; Plot one pixel wide.
	rep	movsb                   ;

	jmp	@@11bytetb

@@12bytestb:
	add	edx,4                   ;
	cmp	ebx,[edx]		; Next X?
	je	@@13bytestb             ;

@@12bytesatb:
	cmp	ax,2               	; Will 2 pixels fit?
	jl	@@11byteatb             ;

	sub	ax,2
	mov	ecx,tbplot_13-tbplot_12 ;
	mov	esi,tbplot_12           ; Plot 2 pixels wide.
	rep	movsb                   ;

	jmp	@@11bytetb

@@13bytestb:
	add	edx,4                   ;
	cmp	ebx,[edx]		; Next X?
	je	@@14bytestb

@@13bytesatb:
	cmp	ax,3
	jl	@@12bytesatb

	sub	ax,3
	mov	ecx,tbplot_14-tbplot_13
	mov	esi,tbplot_13
	rep	movsb

	jmp	@@11bytetb

@@14bytestb:
	add	edx,4                   ;
	cmp	ebx,[edx]		; Next X?
	je	@@15bytestb

@@14bytesatb:
	cmp	ax,4
	jl 	@@13bytesatb

	sub	ax,4
	mov	ecx,tbplot_15-tbplot_14
	mov	esi,tbplot_14
	rep	movsb

	jmp	@@11bytetb

@@15bytestb:
	add	edx,4                   ;
	cmp	ebx,[edx]		; Next X?
	je	@@16bytestb

@@15bytesatb:
	cmp	ax,5
	jl 	@@14bytesatb

	sub	ax,5
	mov	ecx,tbplot_16-tbplot_15
	mov	esi,tbplot_15
	rep	movsb

	jmp	@@11bytetb

@@16bytestb:
	add	edx,4                   ;

	cmp	ax,6
	jl 	@@15bytesatb

	sub	ax,6
	mov	ecx,tbplot_1end-tbplot_16
	mov	esi,tbplot_16
	rep	movsb

	jmp	@@11bytetb

@@cd1l_endtb:
	mov	al,0c3h			; Return.
	mov 	[edi],al		; Faster than a stosb!!

	ret

;*******************************************
;* Draw tob/bottom line of sprite modules. *
;*******************************************

tbplot_11:
	or	al,al
	jz	@@tbplot_11a

	mov	[edi],al

@@tbplot_11a:
	inc	edi

tbplot_12:
	or	al,al
	jz	@@tbplot_12a

	mov	bl,al
	mov	bh,al
	mov	[edi],bx

@@tbplot_12a:
	add	edi,2

tbplot_13:
	or	al,al
	jz	@@tbplot_13a

	mov	[edi],al
	mov	bl,al
  	mov	bh,al
 	mov	[edi+1],bx

@@tbplot_13a:
	add	edi,3

tbplot_14:
	or	al,al
	jz	@@tbplot_14a

     	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi],ebx


@@tbplot_14a:
	add	edi,4

tbplot_15:
	or	al,al
	jz	@@tbplot_15a

     	mov	bl,al
	mov	bh,al
	mov	[edi],bl
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+1],ebx


@@tbplot_15a:
	add	edi,5

tbplot_16:
	or	al,al
	jz	@@tbplot_16a

     	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+2],ebx

@@tbplot_16a:
	add	edi,6

tbplot_1end:

;******************************
;* Create draw_1line routine. *
;******************************

create_draw_1line:
	mov	edx,OFFSET scaletab
	movzx	eax,[eax+acb.s_xloop]

@@11byte:
	mov	ecx,slodsdend-slodsd
	mov	esi,slodsd
	rep	movsb

	or	ax,ax
	jz	@@cd1l_end

	mov	ebx,[edx]
	add	edx,4

	cmp	ebx,[edx]
	je	@@12bytes

@@11bytea:
	sub	ax,1

	mov	ecx,plot_12-plot_11
	mov	esi,plot_11
	rep	movsb

	jmp	@@11byte

@@12bytes:
	add	edx,4

	cmp	ax,2
	jl	@@11bytea

	sub	ax,2
	mov	ecx,plot_1end-plot_12
	mov	esi,plot_12
	rep	movsb

	jmp	@@11byte

@@cd1l_end:
	mov	al,0c3h			; Return.
	mov	[edi],al		; Faster than a stosb!!

	ret

;*******************************
;* Create draw_2lines routine. *
;*******************************

create_draw_2lines:
	mov	edx,OFFSET scaletab
	movzx	eax,[eax+acb.s_xloop]

@@21byte:
	mov	ecx,slodsdend-slodsd
	mov	esi,slodsd
	rep	movsb

	or	ax,ax
	jz	@@cd2l_end

	mov	ebx,[edx]
	add	edx,4

	cmp	ebx,[edx]
	je	@@22bytes

@@21bytea:
  	sub	ax,1

	mov	ecx,plot_22-plot_21
	mov	esi,plot_21
	rep	movsb

	jmp	@@21byte

@@22bytes:
	add	edx,4
	cmp	ebx,[edx]

	je	@@23bytes

@@22bytesa:
	cmp	ax,2
	jl	@@21bytea

	sub	ax,2
	mov	ecx,plot_23-plot_22
	mov	esi,plot_22
	rep	movsb

	jmp	@@21byte

@@23bytes:
	add	edx,4

	cmp	ax,3
	jl	@@22bytesa

	sub	ax,3
	mov	ecx,plot_2end-plot_23
	mov	esi,plot_23
	rep	movsb

	jmp	@@21byte

@@cd2l_end:
	mov	al,0c3h			; Return.
	mov	[edi],al		; Faster than a stosb!!

	ret

;*******************************
;* Create draw_3lines routine. *
;*******************************

create_draw_3lines:
	mov	edx,OFFSET scaletab
	movzx	eax,[eax+acb.s_xloop]

@@31byte:
	mov	ecx,slodsdend-slodsd
	mov	esi,slodsd
	rep	movsb

	or	ax,ax
	jz	@@cd3l_end

	mov	ebx,[edx]
	add	edx,4

	cmp	ebx,[edx]
	je	@@32bytes

@@31bytea:
	sub	ax,1

	mov	ecx,plot_32-plot_31
	mov	esi,plot_31
	rep	movsb

	jmp	@@31byte

@@32bytes:
	add	edx,4
	cmp	ebx,[edx]
	je	@@33bytes

@@32bytesa:
	cmp	ax,2
	jl	@@31bytea

	sub	ax,2
	mov	ecx,plot_33-plot_32
	mov	esi,plot_32
	rep	movsb

	jmp	@@31byte

@@33bytes:
	add	edx,4
	cmp	ebx,[edx]
	je	@@34bytes

@@33bytesa:
	cmp	ax,3
	jl	@@32bytesa

	sub	ax,3
	mov	ecx,plot_34-plot_33
	mov	esi,plot_33
	rep	movsb

	jmp	@@31byte

@@34bytes:
	add	edx,4

	cmp	ax,4
	jl	@@33bytesa

	sub	ax,4
	mov	ecx,plot_3end-plot_34
	mov	esi,plot_34
	rep	movsb

	jmp	@@31byte

@@cd3l_end:
	mov	al,0c3h			; Return.
	mov	[edi],al		; Faster than a stosb!!

	ret

;*******************************
;* Create draw_4lines routine. *
;*******************************

create_draw_4lines:
	mov	edx,OFFSET scaletab
	movzx	eax,[eax+acb.s_xloop]

@@41byte:
	mov	ecx,slodsdend-slodsd
	mov	esi,slodsd
	rep	movsb

	or	ax,ax
	jz	@@cd4l_end

	mov	ebx,[edx]
	add	edx,4

	cmp	ebx,[edx]
	je	@@42bytes

@@41bytea:
	dec	ax

	mov	ecx,plot_42-plot_41
	mov	esi,plot_41
	rep	movsb

	jmp	@@41byte

@@42bytes:
	add	edx,4
	cmp	ebx,[edx]
	je	@@43bytes

@@42bytesa:
	cmp	ax,2
	jl	@@41bytea

	sub	ax,2
	mov	ecx,plot_43-plot_42
	mov	esi,plot_42
	rep	movsb

	jmp	@@41byte

@@43bytes:
	add	edx,4
	cmp	ebx,[edx]
	je	@@44bytes

@@43bytesa:
	cmp	ax,3
	jl	@@42bytesa

	sub	ax,3
	mov	ecx,plot_44-plot_43
	mov	esi,plot_43
	rep	movsb

	jmp	@@41byte

@@44bytes:
	add	edx,4
	cmp	ebx,[edx]
	je	@@45bytes

@@44bytesa:
	cmp	ax,4
	jl 	@@43bytesa

	sub	ax,4
	mov	ecx,plot_45-plot_44
	mov	esi,plot_44
	rep	movsb

	jmp	@@41byte

@@45bytes:
	add	edx,4

	cmp	ax,5
	jl 	@@44bytesa

	sub	ax,5
	mov	ecx,plot_4end-plot_45
	mov	esi,plot_45
	rep	movsb

	jmp	@@41byte

@@cd4l_end:
	mov	al,0c3h			; Return.
	mov	[edi],al		; Faster than a stosb!!

	ret

;*******************************
;* Create draw_5lines routine. *
;*******************************

create_draw_5lines:
	mov	edx,OFFSET scaletab
	movzx	eax,[eax+acb.s_xloop]

@@51byte:
	mov	ecx,slodsdend-slodsd
	mov	esi,slodsd
	rep	movsb

	or	ax,ax
	jz	@@cd5l_end

	mov	ebx,[edx]
	add	edx,4

	cmp	ebx,[edx]
	je	@@52bytes

@@51bytea:
	dec	ax

	mov	ecx,plot_52-plot_51
	mov	esi,plot_51
	rep	movsb

	jmp	@@51byte

@@52bytes:
	add	edx,4
	cmp	ebx,[edx]
	je	@@53bytes

@@52bytesa:
	cmp	ax,2
	jl	@@51bytea

	sub	ax,2
	mov	ecx,plot_53-plot_52
	mov	esi,plot_52
	rep	movsb

	jmp	@@51byte

@@53bytes:
	add	edx,4
	cmp	ebx,[edx]
	je	@@54bytes

@@53bytesa:
	cmp	ax,3
	jl	@@52bytesa

	sub	ax,3
	mov	ecx,plot_54-plot_53
	mov	esi,plot_53
	rep	movsb

	jmp	@@51byte

@@54bytes:
	add	edx,4
	cmp	ebx,[edx]
	je	@@55bytes

@@54bytesa:
	cmp	ax,4
	jl 	@@53bytesa

	sub	ax,4
	mov	ecx,plot_55-plot_54
	mov	esi,plot_54
	rep	movsb

	jmp	@@51byte

@@55bytes:
	add	edx,4
	cmp	ebx,[edx]
	je	@@56bytes

@@55bytesa:
	cmp	ax,5
	jl 	@@54bytesa

	sub	ax,5
	mov	ecx,plot_56-plot_55
	mov	esi,plot_55
	rep	movsb

	jmp	@@51byte

@@56bytes:
	add	edx,4

	cmp	ax,6
	jl 	@@55bytesa

	sub	ax,6
	mov	ecx,plot_5end-plot_56
	mov	esi,plot_56
	rep	movsb

	jmp	@@51byte

@@cd5l_end:
	mov	al,0c3h			; Return.
	mov	[edi],al		; Faster than a stosb!!

	ret

;*******************************
;* Create draw_6lines routine. *
;*******************************

create_draw_6lines:
	mov	edx,OFFSET scaletab
	movzx	eax,[eax+acb.s_xloop]

@@61byte:
	mov	ecx,slodsdend-slodsd
	mov	esi,slodsd
	rep	movsb

	or	ax,ax
	jz	@@cd6l_end

	mov	ebx,[edx]
	add	edx,4

	cmp	ebx,[edx]
	je	@@62bytes

@@61bytea:
	dec	ax

	mov	ecx,plot_62-plot_61
	mov	esi,plot_61
	rep	movsb

	jmp	@@61byte

@@62bytes:
	add	edx,4
	cmp	ebx,[edx]
	je	@@63bytes

@@62bytesa:
	cmp	ax,2
	jl	@@61bytea

	sub	ax,2
	mov	ecx,plot_63-plot_62
	mov	esi,plot_62
	rep	movsb

	jmp	@@61byte

@@63bytes:
	add	edx,4
	cmp	ebx,[edx]
	je	@@64bytes

@@63bytesa:
	cmp	ax,3
	jl	@@62bytesa

	sub	ax,3
	mov	ecx,plot_64-plot_63
	mov	esi,plot_63
	rep	movsb

	jmp	@@61byte

@@64bytes:
	add	edx,4
	cmp	ebx,[edx]
	je	@@65bytes

@@64bytesa:
	cmp	ax,4
	jl 	@@63bytesa

	sub	ax,4
	mov	ecx,plot_65-plot_64
	mov	esi,plot_64
	rep	movsb

	jmp	@@61byte

@@65bytes:
	add	edx,4
	cmp	ebx,[edx]
	je	@@66bytes

@@65bytesa:
	cmp	ax,5
	jl 	@@64bytesa

	sub	ax,5
	mov	ecx,plot_66-plot_65
	mov	esi,plot_65
	rep	movsb

	jmp	@@61byte

@@66bytes:
	add	edx,4

	cmp	ax,6
	jl 	@@65bytesa

	sub	ax,6
	mov	ecx,plot_6end-plot_66
	mov	esi,plot_66
	rep	movsb

	jmp	@@61byte

@@cd6l_end:
	mov	al,0c3h			; Return.
	mov	[edi],al		; Faster than a stosb!!

	ret

;**********************************
;* Draw 1 line of sprite modules. *
;**********************************

plot_11:
	or	al,al
	jz	@@plot_11a
	mov	[edi],al

@@plot_11a:
	inc	edi

plot_12:
	or	al,al
	jz	@@plot_12a

	mov	bl,al
	mov	bh,al
	mov	[edi],bx

@@plot_12a:
	add	edi,2

plot_1end:

;***********************************
;* Draw 2 lines of sprite modules. *
;***********************************

plot_21:
	or	al,al
	jz	@@plot_21a

	mov	[edi],al
	mov	[edi+SCRWID],al

@@plot_21a:
	inc	edi

plot_22:
	or	al,al
	jz	@@plot_22a

	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx

@@plot_22a:
	add	edi,2

plot_23:
	or	al,al
	jz	@@plot_23a

	mov	[edi],al
 	mov	[edi+SCRWID],al
	mov	bl,al
	mov	bh,al
 	mov	[edi+1],bx
 	mov	[edi+1+SCRWID],bx

@@plot_23a:
	add	edi,3

plot_2end:

;***********************************
;* Draw 3 lines of sprite modules. *
;***********************************

plot_31:
	or	al,al
	jz	@@plot_31a

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al

@@plot_31a:
	inc	edi

plot_32:
	or	al,al
	jz	@@plot_32a

	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx
	mov	[edi+(SCRWID*2)],bx

@@plot_32a:
	add	edi,2

plot_33:
	or	al,al
	jz	@@plot_33a

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	bl,al
	mov	bh,al
 	mov	[edi+1],bx
 	mov	[edi+1+SCRWID],bx
 	mov	[edi+1+(SCRWID*2)],bx

@@plot_33a:
	add	edi,3

plot_34:
	or	al,al
	jz	@@plot_34a

	mov	bl,al
	mov	bh,al
	shl	ebx,16
	mov	bl,al
	mov	bh,al
	mov	[edi],ebx
	mov	[edi+SCRWID],ebx
	mov	[edi+(SCRWID*2)],ebx

@@plot_34a:
	add	edi,4

plot_3end:

;***********************************
;* Draw 4 lines of sprite modules. *
;***********************************

plot_41:
	or	al,al
	jz	@@plot_41a

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al

@@plot_41a:
	inc	edi

plot_42:
	or	al,al
	jz	@@plot_42a

	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx
	mov	[edi+(SCRWID*2)],bx
	mov	[edi+(SCRWID*3)],bx

@@plot_42a:
	add	edi,2

plot_43:
	or	al,al
	jz	@@plot_43a

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	bl,al
  	mov	bh,al
 	mov	[edi+1],bx
 	mov	[edi+1+SCRWID],bx
 	mov	[edi+1+(SCRWID*2)],bx
 	mov	[edi+1+(SCRWID*3)],bx

@@plot_43a:
	add	edi,3

plot_44:
	or	al,al
	jz	@@plot_44a

     	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi],ebx
	mov	[edi+SCRWID],ebx
	mov	[edi+(SCRWID*2)],ebx
	mov	[edi+(SCRWID*3)],ebx

@@plot_44a:
	add	edi,4

plot_45:
	or	al,al
	jz	@@plot_45a

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
     	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+1],ebx
	mov	[edi+1+SCRWID],ebx
	mov	[edi+1+(SCRWID*2)],ebx
	mov	[edi+1+(SCRWID*3)],ebx

@@plot_45a:
	add	edi,5

plot_4end:

;***********************************
;* Draw 5 lines of sprite modules. *
;***********************************

plot_51:
	or	al,al
	jz	@@plot_51a

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	[edi+(SCRWID*4)],al

@@plot_51a:
	inc	edi

plot_52:
	or	al,al
	jz	@@plot_52a

	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx
	mov	[edi+(SCRWID*2)],bx
	mov	[edi+(SCRWID*3)],bx
	mov	[edi+(SCRWID*4)],bx

@@plot_52a:
	add	edi,2

plot_53:
	or	al,al
	jz	@@plot_53a

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	[edi+(SCRWID*4)],al
	mov	bl,al
  	mov	bh,al
 	mov	[edi+1],bx
 	mov	[edi+1+SCRWID],bx
 	mov	[edi+1+(SCRWID*2)],bx
 	mov	[edi+1+(SCRWID*3)],bx
 	mov	[edi+1+(SCRWID*4)],bx

@@plot_53a:
	add	edi,3

plot_54:
	or	al,al
	jz	@@plot_54a

     	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi],ebx
	mov	[edi+SCRWID],ebx
	mov	[edi+(SCRWID*2)],ebx
	mov	[edi+(SCRWID*3)],ebx
	mov	[edi+(SCRWID*4)],ebx

@@plot_54a:
	add	edi,4

plot_55:
	or	al,al
	jz	@@plot_55a

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	[edi+(SCRWID*4)],al
     	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+1],ebx
	mov	[edi+1+SCRWID],ebx
	mov	[edi+1+(SCRWID*2)],ebx
	mov	[edi+1+(SCRWID*3)],ebx
	mov	[edi+1+(SCRWID*4)],ebx

@@plot_55a:
	add	edi,5

plot_56:
	or	al,al
	jz	@@plot_56a

    	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx
	mov	[edi+(SCRWID*2)],bx
	mov	[edi+(SCRWID*3)],bx
	mov	[edi+(SCRWID*4)],bx
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+2],ebx
	mov	[edi+2+SCRWID],ebx
	mov	[edi+2+(SCRWID*2)],ebx
	mov	[edi+2+(SCRWID*3)],ebx
	mov	[edi+2+(SCRWID*4)],ebx

@@plot_56a:
	add	edi,6

plot_5end:

;***********************************
;* Draw 6 lines of sprite modules. *
;***********************************

plot_61:
	or	al,al
	jz	@@plot_61a

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	[edi+(SCRWID*4)],al
	mov	[edi+(SCRWID*5)],al

@@plot_61a:
	inc	edi

plot_62:
	or	al,al
	jz	@@plot_62a

	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx
	mov	[edi+(SCRWID*2)],bx
	mov	[edi+(SCRWID*3)],bx
	mov	[edi+(SCRWID*4)],bx
	mov	[edi+(SCRWID*5)],bx

@@plot_62a:
	add	edi,2

plot_63:
	or	al,al
	jz	@@plot_63a

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	[edi+(SCRWID*4)],al
	mov	[edi+(SCRWID*5)],al
	mov	bl,al
  	mov	bh,al
 	mov	[edi+1],bx
 	mov	[edi+1+SCRWID],bx
 	mov	[edi+1+(SCRWID*2)],bx
 	mov	[edi+1+(SCRWID*3)],bx
 	mov	[edi+1+(SCRWID*4)],bx
 	mov	[edi+1+(SCRWID*5)],bx

@@plot_63a:
	add	edi,3

plot_64:
	or	al,al
	jz	@@plot_64a

     	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi],ebx
	mov	[edi+SCRWID],ebx
	mov	[edi+(SCRWID*2)],ebx
	mov	[edi+(SCRWID*3)],ebx
	mov	[edi+(SCRWID*4)],ebx
	mov	[edi+(SCRWID*5)],ebx

@@plot_64a:
	add	edi,4

plot_65:
	or	al,al
	jz	@@plot_65a

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	[edi+(SCRWID*4)],al
	mov	[edi+(SCRWID*5)],al
    	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+1],ebx
	mov	[edi+1+SCRWID],ebx
	mov	[edi+1+(SCRWID*2)],ebx
	mov	[edi+1+(SCRWID*3)],ebx
	mov	[edi+1+(SCRWID*4)],ebx
	mov	[edi+1+(SCRWID*5)],ebx

@@plot_65a:
	add	edi,5

plot_66:
	or	al,al
	jz	@@plot_66a

    	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx
	mov	[edi+(SCRWID*2)],bx
	mov	[edi+(SCRWID*3)],bx
	mov	[edi+(SCRWID*4)],bx
	mov	[edi+(SCRWID*5)],bx
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+2],ebx
	mov	[edi+2+SCRWID],ebx
	mov	[edi+2+(SCRWID*2)],ebx
	mov	[edi+2+(SCRWID*3)],ebx
	mov	[edi+2+(SCRWID*4)],ebx
	mov	[edi+2+(SCRWID*5)],ebx

@@plot_66a:
	add	edi,6

plot_6end:

slodsd:
	mov	al,[esi]	; Get graphic pixel data.
	dec	esi             ;
slodsdend:

fsize_sprite_	ENDP

;****************************************************
;* Expand flipped sprite routine with transparancy. *
;****************************************************

fsize_sprite_trans_	PROC C PUBLIC

	cld                             ; Clear direction flag.

	pushad                         	; Store all registers.

	movzx	ebx,[eax+acb.s_ylines]	; Minimum Y lines to draw.
	mov	ylines1,ebx
	mov	ebp,eax                 ; Store EAX.

	mov	edi,draw_line_tb 	; Create routine to draw tob/bottom line(s) of sprite.
 	call	create_draw_tb_tline	;

	mov	eax,ebp			; Restore EAX.
	mov	edi,draw_line1

	mov	ebx,ylines1
	cmp	ebx,2
	jge	@@y2

@@y1:
	mov	yadd1,SCRWID
	mov	yadd2,SCRWID*2

 	call	create_draw_1tline     	;
	mov	edi,draw_line2          ;
	mov	eax,ebp                 ; Create routines for x2 - x3 sprites.
	call	create_draw_2tlines	;
	jmp	@@cdl_done              ;

@@y2:
	cmp	ebx,3
	jge	@@y3

	mov	yadd1,SCRWID*2
	mov	yadd2,SCRWID*3

 	call	create_draw_2tlines     	;
	mov	edi,draw_line2          ;
	mov	eax,ebp                 ; Create routines for x2 - x3 sprites.
	call	create_draw_3tlines      ;
	jmp	@@cdl_done              ;

@@y3:
	cmp	ebx,4
	jge	@@y4

	mov	yadd1,SCRWID*3
	mov	yadd2,SCRWID*4

	call	create_draw_3tlines      ;
	mov	edi,draw_line2          ;
	mov	eax,ebp                 ; Create routines for x3 - x4 sprites.
 	call	create_draw_4tlines      ;
	jmp	@@cdl_done              ;

@@y4:
	cmp	ebx,5
	jge	@@y5

	mov	yadd1,SCRWID*4
	mov	yadd2,SCRWID*5

	call	create_draw_4tlines     	;
	mov	edi,draw_line2          ;
	mov	eax,ebp                 ; Create routines for x4 - x5 sprites.
 	call	create_draw_5tlines      ;
	jmp	@@cdl_done              ;

@@y5:
	mov	yadd1,SCRWID*5
	mov	yadd2,SCRWID*6

	call	create_draw_5tlines  	;
	mov	edi,draw_line2          ;
	mov	eax,ebp                 ; Create routines for x5 - x6 sprites.
 	call	create_draw_6tlines      ;

@@cdl_done:
	mov	eax,ebp                 	; Restore EAX.

	movzx	ecx,[eax+acb.s_scr_xpos] 	; Get screen X pos.
	movzx	edx,[eax+acb.s_scr_ypos]	; Get screen Y pos.

	imul	edx,SCRWID              	;
	mov 	edi,SCR_PTR          		;
	add	ecx,edx                 	; Get screen offset

	mov	esi,g_addr              	;
	add	esi,[eax+acb.s_dataoff]         ; Get graphics address.

	add	edi,ecx                 	; Add screen offset to screen address.

	mov	ebx,[eax+acb.s_yscale]     	;
	mov	scale,bx 	            	; Store Y scale.

	mov	ecx,[eax+acb.s_init_yscale] 	; Get clipped Y scale value.
	and	ecx,0ffffh                      ; Keep fraction.

	mov	bx,[eax+acb.s_yloop]
	mov	yloop,bx

	movzx	eax,[eax+acb.s_xsize]   ;
	mov	xsize,eax  		; Get sprite X size.

@@yloop:
	xor	eax,eax		; Set Y lines count to 0.
@@count:
	inc	eax		; Increase Y lines count.

	dec	yloop		; Decrease Y count.
	jz	@@last		;

	add   	cx,scale        ; Next graphic data line?
	jnc	@@count         ; No!

	cmp	eax,ylines1     ;
	jl	@@singles       ; Draw part of block?

	je	@@dl1		; Draw whole block.

@@dl2:
	mov	ebp,esi    	; Store esi.
	mov	sedi,edi       	; Store edi.

	call	draw_line2	; Draw a line of sprite.

	mov	edi,sedi    	; Restore edi.
	mov	esi,ebp		; Restore esi.

	add	edi,yadd2	; Next screen line.
	jmp	@@drawn

@@dl1:
	mov	ebp,esi    	; Store esi.
	mov	sedi,edi       	; Store edi.

	call	draw_line1	; Draw a line of sprite.

	mov	edi,sedi    	; Restore edi.
	mov	esi,ebp		; Restore esi.

	add	edi,yadd1	; Next screen line.
	jmp	@@drawn

@@singles:
	mov	bp,ax		; Setup loop count.

@@sloop:
 	mov	sesi,esi	; Store esi.
	mov	sedi,edi        ; Store edi.

	call	draw_line_tb   	; Draw line of sprite.

	mov	edi,sedi        ; Restore edi.
 	mov	esi,sesi        ; Restore esi.

	add	edi,SCRWID
	dec	bp              ; Decrease loop count....
	jnz	@@sloop       	; ...repeat until zero.

@@drawn:
	add	esi,xsize    	; Get next graphic data line.
	jmp	@@yloop       	; Do next line.

@@last:
	mov	bp,ax
@@lloop:
 	mov	sesi,esi
	mov	sedi,edi

	call	draw_line_tb

	mov	edi,sedi
	mov	esi,sesi

	add	edi,SCRWID

	dec	bp
	jnz	@@lloop
@@end:
	popad

	ret

;****************************************************
;* Create draw tob/bottom transparent line routine. *
;****************************************************

create_draw_tb_tline:
	mov	edx,OFFSET scaletab	; Graphics offset table.
	movzx	eax,[eax+acb.s_xloop]

@@11bytetb:
	mov	ecx,slodsdend-slodsd	;
	mov	esi,slodsd              ; Read a byte of data.
	rep	movsb                   ;

	or	ax,ax                  	; X loop over?
	jz	@@cd1l_endtb            ;

	mov	ebx,[edx]               ;
	add	edx,4                   ; Get data offset into EBX.

	cmp	ebx,[edx]		;
	je	@@12bytestb             ; Next X?

@@11byteatb:
	sub	ax,1

	mov	ecx,tbplot_12-tbplot_11	;
	mov	esi,tbplot_11           ; Plot one pixel wide.
	rep	movsb                   ;

	jmp	@@11bytetb

@@12bytestb:
	add	edx,4                   ;
	cmp	ebx,[edx]		; Next X?
	je	@@13bytestb             ;

@@12bytesatb:
	cmp	ax,2               	; Will 2 pixels fit?
	jl	@@11byteatb             ;

	sub	ax,2
	mov	ecx,tbplot_13-tbplot_12 ;
	mov	esi,tbplot_12           ; Plot 2 pixels wide.
	rep	movsb                   ;

	jmp	@@11bytetb

@@13bytestb:
	add	edx,4                   ;
	cmp	ebx,[edx]		; Next X?
	je	@@14bytestb

@@13bytesatb:
	cmp	ax,3
	jl	@@12bytesatb

	sub	ax,3
	mov	ecx,tbplot_14-tbplot_13
	mov	esi,tbplot_13
	rep	movsb

	jmp	@@11bytetb

@@14bytestb:
	add	edx,4                   ;
	cmp	ebx,[edx]		; Next X?
	je	@@15bytestb

@@14bytesatb:
	cmp	ax,4
	jl 	@@13bytesatb

	sub	ax,4
	mov	ecx,tbplot_15-tbplot_14
	mov	esi,tbplot_14
	rep	movsb

	jmp	@@11bytetb

@@15bytestb:
	add	edx,4                   ;
	cmp	ebx,[edx]		; Next X?
	je	@@16bytestb

@@15bytesatb:
	cmp	ax,5
	jl 	@@14bytesatb

	sub	ax,5
	mov	ecx,tbplot_16-tbplot_15
	mov	esi,tbplot_15
	rep	movsb

	jmp	@@11bytetb

@@16bytestb:
	add	edx,4                   ;

	cmp	ax,6
	jl 	@@15bytesatb

	sub	ax,6
	mov	ecx,tbplot_1end-tbplot_16
	mov	esi,tbplot_16
	rep	movsb

	jmp	@@11bytetb

@@cd1l_endtb:
	mov	al,0c3h			; Return.
	mov 	[edi],al		; Faster than a stosb!!

	ret

;*******************************************
;* Draw tob/bottom line of sprite modules. *
;*******************************************

tbplot_11:
	or	al,al
	jz	@@tbplot_11a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al

@@tbplot_11a:
	inc	edi

tbplot_12:
	or	al,al
	jz	@@tbplot_12a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	bl,al
	mov	bh,al
	mov	[edi],bx

@@tbplot_12a:
	add	edi,2

tbplot_13:
	or	al,al
	jz	@@tbplot_13a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
	mov	bl,al
  	mov	bh,al
 	mov	[edi+1],bx

@@tbplot_13a:
	add	edi,3

tbplot_14:
	or	al,al
	jz	@@tbplot_14a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

     	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi],ebx


@@tbplot_14a:
	add	edi,4

tbplot_15:
	or	al,al
	jz	@@tbplot_15a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

     	mov	bl,al
	mov	bh,al
	mov	[edi],bl
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+1],ebx


@@tbplot_15a:
	add	edi,5

tbplot_16:
	or	al,al
	jz	@@tbplot_16a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

     	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+2],ebx

@@tbplot_16a:
	add	edi,6

tbplot_1end:

;******************************
;* Create draw_1line routine. *
;******************************

create_draw_1tline:
	mov	edx,OFFSET scaletab
	movzx	eax,[eax+acb.s_xloop]

@@11byte:
	mov	ecx,slodsdend-slodsd
	mov	esi,slodsd
	rep	movsb

	or	ax,ax
	jz	@@cd1l_end

	mov	ebx,[edx]
	add	edx,4

	cmp	ebx,[edx]
	je	@@12bytes

@@11bytea:
	sub	ax,1

	mov	ecx,plot_12-plot_11
	mov	esi,plot_11
	rep	movsb

	jmp	@@11byte

@@12bytes:
	add	edx,4

	cmp	ax,2
	jl	@@11bytea

	sub	ax,2
	mov	ecx,plot_1end-plot_12
	mov	esi,plot_12
	rep	movsb

	jmp	@@11byte

@@cd1l_end:
	mov	al,0c3h			; Return.
	mov	[edi],al		; Faster than a stosb!!

	ret

;*******************************
;* Create draw_2lines routine. *
;*******************************

create_draw_2tlines:
	mov	edx,OFFSET scaletab
	movzx	eax,[eax+acb.s_xloop]

@@21byte:
	mov	ecx,slodsdend-slodsd
	mov	esi,slodsd
	rep	movsb

	or	ax,ax
	jz	@@cd2l_end

	mov	ebx,[edx]
	add	edx,4

	cmp	ebx,[edx]
	je	@@22bytes

@@21bytea:
  	sub	ax,1

	mov	ecx,plot_22-plot_21
	mov	esi,plot_21
	rep	movsb

	jmp	@@21byte

@@22bytes:
	add	edx,4
	cmp	ebx,[edx]

	je	@@23bytes

@@22bytesa:
	cmp	ax,2
	jl	@@21bytea

	sub	ax,2
	mov	ecx,plot_23-plot_22
	mov	esi,plot_22
	rep	movsb

	jmp	@@21byte

@@23bytes:
	add	edx,4

	cmp	ax,3
	jl	@@22bytesa

	sub	ax,3
	mov	ecx,plot_2end-plot_23
	mov	esi,plot_23
	rep	movsb

	jmp	@@21byte

@@cd2l_end:
	mov	al,0c3h			; Return.
	mov	[edi],al		; Faster than a stosb!!

	ret

;*******************************
;* Create draw_3lines routine. *
;*******************************

create_draw_3tlines:
	mov	edx,OFFSET scaletab
	movzx	eax,[eax+acb.s_xloop]

@@31byte:
	mov	ecx,slodsdend-slodsd
	mov	esi,slodsd
	rep	movsb

	or	ax,ax
	jz	@@cd3l_end

	mov	ebx,[edx]
	add	edx,4

	cmp	ebx,[edx]
	je	@@32bytes

@@31bytea:
	sub	ax,1

	mov	ecx,plot_32-plot_31
	mov	esi,plot_31
	rep	movsb

	jmp	@@31byte

@@32bytes:
	add	edx,4
	cmp	ebx,[edx]
	je	@@33bytes

@@32bytesa:
	cmp	ax,2
	jl	@@31bytea

	sub	ax,2
	mov	ecx,plot_33-plot_32
	mov	esi,plot_32
	rep	movsb

	jmp	@@31byte

@@33bytes:
	add	edx,4
	cmp	ebx,[edx]
	je	@@34bytes

@@33bytesa:
	cmp	ax,3
	jl	@@32bytesa

	sub	ax,3
	mov	ecx,plot_34-plot_33
	mov	esi,plot_33
	rep	movsb

	jmp	@@31byte

@@34bytes:
	add	edx,4

	cmp	ax,4
	jl	@@33bytesa

	sub	ax,4
	mov	ecx,plot_3end-plot_34
	mov	esi,plot_34
	rep	movsb

	jmp	@@31byte

@@cd3l_end:
	mov	al,0c3h			; Return.
	mov	[edi],al		; Faster than a stosb!!

	ret

;*******************************
;* Create draw_4lines routine. *
;*******************************

create_draw_4tlines:
	mov	edx,OFFSET scaletab
	movzx	eax,[eax+acb.s_xloop]

@@41byte:
	mov	ecx,slodsdend-slodsd
	mov	esi,slodsd
	rep	movsb

	or	ax,ax
	jz	@@cd4l_end

	mov	ebx,[edx]
	add	edx,4

	cmp	ebx,[edx]
	je	@@42bytes

@@41bytea:
	dec	ax

	mov	ecx,plot_42-plot_41
	mov	esi,plot_41
	rep	movsb

	jmp	@@41byte

@@42bytes:
	add	edx,4
	cmp	ebx,[edx]
	je	@@43bytes

@@42bytesa:
	cmp	ax,2
	jl	@@41bytea

	sub	ax,2
	mov	ecx,plot_43-plot_42
	mov	esi,plot_42
	rep	movsb

	jmp	@@41byte

@@43bytes:
	add	edx,4
	cmp	ebx,[edx]
	je	@@44bytes

@@43bytesa:
	cmp	ax,3
	jl	@@42bytesa

	sub	ax,3
	mov	ecx,plot_44-plot_43
	mov	esi,plot_43
	rep	movsb

	jmp	@@41byte

@@44bytes:
	add	edx,4
	cmp	ebx,[edx]
	je	@@45bytes

@@44bytesa:
	cmp	ax,4
	jl 	@@43bytesa

	sub	ax,4
	mov	ecx,plot_45-plot_44
	mov	esi,plot_44
	rep	movsb

	jmp	@@41byte

@@45bytes:
	add	edx,4

	cmp	ax,5
	jl 	@@44bytesa

	sub	ax,5
	mov	ecx,plot_4end-plot_45
	mov	esi,plot_45
	rep	movsb

	jmp	@@41byte

@@cd4l_end:
	mov	al,0c3h			; Return.
	mov	[edi],al		; Faster than a stosb!!

	ret

;*******************************
;* Create draw_5lines routine. *
;*******************************

create_draw_5tlines:
	mov	edx,OFFSET scaletab
	movzx	eax,[eax+acb.s_xloop]

@@51byte:
	mov	ecx,slodsdend-slodsd
	mov	esi,slodsd
	rep	movsb

	or	ax,ax
	jz	@@cd5l_end

	mov	ebx,[edx]
	add	edx,4

	cmp	ebx,[edx]
	je	@@52bytes

@@51bytea:
	dec	ax

	mov	ecx,plot_52-plot_51
	mov	esi,plot_51
	rep	movsb

	jmp	@@51byte

@@52bytes:
	add	edx,4
	cmp	ebx,[edx]
	je	@@53bytes

@@52bytesa:
	cmp	ax,2
	jl	@@51bytea

	sub	ax,2
	mov	ecx,plot_53-plot_52
	mov	esi,plot_52
	rep	movsb

	jmp	@@51byte

@@53bytes:
	add	edx,4
	cmp	ebx,[edx]
	je	@@54bytes

@@53bytesa:
	cmp	ax,3
	jl	@@52bytesa

	sub	ax,3
	mov	ecx,plot_54-plot_53
	mov	esi,plot_53
	rep	movsb

	jmp	@@51byte

@@54bytes:
	add	edx,4
	cmp	ebx,[edx]
	je	@@55bytes

@@54bytesa:
	cmp	ax,4
	jl 	@@53bytesa

	sub	ax,4
	mov	ecx,plot_55-plot_54
	mov	esi,plot_54
	rep	movsb

	jmp	@@51byte

@@55bytes:
	add	edx,4
	cmp	ebx,[edx]
	je	@@56bytes

@@55bytesa:
	cmp	ax,5
	jl 	@@54bytesa

	sub	ax,5
	mov	ecx,plot_56-plot_55
	mov	esi,plot_55
	rep	movsb

	jmp	@@51byte

@@56bytes:
	add	edx,4

	cmp	ax,6
	jl 	@@55bytesa

	sub	ax,6
	mov	ecx,plot_5end-plot_56
	mov	esi,plot_56
	rep	movsb

	jmp	@@51byte

@@cd5l_end:
	mov	al,0c3h			; Return.
	mov	[edi],al		; Faster than a stosb!!

	ret

;*******************************
;* Create draw_6lines routine. *
;*******************************

create_draw_6tlines:
	mov	edx,OFFSET scaletab
	movzx	eax,[eax+acb.s_xloop]

@@61byte:
	mov	ecx,slodsdend-slodsd
	mov	esi,slodsd
	rep	movsb

	or	ax,ax
	jz	@@cd6l_end

	mov	ebx,[edx]
	add	edx,4

	cmp	ebx,[edx]
	je	@@62bytes

@@61bytea:
	dec	ax

	mov	ecx,plot_62-plot_61
	mov	esi,plot_61
	rep	movsb

	jmp	@@61byte

@@62bytes:
	add	edx,4
	cmp	ebx,[edx]
	je	@@63bytes

@@62bytesa:
	cmp	ax,2
	jl	@@61bytea

	sub	ax,2
	mov	ecx,plot_63-plot_62
	mov	esi,plot_62
	rep	movsb

	jmp	@@61byte

@@63bytes:
	add	edx,4
	cmp	ebx,[edx]
	je	@@64bytes

@@63bytesa:
	cmp	ax,3
	jl	@@62bytesa

	sub	ax,3
	mov	ecx,plot_64-plot_63
	mov	esi,plot_63
	rep	movsb

	jmp	@@61byte

@@64bytes:
	add	edx,4
	cmp	ebx,[edx]
	je	@@65bytes

@@64bytesa:
	cmp	ax,4
	jl 	@@63bytesa

	sub	ax,4
	mov	ecx,plot_65-plot_64
	mov	esi,plot_64
	rep	movsb

	jmp	@@61byte

@@65bytes:
	add	edx,4
	cmp	ebx,[edx]
	je	@@66bytes

@@65bytesa:
	cmp	ax,5
	jl 	@@64bytesa

	sub	ax,5
	mov	ecx,plot_66-plot_65
	mov	esi,plot_65
	rep	movsb

	jmp	@@61byte

@@66bytes:
	add	edx,4

	cmp	ax,6
	jl 	@@65bytesa

	sub	ax,6
	mov	ecx,plot_6end-plot_66
	mov	esi,plot_66
	rep	movsb

	jmp	@@61byte

@@cd6l_end:
	mov	al,0c3h			; Return.
	mov	[edi],al		; Faster than a stosb!!

	ret

;**********************************
;* Draw 1 line of sprite modules. *
;**********************************

plot_11:
	or	al,al
	jz	@@plot_11a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al

@@plot_11a:
	inc	edi

plot_12:
	or	al,al
	jz	@@plot_12a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	bl,al
	mov	bh,al
	mov	[edi],bx

@@plot_12a:
	add	edi,2

plot_1end:

;***********************************
;* Draw 2 lines of sprite modules. *
;***********************************

plot_21:
	or	al,al
	jz	@@plot_21a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
	mov	[edi+SCRWID],al

@@plot_21a:
	inc	edi

plot_22:
	or	al,al
	jz	@@plot_22a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx

@@plot_22a:
	add	edi,2

plot_23:
	or	al,al
	jz	@@plot_23a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
 	mov	[edi+SCRWID],al
	mov	bl,al
	mov	bh,al
 	mov	[edi+1],bx
 	mov	[edi+1+SCRWID],bx

@@plot_23a:
	add	edi,3

plot_2end:

;***********************************
;* Draw 3 lines of sprite modules. *
;***********************************

plot_31:
	or	al,al
	jz	@@plot_31a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al

@@plot_31a:
	inc	edi

plot_32:
	or	al,al
	jz	@@plot_32a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx
	mov	[edi+(SCRWID*2)],bx

@@plot_32a:
	add	edi,2

plot_33:
	or	al,al
	jz	@@plot_33a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	bl,al
	mov	bh,al
 	mov	[edi+1],bx
 	mov	[edi+1+SCRWID],bx
 	mov	[edi+1+(SCRWID*2)],bx

@@plot_33a:
	add	edi,3

plot_34:
	or	al,al
	jz	@@plot_34a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	bl,al
	mov	bh,al
	shl	ebx,16
	mov	bl,al
	mov	bh,al
	mov	[edi],ebx
	mov	[edi+SCRWID],ebx
	mov	[edi+(SCRWID*2)],ebx

@@plot_34a:
	add	edi,4

plot_3end:

;***********************************
;* Draw 4 lines of sprite modules. *
;***********************************

plot_41:
	or	al,al
	jz	@@plot_41a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al

@@plot_41a:
	inc	edi

plot_42:
	or	al,al
	jz	@@plot_42a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx
	mov	[edi+(SCRWID*2)],bx
	mov	[edi+(SCRWID*3)],bx

@@plot_42a:
	add	edi,2

plot_43:
	or	al,al
	jz	@@plot_43a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	bl,al
  	mov	bh,al
 	mov	[edi+1],bx
 	mov	[edi+1+SCRWID],bx
 	mov	[edi+1+(SCRWID*2)],bx
 	mov	[edi+1+(SCRWID*3)],bx

@@plot_43a:
	add	edi,3

plot_44:
	or	al,al
	jz	@@plot_44a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

     	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi],ebx
	mov	[edi+SCRWID],ebx
	mov	[edi+(SCRWID*2)],ebx
	mov	[edi+(SCRWID*3)],ebx

@@plot_44a:
	add	edi,4

plot_45:
	or	al,al
	jz	@@plot_45a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
     	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+1],ebx
	mov	[edi+1+SCRWID],ebx
	mov	[edi+1+(SCRWID*2)],ebx
	mov	[edi+1+(SCRWID*3)],ebx

@@plot_45a:
	add	edi,5

plot_4end:

;***********************************
;* Draw 5 lines of sprite modules. *
;***********************************

plot_51:
	or	al,al
	jz	@@plot_51a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	[edi+(SCRWID*4)],al

@@plot_51a:
	inc	edi

plot_52:
	or	al,al
	jz	@@plot_52a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx
	mov	[edi+(SCRWID*2)],bx
	mov	[edi+(SCRWID*3)],bx
	mov	[edi+(SCRWID*4)],bx

@@plot_52a:
	add	edi,2

plot_53:
	or	al,al
	jz	@@plot_53a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	[edi+(SCRWID*4)],al
	mov	bl,al
  	mov	bh,al
 	mov	[edi+1],bx
 	mov	[edi+1+SCRWID],bx
 	mov	[edi+1+(SCRWID*2)],bx
 	mov	[edi+1+(SCRWID*3)],bx
 	mov	[edi+1+(SCRWID*4)],bx

@@plot_53a:
	add	edi,3

plot_54:
	or	al,al
	jz	@@plot_54a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

     	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi],ebx
	mov	[edi+SCRWID],ebx
	mov	[edi+(SCRWID*2)],ebx
	mov	[edi+(SCRWID*3)],ebx
	mov	[edi+(SCRWID*4)],ebx

@@plot_54a:
	add	edi,4

plot_55:
	or	al,al
	jz	@@plot_55a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	[edi+(SCRWID*4)],al
     	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+1],ebx
	mov	[edi+1+SCRWID],ebx
	mov	[edi+1+(SCRWID*2)],ebx
	mov	[edi+1+(SCRWID*3)],ebx
	mov	[edi+1+(SCRWID*4)],ebx

@@plot_55a:
	add	edi,5

plot_56:
	or	al,al
	jz	@@plot_56a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

    	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx
	mov	[edi+(SCRWID*2)],bx
	mov	[edi+(SCRWID*3)],bx
	mov	[edi+(SCRWID*4)],bx
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+2],ebx
	mov	[edi+2+SCRWID],ebx
	mov	[edi+2+(SCRWID*2)],ebx
	mov	[edi+2+(SCRWID*3)],ebx
	mov	[edi+2+(SCRWID*4)],ebx

@@plot_56a:
	add	edi,6

plot_5end:

;***********************************
;* Draw 6 lines of sprite modules. *
;***********************************

plot_61:
	or	al,al
	jz	@@plot_61a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	[edi+(SCRWID*4)],al
	mov	[edi+(SCRWID*5)],al

@@plot_61a:
	inc	edi

plot_62:
	or	al,al
	jz	@@plot_62a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx
	mov	[edi+(SCRWID*2)],bx
	mov	[edi+(SCRWID*3)],bx
	mov	[edi+(SCRWID*4)],bx
	mov	[edi+(SCRWID*5)],bx

@@plot_62a:
	add	edi,2

plot_63:
	or	al,al
	jz	@@plot_63a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	[edi+(SCRWID*4)],al
	mov	[edi+(SCRWID*5)],al
	mov	bl,al
  	mov	bh,al
 	mov	[edi+1],bx
 	mov	[edi+1+SCRWID],bx
 	mov	[edi+1+(SCRWID*2)],bx
 	mov	[edi+1+(SCRWID*3)],bx
 	mov	[edi+1+(SCRWID*4)],bx
 	mov	[edi+1+(SCRWID*5)],bx

@@plot_63a:
	add	edi,3

plot_64:
	or	al,al
	jz	@@plot_64a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

     	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi],ebx
	mov	[edi+SCRWID],ebx
	mov	[edi+(SCRWID*2)],ebx
	mov	[edi+(SCRWID*3)],ebx
	mov	[edi+(SCRWID*4)],ebx
	mov	[edi+(SCRWID*5)],ebx

@@plot_64a:
	add	edi,4

plot_65:
	or	al,al
	jz	@@plot_65a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

	mov	[edi],al
	mov	[edi+SCRWID],al
	mov	[edi+(SCRWID*2)],al
	mov	[edi+(SCRWID*3)],al
	mov	[edi+(SCRWID*4)],al
	mov	[edi+(SCRWID*5)],al
    	mov	bl,al
	mov	bh,al
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+1],ebx
	mov	[edi+1+SCRWID],ebx
	mov	[edi+1+(SCRWID*2)],ebx
	mov	[edi+1+(SCRWID*3)],ebx
	mov	[edi+1+(SCRWID*4)],ebx
	mov	[edi+1+(SCRWID*5)],ebx

@@plot_65a:
	add	edi,5

plot_66:
	or	al,al
	jz	@@plot_66a

 	movzx	ebx,BYTE PTR [edi]	;
	shl	ebx,8                   ; Get transparancy depth que table address.
	add	ebx,interpol_tab     	;
	xlatb

    	mov	bl,al
	mov	bh,al
	mov	[edi],bx
	mov	[edi+SCRWID],bx
	mov	[edi+(SCRWID*2)],bx
	mov	[edi+(SCRWID*3)],bx
	mov	[edi+(SCRWID*4)],bx
	mov	[edi+(SCRWID*5)],bx
	shl	ebx,16
     	mov	bl,al
	mov	bh,al
	mov	[edi+2],ebx
	mov	[edi+2+SCRWID],ebx
	mov	[edi+2+(SCRWID*2)],ebx
	mov	[edi+2+(SCRWID*3)],ebx
	mov	[edi+2+(SCRWID*4)],ebx
	mov	[edi+2+(SCRWID*5)],ebx

@@plot_66a:
	add	edi,6

plot_6end:

slodsd:
	mov	al,[esi]
	dec	esi
slodsdend:

fsize_sprite_trans_	ENDP

;***********************************
;* Generic sprite drawing routine. *
;***********************************

generic_spr_	PROC C PUBLIC

	pushad

	movzx	edx,[eax+acb.s_scr_ypos]
	movzx	ecx,[eax+acb.s_scr_xpos]

	imul	edx,SCRWID

	mov 	edi,scr_ptr
	mov	esi,g_addr
	add	edi,ecx

	movzx	ebx,WORD PTR [esi]  	; X size.
	add	esi,2
	inc	ebx

	add	edi,edx

	mov	ebp,SCRWID
	movzx	ecx,WORD PTR[esi]   	; Y loop.
	sub	ebp,ebx
	add	esi,2

@@yloop:
	mov	edx,ebx		;setup X-loop count.

@@xloop:
	mov	al,[esi]
	or	al,al
	jz	@@noplot

	mov	[edi],al

@@noplot:
	inc	esi		; Increase graphics address.
	inc	edi		; Increase screen address.

	dec	edx		;draw whole row.
	jnz	@@xloop		;

	add	edi,ebp

	dec	ecx
	jnz	@@yloop

	popad
	ret

generic_spr_	ENDP

	END



