//ͻ
// UPDATE LOG: BASICS.H                                                     
//                                                                          
// date         update by       description                                 
//                                                  
//                                                                          
//                                                                          
//                                                                          
//                                                                          
//ͼ

#ifndef _BASICS_H_INCLUDED
#define _BASICS_H_INCLUDED

#include "typedefs.h"
#include "debug.h"

/****************************************************************************/

#define	MCGA_RAM 0XA0000

#if DEBUGGING==0
	#define	ifkey(k)	if(keydata->keymap[k])
#else
	#define	ifkey(k)	if(keydata->last_key==(k))
	#define	get_key	getbioskey
#endif

#if DEBUGGING==0
	#define	rawkey(k)	(keydata->keymap[k])
#else
	#define	rawkey(k)	(keydata->last_key==(k))
#endif


#define	RWSIZE	32256			// read/write chunks of this size

#define	MAX_MEM	128			// maximum number of allocated memory lumps

#define	D32RealSeg(P)	((((dword) (P)) >> 4) & 0xffff)
#define	D32RealOff(P)	(((dword) (P)) & 0xf)

#define FALSE	0
#define TRUE	!FALSE

#define TIMER_SPEED 1193180		// hz rate of timer

/****************************************************************************/

enum DISK_ERRORS {			// errors returned by critical error handler
	E_WPROT = 1, E_DRIVENO, E_NODISK, E_UNKNOWN, E_DATERROR, E_BADLEN,
	E_SEEK, E_FORMAT, E_SECTOR, E_NOPAPER, E_WRITE, E_READ, E_GENERAL,
	E_CHANGE = 16
};


#define E_OK			0  	// error numbers given as parameter to
#define E_OPEN			-1 	// getout()
#define E_MEMORY		-2
#define E_IO			-3
#define E_DISKERR		-4
#define E_DOSMEM		-5
#define E_NOMOUSE		-6
#define E_CREATE		-7
#define E_TOOMANY		-8
#define E_MEMLUMPS	-9
#define E_VIDEO		-10

#define MAX_FILES 32

#ifndef DISK_C
#define close my_close
#endif

#define MAX_DOSERROR 39

/****************************************************************************/

enum keys {	// equates for key scancodes

	K_ESC=1, K_1, K_2, K_3, K_4, K_5, K_6, K_7, K_8, K_9, K_0,
	K_MINUS, K_PLUS, K_BSP, K_TAB, K_Q, K_W, K_E, K_R, K_T, K_Y, K_U, K_I,
	K_O, K_P, K_OPENSB, K_CLOSESB, K_RET, K_CTRL, K_A, K_S, K_D, K_F, K_G,
	K_H, K_J, K_K, K_L, K_COLON, K_APOST, K_APOST2, K_LSHIFT, K_BSLASH,
	K_Z, K_X, K_C, K_V, K_B, K_N, K_M, K_COMMA, K_DOT, K_SLASH, K_RSHIFT,
	K_PRINT, K_ALT, K_SPACE, K_CAPS, K_F1, K_F2, K_F3, K_F4, K_F5, K_F6,
	K_F7, K_F8, K_F9, K_F10, K_NUMLOCK, K_SCRLOCK, K_HOME, K_UP, K_PGUP,
	K_KMINUS, K_LEFT, K_K5, K_RIGHT, K_KPLUS, K_END, K_DOWN, K_PGDN, K_INS,
	K_DEL, K_SYSREQ, K_F11=0x57, K_F12 };

#define SIZE_KEYMAP 128			// 128 possible keys
#define SIZE_KEYBUF 64			// room for 64 keys in the keyboard buffer

/****************************************************************************/

struct keystuff {
	uchar	keymap[SIZE_KEYMAP]; //keymap array, 0 = released, -1 = pressed
	uchar	keybuf[SIZE_KEYBUF];
	ushort	bufin;
	ushort	bufout;
	ushort	bufchars;
	uchar	more;
	uchar	action;
	uchar	last_key;	// last key pressed
	uchar	keys_held;	// number of keys currently held down
};

struct todstuff {
	word		old_rmoff;
	word		old_rmseg;
	dword	old_pmoff;
	word		old_pmseg;
	word		tod_count;
	dword	clock;		// big clock counter, 60hz
	word		vbl_count;	// no. of vbls since last sync()
	word		clk_splits[32];	// split timings for timer
	word		no_splits;	// number of splits
	word		split_no;	// next split number
	word		vbl_timerval;	// value returned by calc_vbltimer()
	word		fadecnt;	// frames left during fade
	uchar	source_pal[768]; // the original palette
	word		delta_pal[768];	// palette used for fade calculation
	word		work_pal[768];	// current palette
	char		fadestart;
	char		fadestop;
	char		fadeflip;
	char		vbl_flag;	// flag to say vbl has been done
	uchar	colour;
};

struct brkstuff {
	dword		nothing;
};

struct critstuff {
	char	diskerr;							//value returned by critical error handler
};

struct soundstuff {
	word		old_rmoff;
	word		old_rmseg;
	dword	old_pmoff;
	word		old_pmseg;
	word		sbp_base;
	word		sb_addr;
	uchar	sb_page;
	word		sb_length;
	word		sb_length1;
	word		sb_count;
	uchar	sb_rate;
	uchar	sb_mode;
	uchar	sb_status;
	word		addr_delay;
	word		data_delay;
	word		int_flag;
};

struct soundinst {
	word		old_rmoff;
	word		old_rmseg;
	dword	old_pmoff;
	word		old_pmseg;
	word		sbp_base;
	word		addr_delay;
	word		data_delay;
	word		int_flag;
};

/****************************************************************************/

extern void __interrupt pm_keyint(void);
extern void __interrupt pm_vblint(void);
extern void __interrupt pm_todint(void);
extern void __interrupt pm_brkint(void);
extern void __interrupt pm_critint(void);
extern void __interrupt pm_int_sbinstall(void);
extern void __interrupt pm_sb_irq(void);

extern int start_keystuff;
extern int start_todstuff;
extern int start_vblstuff;
extern int start_brkstuff;
extern int start_critstuff;
extern int start_soundinst;
extern int start_soundstuff;

extern int pm_landmark();



extern int end_keystuff;
extern int end_todstuff;
extern int end_vblstuff;
extern int end_brkstuff;
extern int end_critstuff;
extern int end_soundinst;
extern int end_soundstuff;

extern int getbioskey(void);		//bios version of get_key routine

extern word old_rmtodoff;
extern word old_rmtodseg;
extern void start_tod(void);
extern void init_tod(void);
extern void reset_tod(void);

extern struct keystuff *keydata;	// pointer to keyboard handler data area
extern struct todstuff *toddata;	// pointer to timer handler data area
extern struct brkstuff *brkdata;	// pointer to program break data area
extern struct critstuff *critdata;	// pointer to critical error data area
extern struct soundstuff *sounddata;	// pointer to sound blaster handler data area
extern struct soundstuff *isounddata;	// pointer to sound blaster handler data area

extern word read_timer(void);
extern int calc_vbltimer(void);

/****************************************************************************/

/////////////////////////the joystick variables/////////////////////////////
////////////////////refer to input.s for descriptions///////////////////////

/*extern char joy_mask;
extern char joy_check;
extern word joy_timeout;

extern char joy1_fire;
extern char joy2_fire;

extern sword joy1_xc;
extern sword joy1_yc;
extern sword joy1_lscale;
extern sword joy1_rscale;
extern sword joy1_uscale;
extern sword joy1_dscale;
extern sword joy1_x;
extern sword joy1_y;
extern word joy1_xcentre;
extern word joy1_ycentre;
extern sword joy1_lthresh;
extern sword joy1_rthresh;
extern sword joy1_uthresh;
extern sword joy1_dthresh;

extern sword joy2_xc;
extern sword joy2_yc;
extern sword joy2_lscale;
extern sword joy2_rscale;
extern sword joy2_uscale;
extern sword joy2_dscale;
extern sword joy2_x;
extern sword joy2_y;
extern word joy2_xcentre;
extern word joy2_ycentre;
extern sword joy2_lthresh;
extern sword joy2_rthresh;
extern sword joy2_uthresh;
extern sword joy2_dthresh;*/

////////////////////////////////////////////////////////////////////////////

/****************************************************************************/

extern int init_mouse(void);
extern int set_mouseparams(void);

extern word mbut;			// bitmask for mouse buttons
extern word mx;				// absolute x-coordinate
extern word my;				// absolute x-coordinate

extern char *copysource, *copydest;	// used by the screen dumping routines

extern void print_text(char *, int, int);
extern char *txt_screen;		// which screen to print text on
extern dword txt_linewid;		// width of the screen line
extern dword txt_linewid8;		// line width * 8
extern uchar txt_col;			// draw colour for text

extern struct handler_data handlers[];	// array of handler data structures

extern void handler(int, int);		// (INSTALL/REMOVE, handler number)

extern char exitstr[];			// 1k buffer can be used for most things

extern char last_fname[];
extern long last_flen;
extern int last_error;
extern int last_fmode;
extern int last_handle;
extern int last_memsize;

extern char curdrive;

int setup(void);								// do basic game setup

void blank_box(int, int, int, int);	// clear an area on screen

extern char *error_txt[];		// array of error messages
extern char *dos_error[];		// array of DOS error messages

extern word mouse_buttons;		// no. of buttons on mouse


extern int memlumps;			// no. of memory chunks allocated
extern ulong memdata[MAX_MEM][2];	// address and size of memory chunks

extern char game_palette[256][3];	// the game palette

extern char *backscr;			// 64k screen, allocated by setup()


extern char *file_names[MAX_FILES];


/****************************************************************************/

//////////////////////////////useful routines///////////////////////////////

// check to see if a key is being held down like this:-
//
// ifkey(K_UP) {
//		...do some stuff...
//	}

extern int get_key(void);		//returns next key in buffer or 0 if empty
extern void wait_vblstart(void); 	// wait for the start of the next vbl
extern void sync(void);			// should be done at start of game loop
extern void setcol(char);		// set the background colour
extern void read_joy(void);		// you guessed it, reads the joystick
extern void fade_to_col(int, int); 	// (no. of frames to fade over, RGB value)
extern void fade_to_pal(int, char *); 	// (no. of frames, palette address)
extern void read_mouse(void);		// read the mouse, sets the variables
extern void clr_screen(void);		// clear screen pointed to by copydest
extern void dump_screen(void);		// dump screen from copysource to copydest
extern void print(int, int, char *, ...); // prints text as printf except


// these open routines all return a file handle //

extern int open_read(char *);		// (fname), opens file for reading

extern int open_write(char *);		// (fname), opens file for read & write

extern int open_new(char *);		// (fname), creates a new file


extern void close(int);			// (handle), close file with this handle

extern void read_blk(int, uchar *, ulong);	// (file handle, data area, len)

extern void write_blk(int, uchar *, ulong);	// (file handle, data area, len)

extern long diskfree(int);		// (drive number)

extern void *install(char *);		// (filename), installs file in memory

extern void clear_keyb(void);		// clears the keyboard buffer

extern void getout(int);		// (error number), quits program

extern void wait_fade(void);		// wait for a fade to finish

/****************************************************************************/

struct handler_data {		// an interrupt handler data structure
	word	pm_seg;			// old protected-mode handler address
	dword pm_off;			//
	word	rm_seg;			// old real-mode handler address
	word	rm_off;			//
	word	done;			// install flag
	word	vector;			// vector number for handler
	void **dataptr;		// address of pointer to handler data area
	char *rmhand_start;		// start of real-mode handler
	void (*init)(void);		// initialization routine, NULL if none
	void (__interrupt *pm_handler)(void);	// protected-mode handler address
	word	datasize;			// size of data area
	char *rmhand_end;		// end of real-mode handler
};

enum handler_op { REMOVE, INSTALL };

enum handler_types {		// the interrupt handler equates
	H_KEYBOARD, H_TOD, H_CTRL_C, H_CRITICAL, H_FMVTOD, H_LANDMARK,
	NUM_HANDLERS
};

#endif

/****************************************************************************/
/*								GAZZA'S STUFF
/****************************************************************************/

extern	int	joy_xmin;
extern	int	joy_xmax;
extern	int	joy_ymin;
extern	int	joy_ymax;
extern	int	joy1_x;				//values from -16 to 16
extern	int	joy1_y;

extern	short	joy_x;
extern	short	joy_y;
extern	char	joy1_fire;
extern	char	joy_flag;

extern	short	scrxsize;
extern	short	scrysize;

/****************************************************************************/

