#include "headers.h"

#include "damage.h"
#include "shock.h"
#include "chuck.h"
#include "e_global.h"

#define 	NUM_SOLID_TEXTURES							52
#define 	NUM_RAGGED_TEXTURES							13
#define 	NUM_TRANSYM_TEXTURES						27
#define 	NUM_TRANASYM_TEXTURES						18
#define 	NUM_ANIMATING_TEXTURES					5

#define 	TRANSPARENT_SYMETRICAL_TEXTURE	2

#define 	PESKY_BRIDGE_TEXTURE_1					12
#define 	PESKY_BRIDGE_TEXTURE_2					13
#define 	PESKY_FUCKED_BRIDGE_TEXTURE_1		25
#define 	PESKY_FUCKED_BRIDGE_TEXTURE_2		26



/*-----------------25/10/95 14:59-------------------


	Concerns the WORLD EXCHANGE of all types of landscape
	destruction- FLOOR_OBJECTS, WALL_GROUPS,
	CRUSHABLE_WALLS.

	MAKE_WORLD_DESTRUCT_PAK- (Divided for each type)
	TRANSLATE_WORLD_DESTRUCT_PAK- (Divided for each class
		of damage)

--------------------------------------------------*/

/*WORLD_ID was used to state which object partition was
 being sent. For damage, this will state the DAMAGE TYPE.
 DAMAGE_ID will refer to the position in whichever DAMAGE
 BUFFER is current. */


/*-----------------02/11/95 21:20-------------------
	WORLD_RECEIVER doesn't destroy already destroyed walls.
--------------------------------------------------*/



/*-----------------25/10/95 15:28-------------------

											GLOBALS

--------------------------------------------------*/

/********FLOOR OBJ SEND***********/

/*During WORLD SEND, WORLD_ID indentifies the TYPE of damage,
 DAMAGE_ID identifies the CURR POSITION IN DAMAGE BUFFER*/

int DAMAGE_ID;
unsigned int DAMAGE_PTR;
int DAMAGE_COUNT= 0;

int NUM_VAPES;

int VAPE_VAL;
int VAPE_ID;

int FOBJS_SENT;
int NUM_FOBJS;


/*This holds the positions of floor objects which, when
	destroyed, have the tile value set to 0*/
unsigned short *vapes= NULL;


/********GROUPWALL SEND************/

int maxBuildingGroupPtr;



/*-----------------25/10/95 15:28-------------------

											FUNCTIONS

--------------------------------------------------*/

/*********************************************************
	DESTROYABLE FLOOR OBJECTS
	*********************************************************/

/*Oh jeesiz- have to form a SPECIAL table holding the
	positions of all objects which will turn to '0' when
	blown up. */


/*First deduce what size the vape table will have to be, then
	allocate and form it*/

void MAKE_VAPE (void)
{
	int fobj_det;
	int fobj_die;
	uchar map_val;
	int pass=0;


	for (pass=0;pass<2;pass++)
	{
		NUM_VAPES= 0;
 		NUM_FOBJS=0;

 		for (i=0;i<0xffff;i++)
 		{
 			map_val = obj_map[i];

 			if (map_val!= 0)
 			{
 				NUM_FOBJS++;

 				if ((fobj_det = det_tabs[region][(map_val-1) << 1]))
 				{
 					/*fobj has !0 destruction radius*/
 					fobj_die = det_tabs[region][((map_val-1) <<1) +1];
 					fobj_die>>=8;

					if (fobj_die==0 )
	 				{
	 					/*When this object is destroyed, the objmap tile is
	 						set to 0*/
						if (pass==1)
	 						vapes[NUM_VAPES]= (ushort) i;

						NUM_VAPES++;

	 				}
	 			}
	 		}
		}/*i*/

		/*First pass ascertained necc size of vape table.*/
		/*Next pass will fill it*/
		if (pass==0)
		{

			if (vapes!=NULL)
				free_mem ((char *) vapes);

			vapes= NULL;

			if (NUM_VAPES==0)
				break;

			vapes= (unsigned short *) get_mem (sizeof (short)* NUM_VAPES);
		}

	}/*pass*/


	/*This is for when it is used for sendin'*/
	FOBJS_SENT=0;
	VAPE_ID=0;

	if (NUM_VAPES!=0)
		VAPE_VAL= vapes[VAPE_ID];

}





/*Make fd_pak a GLOBAL so that it can be resent easily if it
	remains unacknowledged*/



/*DAMAGE_ID global stores the position in the obj_map*/
void FLOOR_DAMAGE_SEND()
{
	char eoPak=0; /*pak either full, or fdamage send is over*/
	short map_val;


	/*winkin' size of WORLD_PAK*/
	WORLD_SIZE=0;
	wp[WORLD_SIZE]= FLOOR_DAMAGE;
	WORLD_SIZE++;


	while (!eoPak)
	{
		/*Seek for the next [occupied/once occupied] obj_map tile*/
		map_val= -1;

		while (map_val==-1&&DAMAGE_ID<0xffff)
		{

			map_val= obj_map[DAMAGE_ID];

			/*DON'T include collectables!*/
			if (map_val >= FIRST_CTBL_SPR && map_val <= LAST_CTBL_SPR)
				/*It may still have been once occupied*/
				map_val= 0;

			if (map_val==0)
			{
				/*Condition checks if square was once occupied*/
				if ( !(DAMAGE_ID==VAPE_VAL))
					map_val= -1;

			}

			DAMAGE_ID++;

			/*Have passed previous VAPE_VAL, so move onto next*/
			if ((DAMAGE_ID>VAPE_VAL) && (VAPE_ID<NUM_VAPES))
			{
				VAPE_ID++;

				if (VAPE_ID<NUM_VAPES)
					VAPE_VAL= vapes[VAPE_ID];
			}


		}/*while (map_val*/


	/*Place the map_val in the fdPak*/

	if (DAMAGE_ID<0xffff)
	{
		wp[WORLD_SIZE++]= map_val;

		FOBJS_SENT++;

		if (WORLD_SIZE>=MAX_WORLDPAK_SIZE)
		{
			/*OUTPUT PAK is FULL*/
			eoPak=1;
		}

	}
	else
		/*ALL FDAMAGE HAS BEEN CHECKED*/
		eoPak=1;

	}


	FLOOR_DAMAGE_PAKS++;

	if (DAMAGE_ID>=0xffff)
	{
		/*The next call to FORM_WORLDDAMAGE will move past FOBJS*/
		DAMAGE_ID= -1;
	}

	return;

}



/*Go thru collectList and put 'em on the map*/
void INSTALL_FLOORMAP_COLLECTABLES (void)
{
	int i;
	COLLECT aCollect;


	for (i=0;i<collectList.lsiz;i++)
	{
		if (collectList.slot[i])
		{
			aCollect= collect[i];
			*(obj_map + collect[i].x + (collect[i].z<<8))=cStat[collect[i].type].sprite;
		}

	}

}




/*Distinguish between the different types of DAMAGE by looking
 at the first byte of the pak*/

/*Jeesiz- will have to reset DAMAGE_ID, and things like that,
	when receive phases are moved between*/

void DAMAGE_RECEIVE (void)
{
	hmiNETNOWGetBlock (pPacket,wp,iHeader.size);
	hmiNETNOWPostListen();

	if (wp[0]&(1<<7))
	{
		WORLDREC_STATUS= GOT_DAMAGE;

		/*This is the final DAMAGE pak*/
		wp[0]&=~(1<<7);
		/*HA- HA! put this here for a laff*/
		INSTALL_FLOORMAP_COLLECTABLES ();
		/*Hmm- this may be risky, but do it anyway*/
		/*Other machines *must* have buffered info for RECEIVER*/
		INITIATE_OBJPAK_RECEIVE ();

	}


	switch (wp[0])
	{
		case FLOOR_DAMAGE:
			/*This uses DAMAGE_ID*/
			FLOOR_DAMAGE_RECEIVE(iHeader.size);
		break;

		case WALLGROUP_DAMAGE:
			/*This doesn't*/
			WALLGROUP_DAMAGE_RECEIVE(iHeader.size);
		break;

		case UNIWALL_DAMAGE:
			UNIWALL_DAMAGE_RECEIVE(iHeader.size);
		break;

		default:
			net_getout ("Crushed. DAMAGE type unrecognisable.");
		break;

	}

}




/*Homm.. Difficult to describe this. */
/*DAMAGE_ID should record the current position within
	objmap*/

/*MOOOoooooOOOK!!!!  When both SENDER and RECEIVER scan the
	OBJMAP, collectables should be disregarded, as they are not
 part of the original floorplan. (The problem is that
 RECEIVER *could* receive collectables during the
 DAMAGE_RECEIVE phase)*/


/*fdSiz describes size of packet *including* first byte*/
void FLOOR_DAMAGE_RECEIVE (int fdSiz)
{

	int wi=1; /*Index into pak data. 1 because 1st byte
						  has already been checked.*/


	while (wi!=fdSiz&&DAMAGE_ID < 0xffff)
	{
		/*Seek for next OCCUPIED tile of *own* obj_map */
		/**own* obj_map should be utterly untouched*/

		while ((obj_map[DAMAGE_ID]==0)&&DAMAGE_ID<0xffff)
			DAMAGE_ID++;

		if (DAMAGE_ID<0xffff)
		{
	 		/*ho-ho. It's as simple as that is it?*/
	 		obj_map[DAMAGE_ID++]= wp[wi];
	 		wi++;
		}

	}

}



/*MOVES within and between FLOOR,WALLGROUP,WALLCRUSH
 WORLD_DAMAGE_SEND phases*/

/*This is analogous to NEXT_WORLD_PAK in objects.c*/

/*When DAMAGE_ID is -1, it's time to move to the next type
 of damage*/

void NEXT_DAMAGE_PHASE (void)
{
	BOOL readyToSend= _FALSE;

	while (!readyToSend)
	{
		switch (WORLD_ID)
		{
			case INITIATE_DAMAGE_SEND:
			DAMAGE_ID= 0;
			WORLD_ID= FLOOR_DAMAGE;
			readyToSend=_FALSE;
			break;


			case FLOOR_DAMAGE:
			if (DAMAGE_ID==-1)
			{
				if (nDef.flags&DEBUG_WORLD)
				{
					fp= fopen ("c:\\world.txt","a+");
					fprintf (fp,"Finished Floor Damage Send \n");
					fclose (fp);
				}

				DAMAGE_ID= 0;
				DAMAGE_PTR= 0;
				WORLD_ID= WALLGROUP_DAMAGE;
				readyToSend= _FALSE;

			}
			else
				readyToSend= _TRUE;
			break;


			case WALLGROUP_DAMAGE:
			if (DAMAGE_ID==-1)
			{
				if (nDef.flags&DEBUG_WORLD)
				{
					fp= fopen ("c:\\world.txt","a+");
					fprintf (fp,"Finished WallGroup Send \n");
					fclose (fp);
				}

				DAMAGE_ID= 0;
				WORLD_ID= UNIWALL_DAMAGE;
				readyToSend= _FALSE;
			}
			else
				readyToSend= _TRUE;
			break;

			case UNIWALL_DAMAGE:
			if (DAMAGE_ID==-1)
			{
				if (nDef.flags&DEBUG_WORLD)
				{
					fp= fopen ("c:\\world.txt","a+");
					fprintf (fp,"Finished UniWall damage Send \n");
					fclose (fp);
				}

				/*Signals to	NEXT_WORLD_PAK that DAMAGE PHASE is over*/
				WORLD_ID= 99;
				readyToSend= _TRUE;
			}
			else
				readyToSend= _TRUE;
			break;

			default:
				net_getout ("Oh no-- the DAMAGE PHASE is wonky");
			break;

		}

	}

}




/*FORM the next damage pak, which depends on the DAMAGE PHASE,
	and the stage within that phase. */

void	DAMAGE_PART_SEND ()
{
	switch (WORLD_ID)
	{
		case FLOOR_DAMAGE:
	 		FLOOR_DAMAGE_SEND();
		break;

		case WALLGROUP_DAMAGE:
			MAKE_WALLGROUP_DAMAGE_PAK();
		break;

		case UNIWALL_DAMAGE:
			MAKE_UNIWALL_DAMAGE_PAK();
		break;

		default:
		net_getout ("A sufferin' DAMAGE_PART_SEND bug");
		break;

	}
}



/*Is this texture out of range,from cWallTexture and cWallType?*/
int badTexture (void)
{

	switch (cWallType)
	{
		case 0:
 		if ((cWallTexture<0)||(cWallTexture>=NUM_SOLID_TEXTURES) )
			return (1);
		break;

		case 1:
		if ((cWallTexture<0)||(cWallTexture>=NUM_RAGGED_TEXTURES) )
			return (1);
		break;

		case 2:
		if ((cWallTexture<0)||(cWallTexture>=NUM_TRANSYM_TEXTURES) )
			return (1);
		break;

		case 3:
		if ((cWallTexture<0)||(cWallTexture>=NUM_TRANASYM_TEXTURES) )
			return(1);
		break;

		case 4:
		if ((cWallTexture<0)||(cWallTexture>=NUM_ANIMATING_TEXTURES) )
			return (1);
		break;

		default:
			net_getout ("cWallType out of range");
		break;

	}

	return (0);

}


/*deduce if a wall has been destroyed*************************

			INVISIBLE
if ( cwall->wallType==TOTALLED_TEXTURE )
{
	continue;
}


cWallType = cwall->wallType & 0x3;
cWallTexture = (cwall->wallType&0x1f8) >> 3;
cDetectType = (wdetect_info[cWallType].detectType[cWallTexture])&0x3;

if ( !cDetectType )
{
	cWallcolour = T_GRAD_GREEN + T_SHADE_1;
}
else
	cWallcolour = T_GRAD_GREEN + T_SHADE_4;


 *************************************************************/


/*Form the latest pak consisting of the indices of destroyed
	walls*/

/*Possibly change to send group id instead of wall id*/

/*Check if the first wall of the group has been totalled.
	If so, add its ID to output buffer*/

/* DAMAGE_ID refers to number of the current
	destroyableBuildingGroup*/

/*DAMAGE_PTR points to the current destroyableBuildingGroup*/

/*dbg is a list, consisting of sets of wallIDs corresponding
	to building groups*/

/*DAMAGE_PTR is now a *ushort pointer... jeesizzz*/



void MAKE_WALLGROUP_DAMAGE_PAK (void)
{
	WALL_DATA *tWall;
	ushort *tWallList;
	char *wbuf;

	ushort numWalls2destroy;
	char wallDestroyed;


	/*This shows that the PREVIOUS call was the last neccesary*/
	if (DAMAGE_ID>= numSfcs)
		return;


	WORLD_SIZE=0;
	wp[WORLD_SIZE]= WALLGROUP_DAMAGE;
	WORLD_SIZE++;


	/*Loop thru BUILDINGS list. If one texture in a group is
		totalled, they all are, so just send the INDEX of that one.*/

	while  ((DAMAGE_ID< numSfcs)&&
	       (WORLD_SIZE<MAX_WORLDPAK_SIZE))
	{

		tWallList= destroyableBuildingGroups +
							 destroyableBuildingList[DAMAGE_ID];


		/*If the current wall is not the FIRST wall in the list,
			skippit*/
		if ((DAMAGE_ID++)!= *(tWallList+3))
			continue;

		numWalls2destroy= *tWallList++;

		debug_msg ("Group %i, %i walls", DAMAGE_PTR, numWalls2destroy);

		/*1st short is num of walls in group, 2&3 are midpoint*/
		tWallList+=2;

		/*First wall in wallList*/
		tWall= wallSfcs + (*tWallList);

		wallDestroyed= 0;

		if (tWall->wallType==TOTALLED_TEXTURE)
		{
			wallDestroyed=1;
		}
		else
		{
	 		cWallType = tWall->wallType & 0x3;
	 		cWallTexture = (tWall->wallType&0x1f8) >> 3;


	 		cDetectType =
			(wdetect_info[cWallType].detectType[cWallTexture])&0x3;


			if (!cDetectType)
				wallDestroyed=1;

		}

		/*WALL HAS BEEN DESTROYED****/
		if (wallDestroyed)
		{
			/*Add its id to World Output Buffer*/
			DAMAGE_COUNT++;
			debug_msg ("Group %i is damaged",DAMAGE_PTR);

			wbuf= wp+WORLD_SIZE;
			*((ushort *)  wbuf )= *tWallList;
			WORLD_SIZE+=2;
		}

		/*DAMAGE_PTR now represents the group number*/
		DAMAGE_PTR++;

	}

	WALLGROUP_DAMAGE_PAKS++;

	if (nDef.flags&DEBUG_WORLD)
	{
		debug_msg("Made a WallGroup damage pak.");
	}

	if (DAMAGE_ID>=numSfcs)
	{
		/*Move to next damage phase*/
		DAMAGE_ID= -1;
	}

}







/*All walls in wp belong to groups which have to be destroyed*/


void WALLGROUP_DAMAGE_RECEIVE(int wgdSiz)
{
	int i;
	int wi=1;
	uint destroyedWallIndex;
	ushort destroyIndex;
	ushort *destroyWallList;
	ushort numWalls2destroy;
	WALL_DATA *wall2destroy;
	char *wbuf;

	while (wi<wgdSiz)
	{
		wbuf= wp+wi;
		destroyedWallIndex= * ((ushort *) (wbuf) );

		destroyIndex =
		destroyableBuildingList[destroyedWallIndex];

		destroyWallList= destroyableBuildingGroups + destroyIndex;

		numWalls2destroy= *destroyWallList++;

		/*Skip wallGroup midpt*/
		destroyWallList+=2;

		/*Make sure group ain't already destroyed*/
		wall2destroy = wallSfcs + *destroyWallList;
		if (!(wallStatus (wall2destroy)))
		{
	 		for ( i=0; i<numWalls2destroy; i++ )
	 		{
	 			wall2destroy = wallSfcs + *destroyWallList++;
	 			destroy_texture( wall2destroy );
	 		}
		}

		wi+=2;
	}

}





/*Walls which are solitary, being either obliteratible or
	damagable*/
/*The final pak ought to be marked as such with the upper bit
  in the initial byte of the wp*/

void MAKE_UNIWALL_DAMAGE_PAK (void)
{
	ushort groupIndex;
	WALL_DATA *uWall;
	char wallDestroyed;
	char *wbuf;


	if (DAMAGE_ID>=numSfcs)
		return;


	WORLD_SIZE= 0;
	wp[WORLD_SIZE]= UNIWALL_DAMAGE;
	WORLD_SIZE++;


	while ((DAMAGE_ID<numSfcs) &&
				 (WORLD_SIZE<MAX_WORLDPAK_SIZE))
	{
		groupIndex= *(destroyableBuildingList + DAMAGE_ID);

		if (groupIndex==0xffff)
		{
			wallDestroyed= 0;

			/*Wall is a member of no group. Check if it's destroyed*/
			uWall= wallSfcs +DAMAGE_ID;

			if (uWall->wallType==TOTALLED_TEXTURE)
			{
				wallDestroyed= 1;
			}
			else
			{
 				cWallType = uWall->wallType & 0x3;
				cWallTexture = (uWall->wallType&0x1f8) >> 3;
				cDetectType = (wdetect_info[cWallType].detectType[cWallTexture])&0x3;

				if ( !cDetectType )
				{
					wallDestroyed= 1;
				}

				// this is an ultra frig which has migrated from collide.c to infect damage.c

 				if ( (cWallType==TRANSPARENT_SYMETRICAL_TEXTURE) && (cWallTexture==PESKY_FUCKED_BRIDGE_TEXTURE_1 || cWallTexture==PESKY_FUCKED_BRIDGE_TEXTURE_2))
 				{
					wallDestroyed= 1;
 				}

			}

			if (wallDestroyed)
			{
				wbuf= wp+WORLD_SIZE;
				*((ushort *) (wbuf))= (ushort) DAMAGE_ID;
				WORLD_SIZE+=2;

			}

		}/*if (groupIndex*/


		DAMAGE_ID++;
	}


	UNIWALL_DAMAGE_PAKS++;

	/*Causes damage send phase to move to next damage type*/
	if (DAMAGE_ID>=numSfcs )
	{
		DAMAGE_ID= -1;
		/*Signal to receiver that this is the very last pak ever*/
		wp[0]|=(1<<7);
	}
}



/*Destroy the single walls in the list. They're either
	obliterated or damaged. */

void UNIWALL_DAMAGE_RECEIVE(int uwdSiz)
{
	int wi=1;
	char *wbuf;
	uint destroyedWallIndex;
	WALL_DATA *wall2destroy;

	while (wi<uwdSiz)
	{
		wbuf= wp+wi;
		destroyedWallIndex= *((ushort *) (wbuf));

		wall2destroy = wallSfcs + destroyedWallIndex;

		/*Make sure wall isn't already destroyed*/
		if (!(wallStatus (wall2destroy)))
		{
			destroy_texture (wall2destroy);
		}


		wi+=2;
	}

}




/*O jeeziz- Imagine having to write a function like this.*/

/*Returns the maximum destroyableBuilding index found in
 destroyableBuildingList*/
/*Call after loading in level data*/

/*destroyableBuildingList has an entry for each wall which is
	destroyable and belongs to a group. The entry is a pointer
	to the wallList to which the wall belongs, allowing all the
	walls in a group to be destroyed together. The wallList
  consists o f 2-byte entries. */

int sizeofDestroyableBuildingGroupsList (void)
{
	int i;
	int max_dbg_ptr= (unsigned short) destroyableBuildingList[0];

	for (i=0;i<numSfcs;i++)
	{
		if (((short )destroyableBuildingList[i]) > max_dbg_ptr)
			max_dbg_ptr= destroyableBuildingList[i];
	}

	return (max_dbg_ptr);

}



