

/* Exclusion flags used for obtaining closest linked waypoint */


enum {SLOW_2_STOP, FIND_SUITABLE_SPOT, FOUND_SUITABLE_SPOT};



#define BASIC_EXCLUSION								0
#define USE_CURRENT_TARGET_WAYPOINT		1


#define CONVOY_SPEEDUP_DIST						0x80
#define CONVOY_STOP_DIST							0X20
#define CONVOY_SLOWDOWN_DIST					0X48
#define CONVOY_SPEED									0x280
#define CONVOY_SLOW_SPEED							0x120

#define GUNBOAT_CONVOY_SPEEDUP_DIST		0x100
#define GUNBOAT_CONVOY_STOP_DIST			0X80
#define GUNBOAT_CONVOY_SLOWDOWN_DIST	0XC0
#define GUNBOAT_MAX_SPEED							0X110
#define GUNBOAT_CONVOY_SPEED					0xF0
#define GUNBOAT_CONVOY_SLOW_SPEED			0xC0


#define STILL_THRESHOLD								4		/* if tank in same position for more than 'n' passes it's stuck */



#define HELI_TRACKING_RANGE				0X80		/*Want to get as close as possible to the tank before tracking it */
#define HELI_START_TRACKING_RANGE	0x8

#define HEIGHT_CHANGE_UNIT						0x8

#define HELICOPTER_TRACKING_ALTITUDE 		-0x300
#define GUNSHIP_TRACKING_ALTITUDE				-0x380
#define HELICOPTER_PATROLLING_ALTITUDE	-0x900


#define SHOOT_RANGE								0X700

#define TARGETING_RANGE						0x180
#define	ENEMY_DETECTION_RANGE			0x800		//0x800
#define REGENERATE_RANGE					0x1000	//0x1000

#define SHOOT_ANGLE								0x30
#define SMALL_TURN_THRESHOLD			6
#define SMALL_TURN_RESET_VALUE		12

#define SMALL_TURN_THRESHOLD_2		4
#define SMALL_TURN_RESET_VALUE_2	8

#define SWING_AROUND_ANGLE				0x70
#define STOP_AND_ROTATE_ANGLE			0x200



#define SMALL_TURN_ANGLE					0x20		/* 15 degrees */

#define REL_SHIFT									8				/* Shift factor used to get relative distances */





extern	ushort	enemyAccuracy[];
extern	short	enemyShootRange[];
extern 	short	enemyTargettingRange[];
extern	short enemyTriggerRange[];

extern 	int		turnLeftDecision, turnRightDecision, moveForwardDecision, moveBackwardDecision, shootDecision, detectionFlag ,dontMoveHelicopter;

extern	TANK	*etank,*targetTank;
extern	GUN_BOAT	*mgunboat;
extern	ENEMY_TANK_CTRL	*ectrl;
extern	uchar	*wayptChkList;
extern	uint	numAttacking;
extern	uint	numAttackingHelicopters;




/***************************************************************/
/* Prototypes */
/***************************************************************/

void		get_control_decisions(void);
void		get_helicopter_decision(void);


/* Decision functions */

ushort	get_closest_waypt(ushort x, ushort z);
ushort	get_linked_closest_waypoint(uint	excludeId, uint excludeFlag);
ushort	get_linked_closest_convoy_waypoint(void);

ushort	get_turn_dirn(int , int);
int			test_line_of_sight(int x1, int y1, int x2, int y2 );
ushort	get_shoot_decision(void);
int			get_angle_difference(int ang1, int ang2);
ushort	get_dist_2_target_waypt(void);
int			get_attacking_slot(void);



TANK	*	get_truck_infront(TANK *ctank);


/* Control functions */

void	enemy_tank_stationary(void);
void	enemy_tank_pursue(void);
void	enemy_tank_targetting(void);
void	enemy_wait_for_space(void);
void	enemy_tank_restricted_targeting(void);


void	enemy_helicopter_patroling(void);
void	enemy_helicopter_start_tracking(void);
void	enemy_helicopter_tracking(void);
void	enemy_helicopter_targetting(void);

void	truck_start_convoy(void);
void	truck_follow_convoy(void);
void	leader_reached_end(void);

void	gunboat_start_convoy(void);
void	gunboat_follow_convoy(void);
void	gunboat_reached_end(void);




void	set_turn_decision(TANK *atank, int newTurnDirn);


/***************************************************************/


