#include "headers.h"

#include "chuck.h"
#include "e_global.h"
#include "shokstrc.h"
#include "enemlogc.h"

#include "iff.h"
#include "frontend.h"
#include "frontdef.h"
#include "frglobs.h"



#ifdef MEMCHK
#include <memcheck.h>
#endif



extern GAME_IOSTRUCT	game_data;


/***************************************************************/
/***************************************************************/

int	get_attacking_slot(void)
{
	int n;
	ATTACKING_TANK_DATA *cattack;

	for ( cattack=attackData, n=0; n<MAX_ATTACKING_TANKS; n++, cattack++ )
	{
		if ( !cattack->slotUsed )
		{
			cattack->slotUsed = TRUE;
			cattack->numWalls = 0;
			return (n);
		}
	}
	return (-1);
}


/***************************************************************/

int	test_tank_line_of_sight(void)
{
	int	resetBit;
	int	tnkx, tnkz;

	tnkx = (etank->x>>24)&0xff;
	tnkz = (etank->z>>24)&0xff;

	if( (resetBit=etank->resetLos) )	/* Remove current tank from los map if need to */
	{
		reset_los_bit(tnkx, tnkz);
	}

	etank->targetVisible = test_line_of_sight(tnkx, tnkz, ((targetTank->x>>24)&0xff), ((targetTank->z>>24)&0xff));

	if ( resetBit )										/* Update los map */
	{
		set_los_bit(tnkx, tnkz);
	}

	return (etank->targetVisible);
}

/***************************************************************/

int	 check_convoy_data(void)
{
	int	i;

	for ( i=0; i<numPaths; i++ )
	{
		if ( convoyData[i].numMembers==0xffff )
		{
			debug_msg("Fuckin' 'ells bells.");
			return (TRUE);
		}
	}
	return (FALSE);
}


TANK	*	get_truck_infront(TANK *ctank)
{
	uint	tankIndex;
	uint	prevIndex;
	CONVOY_DATA	*cConvoy;
	ushort	*members;
	uint	cnt;

	tankIndex = ctank - enemyTanks;

	cConvoy = convoyData + (ctank->ectrl->pathUsed)-1;

	cnt = 0;

	members = cConvoy->members;
	prevIndex = *members;

	members++;

	while ( cnt<cConvoy->numMembers )
	{
		if ( tankIndex==*members )
		{
			break;
		}

		prevIndex=*members;
		members++;

		cnt++;
	}

	return (enemyTanks+prevIndex);
}


/***************************************************************/


void	destroy_convoy_truck(TANK *destroyedTank)
{
	CONVOY_DATA	*cConvoy;
	uint		tankIndex;
	ushort	*cmember;
	ushort	memberCnt;

	cConvoy = convoyData + (destroyedTank->ectrl->pathUsed)-1;

	totalConvoyMembers--;

	cConvoy->numMembers--;

	if ( destroyedTank->ectrl->convoyLeader ) /* Destroyed leader - need to get new leader */
	{
		if ( cConvoy->numMembers )
		{
			memmove(cConvoy->members, cConvoy->members+1, sizeof(short)*(MAX_CONVOY_MEMBERS-1) );
			cConvoy->members[MAX_CONVOY_MEMBERS-1] = NULL_ID;

			(enemyTanks+cConvoy->members[0])->ectrl->convoyLeader=TRUE;	/*Make new leader*/
		}
		else
		{
			convoyDestroyed = TRUE;
			cConvoy->members[0]=NULL_ID;
		}
	}
	else
	{
		/* Destroy a follower */
		tankIndex = destroyedTank - enemyTanks;
		memberCnt = 0;
		cmember = cConvoy->members;

		/* Find position of truck in convoy */

		while ( memberCnt<cConvoy->numMembers )
		{
			if ( tankIndex==*cmember )
			{
				break;
			}

			cmember++;
			memberCnt++;
		}

		if ( memberCnt==cConvoy->numMembers ) /* Member is last one in convoy */
		{
			cConvoy->members[memberCnt]=NULL_ID;
			return ;
		}

		// shift up the convoy members array
		memmove(cConvoy->members+memberCnt, cConvoy->members+memberCnt+1, MAX_CONVOY_MEMBERS-memberCnt-1);

		cConvoy->members[MAX_CONVOY_MEMBERS-1]=NULL_ID;
	}
}


/***************************************************************/

void	destroy_tank(TANK	*destroyedTank)
{
	if ( destroyedTank->ectrl->pathUsed )
	{
		destroy_convoy_truck(destroyedTank);
	}
	else
	{
		clear_waypoint_check(destroyedTank);
	}

	if ( ((destroyedTank->def==E_HELICOPTER) || (destroyedTank->def==E_GUNSHIP)) && (destroyedTank->soundHandle!=0XFFFFFFFF) )
	{
		stop_helicopter_sample(destroyedTank);
		numAttackingHelicopters--;
	}

	if ( (destroyedTank->def==E_HELICOPTER) || (destroyedTank->def==E_GUNSHIP) )
	{
		game_data.nairtarg_dest++;
	}
	else
	if ( destroyedTank->def!=ALLIED_TRUCK )
	{
		game_data.ngrdtarg_dest++;		/* Note another ground target has been destroyed */
	}



	if ( destroyedTank->collData != NULL && destroyedTank->def!=ALLIED_TRUCK )
	{
		/** FREE UP ATTACKING TANK SLOT **/
		destroyedTank->collData->slotUsed = FALSE;
		destroyedTank->collData = NULL;
		numAttacking--;
	}

	if ( destroyedTank->ectrl->regenerate && destroyedTank->ectrl->regenCount)
	{
		destroyedTank->def=REGENERATE_OBJECT;
		destroyedTank->ectrl->regenCount--;
		destroyedTank->shellDelayCount=0;
	}
	else
		destroyedTank->def=0;




	if ( destroyedTank->objectiveTarget )
	{
		numObjectiveEnemies--;
		if ( objectiveType==DESTROY_ALL_ENEMIES_OBJECTIVE ) 	/* Update the percentage of objective destroyed */
		{
			game_data.perc_obj++;
		}
	}


	if ( !destroyedTank->ectrl->pathUsed )
	{
		if ( !start_message(DTOUR_MSG4) )
			if ( !start_message(DTOUR_MSG5) )
				start_message(DTOUR_MSG6);
	}


	if ( destroyedTank->resetLos ) /* Update los map as required */
	{
		reset_los_bit(((destroyedTank->x>>24)&0xff), ((destroyedTank->z>>24)&0xff) );
		destroyedTank->resetLos = FALSE;
	}
}

/***************************************************************/

int		test_restricted_tank(void)
{
	ushort	*waypt;
	ushort	wptx, wptz;

	waypt = waypt_data + *(waypt_index + ectrl->next_target_waypoint);
	waypt++; 											/* skip over number links associated with waypoint */

	wptx = *waypt++;
	wptz = *waypt;

	if ( ectrl->restricted ) 			/* Tank is restricted */
	{
		if ( wptx<ectrl->rx1 || wptx>ectrl->rx2 || wptz<ectrl->rz1 || wptz>ectrl->rz2 )	/* waypoint is outside restriction zone */
		{
			ectrl->control_func = enemy_tank_restricted_targeting;
			if ( ectrl->next_target_waypoint!=NULL_ID )
			{
				wayptChkList[ectrl->next_target_waypoint] = FALSE;
			}

			ectrl->target_waypoint = NULL_ID;
			return (TRUE);
		}
	}
	return (FALSE);
}

/***************************************************************/
/* General tank control functions */
/***************************************************************/

void	move_tanks(void)
{
	int			reltx, reltz;				/* Relative distances in terms of tiles */
	int			sqrtdist;						/* squared distance in tiles */
	int			i,j,canRegenerate;
	TANK		*regenOverTank;

	wayptChkList=TankWayptChkList;

	for ( i=0, etank=enemyTanks; i<MAX_ENEMY_TANKS; i++, etank++ )
	{
		if ( etank->def )
		{
			ectrl = etank->ectrl;
			etank->moveTank = TRUE;	/* Assume the tanks position needs to be updated */

			if ( etank->def == REGENERATE_OBJECT )
			{
      	reltx = (pl.x >> 24) - (ectrl->regenx >> 8);	/* Get relative distance in terms of floor tiles */
      	reltz = (pl.z >> 24) - (ectrl->regenz >> 8);

      	reltx *= reltx;
      	reltz *= reltz;

      	sqrtdist = reltx + reltz;

				/* regenerate tank if player out of regeneration range */

				if ( sqrtdist>=REGENERATE_RANGE )
				{
					canRegenerate = TRUE;
					for ( j=0,regenOverTank=enemyTanks; j<MAX_ENEMY_TANKS; j++,regenOverTank )
					{
						if ( regenOverTank->def &&
								(regenOverTank->def!=REGENERATE_OBJECT) &&
								(regenOverTank->x>>26 == ectrl->regenx>>18) &&
								(regenOverTank->z>>26 == ectrl->regenz>>18))
						{
							canRegenerate=FALSE;
							break;
						}
					}

					if ( canRegenerate )
					{
						etank->def=ectrl->regenerateId;
						init_tank_control(etank);
						etank->x=ectrl->regenx<<16;
						etank->z=ectrl->regenz<<16;
						etank->armour = enemyHitpoints[game_data.mission][etank->def];
						etank->angle = etank->dir = ectrl->regenAng;
						etank->speed = 0;
						continue;
					}
				}
				else
					continue;						/* ignore tank otherwise */
			}

			etank->targetVisible = FALSE;

			get_control_decisions();

			if ( ectrl->control_func == NULL )
			{
				etank->moveTank = FALSE;
			}

			if ( etank->moveTank )
			{
				move_tank(etank, turnLeftDecision, turnRightDecision, moveForwardDecision, moveBackwardDecision, shootDecision);
			}
		}
	}
}

/***************************************************************/

/***************************************************************/
/* Specififc tank control functions */
/***************************************************************/

void	enemy_tank_stationary(void)
{
	int			reltx, reltz;				/* Relative distances in terms of tiles */
	int			sqrtdist;						/* squared distance in tiles */
	int			minsqrtdist;
	ushort	*waypt;             /* Pointer to waypoint */
	ushort	newTurnDirn;        /* The calculated turn direction */
	CONVOY_DATA	*cConvoy;
	int			attackSlot;

	/** Find target tank if required **/

	switch ( ectrl->tank_mode )
	{
		case ESTAT_INACTIVE:
    	if ( objectiveType==PROTECT_CONVOY_OBJECTIVE )
    	{
    		int j;
    		ushort	*cmember;
    		TANK	*alliedTruck;

    		/** find the closest target tank - either an allied convoy truck or the player */
      	reltx = (pl.x >> 24) - (etank->x >> 24);	/* Get relative distance in terms of floor tiles */
      	reltz = (pl.z >> 24) - (etank->z >> 24);

      	reltx *= reltx;
      	reltz *= reltz;

    		/** assume the player tank is the closest target tank */
    		ectrl->targetTank = targetTank= &pl;
      	minsqrtdist = reltx + reltz;

    		/** assume their is only one allied convoy (in convoyData[0] **/

    		for ( j=0, cConvoy=convoyData, cmember=cConvoy->members; j<cConvoy->numMembers; j++ )
    		{
					alliedTruck = enemyTanks+(*cmember++);
    			/** get distance to the  **/
    	  	reltx = (alliedTruck->x >> 24) - (etank->x >> 24);	/* Get relative distance in terms of floor tiles */
        	reltz = (alliedTruck->z >> 24) - (etank->z >> 24);

      		reltx *= reltx;
      		reltz *= reltz;

    			if ( (sqrtdist=(reltx+reltz)) < minsqrtdist )
    			{
    				ectrl->targetTank = targetTank = alliedTruck;
    				minsqrtdist = sqrtdist;
    			}
    		}
    	}
    	else
			{
    		ectrl->targetTank = targetTank = &pl;

	    	reltx = (targetTank->x >> 24) - (etank->x >> 24);		/* Get relative distance in terms of floor tiles */
  	  	reltz = (targetTank->z >> 24) - (etank->z >> 24);

    		reltx *= reltx;
    		reltz *= reltz;

    		minsqrtdist = reltx + reltz;
			}


			if ( minsqrtdist >= enemyTriggerRange[etank->def] ) 		/* No target tanks in range */
			{
				etank->moveTank=FALSE;
				return;
			}

			if ( numAttacking > MAX_ATTACKING_TANKS ) 						/* Only have a maximum number attacking at any one time */
			{
				etank->moveTank = FALSE;
				return;
			}

			/* Tank has come into range - need to join the mesh */
			ectrl->target_waypoint = NULL_ID;
			ectrl->stillCount=0;

			/* Try and find a valid target waypoint */
			if ( ectrl->rejoin_waypoint!=NULL_ID )								/* Check if tank was using control net before */
			{
				if ( wayptChkList[ectrl->rejoin_waypoint]==FALSE )	/* Try and use the old waypoint */
				{
					ectrl->target_waypoint = ectrl->rejoin_waypoint;	/* Waypoint available for use */
					wayptChkList[ectrl->rejoin_waypoint] = TRUE;			/* Note that waypoint is being used */
				}
				else
				{
					ectrl->target_waypoint = get_closest_waypt( (etank->x>>16), (etank->z>>16) );
					ectrl->rejoin_waypoint = ectrl->target_waypoint;
				}
			}
			else																								/* Join the waypoint mesh for the first time */
				ectrl->target_waypoint = get_closest_waypt( (etank->x>>16), (etank->z>>16) );


			/* Reset next target waypoint data */
			ectrl->next_target_waypoint = NULL_ID;

			if ( ectrl->target_waypoint==NULL_ID ) 							/* Couldn't find a valid waypoint to use - stay inactive */
			{
				return ;
			}

			if ( (attackSlot=get_attacking_slot()) >= 0 )
			{
				/* This tank has joined the limited number of actual attacking tanks */
				etank->collData = attackData + attackSlot;
				numAttacking++;
			}
			else
			{
				/** not enough attack slots */
				clear_waypoint_check(etank);
				return ;
			}


			/* Get target waypoint coords */

			waypt = waypt_data + *(waypt_index + ectrl->target_waypoint);
			waypt++; /* skip over number links associated with waypoint */

			ectrl->twayptx = *waypt++;
			ectrl->twayptz = *waypt;


			/* Get angle to target waypoint */

			ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

			newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);

			ectrl->small_turn_count = 0;

			/* Check if already facing waypoint */

			if ( newTurnDirn == NO_TURN )
			{
				etank->dir = etank->angle = ectrl->angle_2_target;
				etank->turn = 0;	/* Stop the turning momentum - FRIGG */
				ectrl->control_func = enemy_tank_pursue;
				ectrl->small_turn_count = 0;
				ectrl->tank_mode = EPURSUE_MOVE_2_POINT;
			}
			else
			{
				ectrl->tank_mode = ESTAT_ROTATE;

				if ( (newTurnDirn==LARGE_LEFT_TURN) || (newTurnDirn==SMALL_LEFT_TURN) )
				{
					turnLeftDecision=TRUE;
				}
				else
				{
				 	turnRightDecision=TRUE;
				}

				if ( newTurnDirn&1 )	/* Setup the small turn count if the turn is large */
				{
					ectrl->small_turn_count=SMALL_TURN_THRESHOLD;
				}
			}
			break;

		/****************/

		case ESTAT_ROTATE:
			newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);

			set_turn_decision(etank, newTurnDirn);

			if ( newTurnDirn==NO_TURN  )
			{
				etank->dir = etank->angle = ectrl->angle_2_target;
				etank->turn = 0;	/* Stop the turning momentum - FRIGG */
				ectrl->control_func = enemy_tank_pursue;
				ectrl->small_turn_count = 0;
				ectrl->tank_mode = EPURSUE_MOVE_2_POINT;
				ectrl->slow_decision_made = FALSE;
			}
			break;

		/****************/

		case ESTAT_BECOME_INACTIVE:
			etank->speed=0;

			ectrl->tank_mode = ESTAT_INACTIVE;

			if ( etank->collData != NULL )
			{
				etank->collData->slotUsed = FALSE;
				etank->collData = NULL;
				numAttacking--;
			}

			clear_waypoint_check(etank);

			/** if tank was using an attacking slot then make it available for others */

			if ( etank->collData != NULL )
			{
				etank->collData->slotUsed = FALSE;
				etank->collData=NULL;
			}
			break;
	}
}






/***************************************************************/



void	enemy_tank_pursue(void)
{
	int			reltx, reltz;				/* Relative distances in terms of tiles */
	int			sqrtdist;						/* squared distance in tiles */
	ushort	pursueDecision;
	ushort	newTurnDirn;
	ushort	*waypt;
	ushort	wayptx, wayptz;
	ushort	angle2NextWaypt;
	ushort	oldtwaypt;


	switch ( ectrl->tank_mode )
	{
		case EPURSUE_MOVE_2_POINT:

			pursueDecision = get_dist_2_target_waypt();

			ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

			switch ( pursueDecision )
			{
				case CONTINUE_MOVEMENT:
					break;


				case SLOW_DOWN:
					if ( ectrl->slow_decision_made )
					{
						break;
					}

					/* Check if target tank is still in range */

					reltx = (targetTank->x>>24) - (etank->x>>24);	/* Get relative distance in terms of floor tiles */
					reltz = (targetTank->z>>24) - (etank->z>>24);

					reltx *= reltx;
					reltz *= reltz;

					sqrtdist = reltx + reltz;

					if ( sqrtdist >=enemyTriggerRange[etank->def] ) 	/* No target tanks in range */
					{
						ectrl->control_func = enemy_tank_stationary;
						ectrl->tank_mode = ESTAT_BECOME_INACTIVE;
						ectrl->slow_decision_made = FALSE;
						if ( ectrl->target_waypoint!=NULL_ID )
						{
							wayptChkList[ectrl->target_waypoint] = FALSE;	/*Make target waypoint available to others */
						}

						return ;
	 				}


					if ( test_restricted_tank() )
					{
						return ;
					}


  				/* Check to see if you can target tank */

  				if ( sqrtdist<=enemyTargettingRange[etank->def] )
  				{
  					if ( test_tank_line_of_sight() ) /* Within targetting range and can be seen */
  					{
  						ectrl->control_func = enemy_tank_targetting;
							ectrl->slow_decision_made = FALSE;

							if ( ectrl->target_waypoint==NULL_ID )
							{
								ectrl->target_waypoint = get_closest_waypt( (etank->x>>16), (etank->z>>16) );
							}

							ectrl->rejoin_waypoint = ectrl->target_waypoint;
  						return ;
  					}
  				}



    			/* Look for the next possible target waypoint */

    			ectrl->next_target_waypoint = get_linked_closest_waypoint(NULL_ID, BASIC_EXCLUSION);

    			if ( ectrl->next_target_waypoint==NULL_ID ) 		/* Couldn't find a valid target way point */
    			{
    				/* Nowhere to go */
						ectrl->control_func = enemy_wait_for_space;
						ectrl->slow_decision_made = FALSE;
    				return ;
    			}



					/* Get angle from current waypoint to next waypoint */

					waypt = waypt_data + *(waypt_index + ectrl->next_target_waypoint);
					waypt++; /* skip over number links associated with waypoint */

					wayptx = *waypt++;
					wayptz = *waypt;

					angle2NextWaypt = (int)(phd_atan( (int)(ectrl->twayptx - wayptx), (int)(ectrl->twayptz - wayptz) ) &0x7ff);

					angle2NextWaypt = get_angle_difference(angle2NextWaypt, etank->angle);



					if ( angle2NextWaypt < SWING_AROUND_ANGLE )
					{
						ectrl->slow_decision_made = TRUE;
						break;
					}
					else
					if ( angle2NextWaypt < STOP_AND_ROTATE_ANGLE )
					{
						ectrl->rejoin_waypoint = ectrl->target_waypoint;

						/* Get new target waypoint */
						ectrl->target_waypoint = ectrl->next_target_waypoint;

						ectrl->next_target_waypoint = NULL_ID;

						ectrl->tank_mode = SWING_2_TARGET_POINT;

						ectrl->twayptx = wayptx;
						ectrl->twayptz = wayptz;

						ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

						return ;
					}
					else
					{
						ectrl->rejoin_waypoint = ectrl->target_waypoint;
						/* Get new target waypoint */
						ectrl->target_waypoint = ectrl->next_target_waypoint;

						ectrl->next_target_waypoint = NULL_ID;

						ectrl->tank_mode = ROTATE_2_TARGET_POINT;
						ectrl->twayptx = wayptx;
						ectrl->twayptz = wayptz;

						ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

						return ;
					}
					break;


				case REACHED_TARGET:
					/* Get new target waypoint */
					ectrl->target_waypoint = ectrl->next_target_waypoint;

					/* Reset next target waypoint data */
					ectrl->next_target_waypoint = NULL_ID;

					/* Get position of target waypoint */
					waypt = waypt_data + *(waypt_index + ectrl->target_waypoint);
					waypt++; /* skip over number links associated with waypoint */

					ectrl->twayptx = *waypt++;
					ectrl->twayptz = *waypt;

					ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

					ectrl->slow_decision_made = FALSE;

					break;
			}




			moveForwardDecision=TRUE;



			/* Check if tank has moved */

			if ( (ectrl->stillx == (etank->x>>16)) && (ectrl->stillz == (etank->z>>16)) && (ectrl->rejoin_waypoint!=NULL_ID) && (etank->speed>0x100) )
			{
				ectrl->stillCount++;
				if ( ectrl->stillCount>=STILL_THRESHOLD )
				{
					ectrl->stillCount=0;

					clear_waypoint_check(etank);

					/* Need to find a new target waypoint - stuck using the current one */
					oldtwaypt = ectrl->target_waypoint;

					if ( ectrl->rejoin_waypoint!=NULL_ID )
					{
						ectrl->target_waypoint = ectrl->rejoin_waypoint;/*Get a new waypoint connected to the old waypoint */
						ectrl->next_target_waypoint = get_linked_closest_waypoint(oldtwaypt, BASIC_EXCLUSION);
					}
					else
					{
						ectrl->next_target_waypoint = get_closest_waypt( (etank->x>>16), (etank->z>>16) );
					}

					if ( ectrl->next_target_waypoint==NULL_ID )
					{
						/* nowhere to go */
						ectrl->control_func = enemy_wait_for_space;
						ectrl->slow_decision_made = FALSE;
						return ;
					}

					ectrl->target_waypoint = ectrl->next_target_waypoint;

					ectrl->next_target_waypoint=NULL_ID;

					moveForwardDecision = FALSE;

					waypt = waypt_data + *(waypt_index + ectrl->target_waypoint);
					waypt++; /* skip over number links associated with waypoint */

					ectrl->twayptx = *waypt++;
					ectrl->twayptz = *waypt;

					ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

					ectrl->tank_mode = ROTATE_2_TARGET_POINT;
				}
			}
			else
			{
				ectrl->stillx = etank->x>>16;
				ectrl->stillz = etank->z>>16;
				ectrl->stillCount=0;
			}



			/* Readjust angle of tank if need to */

			newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);

			switch ( newTurnDirn )
			{
				case NO_TURN: /* Force angle and start moving towards point */
					etank->dir = etank->angle = ectrl->angle_2_target;
					etank->turn = 0;	/* Stop the turning momentum - FRIGG */
					break;


				case SMALL_RIGHT_TURN:
					if ( ectrl->small_turn_count>=SMALL_TURN_THRESHOLD_2 )
 					{
 						/* Wait - still experiencing previous turn */
 						if ( ectrl->small_turn_count>=SMALL_TURN_RESET_VALUE_2 )
 						{
 							ectrl->small_turn_count=0;
 						}
 					}
 					else
 						turnRightDecision=TRUE;
 					ectrl->small_turn_count++;
					break;


				case LARGE_RIGHT_TURN:
					ectrl->small_turn_count=SMALL_TURN_THRESHOLD_2;
					moveForwardDecision = FALSE;
					turnRightDecision=TRUE;
					break;


				case SMALL_LEFT_TURN:
					if ( ectrl->small_turn_count>=SMALL_TURN_THRESHOLD_2 )
					{
						/* Wait - still experiencing previous turn */
						if ( ectrl->small_turn_count>=SMALL_TURN_RESET_VALUE_2 )
						{
							ectrl->small_turn_count=0;
						}
					}
					else
 						turnLeftDecision=TRUE;
					ectrl->small_turn_count++;
					break;


				case LARGE_LEFT_TURN:
					ectrl->small_turn_count=SMALL_TURN_THRESHOLD_2;
					turnLeftDecision=TRUE;
					moveForwardDecision = FALSE;
					break;

			}
			break;


/********************/
		case SWING_2_TARGET_POINT:

			ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

			newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);

			switch ( newTurnDirn )
			{
				case SMALL_LEFT_TURN:
				case SMALL_RIGHT_TURN:
				case NO_TURN: /* Force angle and start moving towards point */
					etank->dir = etank->angle = ectrl->angle_2_target;
					etank->turn = 0;	/* Stop the turning momentum - FRIGG */
					moveForwardDecision=TRUE;

					ectrl->tank_mode = EPURSUE_MOVE_2_POINT;
					return;
					break;

				case LARGE_RIGHT_TURN:
					/* Check if there is a closer target waypoint which is quicker to turn to than current one */

					ectrl->small_turn_count=SMALL_TURN_THRESHOLD_2;
					turnRightDecision=TRUE;
					break;


				case LARGE_LEFT_TURN:
					/* Check if there is a closer target waypoint which is quicker to turn to than current one */

					ectrl->small_turn_count=SMALL_TURN_THRESHOLD_2;
					turnLeftDecision=TRUE;
					break;

			}
			break;

/********************/


		case ROTATE_2_TARGET_POINT:
			ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);
			newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);

			switch ( newTurnDirn )
			{
				case SMALL_LEFT_TURN:
				case SMALL_RIGHT_TURN:
				case NO_TURN: /* Force angle and start moving towards point */
					etank->dir = etank->angle = ectrl->angle_2_target;
					etank->turn = 0;	/* Stop the turning momentum - FRIGG */
					moveForwardDecision=TRUE;

					ectrl->tank_mode = EPURSUE_MOVE_2_POINT;
					break;


				case LARGE_RIGHT_TURN:
					/* Check if there is a closer target waypoint which is quicker to turn to than current one */

					ectrl->small_turn_count=SMALL_TURN_THRESHOLD_2;
					turnRightDecision=TRUE;
					if ( etank->speed>0x20 )
					{
						moveBackwardDecision=TRUE;
					}
					else
					if ( etank->speed<0x20 )
					{
						moveForwardDecision=TRUE;
					}
					else
						etank->speed=0;

					break;


				case LARGE_LEFT_TURN:
					/* Check if there is a closer target waypoint which is quicker to turn to than current one */

					ectrl->small_turn_count=SMALL_TURN_THRESHOLD_2;
					turnLeftDecision=TRUE;
					if ( etank->speed>0x20 )
					{
						moveBackwardDecision=TRUE;
					}
					else
					if ( etank->speed<0x20 )
					{
						moveForwardDecision=TRUE;
					}
					else
						etank->speed=0;
					break;

			}
			break;

	}

}

/***************************************************************/


void	enemy_wait_for_space(void)	/*Waits for an available target waypoint - and slows down in the mean time */
{
	ushort	*waypt;
	ushort	angle2NextWaypt;
	int			reltx, reltz;				/* Relative distances in terms of tiles */
	int			sqrtdist;

	/* Check if enemy gone out of range */

	reltx = (targetTank->x>>24) - (etank->x>>24);	/* Get relative distance in terms of floor tiles */
	reltz = (targetTank->z>>24) - (etank->z>>24);

	reltx *= reltx;
	reltz *= reltz;

	sqrtdist = reltx + reltz;

	if ( sqrtdist >=enemyTriggerRange[etank->def] ) 	/* No target tanks in range */
	{
		ectrl->control_func = enemy_tank_stationary;
		ectrl->tank_mode = ESTAT_BECOME_INACTIVE;
		ectrl->slow_decision_made = FALSE;
		return ;
	}

	ectrl->next_target_waypoint = get_linked_closest_waypoint(NULL_ID, BASIC_EXCLUSION);

	if ( ectrl->next_target_waypoint!=NULL_ID )
	{
		ectrl->target_waypoint = ectrl->next_target_waypoint;
		ectrl->next_target_waypoint = NULL_ID;

		waypt = waypt_data + *(waypt_index + ectrl->target_waypoint);
		waypt++; /* skip over number links associated with waypoint */

		ectrl->twayptx = *waypt++;
		ectrl->twayptz = *waypt;

		angle2NextWaypt = ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

		ectrl->control_func = enemy_tank_pursue;
		ectrl->tank_mode = EPURSUE_MOVE_2_POINT;

		angle2NextWaypt = get_angle_difference(angle2NextWaypt, etank->angle);

		ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

		if ( angle2NextWaypt < SWING_AROUND_ANGLE )
		{
			ectrl->slow_decision_made = FALSE;
			ectrl->tank_mode = EPURSUE_MOVE_2_POINT;
		}
		else
		if ( angle2NextWaypt < STOP_AND_ROTATE_ANGLE )
		{
			ectrl->tank_mode = SWING_2_TARGET_POINT;
		}
		else
		{
			ectrl->tank_mode = ROTATE_2_TARGET_POINT;
		}
		return ;
	}
	else
	{
		ectrl->next_target_waypoint = NULL_ID;

		if ( etank->speed>0x20 )
		{
			moveBackwardDecision=TRUE;
		}
		else
		if ( etank->speed<0x20 )
		{
			moveForwardDecision=TRUE;
		}
		else
			etank->speed=0;
	}
}



/***************************************************************/


void	enemy_tank_targetting(void)
{
	int			reltx, reltz;																/* Relative distances in terms of tiles */
	int			sqrtdist;																		/* squared distance in tiles */
	ushort	*waypt;
	ushort	wayptx, wayptz;
	ushort	angle2NextWaypt;
	ushort	newTurnDirn;


	reltx = (targetTank->x>>24) - (etank->x>>24);				/* Get relative distance in terms of floor tiles */
	reltz = (targetTank->z>>24) - (etank->z>>24);

	reltx *= reltx;
	reltz *= reltz;

	sqrtdist = reltx + reltz;

	if ( sqrtdist>enemyTargettingRange[etank->def] 			/* Target gone out of range for targetting */
			|| ( !(test_tank_line_of_sight()) ) )							/* Target not visible anymore */
	{
		if ( sqrtdist > enemyTriggerRange[etank->def] ) 	/* Target out of detection range as well */
		{
 			ectrl->control_func = enemy_tank_stationary;
 			ectrl->tank_mode = ESTAT_BECOME_INACTIVE;
			ectrl->slow_decision_made = FALSE;

			if ( ectrl->target_waypoint!=NULL_ID )
			{
				wayptChkList[ectrl->target_waypoint] = FALSE; /* Make waypoint available */
			}
 			return ;
		}

		/* Need to go back into pursue mode */
		ectrl->next_target_waypoint = get_linked_closest_waypoint(NULL_ID, USE_CURRENT_TARGET_WAYPOINT);

		if ( ectrl->next_target_waypoint==NULL_ID )
		{
			/* nowhere to go */
			ectrl->control_func = enemy_wait_for_space;
			ectrl->slow_decision_made = FALSE;
			return ;
		}

		ectrl->target_waypoint = ectrl->next_target_waypoint;

		ectrl->next_target_waypoint = NULL_ID;

		ectrl->control_func = enemy_tank_pursue;
		ectrl->small_turn_count = 0;
		ectrl->slow_decision_made = FALSE;
		ectrl->tank_mode = EPURSUE_MOVE_2_POINT;

		/* Get angle from current position to next waypoint */

		waypt = waypt_data + *(waypt_index + ectrl->target_waypoint);
		waypt++; /* skip over number links associated with waypoint */

		ectrl->twayptx = wayptx = *waypt++;
		ectrl->twayptz = wayptz = *waypt;

		angle2NextWaypt = (int)(phd_atan( (int)((etank->x>>16) - wayptx), (int)((etank->x>>16) - wayptz) ) &0x7ff);

		angle2NextWaypt = get_angle_difference(angle2NextWaypt, etank->angle);

		ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

		if ( angle2NextWaypt < SWING_AROUND_ANGLE )
		{
			ectrl->tank_mode = EPURSUE_MOVE_2_POINT;
		}
		else
		if ( angle2NextWaypt < STOP_AND_ROTATE_ANGLE )
		{
			ectrl->tank_mode = SWING_2_TARGET_POINT;
		}
		else
		{
			ectrl->tank_mode = ROTATE_2_TARGET_POINT;
		}

		return ;
	}


	if ( etank->speed>0x20 )
	{
		moveBackwardDecision=TRUE;
	}
	else
	if ( etank->speed<0x20 )
	{
		moveForwardDecision=TRUE;
	}
	else
		etank->speed=0;


	/* Rotate towards the target tank */

	ectrl->angle_2_target = (int)((phd_atan( (int) ((uint)(etank->x>>16) - (uint)(targetTank->x>>16)) , (int) ((uint)(etank->z)>>16) - (uint)(targetTank->z>>16) ) ) &0x7ff);

	newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);

	set_turn_decision(etank, newTurnDirn);
}


/***************************************************************/



void	enemy_tank_restricted_targeting(void)
{
	int			reltx, reltz;				/* Relative distances in terms of tiles */
	int			sqrtdist;						/* squared distance in tiles */
	ushort	*waypt;
	ushort	newTurnDirn;
	ushort	wptx, wptz;
	ushort	plrx=targetTank->x>>16, plrz=targetTank->z>>16;

	if ( plrx>=ectrl->rx1 && plrx<=ectrl->rx2 && plrz>=ectrl->rz1 && plrz<=ectrl->rz2 )				/* check if target tank is within restricted zone */
	{
		ectrl->next_target_waypoint = get_linked_closest_waypoint(NULL_ID, BASIC_EXCLUSION);		/* Find nearest linked waypoint to target */

  	if ( ectrl->next_target_waypoint!=NULL_ID )
  	{
  		waypt = waypt_data + *(waypt_index + ectrl->next_target_waypoint);
  		waypt++; /* skip over number links associated with waypoint */

  		wptx = *waypt++;
  		wptz = *waypt;

  		/* Check if new waypoint is within restriction */
  		if ( wptx>=ectrl->rx1 && wptx<=ectrl->rx2 && wptz>=ectrl->rz1 && wptz<=ectrl->rz2 )	/* waypoint is within restriction zone */
  		{
  			ectrl->twayptx = wptx;
  			ectrl->twayptz = wptz;

  			ectrl->target_waypoint = ectrl->next_target_waypoint;
  			ectrl->next_target_waypoint = NULL_ID;

  			/* Get angle to target waypoint */
  			ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);
  			newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);

  			set_turn_decision(etank, newTurnDirn);

  			ectrl->slow_decision_made = FALSE;

  			if ( newTurnDirn == NO_TURN )
  			{
  				etank->dir = etank->angle = ectrl->angle_2_target;
  				etank->turn = 0;	/* Stop the turning momentum - FRIGG */
  				ectrl->control_func = enemy_tank_pursue;
  				ectrl->tank_mode = EPURSUE_MOVE_2_POINT;
  				return ;
  			}


  			ectrl->control_func = enemy_tank_stationary;
  			ectrl->tank_mode = ESTAT_ROTATE;
  			return ;
  		}
			else
			{
				wayptChkList[ectrl->next_target_waypoint]=FALSE;
				ectrl->next_target_waypoint=NULL_ID;
			}

  	}

	}


	reltx = (targetTank->x>>24) - (etank->x>>24);	/* Get relative distance in terms of floor tiles */
	reltz = (targetTank->z>>24) - (etank->z>>24);

	reltx *= reltx;
	reltz *= reltz;

	sqrtdist = reltx + reltz;

	if ( sqrtdist > enemyTriggerRange[etank->def] ) 	/*Target out of detection range as well */
	{
		ectrl->control_func = enemy_tank_stationary;
		ectrl->tank_mode = ESTAT_BECOME_INACTIVE;
		ectrl->slow_decision_made = FALSE;

		if ( ectrl->target_waypoint!=NULL_ID )
		{
			wayptChkList[ectrl->target_waypoint] = FALSE; 	/*Make waypoint available */
		}
		return ;
	}


	if ( etank->speed>0x20 )
	{
		moveBackwardDecision=TRUE;
	}
	else
	if ( etank->speed<0x20 )
	{
		moveForwardDecision=TRUE;
	}
	else
		etank->speed=0;

	test_tank_line_of_sight();


	/* Rotate towards the target tank */

	ectrl->angle_2_target = (int)((phd_atan( (int) ((uint)(etank->x>>16) - (uint)(targetTank->x>>16)) , (int) ((uint)(etank->z)>>16) - (uint)(targetTank->z>>16) ) ) &0x7ff);
	newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);
	set_turn_decision(etank, newTurnDirn);
}



/***************************************************************/
/***************************************************************/
/***************************************************************/


/***************************************************************/
/* Convoy logic */
/***************************************************************/




void	truck_start_convoy(void)
{
	ushort	*waypt;
	ushort	newTurnDirn;

	switch ( ectrl->tank_mode )
	{
		case START_CONVOY:
			ectrl->target_waypoint = NULL_ID;
			ectrl->stillCount=0;

			/* Try and find a valid target waypoint */
			ectrl->target_waypoint = get_closest_waypt( (etank->x>>16), (etank->z>>16) );

			/* Reset next target waypoint data */
			ectrl->next_target_waypoint = NULL_ID;

			if ( ectrl->target_waypoint==NULL_ID ) 		/* Couldn't find a valid waypoint to use - stay inactive */
			{
				return ;
			}

			/* Get target waypoint coords */

			waypt = waypt_data + *(waypt_index + ectrl->target_waypoint);
			waypt++; /* skip over number links associated with waypoint */

			ectrl->twayptx = *waypt++;
			ectrl->twayptz = *waypt;


			/* Get angle to target waypoint */

			ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

			newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);

			ectrl->small_turn_count = 0;

			/* Check if already facing waypoint */

			if ( newTurnDirn == NO_TURN )
			{
				etank->dir = etank->angle = ectrl->angle_2_target;
				etank->turn = 0;	/* Stop the turning momentum - FRIGG */

				ectrl->control_func = truck_follow_convoy;
				ectrl->small_turn_count = 0;

				ectrl->tank_mode = FOLLOW_CONVOY_PATH;
			}
			else
			{
				ectrl->tank_mode = START_CONVOY_ROTATE;

				if ( (newTurnDirn==LARGE_LEFT_TURN) || (newTurnDirn==SMALL_LEFT_TURN) )
				{
					turnLeftDecision=TRUE;
				}
				else
				{
				 	turnRightDecision=TRUE;
				}

				if ( newTurnDirn&1 )	/* Setup the small turn count if the turn is large */
				{
					ectrl->small_turn_count=SMALL_TURN_THRESHOLD;
				}
			}
			break;

		/****************/

		case START_CONVOY_ROTATE:
			newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);

			set_turn_decision(etank, newTurnDirn);

			if ( newTurnDirn == NO_TURN )
			{
				ectrl->small_turn_count = 0;
				ectrl->slow_decision_made = FALSE;
				ectrl->control_func = truck_follow_convoy;
				ectrl->tank_mode = FOLLOW_CONVOY_PATH;
			}
			break;
	}
}


/***************************************************************/


void	truck_follow_convoy(void)
{
	TANK		*truckInfront=NULL;
	uint		sqrtDist;
	ushort	relx,relz;
	ushort	pursueDecision;
	ushort	newTurnDirn;
	ushort	*waypt=NULL;
	ushort	wayptx, wayptz;
	ushort	angle2NextWaypt;

	switch ( ectrl->tank_mode )
	{
		case FOLLOW_CONVOY_PATH:

			pursueDecision = get_dist_2_target_waypt();

			ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

			switch ( pursueDecision )
			{
				case CONTINUE_MOVEMENT:
					break;


				case SLOW_DOWN:
					if ( ectrl->slow_decision_made )
					{
						break;
					}

    			/* Look for the next possible target waypoint */

    			ectrl->next_target_waypoint = get_linked_closest_convoy_waypoint();

					if ( ectrl->convoyLeader )
					{
						if ( ectrl->next_target_waypoint==NULL_ID )
						{
							ectrl->control_func = leader_reached_end;
							return ;
						}
					}

					/* Get angle from current waypoint to next waypoint */

					waypt = waypt_data + *(waypt_index + ectrl->next_target_waypoint);
					waypt++; /* skip over number links associated with waypoint */

					wayptx = *waypt++;
					wayptz = *waypt;

					angle2NextWaypt = (int)(phd_atan( (int)(ectrl->twayptx - wayptx), (int)(ectrl->twayptz - wayptz) ) &0x7ff);

					angle2NextWaypt = get_angle_difference(angle2NextWaypt, etank->angle);

					if ( angle2NextWaypt < SWING_AROUND_ANGLE )
					{
						ectrl->slow_decision_made = TRUE;
						break;
					}
					else
					if ( angle2NextWaypt < STOP_AND_ROTATE_ANGLE )
					{
						/* Get new target waypoint */
						ectrl->target_waypoint = ectrl->next_target_waypoint;

						ectrl->next_target_waypoint = NULL_ID;

						ectrl->tank_mode = CONVOY_SWING_2_TARGET_POINT;

						ectrl->twayptx = wayptx;
						ectrl->twayptz = wayptz;

						ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

						return ;
					}
					else
					{
						/* Get new target waypoint */
						ectrl->target_waypoint = ectrl->next_target_waypoint;

						ectrl->next_target_waypoint = NULL_ID;

						ectrl->tank_mode = CONVOY_ROTATE_2_TARGET_POINT;
						ectrl->twayptx = wayptx;
						ectrl->twayptz = wayptz;

						ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

						return ;
					}
					break;


				case REACHED_TARGET:
					/* First check if reached path checkpoint */

					/* Get new target waypoint */
					ectrl->target_waypoint = ectrl->next_target_waypoint;

					/* Reset next target waypoint data */
					ectrl->next_target_waypoint = NULL_ID;

					/* Get position of target waypoint */
					waypt = waypt_data + *(waypt_index + ectrl->target_waypoint);
					waypt++; /* skip over number links associated with waypoint */

					ectrl->twayptx = *waypt++;
					ectrl->twayptz = *waypt;

					ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

					ectrl->slow_decision_made = FALSE;
					break;
			}

			if ( ectrl->convoyLeader )
			{
				if ( etank->speed<CONVOY_SPEED )
				{
					moveForwardDecision=TRUE;
				}
				else
					moveBackwardDecision=TRUE;
			}
			else
			{
				truckInfront = get_truck_infront(etank);

				relx = (etank->x>>24) - (truckInfront->x>>24);
				relz = (etank->z>>24) - (truckInfront->z>>24);

				relx*=relx;
				relz*=relz;

				sqrtDist = relx+relz;

				if ( sqrtDist > CONVOY_SPEEDUP_DIST ) 			/* Truck in front too far away - catchup */
				{
					moveForwardDecision = TRUE;
				}
				else if ( sqrtDist < CONVOY_STOP_DIST ) 		/* Truck in front very close - stop */
				{
					etank->speed=0;
				}
				else if ( sqrtDist < CONVOY_SLOWDOWN_DIST ) /* Truck in front close - slow down */
				{
					if ( etank->speed > CONVOY_SLOW_SPEED )
					{
						moveBackwardDecision = TRUE;
					}
					else
						moveForwardDecision = TRUE;
				}
				else 																				/* The Truck infront is a ROVER */
				{
  				if ( etank->speed<CONVOY_SPEED )
  				{
  					moveForwardDecision=TRUE;
  				}
  				else
  					moveBackwardDecision=TRUE;
				}

			}



			/* Readjust angle of truck if need to */

			newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);

			set_turn_decision(etank, newTurnDirn);
			break;


/********************/

		case CONVOY_SWING_2_TARGET_POINT:

			ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

			newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);

			switch ( newTurnDirn )
			{
				case SMALL_LEFT_TURN:
				case SMALL_RIGHT_TURN:
				case NO_TURN: /* Force angle and start moving towards point */
					etank->dir = etank->angle = ectrl->angle_2_target;
					etank->turn = 0;	/* Stop the turning momentum - FRIGG */
					moveForwardDecision=TRUE;

					ectrl->tank_mode = EPURSUE_MOVE_2_POINT;
					return;
					break;

				case LARGE_RIGHT_TURN:
					/* Check if there is a closer target waypoint which is quicker to turn to than current one */

					ectrl->small_turn_count=SMALL_TURN_THRESHOLD_2;
					turnRightDecision=TRUE;
					break;


				case LARGE_LEFT_TURN:
					/* Check if there is a closer target waypoint which is quicker to turn to than current one */

					ectrl->small_turn_count=SMALL_TURN_THRESHOLD_2;
					turnLeftDecision=TRUE;
					break;

			}
			break;

/********************/


		case CONVOY_ROTATE_2_TARGET_POINT:

			ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

			newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);

			switch ( newTurnDirn )
			{
				case SMALL_LEFT_TURN:
				case SMALL_RIGHT_TURN:
				case NO_TURN: /* Force angle and start moving towards point */
					etank->dir = etank->angle = ectrl->angle_2_target;
					etank->turn = 0;	/* Stop the turning momentum - FRIGG */
					moveForwardDecision=TRUE;

					ectrl->tank_mode = FOLLOW_CONVOY_PATH;
					break;


				case LARGE_RIGHT_TURN:
					/* Check if there is a closer target waypoint which is quicker to turn to than current one */

					ectrl->small_turn_count=SMALL_TURN_THRESHOLD_2;
					turnRightDecision=TRUE;
					if ( etank->speed>0x20 )
					{
						moveBackwardDecision=TRUE;
					}
					else
					if ( etank->speed<0x20 )
					{
						moveForwardDecision=TRUE;
					}
					else
						etank->speed=0;

					break;


				case LARGE_LEFT_TURN:
					/* Check if there is a closer target waypoint which is quicker to turn to than current one */

					ectrl->small_turn_count=SMALL_TURN_THRESHOLD_2;
					turnLeftDecision=TRUE;
					if ( etank->speed>0x20 )
					{
						moveBackwardDecision=TRUE;
					}
					else
					if ( etank->speed<0x20 )
					{
						moveForwardDecision=TRUE;
					}
					else
						etank->speed=0;
					break;

			}
			break;

	}

}

/***************************************************************/



void	leader_reached_end(void)
{
	CONVOY_DATA *cConvoy;

	if ( etank->speed>0x30 )
	{
		moveBackwardDecision=TRUE;
	}
	else
	if ( etank->speed<-0x30 )
	{
		moveForwardDecision=TRUE;
	}
	else
	{
		etank->speed = 0;
		etank->ectrl->control_func = NULL;	/* Turn truck into a stationary truck */
		cConvoy = convoyData + (etank->ectrl->pathUsed)-1;
		convoyCompleted = TRUE;
	}
}







