void	enemy_tank_stationary(void)
{
	int			reltx, reltz;				/* Relative distances in terms of tiles */
	int			sqrtdist;						/* squared distance in tiles */
	int			minsqrtdist;
	ushort	*waypt;             /* Pointer to waypoint */
	ushort	newTurnDirn;        /* The calculated turn direction */
	CONVOY_DATA	*cConvoy;
	int			attackSlot;

	/** Find target tank if required **/

	switch ( ectrl->tank_mode )
	{
		case ESTAT_INACTIVE:
    	if ( objectiveType==PROTECT_CONVOY_OBJECTIVE )
    	{
    		int j;
    		ushort	*cmember;
    		TANK	*alliedTruck;

    		/** find the closest target tank - either an allied convoy truck or the player */
      	reltx = (pl.x >> 24) - (etank->x >> 24);	/* Get relative distance in terms of floor tiles */
      	reltz = (pl.z >> 24) - (etank->z >> 24);

      	reltx *= reltx;
      	reltz *= reltz;

    		/** assume the player tank is the closest target tank */
    		ectrl->targetTank = targetTank= &pl;
      	minsqrtdist = reltx + reltz;

    		/** assume their is only one allied convoy (in convoyData[0] **/

    		for ( j=0, cConvoy=convoyData, cmember=cConvoy->members; j<cConvoy->numMembers; j++ )
    		{
					alliedTruck = enemyTanks+(*cmember++);
    			/** get distance to the  **/
    	  	reltx = (alliedTruck->x >> 24) - (etank->x >> 24);	/* Get relative distance in terms of floor tiles */
        	reltz = (alliedTruck->z >> 24) - (etank->z >> 24);

      		reltx *= reltx;
      		reltz *= reltz;

    			if ( (sqrtdist=(reltx+reltz)) < minsqrtdist )
    			{
    				ectrl->targetTank = targetTank = alliedTruck;
    				minsqrtdist = sqrtdist;
    			}
    		}

    	}
    	else
			{
    		ectrl->targetTank = targetTank = &pl;

	    	reltx = (targetTank->x >> 24) - (etank->x >> 24);		/* Get relative distance in terms of floor tiles */
  	  	reltz = (targetTank->z >> 24) - (etank->z >> 24);

    		reltx *= reltx;
    		reltz *= reltz;

    		minsqrtdist = reltx + reltz;
			}


			if ( minsqrtdist >= enemyTriggerRange[etank->def] ) 		/* No target tanks in range */
			{
				etank->moveTank=FALSE;
				return;
			}

			if ( numAttacking > MAX_ATTACKING_TANKS ) 						/* Only have a maximum number attacking at any one time */
			{
				etank->moveTank = FALSE;
				return;
			}

			/* Tank has come into range - need to join the mesh */
			ectrl->target_waypoint = NULL_ID;
			ectrl->stillCount=0;

			/* Try and find a valid target waypoint */
			if ( ectrl->rejoin_waypoint!=NULL_ID )								/* Check if tank was using control net before */
			{
				if ( wayptChkList[ectrl->rejoin_waypoint]==FALSE )	/* Try and use the old waypoint */
				{
					ectrl->target_waypoint = ectrl->rejoin_waypoint;	/* Waypoint available for use */
					wayptChkList[ectrl->rejoin_waypoint] = TRUE;			/* Note that waypoint is being used */
				}
				else
				{
					ectrl->rejoin_waypoint = NULL_ID;
					ectrl->target_waypoint = get_closest_waypt( (etank->x>>16), (etank->z>>16) );
				}
			}
			else																								/* Join the waypoint mesh for the first time */
				ectrl->target_waypoint = get_closest_waypt( (etank->x>>16), (etank->z>>16) );


			/* Reset next target waypoint data */
			ectrl->next_target_waypoint = NULL_ID;

			if ( ectrl->target_waypoint==NULL_ID ) 							/* Couldn't find a valid waypoint to use - stay inactive */
			{
				return ;
			}


			if ( (attackSlot=get_attacking_slot()) >= 0 )
			{
				/* This tank has joined the limited number of actual attacking tanks */
				etank->collData = attackData + attackSlot;
				numAttacking++;
			}
			else
			{
				/** not enough attack slots */
				clear_waypoint_check(etank);
				return ;
			}

			/* Get target waypoint coords */

			waypt = waypt_data + *(waypt_index + ectrl->target_waypoint);
			waypt++; /* skip over number links associated with waypoint */

			ectrl->twayptx = *waypt++;
			ectrl->twayptz = *waypt;


			/* Get angle to target waypoint */

			ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

			newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);

			ectrl->small_turn_count = 0;

			/* Check if already facing waypoint */

			if ( newTurnDirn == NO_TURN )
			{
				etank->dir = etank->angle = ectrl->angle_2_target;
				etank->turn = 0;	/* Stop the turning momentum - FRIGG */
				ectrl->control_func = enemy_tank_pursue;
				ectrl->small_turn_count = 0;
				ectrl->tank_mode = EPURSUE_MOVE_2_POINT;
			}
			else
			{
				ectrl->tank_mode = ESTAT_ROTATE;

				if ( (newTurnDirn==LARGE_LEFT_TURN) || (newTurnDirn==SMALL_LEFT_TURN) )
				{
					turnLeftDecision=TRUE;
				}
				else
				{
				 	turnRightDecision=TRUE;
				}

				if ( newTurnDirn&1 )	/* Setup the small turn count if the turn is large */
				{
					ectrl->small_turn_count=SMALL_TURN_THRESHOLD;
				}
			}
			break;

		/****************/

		case ESTAT_ROTATE:
			newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);

			set_turn_decision(etank, newTurnDirn);

			if ( newTurnDirn==NO_TURN  )
			{
				etank->dir = etank->angle = ectrl->angle_2_target;
				etank->turn = 0;	/* Stop the turning momentum - FRIGG */
				ectrl->control_func = enemy_tank_pursue;
				ectrl->small_turn_count = 0;
				ectrl->tank_mode = EPURSUE_MOVE_2_POINT;
				ectrl->slow_decision_made = FALSE;
			}
			break;

		/****************/

		case ESTAT_BECOME_INACTIVE:
			etank->speed=0;

			ectrl->tank_mode = ESTAT_INACTIVE;

			if ( etank->collData != NULL )
			{
				etank->collData->slotUsed = FALSE;
				etank->collData = NULL;
				numAttacking--;
			}

			clear_waypoint_check(etank);

			/** if tank was using an attacking slot then make it available for others */

			if ( etank->collData != NULL )
			{
				etank->collData->slotUsed = FALSE;
				etank->collData=NULL;
			}
			break;
	}
}






/***************************************************************/



void	enemy_tank_pursue(void)
{
	int			reltx, reltz;				/* Relative distances in terms of tiles */
	int			sqrtdist;						/* squared distance in tiles */
	ushort	pursueDecision;
	ushort	newTurnDirn;
	ushort	*waypt;
	ushort	wayptx, wayptz;
	ushort	angle2NextWaypt;
	ushort	oldtwaypt;


	switch ( ectrl->tank_mode )
	{
		case EPURSUE_MOVE_2_POINT:

			pursueDecision = get_dist_2_target_waypt();

			ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

			switch ( pursueDecision )
			{
				case CONTINUE_MOVEMENT:
					break;


				case SLOW_DOWN:
					if ( ectrl->slow_decision_made )
					{
						break;
					}

					/* Check if target tank is still in range */

					reltx = (targetTank->x>>24) - (etank->x>>24);	/* Get relative distance in terms of floor tiles */
					reltz = (targetTank->z>>24) - (etank->z>>24);

					reltx *= reltx;
					reltz *= reltz;

					sqrtdist = reltx + reltz;

					if ( sqrtdist >=enemyTriggerRange[etank->def] ) 	/* No target tanks in range */
					{
						ectrl->control_func = enemy_tank_stationary;
						ectrl->tank_mode = ESTAT_BECOME_INACTIVE;
						ectrl->slow_decision_made = FALSE;
						if ( ectrl->target_waypoint!=NULL_ID )
						{
							wayptChkList[ectrl->target_waypoint] = FALSE;	/*Make target waypoint available to others */
						}

						return ;
	 				}


					if ( test_restricted_tank() )
					{
						return ;
					}


  				/* Check to see if you can target tank */

  				if ( sqrtdist<=enemyTargettingRange[etank->def] )
  				{
  					if ( test_tank_line_of_sight() ) /* Within targetting range and can be seen */
  					{
  						ectrl->control_func = enemy_tank_targetting;
							ectrl->slow_decision_made = FALSE;
							ectrl->rejoin_waypoint = ectrl->target_waypoint;

							if ( ectrl->target_waypoint==NULL_ID )
							{
								ectrl->target_waypoint = get_closest_waypt( (etank->x>>16), (etank->z>>16) );
							}

  						return ;
  					}
  				}



    			/* Look for the next possible target waypoint */

    			ectrl->next_target_waypoint = get_linked_closest_waypoint(NULL_ID, BASIC_EXCLUSION);

    			if ( ectrl->next_target_waypoint==NULL_ID ) 		/* Couldn't find a valid target way point */
    			{
    				/* Nowhere to go */
						ectrl->control_func = enemy_wait_for_space;
						ectrl->slow_decision_made = FALSE;
    				return ;
    			}



					/* Get angle from current waypoint to next waypoint */

					waypt = waypt_data + *(waypt_index + ectrl->next_target_waypoint);
					waypt++; /* skip over number links associated with waypoint */

					wayptx = *waypt++;
					wayptz = *waypt;

					angle2NextWaypt = (int)(phd_atan( (int)(ectrl->twayptx - wayptx), (int)(ectrl->twayptz - wayptz) ) &0x7ff);

					angle2NextWaypt = get_angle_difference(angle2NextWaypt, etank->angle);



					if ( angle2NextWaypt < SWING_AROUND_ANGLE )
					{
						ectrl->slow_decision_made = TRUE;
						break;
					}
					else
					if ( angle2NextWaypt < STOP_AND_ROTATE_ANGLE )
					{
						ectrl->rejoin_waypoint = ectrl->target_waypoint;

						/* Get new target waypoint */
						ectrl->target_waypoint = ectrl->next_target_waypoint;

						ectrl->next_target_waypoint = NULL_ID;

						ectrl->tank_mode = SWING_2_TARGET_POINT;

						ectrl->twayptx = wayptx;
						ectrl->twayptz = wayptz;

						ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

						return ;
					}
					else
					{
						ectrl->rejoin_waypoint = ectrl->target_waypoint;
						/* Get new target waypoint */
						ectrl->target_waypoint = ectrl->next_target_waypoint;

						ectrl->next_target_waypoint = NULL_ID;

						ectrl->tank_mode = ROTATE_2_TARGET_POINT;
						ectrl->twayptx = wayptx;
						ectrl->twayptz = wayptz;

						ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

						return ;
					}
					break;


				case REACHED_TARGET:
					/* Get new target waypoint */
					ectrl->target_waypoint = ectrl->next_target_waypoint;

					/* Reset next target waypoint data */
					ectrl->next_target_waypoint = NULL_ID;

					/* Get position of target waypoint */
					waypt = waypt_data + *(waypt_index + ectrl->target_waypoint);
					waypt++; /* skip over number links associated with waypoint */

					ectrl->twayptx = *waypt++;
					ectrl->twayptz = *waypt;

					ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

					ectrl->slow_decision_made = FALSE;

					break;
			}




			moveForwardDecision=TRUE;



			/* Check if tank has moved */

			if ( (ectrl->stillx == (etank->x>>16)) && (ectrl->stillz == (etank->z>>16)) && (ectrl->rejoin_waypoint!=NULL_ID) && (etank->speed>0x100) )
			{
				ectrl->stillCount++;
				if ( ectrl->stillCount>=STILL_THRESHOLD )
				{
					ectrl->stillCount=0;

					clear_waypoint_check(etank);

					/* Need to find a new target waypoint - stuck using the current one */
					oldtwaypt = ectrl->target_waypoint;

					if ( ectrl->rejoin_waypoint!=NULL_ID )
					{
						ectrl->target_waypoint = ectrl->rejoin_waypoint;/*Get a new waypoint connected to the old waypoint */
						ectrl->next_target_waypoint = get_linked_closest_waypoint(oldtwaypt, BASIC_EXCLUSION);
					}
					else
					{
						ectrl->next_target_waypoint = get_closest_waypt( (etank->x>>16), (etank->z>>16) );
					}

					if ( ectrl->next_target_waypoint==NULL_ID )
					{
						/* nowhere to go */
						ectrl->control_func = enemy_wait_for_space;
						ectrl->slow_decision_made = FALSE;
						return ;
					}

					ectrl->target_waypoint = ectrl->next_target_waypoint;

					ectrl->next_target_waypoint=NULL_ID;

					moveForwardDecision = FALSE;

					waypt = waypt_data + *(waypt_index + ectrl->target_waypoint);
					waypt++; /* skip over number links associated with waypoint */

					ectrl->twayptx = *waypt++;
					ectrl->twayptz = *waypt;

					ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

					ectrl->tank_mode = ROTATE_2_TARGET_POINT;
				}
			}
			else
			{
				ectrl->stillx = etank->x>>16;
				ectrl->stillz = etank->z>>16;
				ectrl->stillCount=0;
			}



			/* Readjust angle of tank if need to */

			newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);

			switch ( newTurnDirn )
			{
				case NO_TURN: /* Force angle and start moving towards point */
					etank->dir = etank->angle = ectrl->angle_2_target;
					etank->turn = 0;	/* Stop the turning momentum - FRIGG */
					break;


				case SMALL_RIGHT_TURN:
					if ( ectrl->small_turn_count>=SMALL_TURN_THRESHOLD_2 )
 					{
 						/* Wait - still experiencing previous turn */
 						if ( ectrl->small_turn_count>=SMALL_TURN_RESET_VALUE_2 )
 						{
 							ectrl->small_turn_count=0;
 						}
 					}
 					else
 						turnRightDecision=TRUE;
 					ectrl->small_turn_count++;
					break;


				case LARGE_RIGHT_TURN:
					ectrl->small_turn_count=SMALL_TURN_THRESHOLD_2;
					moveForwardDecision = FALSE;
					turnRightDecision=TRUE;
					break;


				case SMALL_LEFT_TURN:
					if ( ectrl->small_turn_count>=SMALL_TURN_THRESHOLD_2 )
					{
						/* Wait - still experiencing previous turn */
						if ( ectrl->small_turn_count>=SMALL_TURN_RESET_VALUE_2 )
						{
							ectrl->small_turn_count=0;
						}
					}
					else
 						turnLeftDecision=TRUE;
					ectrl->small_turn_count++;
					break;


				case LARGE_LEFT_TURN:
					ectrl->small_turn_count=SMALL_TURN_THRESHOLD_2;
					turnLeftDecision=TRUE;
					moveForwardDecision = FALSE;
					break;

			}
			break;


/********************/
		case SWING_2_TARGET_POINT:

			ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

			newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);

			switch ( newTurnDirn )
			{
				case SMALL_LEFT_TURN:
				case SMALL_RIGHT_TURN:
				case NO_TURN: /* Force angle and start moving towards point */
					etank->dir = etank->angle = ectrl->angle_2_target;
					etank->turn = 0;	/* Stop the turning momentum - FRIGG */
					moveForwardDecision=TRUE;

					ectrl->tank_mode = EPURSUE_MOVE_2_POINT;
					return;
					break;

				case LARGE_RIGHT_TURN:
					/* Check if there is a closer target waypoint which is quicker to turn to than current one */

					ectrl->small_turn_count=SMALL_TURN_THRESHOLD_2;
					turnRightDecision=TRUE;
					break;


				case LARGE_LEFT_TURN:
					/* Check if there is a closer target waypoint which is quicker to turn to than current one */

					ectrl->small_turn_count=SMALL_TURN_THRESHOLD_2;
					turnLeftDecision=TRUE;
					break;

			}
			break;

/********************/


		case ROTATE_2_TARGET_POINT:
			ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);
			newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);

			switch ( newTurnDirn )
			{
				case SMALL_LEFT_TURN:
				case SMALL_RIGHT_TURN:
				case NO_TURN: /* Force angle and start moving towards point */
					etank->dir = etank->angle = ectrl->angle_2_target;
					etank->turn = 0;	/* Stop the turning momentum - FRIGG */
					moveForwardDecision=TRUE;

					ectrl->tank_mode = EPURSUE_MOVE_2_POINT;
					break;


				case LARGE_RIGHT_TURN:
					/* Check if there is a closer target waypoint which is quicker to turn to than current one */

					ectrl->small_turn_count=SMALL_TURN_THRESHOLD_2;
					turnRightDecision=TRUE;
					if ( etank->speed>0x20 )
					{
						moveBackwardDecision=TRUE;
					}
					else
					if ( etank->speed<0x20 )
					{
						moveForwardDecision=TRUE;
					}
					else
						etank->speed=0;

					break;


				case LARGE_LEFT_TURN:
					/* Check if there is a closer target waypoint which is quicker to turn to than current one */

					ectrl->small_turn_count=SMALL_TURN_THRESHOLD_2;
					turnLeftDecision=TRUE;
					if ( etank->speed>0x20 )
					{
						moveBackwardDecision=TRUE;
					}
					else
					if ( etank->speed<0x20 )
					{
						moveForwardDecision=TRUE;
					}
					else
						etank->speed=0;
					break;

			}
			break;

	}

}

/***************************************************************/


void	enemy_wait_for_space(void)	/*Waits for an available target waypoint - and slows down in the mean time */
{
	ushort	*waypt;
	ushort	angle2NextWaypt;
	int			reltx, reltz;				/* Relative distances in terms of tiles */
	int			sqrtdist;

	/* Check if enemy gone out of range */

	reltx = (targetTank->x>>24) - (etank->x>>24);	/* Get relative distance in terms of floor tiles */
	reltz = (targetTank->z>>24) - (etank->z>>24);

	reltx *= reltx;
	reltz *= reltz;

	sqrtdist = reltx + reltz;

	if ( sqrtdist >=enemyTriggerRange[etank->def] ) 	/* No target tanks in range */
	{
		ectrl->control_func = enemy_tank_stationary;
		ectrl->tank_mode = ESTAT_BECOME_INACTIVE;
		ectrl->slow_decision_made = FALSE;
		return ;
	}

if ( ectrl->target_waypoint==NULL_ID )
{
	debug_msg("In enemy 'void	enemy_wait_for_space(void)':\n");
	print_tank_data(etank);

 	getout("Found a fucker");
}


	ectrl->next_target_waypoint = get_linked_closest_waypoint(NULL_ID, BASIC_EXCLUSION);

	if ( ectrl->next_target_waypoint!=NULL_ID )
	{
		ectrl->target_waypoint = ectrl->next_target_waypoint;
		ectrl->next_target_waypoint = NULL_ID;

		waypt = waypt_data + *(waypt_index + ectrl->target_waypoint);
		waypt++; /* skip over number links associated with waypoint */

		ectrl->twayptx = *waypt++;
		ectrl->twayptz = *waypt;

		angle2NextWaypt = ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

		ectrl->control_func = enemy_tank_pursue;
		ectrl->tank_mode = EPURSUE_MOVE_2_POINT;

		angle2NextWaypt = get_angle_difference(angle2NextWaypt, etank->angle);

		ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

		if ( angle2NextWaypt < SWING_AROUND_ANGLE )
		{
			ectrl->slow_decision_made = FALSE;
			ectrl->tank_mode = EPURSUE_MOVE_2_POINT;
		}
		else
		if ( angle2NextWaypt < STOP_AND_ROTATE_ANGLE )
		{
			ectrl->tank_mode = SWING_2_TARGET_POINT;
		}
		else
		{
			ectrl->tank_mode = ROTATE_2_TARGET_POINT;
		}
		return ;
	}
	else
	{
		ectrl->next_target_waypoint = NULL_ID;

		if ( etank->speed>0x20 )
		{
			moveBackwardDecision=TRUE;
		}
		else
		if ( etank->speed<0x20 )
		{
			moveForwardDecision=TRUE;
		}
		else
			etank->speed=0;
	}
}



/***************************************************************/


void	enemy_tank_targetting(void)
{
	int			reltx, reltz;																/* Relative distances in terms of tiles */
	int			sqrtdist;																		/* squared distance in tiles */
	ushort	*waypt;
	ushort	wayptx, wayptz;
	ushort	angle2NextWaypt;
	ushort	newTurnDirn;

	reltx = (targetTank->x>>24) - (etank->x>>24);				/* Get relative distance in terms of floor tiles */
	reltz = (targetTank->z>>24) - (etank->z>>24);

	reltx *= reltx;
	reltz *= reltz;

	sqrtdist = reltx + reltz;

	if ( sqrtdist>enemyTargettingRange[etank->def] 			/* Target gone out of range for targetting */
			||
			( !(test_tank_line_of_sight()) ) )							/* Target not visible anymore */
	{
		if ( sqrtdist > enemyTriggerRange[etank->def] ) 	/* Target out of detection range as well */
		{
 			ectrl->control_func = enemy_tank_stationary;
 			ectrl->tank_mode = ESTAT_BECOME_INACTIVE;
			ectrl->slow_decision_made = FALSE;

			if ( ectrl->target_waypoint!=NULL_ID )
			{
				wayptChkList[ectrl->target_waypoint] = FALSE; /* Make waypoint available */
			}
 			return ;
		}

if ( ectrl->target_waypoint==NULL_ID )
{
	debug_msg("In enemy 'void	enemy_tank_targetting(void)':\n");
	print_tank_data(etank);
 	getout("Found a fucker");
}

		/* Need to go back into pursue mode */
		ectrl->next_target_waypoint = get_linked_closest_waypoint(NULL_ID, USE_CURRENT_TARGET_WAYPOINT);

		if ( ectrl->next_target_waypoint==NULL_ID )
		{
			/* nowhere to go */
			ectrl->control_func = enemy_wait_for_space;
			ectrl->slow_decision_made = FALSE;
			return ;
		}

		ectrl->target_waypoint = ectrl->next_target_waypoint;


		ectrl->next_target_waypoint = NULL_ID;

		ectrl->control_func = enemy_tank_pursue;
		ectrl->small_turn_count = 0;
		ectrl->slow_decision_made = FALSE;
		ectrl->tank_mode = EPURSUE_MOVE_2_POINT;

		/* Get angle from current position to next waypoint */

		waypt = waypt_data + *(waypt_index + ectrl->target_waypoint);
		waypt++; /* skip over number links associated with waypoint */

		ectrl->twayptx = wayptx = *waypt++;
		ectrl->twayptz = wayptz = *waypt;

		angle2NextWaypt = (int)(phd_atan( (int)((etank->x>>16) - wayptx), (int)((etank->x>>16) - wayptz) ) &0x7ff);

		angle2NextWaypt = get_angle_difference(angle2NextWaypt, etank->angle);

		ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);

		if ( angle2NextWaypt < SWING_AROUND_ANGLE )
		{
			ectrl->tank_mode = EPURSUE_MOVE_2_POINT;
		}
		else
		if ( angle2NextWaypt < STOP_AND_ROTATE_ANGLE )
		{
			ectrl->tank_mode = SWING_2_TARGET_POINT;
		}
		else
		{
			ectrl->tank_mode = ROTATE_2_TARGET_POINT;
		}

		return ;
	}


	if ( etank->speed>0x20 )
	{
		moveBackwardDecision=TRUE;
	}
	else
	if ( etank->speed<0x20 )
	{
		moveForwardDecision=TRUE;
	}
	else
		etank->speed=0;


	/* Rotate towards the target tank */

	ectrl->angle_2_target = (int)((phd_atan( (int) ((uint)(etank->x>>16) - (uint)(targetTank->x>>16)) , (int) ((uint)(etank->z)>>16) - (uint)(targetTank->z>>16) ) ) &0x7ff);

	newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);

	set_turn_decision(etank, newTurnDirn);
}


/***************************************************************/



void	enemy_tank_restricted_targeting(void)
{
	int			reltx, reltz;				/* Relative distances in terms of tiles */
	int			sqrtdist;						/* squared distance in tiles */
	ushort	*waypt;
	ushort	newTurnDirn;
	ushort	wptx, wptz;
	ushort	plrx=targetTank->x>>16, plrz=targetTank->z>>16;

	if ( plrx>=ectrl->rx1 && plrx<=ectrl->rx2 && plrz>=ectrl->rz1 && plrz<=ectrl->rz2 )				/* check if target tank is within restricted zone */
	{
if ( ectrl->target_waypoint==NULL_ID )
{
	debug_msg("In enemy 'enemy_tank_restricted_targeting(void)':\n");
	print_tank_data(etank);

 	getout("Found a fucker");
}


		ectrl->next_target_waypoint = get_linked_closest_waypoint(NULL_ID, BASIC_EXCLUSION);		/* Find nearest linked waypoint to target */

  	if ( ectrl->next_target_waypoint!=NULL_ID )
  	{
  		waypt = waypt_data + *(waypt_index + ectrl->next_target_waypoint);
  		waypt++; /* skip over number links associated with waypoint */

  		wptx = *waypt++;
  		wptz = *waypt;

  		/* Check if new waypoint is within restriction */
  		if ( wptx>=ectrl->rx1 && wptx<=ectrl->rx2 && wptz>=ectrl->rz1 && wptz<=ectrl->rz2 )	/* waypoint is within restriction zone */
  		{
  			ectrl->twayptx = wptx;
  			ectrl->twayptz = wptz;

  			ectrl->target_waypoint = ectrl->next_target_waypoint;
  			ectrl->next_target_waypoint = NULL_ID;

  			/* Get angle to target waypoint */
  			ectrl->angle_2_target = (int)((phd_atan( (int)((uint)(etank->x>>16) - (uint)ectrl->twayptx) , (int)((uint)(etank->z)>>16) - (uint)ectrl->twayptz ) ) &0x7ff);
  			newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);

  			set_turn_decision(etank, newTurnDirn);

  			ectrl->slow_decision_made = FALSE;

  			if ( newTurnDirn == NO_TURN )
  			{
  				etank->dir = etank->angle = ectrl->angle_2_target;
  				etank->turn = 0;	/* Stop the turning momentum - FRIGG */
  				ectrl->control_func = enemy_tank_pursue;
  				ectrl->tank_mode = EPURSUE_MOVE_2_POINT;
  				return ;
  			}


  			ectrl->control_func = enemy_tank_stationary;
  			ectrl->tank_mode = ESTAT_ROTATE;
  			return ;
  		}
			else
			{
				wayptChkList[ectrl->next_target_waypoint]=FALSE;
				ectrl->next_target_waypoint=NULL_ID;
			}

  	}

	}


	reltx = (targetTank->x>>24) - (etank->x>>24);	/* Get relative distance in terms of floor tiles */
	reltz = (targetTank->z>>24) - (etank->z>>24);

	reltx *= reltx;
	reltz *= reltz;

	sqrtdist = reltx + reltz;

	if ( sqrtdist > enemyTriggerRange[etank->def] ) 	/*Target out of detection range as well */
	{
		ectrl->control_func = enemy_tank_stationary;
		ectrl->tank_mode = ESTAT_BECOME_INACTIVE;
		ectrl->slow_decision_made = FALSE;

		if ( ectrl->target_waypoint!=NULL_ID )
		{
			wayptChkList[ectrl->target_waypoint] = FALSE; 	/*Make waypoint available */
		}
		return ;
	}


	if ( etank->speed>0x20 )
	{
		moveBackwardDecision=TRUE;
	}
	else
	if ( etank->speed<0x20 )
	{
		moveForwardDecision=TRUE;
	}
	else
		etank->speed=0;

	test_tank_line_of_sight();


	/* Rotate towards the target tank */

	ectrl->angle_2_target = (int)((phd_atan( (int) ((uint)(etank->x>>16) - (uint)(targetTank->x>>16)) , (int) ((uint)(etank->z)>>16) - (uint)(targetTank->z>>16) ) ) &0x7ff);
	newTurnDirn = get_turn_dirn(etank->angle, ectrl->angle_2_target);
	set_turn_decision(etank, newTurnDirn);
}



/************************************************************************************/
/************************************************************************************/
/************************************************************************************/
/************************************************************************************/




/***************************************************************/


ushort	get_linked_closest_waypoint(uint	excludeId, uint excludeFlag)
{
	ushort	targetx, targetz;
	uint		sqrDist;										/* squared distance of waypoint from target */
	uint		csqrDist;										/* Closest distance so far  */
	uint		relx, relz;									/* relative x and z values */
	ushort	*waypt;											/* Pointer to current waypoint data */
	ushort	*link;
	ushort	*lwaypt;										/* pointer to the linked waypoint */
	ushort	wptx, wptz;									/* current waypoint x and z */
	ushort	cwayptId;										/* current waypoint id */
	ushort	closestWaypt=NULL_ID;				/* Closest waypoint */
	ushort	numLinks;
	ushort	linkCnt;
	ushort	linkCondition;
	ushort	oppDir;
	ushort	twaypoint;


	if ( etank!=NULL && etank->flying )
	{
		oppDir = (pl.dir+0x400)&0x7ff;

  	targetx = targetTank->x>>16;
  	targetz = targetTank->z>>16;

		targetx += ((HELICOPTER_THREAT_DIST * ((int)sintab[oppDir+512])) >> 15);
		targetz += ((HELICOPTER_THREAT_DIST * ((int)sintab[oppDir])) >> 15);
	}
	else
	{
  	switch ( ectrl->iq )
  	{
			case SMART:
				oppDir = (pl.dir+0x400)&0x7ff;
  			targetx = targetTank->x>>16;
  			targetz = targetTank->z>>16;
				targetx += ((TANK_THREAT_DIST * ((int)sintab[oppDir+512])) >> 15);
				targetz += ((TANK_THREAT_DIST * ((int)sintab[oppDir])) >> 15);
				break;


  		case QUITE_DIM:
  			targetx = targetTank->x>>16;
  			targetz = targetTank->z>>16;
  			break;


			default:
  			targetx = targetTank->x>>16;
  			targetz = targetTank->z>>16;
				break;
  	}
	}


	if ( ectrl->target_waypoint!=NULL_ID )
	{
		twaypoint = ectrl->target_waypoint;

		ectrl->rejoin_waypoint = ectrl->target_waypoint;									/*Note the last waypoint incase tank becomes inactive and needs to rejoin mesh */

		if ( ectrl->control_func!=enemy_wait_for_space )
		{
			wayptChkList[ectrl->rejoin_waypoint] = FALSE;										/*Free up the current target waypoint for use by others */
		}
	}
	else
		twaypoint = ectrl->rejoin_waypoint;

	if ( twaypoint==NULL_ID )
	{
		debug_msg("Found a fucker inside 'get_linked_closest_waypt\n'");
		print_tank_data(etank);
		getout("Found a fucker");
	}

	waypt = waypt_data + *(waypt_index + twaypoint);		/* Get the best waypoint linked to the current waypoint */

	numLinks = *waypt++;	/* Get the number of links that have to be checked */
	waypt+=2;							/* Skip over the x and z values of the current waypoint */

	csqrDist = 0xffffffff;



	/* If current target waypoint is elligible then assume it is the best choice */

	if ( excludeFlag & USE_CURRENT_TARGET_WAYPOINT )
	{
		lwaypt = waypt_data + *(waypt_index + ectrl->target_waypoint);

		lwaypt++; /* Skip over number of links data */

		/* Get position of linked waypoint */
		wptx = *lwaypt++;
		wptz = *lwaypt;

		relx = abs(targetx - wptx);
		relz = abs(targetz - wptz);

		csqrDist = relx*relx + relz*relz;
		closestWaypt = ectrl->target_waypoint;
	}


	for ( linkCnt=0; linkCnt<numLinks; linkCnt++ )
	{
		link = link_data + *waypt++;
		linkCondition = *link++;

		if ( (linkCondition == FALSE) && (!etank->flying) )
		{
			continue;
		}

		if ( *link==ectrl->target_waypoint )
		{
			link++;
		}

		cwayptId = *link;

		if ( cwayptId == excludeId)			/* This waypoint is not to be considered */
		{
			continue;
		}

		if ( wayptChkList[cwayptId] ) 	/* This waypoint is not to be considered - already being used as target */
		{
			continue;
		}

		if ( (cwayptId == ectrl->last_waypoint) && (numLinks>1) ) /*Can't go back to the previous waypoint unless it's the only one */
		{
			continue;
		}



		lwaypt = waypt_data + *(waypt_index + *link);

		lwaypt++; /* Skip over number of links data */

		/* Get position of linked waypoint */
		wptx = *lwaypt++;
		wptz = *lwaypt;

		relx = abs(targetx - wptx);
		relz = abs(targetz - wptz);

		sqrDist = relx*relx + relz*relz;

		if ( sqrDist < csqrDist )
		{
			csqrDist = sqrDist;
			closestWaypt = cwayptId;
		}

	}


	if ( closestWaypt!=NULL_ID )
	{
		wayptChkList[closestWaypt]=TRUE;			/* Note that waypoint is being used as a target */

		if ( ectrl->target_waypoint!=NULL_ID ) 				/* Remember the previous waypoint to prevent oscillation */
		{
			ectrl->last_waypoint=ectrl->target_waypoint;
		}
	}

	return (closestWaypt);
}

