/***************************************************************************
*
*
*		 				SHELLSHOCK  MAIN FRONTEND LOGIC CODE
*							 PC - SATURN - PLAYSTATION
*
*								  David Long 1995
*
*
*
****************************************************************************/


#include  "typedefs.h"
#include "frontend.h"
#include "iff.h"
#include <stdio.h>
#include "frontdef.h"

#ifdef PC_VERSION

#include "shell.h"
#include "types.h"
#include "rad.h"
#include "smack.h"
#include "dosext.h"
#include "radmal.i"
#include "svga.h"
#include "timer.h"

#else

typedef struct
	{
	short	sc_width,sc_height;
	short	mx_sense,my_sense,ms_dthresh;
	void		*scrn_ptr;
	short	col_mode;
	short	dump_x,dump_y,dump_width,dump_height;
	}
	SETUP;

int mx,my;

#include "headers.h" /* Platform specific header files */
#include "chuck.h"

#endif





/**************************************************************************/
/*********************** FRONTEND DATA SECTION  ***************************/
/**************************************************************************/

extern SETUP game_setup;
extern char installDir[];

uword	nextMissionTypes[26] =
{
	DUNNOMISS,
	SEARCHMISS,
	DUNNOMISS,
	SEARCHMISS|HOSTAGEMISS,
	NIGHTMISS,
	SEARCHMISS,
	SEARCHMISS|HOSTAGEMISS,
	DUNNOMISS,
	SEARCHMISS,
	NIGHTMISS,
 	SEARCHMISS,
	SEARCHMISS,
	SEARCHMISS,
	SEARCHMISS,
	DUNNOMISS,
	SEARCHMISS|HOSTAGEMISS,
	DUNNOMISS,
	SEARCHMISS,
	DUNNOMISS,
	DUNNOMISS,
	DEFENSIVEMISS,
	DEFENSIVEMISS,
	DEFENSIVEMISS,
	SEARCHMISS,
	SEARCHMISS|HOSTAGEMISS,
	SEARCHMISS|HOSTAGEMISS
};

uword MissionVehicles[26]={
	0,
	AIRTARGS,
	TRUCKS,
	0,
	TRUCKS,
	AIRTARGS,
	0,
	TRUCKS,
	AIRTARGS,
	0,
	AIRTARGS,
	AIRTARGS|TRUCKS,
	AIRTARGS,
	AIRTARGS|TRUCKS,
	AIRTARGS|TRUCKS
};


GAME_IOSTRUCT games[4];


GAME_IOSTRUCT game_data={
	1,		/* Flag */
	1,    /* Mission (current) */
	2,		/* Next mission */
	3,		/* Last armour level */
	24,		/* Last armour integrity */
	3,		/* Armour level */
	24,		/* Armour integrity */

  0,		/* Number of sams */
	0,		/* mine utilizaition system */
	0,		/* Night sight */

	/* Upgrades */

	0,		/* Air support */
	0,		/* engine upgrade */
	0,		/* Track upgrade */
	0,		/* reload upgrade */
	0,		/* Track upgrade */
	0,		/* chain gun upgrade */

	0,		/* Money */

	0,		/* Score */

  100, 	/* Hit acc percent */
  0,		/* Body count */

  32760,   /* Sound vol */
  32760,		/* music vol */
  2,		/* music */
  0,		/* Subtitles */
	GERMAN,		/* Language */

	0,		/* Control device */

	0,		/* Mission status */
	25,
	3,
	10,
	89,
	100,
	95,
	8,
	"",

	/* Keys */

// 	K_COMMA,				/* Left */
//	K_DOT,			    /* Right */
//	K_Q,					  /* Accelerate */
//	K_A,				    /* Reverse */
//	K_SPACE,			  /* Fire weapon */
//	K_S,			      /* Select weapon */
//	K_T,				    /* Reselect target */
//	K_TAB,					/* Access tactical */
//
//  K_A,					  /* Left track forward */
//	K_Z,					  /* Left track backward */
//	K_COLON,			  /* Right track forward */
//	K_DOT,				  /* Right track back */
//	K_SPACE,        /* Fire weapon */
//	K_RET,			    /* Select weapon */
//	K_T,				  /* Reselect target */
//	K_TAB						/* Tactical map */
 };



GAME_IOSTRUCT original_game_data={
	1,		/*Flag */
	1,    /* Mission (current) */
	2,		/* Next mission */
	3,		/* Last armour level */
	24,		/* Last armour integrity */
	3,		/* Armour level */
	24,		/* Armour integrity */

   0,		/* Number of sams */
	0,		/* mine utilizaition system */
	0,		/* Night sight */

	/* Upgrades */

	0,		/* Air support */
	0,		/* engine upgrade */
	0,		/* Track upgrade */
	0,		/* reload upgrade */
	0,		/* Track upgrade */
	0,		/* chain gun upgrade */

	0,		/* Money */

	0,		/* Score */

   100, 	/* Hit acc percent */
   0,		/* Body count */
   32760,   /* Sound vol */
   32760,		/* music vol */
   2,		/* music */
   1,		/* Subtitles */
	GERMAN,		/* Language */

	0,		/* Control device */

	0,		/* Mission status */

	/* Keys */

// 	K_COMMA,				/* Left */
//	K_DOT,			    /* Right */
//	K_Q,					  /* Accelerate */
//	K_A,				    /* Reverse */
//	K_SPACE,			  /* Fire weapon */
//	K_S,			      /* Select weapon */
//	K_T,				    /* Reselect target */
//	K_TAB,					/* Access tactical */
//
//  K_A,					  /* Left track forward */
//	K_Z,					  /* Left track backward */
//	K_COLON,			  /* Right track forward */
//	K_DOT,				  /* Right track back */
//	K_SPACE,        /* Fire weapon */
//	K_RET,			    /* Select weapon */
//	K_T,				  /* Reselect target */
//	K_TAB						/* Tactical map */
 };


/*************************** SOUND STUFF ********************************/


char mouth_frms[]={4,0,1,0,4,0,1,2,1,3,1,0,1,2,1,0,1,0};		  	/* mouth animation frames */
int nvolblks,boff,lastboff,gapstart,nops,shandle,sampno,gotalk;
struct vgap{uword start;uword size;};
struct vgap scantbles[5][64];
uword	scansizes[5];
int gpb,gpe;													/* sample gap start,end */
static uword stfrs[]={0,3,7};
uword soundcard=1;											/* 1- sound card installed */
uword dtscript,dogscript,earscript,ninscript,prpscript;  /* script files for talking chars */
char *prop_scripts[5];						  				/* props script file names */

/* character speech script file names */

 char *DTOUR_fns[]={
	"",
   "dtour1.txt",
   "dtour2.txt",
   "dtour3.txt",
   "dtour4.txt",
   "dtour5.txt",
   "dtour6.txt",
   "dtour7.txt",
   "dtour8.txt",
   "dtour9.txt",
   "dtour10.txt",
   "dtour11.txt",
   "dtour12.txt",
   "dtour13.txt",
   "dtour14.txt",
   "dtour15.txt",
   "dtour16.txt",
   "dtour17.txt"
};

char *DOGGTAG_fns[]={
	"",
   "dogg1.txt",
   "dogg2.txt",
   "dogg3.txt",
   "dogg4.txt",
   "dogg5.txt",
   "dogg6.txt",
   "dogg7.txt",
   "dogg8.txt",
   "dogg9.txt",
   "dogg10.txt",
   "dogg11.txt",
   "dogg12.txt",
   "dogg13.txt"
};

char *EARSHOT_fns[]={
	"",
	"ear1.txt",
	"ear2.txt",
	"ear3.txt",
	"ear4.txt",
	"ear5.txt",
	"ear6.txt",
	"ear7.txt",
	"ear8.txt"
};

char *NINE_fns[]={
   "",
	"9111.txt",
	"9112.txt",
	"9113.txt",
	"9114.txt",
	"9115.txt",
	"9116.txt",
	"9117.txt",
	"9118.txt",
	"9119.txt"};


char *PROP_fns[]={
	"prop1.txt",
	"prop2.txt",
	"prop3.txt",
	"prop4.txt",
	"prop5.txt"
};


/***************************** MENUS *************************************/


/* keyboard config menus */

char *cm1txt0[]={
"     SELECT CONTROL TYPE",
"     STEUERUNGSART WHLEN",
"SELECTIONNER LE TYPE DE CONTROLE"
};
char *cm1txt1[]={
"KEYBOARD - STANDARD",
"TASTATUR - STANDARD",
"CLAVIER - STANDARD"
};
char *cm1txt2[]={
"KEYBOARD - DUAL TRACK",
"TASTATUR - EINZELKETTENSTEUERUNG",
"CLAVIER - DOUBLE PISTE"
};
char *cm1txt3[]={
"JOYSTICK",
"JOYSTICK",
"JOYSTICK"
};
char *cm1txt4[]={
"CUSTOMISE KEYBOARD",
"TASTATURBELEGUNG",
"PERSONNALISER CLAVIER"
};
char *cm1txt5[]={
"QUIT",
"BEENDEN",
"QUITTER"
};

MENU ctrlmenu1={
 5,0,
 cm1txt0,75,40,
 88,60,(char **)cm1txt1,0,SELECTORBOX+SELECTED,
 88,70,cm1txt2,0,SELECTORBOX,
 88,80,cm1txt3,0,SELECTORBOX,
 65,100,cm1txt4,0,0,
 65,110,cm1txt5,0,0
};

char *cm2txt0[]={
"      STANDARD CONTROL",
"     STANDARDSTEUERUNG",
"    LE CONTROLE STANDARD"
};
char *cm2txt1[]={
"ROTATE LEFT",
"NACH LINKS DREHEN",
"TOURNER A GAUCHE"
};
char *cm2txt2[]={
"ROTATE RIGHT",
"NACH RECHTS DREHEN",
"TOURNER A DROITE"};
char *cm2txt3[]={
"FORWARD",
"VORWRTS",
"AVANT"};
char *cm2txt4[]={
"REVERSE",
"RCKWRTS",
"ARRIERE"};
char *cm2txt5[]={
"FIRE WEAPON",
"WAFFE ABFEUERN",
"TIRER"};
char *cm2txt6[]={
"SELECT WEAPON",
"WAFFE WHLEN",
"SELECTIONNER ARME"};
char *cm2txt7[]={
"TACTICAL MAP",
"TAKTISCHE KARTE",
"CARTE TACTIQUE"};
char *cm2txt8[]={
"CHANGE TARGET",
"NEUES ZIEL",
"CHANGER DE CIBLE"};
char *cm2txt9[]={
"DONE",
"FERTIG",
"TERMINE"
};

MENU ctrlmenu2={
 9,0,
 cm2txt0,70,40,
 70,60,cm2txt1,&game_data.normksetup[0],0,
 70,70,cm2txt2,&game_data.normksetup[1],0,
 70,80,cm2txt3,&game_data.normksetup[2],0,
 70,90,cm2txt4,&game_data.normksetup[3],0,
 70,100,cm2txt5,&game_data.normksetup[4],0,
 70,110,cm2txt6,&game_data.normksetup[5],0,
 70,120,cm2txt7,&game_data.normksetup[6],0,
 70,130,cm2txt8,&game_data.normksetup[7],0,
 70,150,cm2txt9,0,0
};

char *cm3txt0[]={
"      DUAL TRACK CONTROL",
"    EINZELKETTENSTEUERUNG",
" CONTROLE DES DEUX CHENILLES"};
char *cm3txt1[]={
"LEFT TRACK FORWARD",
"LINKE KETTE VORWRTS",
"CHENILLE GAUCHE VERS L'AVANT"};
char *cm3txt2[]={
"LEFT TRACK REVERSE",
"LINKE KETTE VORWRTS",
"CHENILLE GAUCHE VERS L'ARRIERE"};
char *cm3txt3[]={
"RIGHT TRACK FORWARD",
"RECHTE KETTE VORWRTS",
"CHENILLE DROITE VERS L'AVANT"};
char *cm3txt4[]={
"RIGHT TRACK REVERSE",
"RECHTE KETTE RCKWRTS",
"CHENILLE DROITE VERS L'ARRIERE"};
char *cm3txt5[]={
"FIRE WEAPON",
"WAFFE ABFEUERN",
"TIRER"};
char *cm3txt6[]={
"SELECT WEAPON",
"WAFFE WHLEN",
"SELECTIONNER ARME"};
char *cm3txt7[]={
"TACTICAL MAP",
"TAKTISCHE KARTE",
"CARTE TACTIQUE"};
char *cm3txt8[]={
"CHANGE TARGET",
"NEUES ZIEL",
"CHANGER DE CIBLE"};
char *cm3txt9[]={
"DONE",
"FERTIG",
"TERMINE"};

MENU ctrlmenu3={
 9,0,
 cm3txt0,70,40,
 70,60,cm3txt1	,&game_data.dualksetup[0],0,
 70,70,cm3txt2	,&game_data.dualksetup[1],0,
 70,80,cm3txt3	,&game_data.dualksetup[2],0,
 70,90,cm3txt4	,&game_data.dualksetup[3],0,
 70,100,cm3txt5	,&game_data.dualksetup[4],0,
 70,110,cm3txt6	,&game_data.dualksetup[5],0,
 70,120,cm3txt7	,&game_data.dualksetup[6],0,
 70,130,cm3txt8	,&game_data.dualksetup[7],0,
 70,150,cm3txt9  ,0,0
};


/* sound set up menu */

char *stertxt0[]={
"   CONFIGURE SOUND",
" SOUNDKONFIGURATION",
" CONFIGURER LE SON"};
char *stertxt1[]={
"SOUND EFFECTS VOLUME",
"LAUTSTRKE DER SOUNDEFFEKTE",
"VOLUME DES EFFETS SONORES"};
char *stertxt2[]={
"MUSIC VOLUME",
"LAUTSTRKE DER MUSIK",
"VOLUME DE LA MUSIQUE"};
char *stertxt3[]={
"SUBTITLES",
"UNTERTITEL",
"SOUS-TITRES"};
char *stertxt4[]={
"NEXT MISSION MUSIC",
"MUSIK FR NCHSTEN EINSATZ",
"MUSIQUE DE LA MISSION SUIVANTE"};
char *stertxt5[]={
"QUIT",
"BEENDEN",
"QUITTER"};


MENU stermenu={
 5,0,
 stertxt0,100,52,
 42,76,	stertxt1,0,0,
 42,88,	stertxt2,0,0,
 42,100,	stertxt3,0,0,
 42,112,	stertxt4,0,0,
 42,130,	stertxt5,0,0
};

MENU *lockmen_p;		  								/* locker game empty/full menu */
MENU *ctrlmen_p; 										/* standard/dual menu */
MENU netmenu;	 										/* dave muir's */


/* load / save game menus */

char *locktxt0[]={
"LOAD GAME",
"SPIEL LADEN",
"CHARGER LE JEU"};
char *locktxt1[]={
"SAVE GAME",
"SPIEL SICHERN",
"SAUVEGARDER LE JEU"};
char *locktxt2[]={
"QUIT",
"BEENDEN",
"QUITTER"};

MENU lockmenu={
 3,0,
 NULL,0,0,
 80,120,locktxt0,0,0,
 80,130,locktxt1,0,0,
 80,140,locktxt2,0,0
};

char *locketxt0[]={
"SAVE GAME",
"SPIEL SICHERN",
"SAUVEGARDER LE JEU"};
char *locketxt1[]={
"QUIT",
"BEENDEN",
"QUITTER"};

MENU lockemptymenu={
 2,0,
 NULL,0,0,
 80,130,locketxt0,0,0,
 80,140,locketxt1,0,0
};


char *upgstateng[]={"ARMOUR","ARMOUR","SAMS","MNS","RELOADING","TARGETING", "ENGINE","TRACKS","NIGHT SIGHTS","NIGHT SIGHTS","AIR SUPPORT","C-GUN COOLANT"};
char *upgstatger[]={"PANZERUNG","PANZERUNG","SAMS","M.N.S.","NACHLADEN","ZIELEN", "MOTOR","KETTEN","NACHTVISIER","NACHTVISIER","LUFTUNTERSTTZUNG","MG-KHLSYSTEM"};
char *upgstatfrn[]={"BLINDAGE","BLINDAGE","MISSILES SOL-AIR","MNS","RECHARGEMENT","VISER",
"MOTEUR","CHENILLES","VUES NOCTURNES","VUES NOCTURNES","SOUTIEN AERIEN","SYSTEME CALOPORTEUR POUR MITRAILLEUSE"};
char **upgstattxts[]={upgstateng,upgstatger,upgstatfrn};

char *stinfoeng[]={"CASHFLOW:","HIT ACCURACY:","SCORE:","BODY COUNT:","DATELINE:"};
char *stinfoger[]={"BARGELD:","TREFFERGENAUIGKEIT:","PUNKTE:","VERLUSTE DES GEGNERS:","EINSATZDATEN:"};
char *stinfofrn[]={"RENTREES D'ARGENT:","PRECISION DU TIR:","SCORE:","VICTIMES:","DATE:"};
char **stinfotxt[]={stinfoeng,stinfoger,stinfofrn};

char *loadsaveeng[]={" LOAD\\SAVE GAME","MISSION:","CASHFLOW:","HIT ACCURACY:",
"SCORE:","BODY COUNT:","ARMOUR","EMPTY"};
char *loadsaveger[]={" SPIEL LADEN\\SICHERN","EINSATZ:","BARGELD:","TREFFERGENAUIGKEIT:",
		"PUNKTE:","VERLUSTE DES GEGNERS:","PANZERUNG","LEER"};
char *loadsavefrn[]={" LOAD\\SAVE LE GAME","MISSION:","CASHFLOW:","HIT ACCURACY:",
		"SCORE:","BODY COUNT:","ARMOUR","EMPTY"};

char **loadsavetxt[]={loadsaveeng,loadsaveger,loadsavefrn};

/* pen option texts */
char *mainengtxt[]={"GO TO TANK","GO TO BASKETBALL COURT","ENTER WORKSHOP AREA","ENTER BRIEFING AREA","LEAVE THE PEN",NULL};
char *maingertxt[]={"ZUM PANZER GEHEN","ZUM BASKETBALL-COURT GEHEN","IN DIE WERKSTATT GEHEN","IN DEN BESPRECHUNGSRAUM GEHEN","DEN KNAST VERLASSEN",NULL};
char *mainfrntxt[]={"ALLER AU CHAR","ACCEDER AU TERRAIN DE BASKET","ACCEDER A L'ATELIER","ACCEDER A LA SALLE DE BRIEFING","QUITTER LE MITARD",NULL};

#ifdef PC_VERSION

char *tnkengtxt[]={"TALK TO D-TOUR","CLIMB ABOARD TANK","GO BACK TO ENTRANCE",NULL};
char *tnkgertxt[]={"MIT D-TOUR SPRECHEN","IN DEN PANZER STEIGEN","ZURCK ZUM EINGANG",NULL};
char *tnkfrntxt[]={"PARLER A D-TOUR","GRIMPER A BORD DU CHAR","RETOURNER A L'ENTREE",NULL};


#else

char *tnkengtxt[]={"TALK TO D-TOUR","GO BACK TO ENTRANCE",NULL};
char *tnkgertxt[]={"MIT D-TOUR SPRECHEN","ZURCK ZUM EINGANG",NULL};
char *tnkfrntxt[]={"PARLER A D-TOUR","RETOURNER A L'ENTREE",NULL};

#endif

char *bbengtxts[]={"ENTER SIMULATION ROOM","GO TO STEREO SYSTEM","RETURN TO ENTRANCE","TALK TO 9-1-1",NULL};
char *bbgertxts[]={"ZUM SIMULATIONSRAUM","STEREO-SYSTEM AUFRUFEN","ZURCK ZUM EINGANG","MIT 9-1-1 SPRECHEN",NULL};
char *bbfrntxts[]={"ENTRER DANS LA CHAMBRE DE SIMULATION","ACCEDER AU SYSTEME STEREO","RETOURNER A L' ENTREE","PARLER A 9-1-1",NULL};

#ifdef PC_VERSION

char *simengtxts[]={"START NETWORK GAME","TALK TO EARSHOT","LEAVE SIMULATOR",""};
char *simgertxts[]={"NETZWERKSPIEL STARTEN","MIT EARSHOT SPRECHEN","SIMULATIONSRAUM VERLASSEN",""};
char *simfrntxts[]={"COMMENCER JEU EN RESEAU","PARLER A EARSHOT","QUITTER LE SIMULATEUR",""};

#else

char *simengtxts[]={"TALK TO EARSHOT","LEAVE SIMULATOR",""};
char *simgertxts[]={"MIT EARSHOT SPRECHEN","SIMULATIONSRAUM VERLASSEN",""};
char *simfrntxts[]={"PARLER A EARSHOT","QUITTER LE SIMULATEUR",""};

#endif

char *tlkengtxts[]={"GO BACK TO ENTRANCE",""};
char *tlkgertxts[]={"ZURCK ZUM EINGANG",""};
char *tlkfrntxts[]={"RETOURNER A L'ENTREE",""};

char *wrkengtxts[]={"CHECK STATUS","TALK TO PROPS","RETURN TO ENTRANCE",""};
char *wrkgertxts[]={"ZUSTAND PRFEN","MIT PROPS SPRECHEN","ZURCK ZUM EINGANG",""};
char *wrkfrntxts[]={"VERIFIER STATUT","PARLER A PROPS","RETOURNER A L'ENTREE",""};


#ifdef PC_VERSION

char *lockengtxts[]={
"OPEN LOCKER 1","OPEN LOCKER 2","OPEN LOCKER 3","OPEN LOCKER 4", "ENTER BRIEFING ROOM","TALK TO DOGG-TAG","RETURN TO MAIN HANGAR",""};
char *lockgertxts[]={
"SCHLIESSFACH 1 FFNEN","SCHLIESSFACH 2 FFNEN","SCHLIESSFACH 3 FFNEN","SCHLIESSFACH 4 FFNEN", "IN DEN BESPRECHUNGSRAUM GEHEN","MIT DOGG-TAG SPRECHEN","ZURCK ZUM HAUPTHANGAR",""};
char *lockfrntxts[]={
	"OUVRIR VESTIAIRE 1","OUVRIR VESTIAIRE 2","OUVRIR VESTIAIRE 3","OUVRIR VESTIAIRE 4",
	"ACCEDER A LA SALLE DE BRIEFING","PARLER A DOGG-TAG","RETOURNER AU HANGAR PRINCIPAL",""};

#else

char *lockengtxts[]={
"ENTER BRIEFING ROOM","TALK TO DOGG-TAG","RETURN TO MAIN HANGAR",""};
char *lockgertxts[]={
"IN DEN BESPRECHUNGSRAUM GEHEN","MIT DOGG-TAG SPRECHEN","ZURCK ZUM HAUPTHANGAR",""};
char *lockfrntxts[]={
"ACCEDER A LA SALLE DE BRIEFING","PARLER A DOGG-TAG","RETOURNER AU HANGAR PRINCIPAL",""};

#endif


char *mstatengtxts[]={"GO TO HANGAR",""};
char *mstatgertxts[]={"ZUM HANGAR GEHEN",""};
char *mstatfrntxts[]={"RETOURNER AU HANGAR",""};

char **maintxts[]={mainengtxt,maingertxt,mainfrntxt};
char **tanktxts[]={tnkengtxt,tnkgertxt,tnkfrntxt};
char **bballtxts[]={bbengtxts,bbgertxts,bbfrntxts};
char **simtxts[]={simengtxts,simgertxts,simfrntxts};
char **tlktxts[]={tlkengtxts,tlkgertxts,tlkfrntxts};
char **locktxts[]={lockengtxts,lockgertxts,lockfrntxts}; char **wrktxts[]={wrkengtxts,wrkgertxts,wrkfrntxts};
char **mstattxts[]={mstatengtxts,mstatgertxts,mstatfrntxts};

/* mission status texts */

char *missstateng[]={
"         MISSION DEBRIEFING ", "STRUCTURES DESTROYED:",
"AIR TARGETS DESTROYED:",
"GROUND TARGETS DESTROYED:",
"TRUCKS SURVIVED:",
"HOSTAGES RESCUED:",
"OBJECTIVES DESTROYED:",
"HIT ACCURACY:",
"SUPPLY CRATES COLLECTED:",
"SCORE:",
"CASHFLOW:"
};
char *missstatger[]={
"      EINSATZBEURTEILUNG ", "ZERSTRTE EINRICHTUNGEN:",
"ZERSTRTE LUFTZIELE:",
"ZERSTRTE BODENZIELE:",
"GERETTETE LASTWAGEN:",
"BEFREITE GEISELN:",
"ERFLLTE EINSATZZIELE:",
"TREFFERGENAUIGKEIT:",
"SICHERGESTELLTE NACHSCHUBKISTEN:",
"PUNKTE:",
"BARGELD:"
};

char *missstatfrn[]={
"      COMPTE-RENDU DE MISSION",
"STRUCTURES DETRUITES:",
"CIBLES AERIENNES DETRUITES:",
"CIBLES TERRESTRES DETRUITES:",
"CAMIONS RESTANTS:",
"OTAGES SAUVES:",
"OBJECTIFS DETRUITS:",
"PRECISION DU TIR:",
"CAISSES DE MUNITIONS RAMASSEES:",
"SCORE:",
"RENTREES D'ARGENT:"
};

char **missstattxt[]={missstateng,missstatger,missstatfrn};
char *upgrdseng[]={
"ARMOUR REPAIR","EXTRA ARMOUR","SAM","M.N.S.","RELOAD MECHANISM", "TARGETTING COMPUTER","ENGINE UPGRADE","TRACKS UPGRADE","IMAGE INTENSIFIER", "AIR SUPPORT","CHAIN GUN COOLANT"};
char *upgrdsger[]={
"REPARATUR DER PANZERUNG","EXTRAPANZERUNG","SAM","M.N.S.","LADEMECHANISMUS", "ZIELSUCH-COMPUTER","AUFWERTUNG DES MOTORS","AUFWERTUNG DER KETTEN","LICHTVERSTRKUNGSSYSTEM", "LUFTUNTERSTTZUNG","MG-KHLSYSTEM"};
char *upgrdsfrn[]={
"REPARATION DU BLINDAGE","BLINDAGE SUPPLEMENTAIRE","MISSILE AIR-SOL","M.N.S.","MECANISME DE RECHARGEMENT",
"ORDINATEUR DETECTEUR DE CIBLE","AMELIORATION DU MOTEUR","AMELIORATIONS DES CHENILLES","INTENSIFICATEUR D'IMAGE",
"SOUTIEN AERIEN","SYSTEME CALOPORTEUR POUR MITRAILLEUSE"};
char **upgrds[]={upgrdseng,upgrdsger,upgrdsfrn};
char *tracktxt[]={"TRACK","KETTE","TRACK"};
char *coststxt[]={"COSTS","KOSTEN","COSTS"};


/************************************************************************/

char *datelines[]={
	"",
	"7.1.97",
	"7.6.97",
	"7.9.97",
	"8.16.97",
	"8.19.97",
	"8.24.97",
	"8.27.97",
	"9.4.97",
	"9.8.97",
	"9.11.97",
	"9.18.97",
	"9.22.97",
	"9.25.97",
	"9.28.97",
	"10.5.97",
	"10.8.97",
	"10.13.97",
	"10.15.97",
	"10.18.97",
	"11.1.97",
	"11.4.97",
	"11.6.97",
	"11.14.97",
	"11.17.97",
	"11.20.97"
};

#define HIGHLIGHTED	1

enum {START_ANIM,FIDDLE_ANIM,PICKUP_ANIM,PUTDOWN_ANIM,FIDDLE2_ANIM,LOOKAWAY_ANIM};
enum {BB_START_ANIM,BB_LOOKUPR_ANIM,BB_HEAD_DR_ANIM,BB_LOOKUPL_ANIM,BB_HEAD_DL_ANIM,
		BB_LOOKUP1_ANIM,BB_LOOKUP2_ANIM,BB_LOOKR_ANIM,BB_LOOKL_ANIM,BB_SCRATCH_ANIM,
		BB_PUTDOWN_ANIM};
enum {SIM_F1,SIM_OTHER_ACT,SIM_LOOK_R,SIM_HES,SIM_LOOK_L,SIM_LOOK_U,SIM_LOOK_AR};
enum {ST_START,ST_WRITE,ST_LOOKUP,ST_HEADU,ST_HEADD,ST_LOOKR,ST_HEADDR,
      ST_HEADL,ST_LOOKL,ST_LOOKAR};
enum{STR_STANDSTILL,STR_LOOKR,STR_LOOKL,STR_CLIPBOARD,STR_TALK};
enum{STAT_START,STAT_LOOKR,STAT_LOOKL,STAT_LOOK_YOU,STAT_LOWER_CBRD,
	  STAT_CBRD,STAT_CBRD_LOOKR,STAT_CBRD_LOOKL,STAT_CBRD_RAISE};

char language=GERMAN;
char text[1024];				  						/* script line buffer */
PIC ps;
char *scrptr;
char *mainsprs;
char *exsprs;									  		/* exit symbol sprites */
char gpath[]="graph\\";						  		/* file paths */
char spath[]="sound\\";
char *tpaths[]={"english\\","german\\","french\\","japanese\\"};
struct img backim,backim2;
char backpal[256*3];									/* background pal */
char transpal[256*3];						 		/* transparency */
char fadepal[256*3];							  		/* all 0's except top 8 cols */
char fn[50];
char sfn[50];											/* script file name */
char strs[16][80];										/* string split into these */
int slens[16];										  	/* lengths */
uword nstrs;											/* # split strings */
uword maxsubw=52;										/* max #chars in subtitle */
char *con1sprs,*con2sprs,*con3sprs,*con4sprs;
char upp8cols[8*3]={									/* reserved top 9 cols */
	0x3f,0,0, 0,0x0e,0, 00,0x2b,00, 0x2b,0x27,00, 0x3f,0x3f,0,
 	0x24,0x24,0x24, 0,0,0, 0x3f,0x3f,0x3f};

/* next animation options */

char start_next[]={PICKUP_ANIM,FIDDLE_ANIM};
char fidd_next[]={START_ANIM,FIDDLE_ANIM};
char pick_next[]={FIDDLE2_ANIM,LOOKAWAY_ANIM,PUTDOWN_ANIM};
char pick_frames[]={9,8,7,6,6,6,6,5,4};
char look_next[]={FIDDLE2_ANIM,PUTDOWN_ANIM};
char fidd2_next[]={FIDDLE2_ANIM,PUTDOWN_ANIM,LOOKAWAY_ANIM};
char st_startn[]={ST_WRITE,ST_LOOKUP,ST_LOOKL};

char bb_startn[]={BB_LOOKUPR_ANIM,BB_LOOKUPL_ANIM,
						BB_LOOKUPR_ANIM,BB_LOOKUPL_ANIM,
						BB_LOOKUPR_ANIM,BB_LOOKUPL_ANIM,BB_SCRATCH_ANIM};
char bb_lookn[]={BB_LOOKUP1_ANIM,BB_HEAD_DR_ANIM};
char bb_lookupln[]={BB_LOOKUP2_ANIM,BB_HEAD_DL_ANIM};
char bb_lookup1n[]={BB_LOOKR_ANIM,BB_LOOKL_ANIM};
char bb_lookuprn[]={BB_LOOKUP1_ANIM,BB_HEAD_DR_ANIM};
char simnextf[9][3]={2,9,0, 3,1,0, 4,2,0, 5,3,0, 6,4,0, 7,5,0,
							8,6,10, 9,7,0, 1,8,0};
struct img cursim;			 						/* cursor */
short cursposx[]={24,141,208,288};			  	/* ? */
short cursposy[]={77,109,70,98};
short mainsel;											/* area in pen to go to */
short exitflg;											/* exit selected */
uword draworder;				  						/* conversation - which one to draw first */
short frame,animfr,animfr1,animfc;				/* for animation */
uword backloaded=FALSE;
int selitem;
uword selectrel;
uword cancelrel;

/* current font data */

char *gfont,gcol;
short	fontw,fonth;
struct font font1,font2;


/* upgrade costs */

char *costs[]={
	"cost: $2,000","cost: $7,500","cost: $4,000","cost: $7,500","cost: $7,500",
   "cost: $5,000","cost: $5,000","cost: $5,000","cost: $10,000","cost: $20,000",
   "cost: $4,000"};
ulong item_costs[]={2000,7500,4000,7500,7500,5000,5000,5000,10000,20000,4000};


char *mtracktxts[]={
	"TRACK 1","TRACK 2","TRACK 3","TRACK 4","TRACK 5",
	"TRACK 6","TRACK 7","TRACK 8"};

short ecols;
char *tanksprs;
int  sprx,spry,sprw,sprh,sw,sh;
char *backg;
int anim;
char *animd;
int animhold;
int relflg;
int upgr,mfrct;
int stance,movem;


RECT mainareas[]={
	0,58,109,148,
	146,77,193,117,
	208,49,245,129,
	287,83,314,145,
	278,160,314,194};

#ifdef PC_VERSION

RECT tankareas[]={
	57,103,113,170,
	0,41,219,157,
	278,160,314,194};

#else

RECT tankareas[]={
	57,103,113,170,
	278,160,314,194};

#endif

RECT *opareas;
RECT bballareas[]={
	12,81,56,149,
	220,95,285,128,
	278,160,314,194,
	103,108,151,199
};
RECT exitarea[]={
	278,160,314,194};

#ifdef PC_VERSION

RECT simareas[]={
	0,100,43,146,
	44,92,92,145,
	278,160,314,194};

#else

RECT simareas[]={
	44,92,92,145,
	278,160,314,194};

#endif

RECT wrkareas[]={
	7,89,123,151,
	241,83,284,177,
	278,160,314,194};
RECT storareas[]={
   7,161,7+24,161+24,
	249,161,249+24,161+24,
   0,106,180,199,
	278,160,314,194};

#ifdef PC_VERSION

RECT lockareas[]={
	0,61,55,199,
	56,73,93,199,
	94,79,119,179,
	162,85,187,154,
	193,80,246,150,
	255,99,306,141,
	278,160,314,194};

#else

RECT lockareas[]={
	193,80,246,150,
	255,99,306,141,
	278,160,314,194};

#endif

void (*ctrl_func_p)();
void (*disp_func_p)();
int noptions;
char **optxts;			  							/* pen area texts */
char *tank1txts[]={"",""};
char *confns[4]={"con1.spr","con3.spr","con4.spr","con2.spr"};
char *consprs[4];
short ctrlys[7]={80,90,110};
short keyys[]={80,90,100,110,120,130,140,150,170};
short actys[]={80,90,100,120};
short confrms[3];
short confrdel[3];
 short conanimct[3];
short confrmct[3]={4,7,2};
short radfr,raddel;
F_POINT conpos[3]={56,132, 265,25, 234,137};
F_POINT consizes[3]={45,28, 55,81, 31,45};

int  ctrl,ctrlsel,buttsel;

char *asckeyconv[]={
	"ESC","1","2","3","4","5","6","7","8","9",
	"0","-" , "+", "BSPC", "TAB" , "Q" , "W" , "E" , "R" , "T" ,
	 "Y" , "U" , "I","O" , "P" , "[" , "]" , "RET", "CTRL", "A",
	"S", "D", "F" , "G" ,"H" , "J" , "K" , "L" , ":" , "'" ,
	"#" ,"LSHFT" , "" ,"Z" , "X" , "C" , "V" , "B" , "N" , "M" ,
	"," , "." , "/" , "RSFT" ,"PRT", "ALT" , "SPC ", "CAPS" , "F1" ,"F2" ,
	"F3" , "F4" , "F5" , "F6" ,"F7","F8","F9","F10","NLCK","SLCK",
	"HOME","UP","PGUP","PAD-","LFT","PAD5","RGT","PAD+","END","DWN",
	"PDWN","INS","DEL","SREQ","","","F11","F12"};
short keysel,tscreen;
char key,ctrlval;
struct gadget *sgadget;
short sgadgetno;
char *dtoursprs;
char *bbalsprs;
char bbdone;
char *simsprs;
char *ninesprs;
char *wksprs;
char *propsprs,*upgsprs;
struct img larrim;
struct img rarrim;
struct img earim;
char *earsprs;
struct img doggim;
char *doggsprs;
char *tssprs;
char *brief1sprs,*brief2sprs;
char *mempool_p,*mempoolend_p;
int memused,memres;
int gapthresh=20;

char *locksprs[5];
char *lockfns[5]={"lock1.spr","lock2.spr","lock3.spr","lock4.spr","lock5.spr"};
short locksprx[]={33,83,108,166};
short lockspry[]={62,75,81,88};
short locksprw[]={68,45,33,20};
short locksprh[]={139,104,85,57};
short locker,lockanim,lockfr,lockflg;
short lockx,locky,lockw,lockh,lockdisp;
int mysgn,msy,curmov,dstmx,dstmy,mdx,mdy,mbx,mby,mstep;
uword linelen,linepos,arglen;
char linebuff[1024];
char *scriptmem;	  								/* script file mem */
char argbuff[128];				  				/* script command argument buffer */
int scoff;							  				/* script file position */
short *tlkfr_p,*lstfr_p;						/* talk/listening frames */
char charface[10];
char charaway[10];
uword basefr,tlkfrm1,lstanim,tlkanim;
short exanim,exfr;								/* for animating exit sprite */
int facsprx,facspry,facsprw,facsprh; 		/* character facing\away sprite dimensions */
int awsprx,awspry,awsprw,awsprh;
int manpic,briefdisp,backpic,mappic2,mappic1,facepic,awypic;
int doggpic;
char char_widths[256];


/* briefing script files */

char *BRIEFING_fns[]={
	"",
	"eng_br01.txt",
	"eng_br02.txt",
	"eng_br03.txt",
	"eng_br04.txt",
	"eng_br05.txt",
	"eng_br06.txt",
	"eng_br07.txt",
	"eng_br08.txt",
	"eng_br09.txt",
	"eng_br10.txt",
	"eng_br11.txt",
	"eng_br12.txt",
	"eng_br13.txt",
	"eng_br14.txt",
	"eng_br15.txt",
	"eng_br16.txt",
	"eng_br17.txt",
	"eng_br18.txt",
	"eng_br19.txt",
	"eng_br20.txt",
	"eng_br21.txt",
	"eng_br22.txt",
	"eng_br23.txt",
	"eng_br24.txt",
	"eng_br25.txt"
};

/* the man background pics */

char *MANPIC_fns[]={
	"",
	"brtv0002.lbm",
	"brtv0003.lbm",
	"brtv0004.lbm",
	"brtv0005.lbm",
	"brtv0006.lbm",
	"brtv0007.lbm",
	"brtv0008.lbm",
	"brtv0009.lbm"};

/* map pics */

char *MAPPIC_fns[]={
	"",
 	"brtv0010.lbm",
	"brtv0011.lbm",
	"brtv0012.lbm",
	"brtv0013.lbm",
	"brtv0014.lbm",
	"brtv0015.lbm",
	"brtv0016.lbm",
	"brtv0017.lbm",
	"brtv0018.lbm",
	"brtv0019.lbm",
	"brtv0020.lbm"};


/* dogg background and sprites */

char *DOGG1C_fns[]={
	"",
  	"dogg1c.spr",
   "dogg2c.spr",
	"dogg3c.spr",
	"dogg4c.spr",
	"dogg5c.spr",
	"dogg6c.spr"
};
char *DOGGCBACK_fns[]={
	"",
	"bd1c0001.lbm",
	"bd2c0001.lbm",
	"bd3c0001.lbm",
	"bd4c0001.lbm",
	"bd5c0001.lbm",
	"bd6c0001.lbm"
};
char *DOGG1M_fns[]={
	"",
  	"dogg1m.spr",
   "dogg2m.spr",
	"dogg3m.spr",
	"dogg4m.spr",
	"dogg5m.spr",
	"dogg6m.spr"
};
char *DOGGMBACK_fns[]={
	"",
	"bd1m0001.lbm",
	"bd2m0001.lbm",
	"bd3m0001.lbm",
	"bd4m0001.lbm",
	"bd5m0001.lbm",
	"bd6m0001.lbm"
};

/* x,y pos's of sprites
   (weren't included in sprite files as they should have been) */

short DOGGC_pos[]={
	0,0,
	91,35,89,28,108,51,125,44,109,52,107,56};
short DOGGM_pos[]={
	0,0,
	138,80,134,75,138,82,145,77,139,82,134,82};



/* character pics and  sprites */


char *BACK_fns[]={
	"",
	"brr10001.lbm",
	"brl10001.lbm",
	"brl20001.lbm",
	"brl30001.lbm",
   "brr20001.lbm",
   "brr30001.lbm"
};

char *CHARFACE_fns[]={
	"",
	"brr1_f.spr",
	"brl1_f.spr",
	"brl2_f.spr",
	"brl3_f.spr",
	"brr2_f.spr",
   "brr3_f.spr"
};

char *CHARAWAY_fns[]={
	"",
	"brr1_a.spr",
	"brl1_a.spr",
	"brl2_a.spr",
	"brl3_a.spr",
   "brr2_a.spr",
   "brr3_a.spr"
 };

short CHARFACE_pos[]={
	0,0,
   99,0,122,52,122,0,101,46,102,47,99,0};
short CHARAWAY_pos[]={
	0,0,
   202,18,20,56,15,56,15,57,202,18,202,32};


#include "iff.c"
#include "pc.c"


/************************************************************************/
/** Prototypes **/

void 	next_mission(void);
void 	reset_game(void);
void	mission_stats_screen(void);

/************************************************************************/

/*************************
 * game  entry point 	 *
 *************************/

void dave_main()

{

 init_cdsys();
 reset_game();
 load_games();
 if(!(soundcard=SoundIsDIGIEnabled()))
	game_data.subtitl=1;
/* fmv(CORE_SEQUENCE);
 fmv(INTRO_SEQUENCE);
 fmv(INTRO_SEQUENCE1);
 scrptr=game_setup.scrn_ptr;
 */

 InitMemAlloc();
 title_seq();
 load_resident_stuff();
 select_character_scripts();
 main_hangar();
 getout("");
}
/************************************************************************/
/***********************                               ******************/
/*********************** Character script file loaders ******************/
/***********************                               ******************/
/************************************************************************/

/* load the appropriate speech script file for mission */

void select_character_scripts()
{
 select_dtour_script();
 select_dogg_script();
 select_earshot_script();
 select_911_script();
}

void select_dtour_script()
{
 switch(game_data.mission)
	{
	 case 1:
   	dtscript=1;
		return;
	 case 12:
   	dtscript=2;
		return;
	 case 24:
   	dtscript=3;
		return;
 	 case 25:
   	dtscript=4;
		return;
	}
  if((game_data.armint/8)<=1)
   	dtscript=5;
  else if((game_data.armint/8)<=2)
  		dtscript=6;
  else if((game_data.armint/8)>2 && game_data.armlev==3)
		dtscript=7;
  else if((game_data.armint/8)>5 && game_data.armlev==6)
		 dtscript=8;
  else if(game_data.nextmiss==0 && !game_data.imageint)
		 dtscript=9;
  else if(!game_data.nsams)
		 dtscript=10;
  else if(game_data.hitacc < 50)
 		{
	 	 if(game_data.relupg<4)
		 	dtscript=11;
	 	 else if(game_data.relupg==4 && game_data.tarupg<4)
		 	dtscript=12;
	 	 else if(game_data.relupg==4 && game_data.tarupg==4)
		 	dtscript=13;
		}
  else
	  {
	   if(game_data.engupg<4)
			dtscript=14;
		else if(game_data.engupg==4 && game_data.trkupg<4)
		 	dtscript=15;
  	 	else if(game_data.engupg==4 && game_data.trkupg==4)
			dtscript=16;
      else
			dtscript=17;
	  }
}

void select_dogg_script()
{int n;

 if(game_data.mission==1)
	dogscript=1;
 else if(game_data.mission==11)
	dogscript=2;
 else if(game_data.mission==25)
	dogscript=3;
 else
	{
	 n=( ((game_data.mission*10)/(25*3))+(game_data.hitacc/30)+(( (game_data.armint/8)*4)/(game_data.armlev) ));
    if(n<=1)
		dogscript=4;
	 else
		dogscript=5;
	}
}

void select_earshot_script()
{
 if(game_data.mission==1)
	earscript=1;
 else if(game_data.mission==24)
	earscript=2;
 else if(game_data.mission==25)
	earscript=3;
 else if(game_data.nextmiss&SEARCHMISS)
	earscript=4;
 else if(game_data.nextmiss&HOSTAGEMISS)
	earscript=5;
 else if(game_data.nextmiss&NIGHTMISS)
	earscript=6;
 else if(game_data.nextmiss&DEFENSIVEMISS)
	earscript=7;
 else
	earscript=8;
}

void select_911_script()
{
 if(game_data.mission==1)
	ninscript=1;
 else if(game_data.mission==23)
	ninscript=2;
 else if(game_data.mission==25)
	ninscript=3;
 else if((game_data.nextmiss&HOSTAGEMISS) && game_data.hitacc<50)
	ninscript=4;
 else if((game_data.nextmiss&HOSTAGEMISS) && game_data.hitacc>=50)
	ninscript=5;
 else if(!game_data.airsupp)
	ninscript=6;
 else if(game_data.airsupp && (game_data.nextmiss&DEFENSIVEMISS))
	ninscript=7;
 else if(game_data.airsupp)
	ninscript=8;
}

void load_prop_scripts()
{int i;

 for(i=0;i<5;i++)
	 prop_scripts[i]=load_script_file(PROP_fns[i]);
}

/***************************************************************************/
/**********************                           **************************/
/********************** D-tour animation routines **************************/
/**********************                           **************************/
/***************************************************************************/

int start_anim()
{

 set_frame(0);
 wait_loop(randomr(50,100));
 return start_next[random(1)];
}

int fiddle_anim()
{
 set_frame(1);
 wait_loop(randomr(50,100));
 set_frame(2);
 wait_loop(randomr(50,100));
 set_frame(1);
 wait_loop(5);
 return fidd_next[random(1)];
}


int pickup_anim()
{
 set_frame(4);
 wait_loop(5);
 set_frame(5);
 wait_loop(5);
 set_frame(6);
 wait_loop(randomr(50,100));
 set_frame(4);
 wait_loop(7);
 set_frame(5);
 wait_loop(8);
 set_frame(9);
 wait_loop(randomr(50,100));
 return pick_next[random(2)];
}
int putdown_anim()
{

 animate(0,9,5);
 return 0;
}
int fiddle2_anim()
{
 set_frame(9);
 wait_loop(randomr(50,100));
 set_frame(10);
 wait_loop(randomr(50,100));
 set_frame(11);
 wait_loop(randomr(50,100));
 set_frame(9);
 wait_loop(randomr(50,100));
 return fidd2_next[random(2)];

}
int lookaway_anim()
{
 set_frame(12);
 wait_loop(5);
 set_frame(13);
 wait_loop(5);
 set_frame(14);
 wait_loop(randomr(50,100));
 set_frame(15);
 wait_loop(5);
 set_frame(12);
 wait_loop(5);
 return look_next[random(1)];
}


/*******************************************************************/
/**************************                *************************/
/************************** TITLE SEQUENCE *************************/
/**************************                *************************/
/*******************************************************************/

void title_seq()

{char *mem,*pal;
 int i;
 struct img im;


 scrptr=(char *)game_setup.scrn_ptr;
 clr_screen();
 dump_screen();
 settop8cols(fadepal);
 setfn("titl.spr");
 mem=load_sprites(fn);
 setfn("titl.pal");
 pal=LoadFile(fn,"rb");
 im.x=54;
 im.y=9;
 im.w=212;
 im.h=178;
 im.data=mem;
 for(i=0;i<25;i++)
	{
	 clr_screen();
    dump_pal(pal,0,256);
	 copy_image(&im);
	 dump_screen();
    im.data+=212*178;
	 wait(5);
	}
 FreeMem();
 for(i=0;i<100;i++)
	{ScreenWaitVbl();
	 read_joypad();
    if(select_status())
		break;
   }
 clr_screen();
 dump_screen();
 disp_func_p=NULL;
}

/*************************************************************************/
/*******************                     *********************************/
/******************* MAIN HANGAR SECTION *********************************/
/*******************                     *********************************/
/*************************************************************************/

//#ifdef PC_VERSION

int quit_to_dos_check()

{
 static char quittxt[]="ARE YOU SURE ? (Y/N)";
 char c;

 set_col(255);
 memcpy(scrptr,backim.data,320*200);
 print_textbar(quittxt,-1,90);
 dispexit();
 disp_cursor();
 dump_vram();

#ifdef PC_VERSION

 for(;;)
	{
	 c=get_key();
	 if(c==K_Y)
		return 1;
 	 if(c==K_N)
		return 0;
	}

#endif
}

//#endif

void main_ctrl()
{
 anim_exit();
 if(select_status())
  {
    switch(mainsel)
  		{
    	 case 0:
			FreeMem();
			SoundFreeSamples();
			tank_exterior();
			init_main();
			break;
		 case 1:
			FreeMem();
			SoundFreeSamples();
			bball_court();
			init_main();
			break;
		 case 2:
			workshop();
			init_main();
			break;
		 case 3:
			FreeMem();
			SoundFreeSamples();
			locker_room();
			init_main();
			break;

//#ifdef PC_VERSION

	 	 case 4:
			if(quit_to_dos_check())
				{start_exanim();
				 return;
				}
			break;
//#endif
		}
  }
}


void init_main()
{


/* load main hangar graphics */

 CDStop();
 FreeMem();
 set_col(253);
 fade_to_pal(FADEOUT_RATE,fadepal);
 setfn("main.spr");
 mainsprs=load_sprites(fn);
 if(game_data.mission==24)
	{
 	 setfn("main0017.lbm");
 	 load_iffimage(fn,&backim,backpal);
	}
 else
	{
 	 setfn("main0001.lbm");
 	 load_iffimage(fn,&backim,backpal);
	}
 settop8cols(backpal);
 CDPlay(2);
 wait_fade();

 ctrl_func_p=main_ctrl;
 disp_func_p=main_display;
 noptions=5;
 sprx=27;
 spry=105;
 sprw=37;
 sprh=43;
 optxts=maintxts[game_data.lang];
 opareas=mainareas;
 animd= mainsprs;
 backg=(char *)backim.data;
 init_vars();
 gen_qtab(0,128,transpal,backpal);
 main_display();
 fade_in(backpal);
}


void main_hangar()

{

 init_main();
 for(;;)
	{

/* animate d-tour (same animation in tank exterior) */

	 switch(anim)
		{
		 case START_ANIM:
			anim=start_anim();
			break;
		 case FIDDLE_ANIM:
			anim=fiddle_anim();
			break;
		 case PICKUP_ANIM:
			anim=pickup_anim();
			break;
		 case PUTDOWN_ANIM:
			anim=putdown_anim();
			break;
		 case FIDDLE2_ANIM:
			anim=fiddle2_anim();
			break;
		 case LOOKAWAY_ANIM:
			anim=lookaway_anim();
			break;
		}

#ifdef PC_VERSION

    if(key==K_ESC)
		{exitflg=FALSE;
		 if(quit_to_dos_check())
			{CDStop();
			 getout("");
			}
		}
    if(exitflg==TRUE)
		break;

#endif
	}


 main_display();
 CDStop();
}

/***********************************************************************/
/**************************                      ***********************/
/************************** Tank exterior screen ***********************/
/**************************                      ***********************/
/***********************************************************************/

void tanksel()
{

 anim_exit();
  {
  if(select_status())
  	switch(mainsel)
 		{
		 case 0:
			FreeMem();
			talk_to_dtour();
			init_tankext();
			break;
#ifdef PC_VERSION
  		 case 1:
			FreeMem();
			tank_interior();
			init_tankext();
			break;
 	 	 case 2:
			start_exanim();
		   return;
#else
 	 	 case 1:
			start_exanim();
		   return;
#endif
		}
  }
}



void init_tankext()

{
/* load tank graphics */

 CDStop();
 fade_to_pal(FADEOUT_RATE,fadepal);
 setfn("tank.spr");
 tanksprs=load_sprites(fn);
 setfn("tank0001.lbm");
 load_iffimage(fn,&backim,backpal);
 settop8cols(backpal);
 wait_fade();
 CDPlay(3);

 sprx=61;
 spry=104;
 sprw=51;
 sprh=68;
 optxts=tanktxts[game_data.lang];
 opareas=tankareas;
#ifdef PC_VERSION
 noptions=3;
#else
 noptions=2;
#endif
 ctrl_func_p=tanksel;
 disp_func_p=main_display;
 animd=tanksprs;
 backg=(char *)backim.data;
 init_vars();
 gen_qtab(0,128,transpal,backpal);
 main_display();
 fade_in(backpal);
 exanim=exfr=0;
}

void tank_exterior()
{

 set_col(253);
 init_tankext();
 fade_in(backpal);
 while(exitflg==FALSE)
	{
	 switch(anim)
		{
		 case START_ANIM:
			anim=start_anim();
			break;
		 case FIDDLE_ANIM:
			anim=fiddle_anim();
			break;
		 case PICKUP_ANIM:
			anim=pickup_anim();
			break;
		 case PUTDOWN_ANIM:
			anim=putdown_anim();
			break;
		 case FIDDLE2_ANIM:
			anim=fiddle2_anim();
			break;
		 case LOOKAWAY_ANIM:
			anim=lookaway_anim();
			break;
		}
	}
 main_display();
 FreeMem();
}


/*************************************************************************/
/**************                             				  ******************/
/**************  TANK INTERIOR SCREEN (PC VERSION only) ******************/
/**************                             				  ******************/
/*************************************************************************/

#ifdef PC_VERSION

void tankint_disp()

{struct img img;
 int i;

 memcpy(scrptr,backim.data,320*200);

  img.x=139;
  img.y=133;
  img.w=65;
  img.h=55;
  img.data=consprs[3]+(radfr*65*55);
  copy_image(&img);
  for(i=0;i<3;i++)
	{
	 img.x=conpos[i].x;
	 img.y=conpos[i].y;
	 img.w=consizes[i].x;
	 img.h=consizes[i].y;
	 img.data=consprs[i]+(confrms[i]*img.w*img.h);
    copy_image(&img);
	}
 disp_3d_transbox(50,30,220,140);

 if(!tscreen)
	print_menu(&ctrlmenu1);
 else if(tscreen==1)
	print_menu(ctrl?&ctrlmenu3:&ctrlmenu2);
 dispexit();
 disp_cursor();
 dump_vram();
}

/* control device selection \ configuration */

void tankintsel()
{
 static int inpmode;
 int sflg;

   ctrlmen_p=ctrl?&ctrlmenu3:&ctrlmenu2; 		/* set menu ptr to standard/dual-track control */
 	anim_exit();							 			/* animate exit sprite */

/* main menu */

	if(!tscreen)
 	  {
		sflg=menu_selector(&ctrlmenu1);			/* menu update */
		if(sflg==4)										/* quit */
			{exitflg=TRUE;return;}
      if(sflg>=0)
			{if(ctrlmenu1.curritem<3)			 	/* configure keyboard */
				 {
  				  ctrlmenu1.items[selitem].flags=1;
 				  ctrlmenu1.items[ctrlmenu1.curritem].flags|=SELECTED;
				  selitem=ctrlmenu1.curritem;
				 }
			 else if(selitem<2)						/* select control type */
				{
				 tscreen=1;								/* display sub-menu */
 				 contract_3d_transbox(50,30,224,140,NULL);
 				 expand_3d_transbox(50,30,220,140,NULL);
				 ctrl=selitem;
				}
			}
     }

/* sub-menu (std or dual) */

	else if(tscreen==1)
		{
		 sflg=menu_selector(ctrlmen_p);
		 if(!inpmode)								 	/* input mode ? */
		 	{
 			 if(sflg>=0)					  		   /* quit */
			 	{if(ctrlmen_p->curritem==8)
 				 	{contract_3d_transbox(50,30,224,140,NULL);
 				 	 expand_3d_transbox(50,30,220,140,NULL);
					 tscreen=0;						   /* back to main menu */
					}
			 	 else
					{inpmode=1;						 	/*  go to input mode */
	 	 		 	 set_keyconfig(ctrlmen_p->curritem,K_WAITINPUT);
					 ctrlmen_p->flags|=LOCKOUTUSER;
					}
				}
			 }
		 else										  		/* key selected */
	 		{if(key)
				{
			 	 if(!(set_keyconfig(ctrlmen_p->curritem,key)) )
				 	{ctrlmen_p->flags&=~LOCKOUTUSER;
	 	 	 	 	 inpmode=0;
					}
				}
			}
		}

 if(select_status())		 							/* check for main menu exit */
		{
		 if(!mainsel && !tscreen)
			start_exanim();
		}
}


void tank_interior()
{int i;

 fade_to_pal(FADEOUT_RATE,fadepal);
 setfn("cpit0008.lbm");
 load_iffimage(fn,&backim,backpal);
 settop8cols(backpal);
 for(i=0;i<4;i++)
	{
	 setfn(confns[i]);
    consprs[i]=load_sprites(fn);
	}
 wait_fade();
 noptions=1;
 opareas=exitarea;
 optxts=tank1txts[game_data.lang];
 ctrl_func_p=tankintsel;
 disp_func_p=tankint_disp;
 exanim=exfr=0;
 init_vars();


 gen_qtab(0,80,transpal,backpal);
 memcpy(scrptr,backim.data,320*200);
 disp_pic();
 fade_in(backpal);
 expand_3d_transbox(50,30,220,140,NULL);


/* tank radar etc animations */

 while(exitflg==FALSE || tscreen)
	{
	 if(--raddel<0)					 				/* radar */
		{raddel=10;
    	 if(--radfr<0)
			radfr=3;
		}
    for(i=0;i<3;i++)				 					/* computers */
		{
		 if(--confrdel[i]<0)	 						/* frame delay */
			{confrdel[i]=random(100);
			 --confrms[i];
			 if(--conanimct[i]<0)
				{confrms[i]=confrmct[i]-1;
				 conanimct[i]=random(confrmct[i]-1);
				}
			}
		}
	 wait_loop(1);
	}
 contract_3d_transbox(50,30,224,140,NULL);
 FreeMem();
}

#endif

/**************************************************************************/
/****************************               *******************************/
/**************************** D-tour screen *******************************/
/****************************               *******************************/
/**************************************************************************/

void dtour_ctrl()
{
 anim_exit();
 if(select_status() && !mainsel)
	start_exanim();
}

void man_disp()
{struct img img;

 memcpy(scrptr,backg,320*200);
 img.x=sprx;
 img.y=spry;
 img.w=sprw;
 img.h=sprh;
 img.data=animd+(frame*sprw*sprh);
 copy_image(&img);
 disp_subs();
 dump_vram();
}


void talk_to_dtour()

{

 CDStop();
 fade_to_pal(FADEOUT_RATE,fadepal);
 setfn("dtor.spr");
 dtoursprs=load_sprites(fn);
 setfn("dtor0001.lbm");
 load_iffimage(fn,&backim,backpal);
 settop8cols(backpal);
 load_script_file(DTOUR_fns[dtscript]);
 wait_fade();

 sprx=9;
 spry=32;
 sprw=143;
 sprh=168;
 animd=dtoursprs;
 backg=backim.data;

 noptions=1;
 init_vars();
 optxts=tlktxts[game_data.lang];
 opareas=exitarea;
 ctrl_func_p=dtour_ctrl;
 disp_func_p=man_disp;
 gen_qtab(0,80,transpal,backpal);
 man_disp();
 fade_in(backpal);
 animate_man();

 man_disp();
 FreeMem();
 SoundFreeSamples();
}

/***********************************************************************/
/***************                                   *********************/
/***************    BASKET BALL COURT SECTION      *********************/
/***************                                   *********************/
/***********************************************************************/


void bball_ctrl()
{int i;

 anim_exit();
 if(select_status())
 	{

	 switch(mainsel)
		{
		 case 0:
			FreeMem();
			sim_room();
			init_bballcourt();
			break;
		 case 3:
			if(game_data.mission==24)
				break;
         if(!anim)								/* make 911 stop and look at you */
			 {
			  for(i=32;i<=36;i++)
				{set_frame(i);
				 main_display();
			    wait(5);
				}
			 }
			FreeMem();
			talk_to_911();
			init_bballcourt();
			break;
		 case 1:
			FreeMem();
			sound_config();
			init_bballcourt();
			break;
		 case 2:
			start_exanim();
		}
	}
}

void init_bballcourt()
{
 CDStop();
 fade_to_pal(FADEOUT_RATE,fadepal);
 setfn("bbal.spr");
 bbalsprs=load_sprites(fn);
 setfn("bbal0038.lbm");
 load_iffimage(fn,&backim,backpal);
 settop8cols(backpal);
 wait_fade();
 CDPlay(3);

 if(game_data.mission==24)
   {noptions=3;
	 animd=NULL;
	}
 else
 	{noptions=4;
 	 animd=bbalsprs;
	}
 ctrl_func_p=bball_ctrl;
 optxts=bballtxts[game_data.lang];
 opareas=bballareas;
 disp_func_p=main_display;
 sprx=103;
 spry=109;
 sprw=66;
 sprh=90;
 backg=(char *)backim.data;
 init_vars();
 gen_qtab(0,80,transpal,backpal);
 main_display();
 fade_in((char *)backpal);
}

void bball_court()
{


 init_bballcourt();
 anim=0;

/* 911 animation */

 while(exitflg==FALSE)
	{
	 switch(anim)
		{
		 case BB_START_ANIM:
			set_frame(0);
			wait_loop(randomr(50,100));
			anim=bb_startn[random(6)];
			break;
		 case BB_LOOKUPR_ANIM:
			set_frame(1);
			wait_loop(5);
			set_frame(2);
			wait_loop(5);
			set_frame(3);
			wait_loop(randomr(50,100));
	      anim=bb_lookuprn[random(1)];
			break;
		 case BB_HEAD_DR_ANIM:
			set_frame(2);
			wait_loop(5);
			set_frame(1);
			wait_loop(5);
			anim=BB_START_ANIM;
			break;
		 case BB_LOOKUPL_ANIM:
			set_frame(8);
			wait_loop(5);
			set_frame(7);
			wait_loop(5);
			set_frame(6);
			wait_loop(randomr(50,100));
			anim=bb_lookupln[random(1)];
			break;
		 case BB_HEAD_DL_ANIM:
			set_frame(7);
			 wait_loop(5);
			set_frame(8);
			wait_loop(5);
			anim=BB_START_ANIM;
			break;
		 case BB_LOOKUP1_ANIM:
			set_frame(4);
			wait_loop(randomr(50,100));
			anim=bb_lookup1n[random(1)];
			break;
		 case BB_LOOKUP2_ANIM:
 			set_frame(5);
			wait_loop(5);
			anim=BB_LOOKUP1_ANIM;
			break;
		 case BB_LOOKR_ANIM:
			set_frame(3);
			wait_loop(100);
			anim=BB_HEAD_DR_ANIM;
			break;
		 case BB_LOOKL_ANIM:
			set_frame(5);
			wait_loop(5);
			set_frame(6);
			wait_loop(randomr(50,100));
			anim=BB_HEAD_DL_ANIM;
			break;
		 case BB_SCRATCH_ANIM:
			animate(9,19,5);
			set_frame(20);
			wait_loop(randomr(50,100));
			animate(21,31,5);
			anim=BB_START_ANIM;
			break;
			break;
		}
	}

 main_display();
 FreeMem();
}

/*************************************************************************/
/*************************              **********************************/
/************************* 9-1-1 screen **********************************/
/*************************              **********************************/
/*************************************************************************/


void nine_ctrl()
{
 anim_exit();
 if(select_status() && !mainsel)
	start_exanim();
}

void talk_to_911()

{

 CDStop();
 fade_to_pal(FADEOUT_RATE,fadepal);
 setfn("nine0001.lbm");
 load_iffimage(fn,&backim,(char *)backpal);
 settop8cols((char *)backpal);
 setfn("nine.spr");
 ninesprs=load_sprites(fn);
 load_script_file(NINE_fns[ninscript]);
 wait_fade();

 sprx=10;
 spry=58;
 sprw=120;
 sprh=141;
 animd=ninesprs;
 backg=backim.data;

 noptions=1;
 init_vars();
 optxts=tlktxts[game_data.lang];
 opareas=exitarea;
 ctrl_func_p=nine_ctrl;
 disp_func_p=man_disp;
 gen_qtab(0,80,transpal,backpal);
 main_display();
 fade_in(backpal);
 man_disp();
 animate_man();

 man_disp();
 FreeMem();
 SoundFreeSamples();
}


/**********************************************************************/
/*************************                     ************************/
/************************* Sound config screen ************************/
/*************************                     ************************/
/**********************************************************************/


void ster_ctrl()
{

 anim_exit();
 if(4==menu_selector(&stermenu))			  			/* quit */
	exitflg=TRUE;
 switch(ctrlval)
	{
 	 case CTRL_LEFT:
		switch(stermenu.curritem)
		 	{
			 case 0:
				if(game_data.soundvol)game_data.soundvol-=3276;break;
			 case 1:
				if(game_data.musicvol)game_data.musicvol-=3276;break;
			 case 2:
				game_data.subtitl^=1;break;
			 case 3:
				if((--game_data.music)==1)
					game_data.music=8;
 				CDPlay(game_data.music);
				break;
			}
		break;
 	 case CTRL_RIGHT:
		switch(stermenu.curritem)
		 	{
			 case 0:
				if(game_data.soundvol<32760)game_data.soundvol+=3276;break;
			 case 1:
				if(game_data.musicvol<32760)game_data.musicvol+=3276;break;
			 case 2:
				game_data.subtitl^=1;break;
			 case 3:
				if((++game_data.music)>8)
					game_data.music=2;
 				CDPlay(game_data.music);
				break;
			}
	}
 if(select_status() && !mainsel)
    start_exanim();
}


void ster_disp()
{

 memcpy(scrptr,backim.data,320*200);
 disp_3d_transbox(30,40,261,123);
 print_menu(&stermenu);
 disp_vslider(200,76,game_data.soundvol/3276);
 disp_vslider(200,88,game_data.musicvol/3276);
 set_col(stermenu.curritem==2?255:253);
 sprint(game_data.subtitl ? "ON":"OFF",230,100);
 set_col(stermenu.curritem==3?255:253);
 sprint(mtracktxts[game_data.music-2],215,112);
 if(!mainsel)
 	print_textbar(optxts[mainsel],-1,188);

#ifdef PC_VERSION

 dispexit();
 disp_cursor();

#endif

 dump_vram();
}

void sound_config()
{
 CDStop();
 fade_to_pal(FADEOUT_RATE,fadepal);
 setfn("ster0001.lbm");
 load_iffimage(fn,&backim,backpal);
 settop8cols(backpal);
 wait_fade();
 CDPlay(game_data.music);

 noptions=1;
 optxts=tlktxts[game_data.lang];
 opareas=exitarea;
 ctrl_func_p=ster_ctrl;
 disp_func_p=ster_disp;
 init_vars();
 gen_qtab(0,80,transpal,backpal);
 memcpy(scrptr,backim.data,320*200);
 disp_pic();
 fade_in(backpal);
 expand_3d_transbox(40,40,241,123,NULL);
 while(exitflg==FALSE)
	wait_loop(1);
 contract_3d_transbox(40,40,240,123,NULL);
 FreeMem();
 SoundSetMasterVolume(game_data.soundvol);
}


/*************************************************************************/
/**************************                    ***************************/
/************************** SIMULATION SECTION ***************************/
/**************************                    ***************************/
/*************************************************************************/

void sim_ctrl()
{
 anim_exit();
 if(select_status())
	{
	 switch(mainsel)
		{
#ifdef PC_VERSION
		 case 1:
			FreeMem();
			talk_to_earshot();
			init_sim();
			break;
		 case 0:
			break;
		 case 2:
	 		start_exanim();
			break;
#else
		 case 0:
			FreeMem();
			talk_to_earshot();
			init_sim();
			break;
		 case 1:
	 		start_exanim();
			break;
#endif

		}
	}
}

void sim_room()
{int anim,fr,i;


 init_sim();
 anim=fr=0;
 while(exitflg==FALSE)
  {

/* animate earshot */

  switch(anim)
	{
    case SIM_OTHER_ACT:
		anim=random(2)+2;
		break;
	 case SIM_LOOK_R:
		animate(9,11,5);
		wait_loop(randomr(50,100));
		animate(12,13,5);
		anim=SIM_F1;
		break;
	 case SIM_HES:
		animate(14,19,5);
		wait_loop(randomr(50,100));
		animate(20,22,5);
		 anim=SIM_F1;
		break;
	 case SIM_LOOK_L:
		animate(23,24,5);
		wait_loop(randomr(50,100));
		animate1(23,5);
		anim=SIM_F1;
		break;
	 case SIM_LOOK_U:
		animate(25,26,5);
		animate1(27,randomr(50,100));
		animate(26,25,5);
		anim=SIM_F1;
		break;
	 case SIM_LOOK_AR:
		animate(28,31,5);
		anim=SIM_F1;
		break;
	 case SIM_F1:
		set_frame(fr);
      wait_loop(random(100));
		i=random(2);
		if(!(fr=simnextf[fr][i]))
			anim=SIM_OTHER_ACT;
		else
 			--fr;
 		break;
	}
 }
  main_display();
  FreeMem();
}


void init_sim()
{
 CDStop();
 fade_to_pal(FADEOUT_RATE,fadepal);
 setfn("simu.spr");
 simsprs=load_sprites(fn);
 setfn("simu0001.lbm");
 load_iffimage(fn,&backim,backpal);
 settop8cols((char *)backpal);
 wait_fade();
 CDPlay(5);

 optxts=simtxts[game_data.lang];
 opareas=simareas;

#ifdef PC_VERSION
 noptions=3;
#else
 noptions=2;
#endif

 ctrl_func_p=sim_ctrl;
 disp_func_p=main_display;
 sprx=42;
 spry=88;
 sprw=53;
 sprh=60;
 backg=backim.data;
 animd=(char *)simsprs;
 init_vars();
 gen_qtab(0,80,transpal,backpal);
 main_display();
 fade_in(backpal);
}

/***************************************************************************/
/****************************                *******************************/
/**************************** Earshot screen *******************************/
/****************************                *******************************/
/***************************************************************************/

void earshot_ctrl()
{
 anim_exit();
 if(select_status() && !mainsel)
	start_exanim();
}

void talk_to_earshot()

{

 CDStop();
 fade_to_pal(FADEOUT_RATE,fadepal);
 setfn("esht.spr");
 earsprs=load_sprites(fn);
 setfn("esht0001.lbm");
 load_iffimage(fn,&earim,backpal);
 settop8cols(backpal);
 load_script_file(EARSHOT_fns[earscript]);

 sprx=158;
 spry=35;
 sprw=128;
 sprh=165;
 animd=earsprs;
 backg=earim.data;

 noptions=1;
 init_vars();
 optxts=tlktxts[game_data.lang];
 opareas=exitarea;
 ctrl_func_p=earshot_ctrl;
 disp_func_p=man_disp;
 gen_qtab(0,80,transpal,backpal);
 man_disp();
 fade_in(backpal);
 animate_man();
 FreeMem();
 SoundFreeSamples();
}

/*************************************************************************/
/**************************                  *****************************/
/************************** WORKSHOP SECTION *****************************/
/**************************                  *****************************/
/*************************************************************************/



void wk_ctrl()
{int i;

 anim_exit();
 if(select_status())
	{
	 switch(mainsel)
		{
 		 case 0:
			status_screen();
			init_workshop();
			break;
		 case 1:
			if(!anim) 								/* make props putdown clipboard */
			  {
				for(i=42;i<=51;i++)
					{set_frame(i);
				 	 main_display();
				 	 wait(5);
					}
			  }
			stores();
			init_workshop();
			break;
		 case 2:
			start_exanim();
			break;
		}
	}
}

void init_workshop()
{
 CDStop();
 fade_to_pal(FADEOUT_RATE,fadepal);
 setfn("stor.spr");
 wksprs=load_sprites(fn);
 setfn("stor0001.lbm");
 load_iffimage(fn,&backim,backpal);
 settop8cols(backpal);
 wait_fade();
 CDPlay(6);

 noptions=3;
 optxts=wrktxts[game_data.lang];
 opareas=wrkareas;
 ctrl_func_p=wk_ctrl;
 disp_func_p=main_display;
 sprx=242;
 spry=83;
 sprw=48;
 sprh=103;
 backg=backim.data;
 animd=wksprs;
 init_vars();
 gen_qtab(0,80,transpal,backpal);
 main_display();
 fade_in(backpal);
}

void workshop()

{

 init_workshop();
 anim=0;
 while(exitflg==FALSE)
  {

/* props animation */

   switch(anim)
	{
    case ST_START:
		animate1(0,randomr(50,100));
		anim=st_startn[random(2)];
		break;
	 case ST_WRITE:
		animate(1,9,5);
		wait_loop(randomr(100,200));
		animate(10,25,5);
		anim=ST_START;
		break;
	 case ST_LOOKUP:
		animate1(26,5);
		animate1(27,5);
	 case ST_HEADU:
		set_frame(28);
		wait_loop(randomr(50,100));
		anim=ST_HEADD+random(1);
		break;
	 case ST_HEADD:
		animate1(27,5);
		animate1(26,5);
		anim=START_ANIM;
		break;
	 case ST_LOOKR:
		animate1(29,5);
		animate1(30,5);
		wait_loop(randomr(50,100));
		anim= random(1) ? ST_HEADL:ST_HEADDR;
		break;
	 case ST_HEADDR:
		animate(32,35,5);
		anim=ST_START;
		break;
    case ST_HEADL:
		animate1(30,5);
		animate1(29,5);
		anim=ST_HEADU;
		break;
	 case ST_LOOKL:
		animate(36,41,5);
		wait_loop(randomr(50,100));
		animate(40,36,5);
		anim=ST_START;
		break;
	}
 }
 main_display();
 FreeMem();
}

/**************************************************************************/
/***************************               ********************************/
/*************************** STORES SCREEN ********************************/
/***************************               ********************************/
/**************************************************************************/


void stores_disp()
{struct img img;
 char s[40];
 int n;

/* prop frame */

 memcpy(scrptr,backim.data,320*200);
 img.x=221;
 img.y=43;
 img.w=99;
 img.h=157;
 img.data=propsprs+(frame*99*157);
 copy_image(&img);

/* item frame */

 if(game_data.mission>1)
 	{img.x=0;
 	 img.y=44;
 	 img.w=182;
 	 img.h=156;
 	 img.data=upgsprs+((upgr)*182*156);
 	 copy_image(&img);

/* display cashflow status */

 	disp_transbox(8,8,180,38);
 	sprint("CASHFLOW: $",20,16);
 	sprintf(s,"%d",game_data.money);
 	sprint(s,84,16);
 	disp_upgstat(upgr,20,28,255);

/* display item bar */

 	disp_transbox(7,161,270,24);
 	copy_image(&rarrim);
 	copy_image(&larrim);
 	n=stringlen(upgrds[game_data.lang][upgr]);
 	sprint(upgrds[game_data.lang][upgr],(142-(n/2)),163);
 	n=stringlen(costs[upgr]);
 	sprint(costs[upgr],(142-(n/2)),173);
  }

 disp_subs();
 dispexit();
 disp_cursor();
 dump_vram();
}


/* atempt to buy an item - returns TRUE if item bought */

int buy_upgrade()
{

 if(game_data.money<item_costs[upgr])			/* not enough money */
	{sampno=1;											/* says this */
	 return FALSE;
	}

 switch(upgr)		  									/* buy it \got it */
	{
	 case 1:
		if(game_data.armlev==6)
			goto gotit;
		game_data.armlev+=1;
		break;
	 case 0:
		if(game_data.armint/8==game_data.armlev)
			goto gotit;
		game_data.armint+=8;
	   break;
	 case 2:
		if(game_data.nsams==4)
			goto gotit;
		game_data.nsams++;
	   break;
	 case 3:
		if(game_data.mns)
			goto gotit;
		game_data.mns=1;
	   break;
   case 4:
		if(game_data.relupg==4)
			goto gotit;
		game_data.relupg++;
	   break;
	 case 6:
		if(game_data.engupg==4)
			goto gotit;
		game_data.engupg++;
	   break;
	 case 7:
		if(game_data.trkupg==4)
			goto gotit;
		game_data.trkupg++;
		break;
	 case 5:
		if(game_data.tarupg==4)
			goto gotit;
		game_data.tarupg++;
	   break;
	 case 8:
		if(game_data.imageint)
			goto gotit;
		game_data.imageint=1;
	   break;
	 case 9:
		if(game_data.airsupp)
			goto gotit;
		game_data.airsupp=1;
	   break;
	 case 10:
		if(game_data.cgunupg==4)
			goto gotit;
		game_data.cgunupg++;
	   break;
	}

 game_data.money-=item_costs[upgr];
 return TRUE;
gotit:
 sampno=4;
 return FALSE;
}

int get_sampleno()
{
 if(game_data.money>=item_costs[upgr])
		 return 2;
 else
		return 1;

}

/* get prop to say something from a script file (already loaded) */


void prop_says(int n)
{

 scriptmem=prop_scripts[n];
 for(;;)
 	{get_line();
 	 n=interpret_command();
 	 switch(n)
		{
		 case SCOM_CHARSAY:
			load_sample();
			SoundPlaySample(0,game_data.soundvol,100,0x8000);
			break;
		 case SCOM_CHARTXT:
			set_subtitle_width(42);	 						/* subtitles */
			get_subtitles();
			break;
		 case SCOM_SAMPGAP:
	  		get_commarg();
	  		gpb=atoi(argbuff);
	  		get_commarg();
	  		gpe=atoi(argbuff);
	  		do{													/* while talking */
	  			get_sample_position();
				if(--animfc==0)
					{animfc=5;
				 	 set_frame(mouth_frms[animfr]+29);	/* get mouth frame */
 	  		 	 	 animfr++;
	  		 	 	 if(animfr==18)
			 		 	animfr=0;
					}
  				wait_loop(1);
				if(exitflg==TRUE)
					 return;
 				if(select_status() && mainsel==3)		/* exit sprite selected */
					{
			 		 sampno=3;
					 return;
					}
			  }while(boff<gpb);
			if(!gpe)
				{nstrs=0;scoff=0;
				 return;
				}
			do{
				get_sample_position();					 	/* wait for end of sample */
			  }while(boff<gpe && boff);
			break;
       case SCOM_BRIEFEND:
			nstrs=0;scoff=0;
			return;
		}
	}
}


void start_buyanim()
{
 if(TRUE==buy_upgrade()) 					/* bought it ? */
	 {prop_says(2);
	  anim=STR_STANDSTILL;
	  gotalk=0;
	 }
 else 									  		/* nope - tough luck */
 	{
 	 anim=STR_CLIPBOARD;						/* raises clipboard then */
    frame=16;									/* tells you to eat shit */
 	 gotalk=1;
 	}
}


void stores_ctrl()
{
}

void stores()
{

 FreeMem();
 CDStop();
 fade_to_pal(FADEOUT_RATE,fadepal);
 setfn("wshp0001.lbm");
 load_iffimage(fn,&backim,backpal);
 settop8cols(backpal);
 setfn("wshp.spr");
 propsprs=load_sprites(fn);
 setfn("wshp1.spr");
 upgsprs=load_sprites(fn);
 setfn("larrow.bbm");
 load_iffimage(fn,&larrim,NULL);
 larrim.x=8;larrim.y=161;
 setfn("rarrow.bbm");
 load_iffimage(fn,&rarrim,NULL);
 rarrim.x=249;rarrim.y=161;
 load_prop_scripts();
 fade_out();

 noptions=4;
 opareas=storareas;
 ctrl_func_p=stores_ctrl;
 disp_func_p=stores_disp;
 backg=backim.data;
 init_vars();
 gen_qtab(0,80,transpal,backpal);
 stores_disp();
 fade_in(backpal);
 anim=STR_STANDSTILL;
 animfc=5;animhold=gotalk=0;


 if(game_data.mission==1)
	{
	 anim=STR_STANDSTILL;
    sampno=0;gotalk=1;
	}
 while(exitflg==FALSE)
	{
	 wait_loop(1);
		if(--animhold<0)					 					/* holds current animation */
		 	{animhold=0;
			 switch(anim)
		 		{
		 	 	 case STR_STANDSTILL:				 		/* standing */
					if(gotalk)								   /* make him talk */
				 		{anim=STR_TALK;animfr=0;
						}
					else
						{set_frame(16);
						}
					break;
		 	 	 case STR_LOOKR:				 				/* look right,pause then look left */
					if(--animfc==0)
						{animfc=5;
					 	 if(++frame==6)
   						{frame=5;
						    animhold=random(100);
							 anim=STR_LOOKL;
							}
						}
					break;
		 	 	 case STR_LOOKL:
					if(--animfc==0)
						{
						 animfc=5;
					 	 if(--frame==0)						/* done */
							{if(gotalk)							/* try to buy item */
								start_buyanim();
							 else
							 	anim=STR_STANDSTILL;		 	/* just stands */
							}
						}
					break;
		 	 	 case STR_CLIPBOARD:							/* raise then lower clipboard */
						{if(--animfc==0)
							{
							 if(frame==21)
								frame+=2;
							 animfc=5;
							 if(++frame==29)
								{
								 anim=STR_STANDSTILL;		/* done */
								}
							}
						}
					break;
			 	 case STR_TALK:
					prop_says(sampno);
					anim=STR_STANDSTILL;
					gotalk=0;
					if(sampno==3)									/* this is exit speech */
						start_exanim();
					break;
				}
			}

 anim_exit();

 if(select_status() && !gotalk)

	{
	 selectrel=0;
 	 if(mainsel==3 && !exanim)
			{if(anim==STR_LOOKR)
				 anim=STR_LOOKL;
		    gotalk=1;
			 sampno=3;
			 animhold=0;
			}
	  else if(!mainsel && game_data.mission >1)
			{if(anim==STR_STANDSTILL && !gotalk)		/* if standing and not going to talk */
				{anim=STR_LOOKR;						  		/* start look right */
				 animfc=5;frame=0;
				}
			 if(++upgr>10)									  	/* next item */
				upgr=0;
			}
	  else if(mainsel==1 && game_data.mission>1)
			{
			 if(anim==STR_STANDSTILL && !gotalk)		/* same as above */
				{anim=STR_LOOKR;
				 animfc=5;frame=0;
				}
			 if(--upgr<0)
				upgr=10;
			}
	  else if(mainsel==2 &&	game_data.mission>1)		/* buy the bugger ? */
 			{if(anim==STR_STANDSTILL)
 				{
				 start_buyanim();
				}
			 else if(anim==STR_LOOKR)	 					/* in process of looking right */
				{
				 anim=STR_LOOKL;							   /* make him turn head back etc */
				 gotalk=1;
				 animhold=0;
				}
          else if(anim==STR_LOOKL)
				 {animhold=0;
				  gotalk=1;
				 }
			}
	 }
 }
 stores_disp();
 FreeMem();
 SoundStopAllSamples();
 SoundFreeSamples();
}


/***************************************************************************/
/***************************               *********************************/
/*************************** STATUS SCREEN *********************************/
/***************************               *********************************/
/***************************************************************************/


void stat_ctrl()
{int i,y;

 if(ctrlval==CTRL_SELECT)
  {
 	for(i=0,y=97;i<9;i++,y+=10)
		{
	 	if(mx>=20 && mx<=100 && my>=y && my< y+10)	/* MENU ????? */
			upgr=i;
		}
  }
 anim_exit();
 if(ctrlval==CTRL_SELECT)									/* quit */
	{
	 switch(mainsel)
		{
 		 case 0:
			start_exanim();
			break;
		}
	}
 switch(ctrlval)
	{
	 case CTRL_UP:
		if(--upgr<0)
			upgr=8;
		break;
	 case CTRL_DOWN:
		if(++upgr>8)
			upgr=0;
		break;
	}
}


/* display an upgrade status bar */

void disp_upgstat(int i,int x,int y,char txtcol)
{char **p;

 p=upgstattxts[game_data.lang];
 set_col(txtcol);
 switch(i){
 case 0:sprint(p[0],x,y);disp_statbar(x+100,y,6,game_data.armint,game_data.armlev);
 break;
 case 1:sprint(p[1],x,y);disp_statbar(x+100,y,6,game_data.armint,game_data.armlev);
 break;
 case 2:sprint(p[2],x,y);disp_statbar(x+100,y,4,game_data.nsams*8,game_data.nsams);
 break;
 case 3:sprint(p[3],x,y);disp_statbar(x+100,y,1,game_data.mns*8,game_data.mns);
 break;
 case 4:sprint(p[4],x,y);disp_statbar(x+100,y,4,game_data.relupg*8,game_data.relupg);
 break;
 case 5:sprint(p[5],x,y);disp_statbar(x+100,y,4,game_data.tarupg*8,game_data.tarupg);
 break;
 case 6:sprint(p[6],x,y);disp_statbar(x+100,y,4,game_data.engupg*8,game_data.engupg);
 break;
 case 7:sprint(p[7],x,y);disp_statbar(x+100,y,4,game_data.trkupg*8,game_data.trkupg);
 break;
 case 8:sprint(p[8],x,y);disp_statbar(x+100,y,1,game_data.imageint*8,game_data.imageint);
 break;
 case 9:sprint(p[9],x,y);disp_statbar(x+100,y,1,game_data.airsupp*8,game_data.airsupp);
 break;
 case 10:sprint(p[10],x,y);disp_statbar(x+100,y,4,game_data.cgunupg*8,game_data.cgunupg);
 break;
}
}


void stat_disp()

{struct img img;


 memcpy(scrptr,backim.data,320*200);


/* tank display */

 disp_3d_transbox(8,8,304,184);
 img.x=20;
 img.y=16;
 img.w=156;
 img.h=74;
 img.data=tssprs+((upgr)*156*74);
 copy_spr(&img);
 disp_upgstat(0,16,97,upgr==0?255:253);
 disp_upgstat(2,16,107,upgr==1?255:253);
 disp_upgstat(3,16,117,upgr==2?255:253);
 disp_upgstat(4,16,127,upgr==3?255:253);
 disp_upgstat(5,16,137,upgr==4?255:253);
 disp_upgstat(6,16,147,upgr==5?255:253);
 disp_upgstat(7,16,157,upgr==6?255:253);
 disp_upgstat(8,16,167,upgr==7?255:253);
 disp_upgstat(10,16,177,upgr==8?255:253);


 set_col(255);
 sprint(stinfotxt[game_data.lang][0],170,97);
 printnum(game_data.money,290,97);
 sprint(stinfotxt[game_data.lang][1],170,107);
 printnum(game_data.hitacc,290,107);
 sprint(stinfotxt[game_data.lang][2],170,117);
 printnum(game_data.score,290,117);
 sprint(stinfotxt[game_data.lang][3],170,127);
 printnum(game_data.bodycount,290,127);

 sprint(stinfotxt[game_data.lang][4],185,17);
 sprint(datelines[game_data.mission],265,17);

 dispexit();
 disp_cursor();
 dump_vram();
}



void status_screen()
{

/* load status screen stuff */

 CDStop();
 fade_to_pal(FADEOUT_RATE,fadepal);
 setfn("stnk.spr");
 tssprs=load_sprites(fn);
 setfn("stat0001.lbm");
 load_iffimage(fn,&backim,backpal);
 settop8cols(backpal);
 wait_fade();
 CDPlay(7);

 noptions=1;
 upgr=0;
 opareas=exitarea;
 ctrl_func_p=stat_ctrl;
 disp_func_p=stat_disp;
 init_vars();
 gen_qtab(0,80,transpal,backpal);
 memcpy(scrptr,backim.data,320*200);
 disp_pic();
 fade_in(backpal);
 expand_3d_transbox(8,8,304,184,NULL);

 while(exitflg==FALSE)
	wait_loop(1);

 contract_3d_transbox(8,8,304,184,NULL);
 FreeMem();
}


/***************************************************************************/
/***************************                     ***************************/
/*************************** LOCKER ROOM SECTION ***************************/
/***************************                     ***************************/
/***************************************************************************/


  		/*****************************************************
		 *																	  *
		 *																	  *
		 *				Display the locker door sprites 			  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void draw_lock_sprites()
{struct img img;

 img.x=263;
 img.y=100;
 img.w=46;
 img.h=44;
 img.data=locksprs[4]+(frame*46*44);
 copy_image(&img);

 if(lockanim)
  {
 	img.x=lockx;
 	img.y=locky;
 	img.w=lockw;
 	img.h=lockh;
 	img.data=locksprs[locker]+(lockfr/4*lockw*lockh);
	copy_image(&img);
  }
 dispexit();
 disp_cursor();
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 *				Screen update						 			  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void lock_disp()
{
 memcpy(scrptr,backim.data,320*200);
 draw_lock_sprites();

/* locker menu activated */

 if(lockdisp)
	 {
	  disp_3d_transbox(48,22,225,140);
	  set_col(252);
 	  sprint(loadsavetxt[game_data.lang][0],85,30);
     print_char(215,30,locker+1+'0');

/* save game not empty - show info */

	 if(games[locker].flag)
	  {
	 	set_col(255);
	 	sprint(loadsavetxt[game_data.lang][1],80,50);
	 	printnum(games[locker].mission,215,50);

 	 	sprint(loadsavetxt[game_data.lang][2],80,60);
 	 	printnum(games[locker].money,215,60);

 	 	sprint(loadsavetxt[game_data.lang][3],80,70);
    	printnum(games[locker].hitacc,215,70);

 	 	sprint(loadsavetxt[game_data.lang][4],80,80);
 	 	printnum(games[locker].score,215,80);

 	 	sprint(loadsavetxt[game_data.lang][5],80,90);
 	 	printnum(games[locker].bodycount,215,90);

	 	sprint(loadsavetxt[game_data.lang][6],80,100);
	 	disp_statbar(215,100,0,games[locker].armint,games[locker].armlev);

	  }

/* empty game - show 'empty' */

	 else
	  {
	 	set_col(255);
    	sprint(loadsavetxt[game_data.lang][7],80,50);
	  }
   print_menu(lockmen_p); 							/* display menu for saved \empty game */
  }

 if(mainsel<7 && !lockdisp)
 	print_textbar(optxts[mainsel],-1,180);
 dispexit();
 disp_cursor();
 dump_vram();
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 *				Animate open/close locker		 			  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void anim_locker()
{

/* open a menu */

 if(lockanim>0)
	{
    if(++lockfr==12)									/* done ? */
		{
		 lockfr=11;
 		 if(!lockdisp)									/* expand meu */
			 expand_3d_transbox(48,22,225,140,draw_lock_sprites);
		 lockdisp=1;					  				/* menu activated */
		}

 	}

/* close */

 else if(lockanim<0)
	{
    if(--lockfr<0)
		{
		 lockanim=0;
		}
	}
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 *				Locker menu selection screen	 			  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void lock_ctrl()
{int i;

 anim_exit();

/********************** PC CODE ***********************/

#ifdef PC_VERSION

/* load /save game menu activated */

 anim_locker();
 if(lockdisp)
 	{
 	 if(exitflg==TRUE)
		{
	 	 lockdisp=0;
	 	 lockanim=-1;
	 	 noptions=7;
	 	}
 i=menu_selector(lockmen_p);
 if(i>=0)
 	{if(!games[locker].flag)
	  	i++;
	 switch(i)
		{
		 case 0:
 	   	game_data=games[locker];
			break;
		 case 1:
			save_games();
			lock_disp();
			wait(50);
			break;
		 case 2:
			break;
		}
 	 lockdisp=0;
  	 lockanim=-1;
 	 contract_3d_transbox(48,22,224,140,draw_lock_sprites);
 	 noptions=7;
    }
	}

 if(select_status())
	{

	 if(mainsel==6)
		start_exanim();


/* open up a locker */

	 else if(mainsel<4)
		{
		 if(!lockanim)									/* already open ?*/
			{lockanim=1;								/* init animation */
			 lockfr=0;
			 locker=mainsel;
			 lockx=locksprx[locker];
			 locky=lockspry[locker];
			 lockw=locksprw[locker];
			 lockh=locksprh[locker];
			 if(games[locker].flag)
				lockmen_p=&lockmenu;
			 else
				lockmen_p=&lockemptymenu;
			 noptions=0;
			}
		}

/* enter briefing and GAME */

	 else if(mainsel==4)
		{
		 FreeMem();
		 briefing_screen();
		 exitflg=TRUE;
		}

/*  dogg-tag */

    else if(mainsel==5)
  		{
		 talk_to_doggtag();
		 init_lock();
		}

	}

/*************** CONSOLE CODE (no load\save game) ****************/

#else

 if(select_status())
	{
	 if(mainsel==2)
		start_exanim();


/* enter briefing and GAME */

	 else if(mainsel==0)
		{
		 FreeMem();
		 briefing_screen();
		 exitflg=TRUE;
		}

/*  dogg-tag */

    else if(mainsel==1)
  		{
		 talk_to_doggtag();
		 init_lock();
		}
	}

#endif

}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 *				Initialise						 			  	  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void init_lock()
{int i;

 CDStop();
 fade_to_pal(FADEOUT_RATE,fadepal);
 setfn("lock0001.lbm");
 load_iffimage(fn,&backim,backpal);
 settop8cols(backpal);
 for(i=0;i<5;i++)
	{setfn(lockfns[i]);
	 locksprs[i]=load_sprites(fn);
	}
 wait_fade();
 CDPlay(7);

#ifdef PC_VERSION
 noptions=7;
#else
 noptions=3;
#endif

 optxts=locktxts[game_data.lang];
 opareas=lockareas;
 ctrl_func_p=lock_ctrl;
 disp_func_p=lock_disp;
 backg=backim.data;
 init_vars();
 gen_qtab(0,80,transpal,backpal);
 lock_disp();
 fade_in(backpal);
 lockfr=lockanim=locker=lockdisp=0;
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 *				Main animation loop 			 			  	  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void locker_room()
{

 init_lock();
 for(;;)
 	{
	 if(exitflg==TRUE && !lockdisp)
		break;
	 switch(anim)
		{
		 case 0:
			set_frame(0);
			wait_loop(randomr(50,100));
			anim=random(3)+1;
			break;
		 case 1:
			animate(1,3,5);
			wait_loop(randomr(50,100));
			animate1(2,5);
			animate1(1,5);
			anim=0;
			break;
		 case 2:
			animate(4,6,5);
			wait_loop(randomr(50,100));
			animate1(5,5);
			animate1(4,5);
			anim=0;
			break;
		 case 3:
			animate(8,14,5);
			wait_loop(randomr(100,200));
			animate(13,7,5);
			anim=0;
			break;
		 case 4:
			animate(15,19,5);
			wait_loop(randomr(100,200));
			animate(18,15,5);
			anim=0;
			break;
		}
	}
 if(disp_func_p)
 	lock_disp();
 FreeMem();
}

/**************************************************************************/
/****************************                 *****************************/
/**************************** Dogg-tag screen *****************************/
/****************************                 *****************************/
/**************************************************************************/

void dogg_ctrl()
{
 anim_exit();
 if(select_status() && !mainsel)
	start_exanim();
}


void talk_to_doggtag()

{

/* load dogg-tag graphics */

 CDStop();
 fade_to_pal(FADEOUT_RATE,fadepal);
 setfn("dogg0001.lbm");
 load_iffimage(fn,&doggim,backpal);
 setfn("dogg.spr");
 doggsprs=load_sprites(fn);
 settop8cols(backpal);
 load_script_file(DOGGTAG_fns[dogscript]);
 wait_fade();

 sprx=201;
 spry=49;
 sprw=119;
 sprh=151;
 animd=doggsprs;
 backg=doggim.data;

 noptions=1;
 init_vars();
 optxts=tlktxts[game_data.lang];
 opareas=exitarea;
 ctrl_func_p=dogg_ctrl;
 disp_func_p=man_disp;
 gen_qtab(0,80,transpal,backpal);
 man_disp();
 fade_in(backpal);
 animate_man();
/*
 for(i=1;i<=13;i++)
	{load_script_file(DOGGTAG_fns[i]);
	 animate_man();
	 FreeMem();
	}

*/

 man_disp();
 FreeMem();
 SoundFreeSamples();
}

/***************************************************************************/
/**************************                   ******************************/
/************************** MISSION BRIEFINGS ******************************/
/**************************                   ******************************/
/***************************************************************************/


  		/*****************************************************
		 *																	  *
		 *																	  *
		 *			SETANIM command 	(name,frame) 			  	  *
		 *			Sets frame for given character				  *
		 *																	  *
		 *																	  *
		 *****************************************************/

void set_anim()
{
 get_commarg();
 if(!strcmp(charface,argbuff))
	{get_commarg();
	 animfr=atoi(argbuff)-1;
	}
 else
	{get_commarg();
	 animfr1=atoi(argbuff)-1;
	}
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 *			Load animation graphics							  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void load_charsay_stuff()
{
 if(backloaded==FALSE)
	 {
	  setfn(BACK_fns[facepic]);
	  load_iffimage(fn,&backim,backpal);
	  setfn(CHARFACE_fns[facepic]);
	  brief1sprs=load_sprites(fn);
	  facsprx=CHARFACE_pos[facepic*2];
	  facspry=CHARFACE_pos[(facepic*2)+1];
	  facsprw=sw;
	  facsprh=sh;
	  setfn(CHARAWAY_fns[awypic]);
	  brief2sprs=load_sprites(fn);
	  fade_out();
	  awsprx=CHARAWAY_pos[awypic*2];
	  awspry=CHARAWAY_pos[(awypic*2)+1];
	  awsprw=sw;
	  awsprh=sh;
	  backloaded=TRUE;
	  briefdisp=0;
     nstrs=0;
     gen_qtab(0,80,transpal,backpal);
 	  settop8cols(backpal);
	  briefing_disp();
	  fade_in(backpal);
	 }
}


  		/*****************************************************
		 *																	  *
		 *																	  *
		 * 		Set up frame pointer for talking anim		  *
		 *			(animfr is char facing )						  *
		 * 		tlkfr_p - talking animation pointer			  *
 		 * 		tlkfr1_p - listening								  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void init_talkanim()
{
 get_commarg();
 if(!strcmp(charface,argbuff))
	{tlkfr_p=&animfr;lstfr_p=&animfr1;}
 else
	{tlkfr_p=&animfr1;lstfr_p=&animfr;}
 get_commarg();

/* set talking frames */

 if(tlkanim<3)
 	{tlkanim=random(2)+1;
 	 switch(tlkanim)
 		{
 	  	 case 1:
 			basefr=8;tlkfrm1=24;
 			break;
 	  	 case 2:
 			basefr=9;tlkfrm1=28;
 			break;
 	  	 case 3:
 			basefr=10;tlkfrm1=32;
 			break;
		}
 	 }

/* set up listening character animation  */

 get_commarg();
  lstanim=atoi(argbuff);
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 *			Process the subtitles for						  *
		 *			the 'man' and dogg tag speech					  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void do_subs()
{int n;

 for(;;)
	{
    get_line();
	 if(linelen)
		{
		 n=interpret_command();
		 switch(n)
	 	 	{
			 case SCOM_CHARTXT:		 					/* get and display subs */
		   	set_subtitle_width(52);
				get_subtitles();
 				briefing_disp();
				break;
			 case SCOM_SAMPGAP:						  	/* wait for a gap */
				get_commarg();
				gpb=atoi(argbuff);
				get_commarg();
				gpe=atoi(argbuff);
				do{
					wait_loop(1);
					if(exitflg==TRUE)
						{SoundStopAllSamples();return;}
					get_sample_position();
				  }while(boff<gpb);
				if(!gpe)
					return;
				break;
			}
		}
	}
}
  		/*****************************************************
		 *																	  *
		 *																	  *
		 *			Animation a conversation between	  			  *
		 *			2 characters										  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


void  animate_conversation()
{int n,f,mindex,noddel;

 shandle=SoundPlaySample(0,game_data.soundvol,100,0x8000);
 mindex=noddel=0;
 for(;;)
	{
    get_line();
	 if(linelen)
		{
		 n=interpret_command();
		 switch(n)
	 	 	{
			 case SCOM_CHARTXT:							/* grab subs */
		   	set_subtitle_width(52);
				get_subtitles();
				break;
			 case SCOM_SAMPGAP:	 						/* animate during speech */
				get_commarg();
				gpb=atoi(argbuff);
				get_commarg();
				gpe=atoi(argbuff);
				do{
					get_sample_position();	  			/* offset in sample  */
	 				if(tlkanim)			 					/* talking animation 0-none */
						{
	 	 				 	 f=mouth_frms[mindex]; 		/* get mouth frame */
	 	 				 	 if(f==4)					  	/* 4- mouth closed frame */
 								*tlkfr_p=basefr;
	 	 				 	 else
								*tlkfr_p=tlkfrm1+f;		/* mouth frame 0-3 */
	 	 				 	 if(++mindex==18)
	 							mindex=0;
						}
					else									 	/* no anim */
						*tlkfr_p=basefr;

	 				if(lstanim==5 || !lstanim)			/* anim 0 or 5 - random movement of listener's head */
						{if(!random(15))
	 				 	  *lstfr_p=random(2)+8;
						 }
					else if(lstanim==6)			 		/* 6 - nod animation */
						{if(!noddel)						/* gap between anims */
						 	{--(*lstfr_p);
						 	 if(*lstfr_p<2)
						 		{*lstfr_p=4;noddel=random(25);}
							}
						 else
							--noddel;
						}
	 				wait_loop(8);							/* wait 5 frames */
					if(exitflg==TRUE)
						{SoundStopAllSamples();return;}
			  		}while(boff<gpb);						/* ...until gap in sample */

				if(!gpe)								  		/* done */
					return;
				do{											/* wait for end of gap */
					get_sample_position();
				  }while(boff<gpe && boff);
			}
		}
	}
}

  		/*****************************************************
		 *																	  *
		 *																	  *
		 *			Scan script file an execute commands		  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *																	  *
		 *****************************************************/


int process_script_file()
{
 int i,n;
 uword scoffbs;


 i=0;scoff=0;
 backloaded=FALSE;
 while(get_line()!=-1)
 {
  if(linelen){
    n=interpret_command();
    switch(n)
		{
		 case SCOM_SETDOGG: 									/* set dogg background */
			get_commarg();
			doggpic=atoi(argbuff);
			break;
	    case SCOM_DATELINE:									/* display dateline */
 			FreeMem();
			get_commarg();
			fade_out();
			load_script_file(sfn);
 			load_fontdata("font2.lbm",&font2);
 			font2.w=16;
 			font2.h=16;
 			setfont(&font2);
			set_col(1);
 			memset(backpal,0,256*3);			  			/* black pal */
		   backpal[4]=0x2b; 									/* text col */
 			memset(scrptr,0,320*200);
 			sprint(argbuff,8,90);							/* print dateline */
			 dump_screen();
			fade_to_pal(FADEOUT_RATE,backpal);			/* fade in */
			wait_fade();
			for(i=0;i<300;i++)
				{ScreenWaitVbl();
				 read_joypad();
				 if(ctrlval==CTRL_SELECT)
					break;
				}
			fade_to_pal(FADEOUT_RATE,fadepal);
			wait_fade();
			setfont(&font1);
			break;
	 	 case SCOM_SETMAN:			 						/* back pic */
			get_commarg();
			manpic=atoi(argbuff);
			break;
		 case SCOM_SETMAP1:									/* back pic */
			get_commarg();
			mappic1=atoi(argbuff);
			break;
		 case SCOM_SETMAP2:								   /* back pic */
			get_commarg();
			mappic2=atoi(argbuff);
			break;
	 	 case SCOM_SETFACING:								/* set name of char facing */
			get_commarg();
			strcpy(charface,argbuff);
			get_commarg();
			facepic=atoi(argbuff);
			break;
	 	 case SCOM_SETAWAY:
			get_commarg();
			strcpy(charaway,argbuff);
			get_commarg();
			awypic=atoi(argbuff);
			break;
	 	 case SCOM_SETANIM:	 								/* set character frame */
			set_anim();
			break;
		 case SCOM_SHOWFRAME:
			load_charsay_stuff();
			wait_loop(5);
			break;
		 case	SCOM_SETDRAW:								  	/* set draw order of sprites */
			get_commarg();
			draworder=atoi(argbuff);
			break;
	 	 case SCOM_BRIEFSTART:								/* start briefing */
			scoffbs=scoff;
			for(;;)
				{
				 if(exitflg==TRUE)
					return 0;
				 get_line();
				 if(linelen>1)
					{
				 	 n=interpret_command();
				 	 switch(n)
						{
						 case SCOM_PAUSEFRAME:
							get_commarg();
							wait_loop(atoi(argbuff));
							break;
		 			 	 case SCOM_SETANIM:
							set_anim();
					 		break;
				    	 case SCOM_SHOWFRAME:
 							load_charsay_stuff();
						 	wait_loop(5);
							break;
		 			 	 case SCOM_BRIEFEND:
							FreeMem();
							SoundFreeSamples();
							return 0;
						 case SCOM_CHARTXT:
							break;
						 case SCOM_MAPSAY1:
							nstrs=0;
							briefdisp=1;
							load_sample();
							setfn(MAPPIC_fns[mappic1]);
							goto doscr;
						 case SCOM_MAPSAY2:
							nstrs=0;
							briefdisp=1;
							load_sample();
							setfn(MAPPIC_fns[mappic2]);
							goto doscr;
						 case SCOM_MANSAY:
					   	FreeMem();
						   backloaded=FALSE;
							nstrs=0;
							briefdisp=1;
							load_sample();
							load_script_file(sfn);
							setfn(MANPIC_fns[manpic]);
doscr:
							load_iffimage(fn,&backim,backpal);
							fade_out();
 							gen_qtab(0,80,transpal,backpal);
 							settop8cols(backpal);
							briefing_disp();
							fade_in(backpal);
							shandle=SoundPlaySample(0,game_data.soundvol,100,0x8000);
	  						do_subs();
							SoundFreeSamples();
							break;
					    case SCOM_DOGGSAYC:
							FreeMem();
						   backloaded=FALSE;
							setfn(DOGG1C_fns[doggpic]);
							animd=load_sprites(fn);
	   					setfn(DOGGCBACK_fns[doggpic]);
							load_iffimage(fn,&backim,backpal);
							fade_out();
							sprx=DOGGC_pos[doggpic*2];
							spry=DOGGC_pos[(doggpic*2)+1];
							goto mansay;
						 case SCOM_DOGGSAYM:
							FreeMem();
							setfn(DOGG1M_fns[doggpic]);
							animd=load_sprites(fn);
							setfn(DOGGMBACK_fns[doggpic]);
							load_iffimage(fn,&backim,backpal);
							fade_out();
							sprx=DOGGM_pos[doggpic*2];
							spry=DOGGM_pos[(doggpic*2)+1];
mansay:
							load_script_file(sfn);
							nstrs=0;
 							gen_qtab(0,80,transpal,backpal);
 							settop8cols(backpal);
							sprw=sw;
							sprh=sh;
						   backloaded=FALSE;
							briefdisp=2;
 							briefing_disp();
							fade_in(backpal);
							mansay();
							break;
		 			 	 case SCOM_CHARSAY:
							FreeMem();
							load_script_file(sfn);
 							load_charsay_stuff();
							init_talkanim();
							load_sample();
							animate_conversation();
							SoundFreeSamples();
						 	break;
					   }
					}
				}
			break;
		}
	}
 i++;
 }
 return 0;
}

void draw_facspr()
{struct img img;

 img.x=facsprx;
 img.y=facspry;
 img.w=facsprw;
 img.h=facsprh;
 img.data=brief1sprs+(animfr*facsprw*facsprh);
 copy_image(&img);
}

void draw_backspr()
{struct img img;

 img.x=awsprx;
 img.y=awspry;
 img.w=awsprw;
 img.h=awsprh;
 img.data=brief2sprs+(animfr1*awsprw*awsprh);
 copy_image(&img);
}

void briefing_disp()

{
 struct img img;

 memcpy(scrptr,backim.data,320*200);
 if(!briefdisp)
  {
   if(!draworder)
		{draw_facspr();draw_backspr();}
	else
		{draw_backspr();draw_facspr();}
   disp_subs();
  }
 else	if(briefdisp==1)
   disp_subs();
 else
   {
 	 img.x=sprx;
 	 img.y =spry;
 	 img.w=sprw;
 	 img.h=sprh;
 	 img.data=animd+(frame*sprw*sprh);
 	 copy_image(&img);
	 disp_subs();
	}
 dump_vram();
}

void briefing_ctrl()
{
}

void briefing_screen()

{
 CDStop();
 animfr=animfr1=0;
 noptions=1;
 optxts=tlktxts[game_data.lang];
 opareas=exitarea;
 ctrl_func_p=briefing_ctrl;
 disp_func_p=briefing_disp;
 init_vars();
 gen_qtab(0,80,transpal,backpal);
 strcpy(sfn,BRIEFING_fns[game_data.mission]);
 load_script_file(sfn);
 process_script_file();
 SoundStopAllSamples();
 SoundFreeSamples();

 FreeAll();

 my_main();

 InitMemAlloc();
 load_resident_stuff();
 select_character_scripts();

 switch(game_data.missstatus)
	{
	 case TANK_DESTROYED:						/* Lost the plot */
			fmv(DEATH_SEQUENCE);
			fmv(GAME_OVER_SEQUENCE);
			reset_game();
			title_seq();
			break;

	 case MISSION_FAILED:						/* Chickened out */
			mission_failed();
			endmission_stats_screen();
			fmv(GAME_OVER_SEQUENCE);
			reset_game();
			title_seq();
			break;

	 case MISSION_SUCC:							/* Ride 'em cowboy! */
			if(game_data.mission==25)
			{
				fmv(COMPLETION_SEQUENCE);
				title_seq();
				game_data.mission=1;			/* Start from the beginning again. */
				break;
			}
			endmission_stats_screen();
			game_data.mission++;
			next_mission();
			break;
	}
 	FreeMem();
}

/********************* MISSION FAILED SECTION *****************************/

void mission_failed()
{
 init_vars();
 fade_to_pal(FADEOUT_RATE,fadepal);
 setfn("fail0001.lbm");
 load_iffimage(fn,&backim,backpal);
 setfn("fail.spr");
 doggsprs=load_sprites(fn);
 settop8cols(backpal);
 load_script_file("fail.txt");
 wait_fade();

 sprx=76;
 spry=16;
 sprw=244;
 sprh=184;
 animd=doggsprs;
 backg=backim.data;

 noptions=1;
 optxts=tlktxts[game_data.lang];
 opareas=exitarea;
 ctrl_func_p=dogg_ctrl;
 disp_func_p=man_disp;

 init_vars();
 gen_qtab(0,80,transpal,backpal);
 man_disp();
 fade_in(backpal);
 animate_man();
 wait_loop(50);
 FreeMem();
 SoundFreeSamples();
}


/********************** Mission Stats screen **********************/


void endmiss_display()
{struct img img;
 char **p;
 int y=48;


 p=missstattxt[game_data.lang];


 memcpy(scrptr,backim.data,320*200);
 disp_3d_transbox(13,10,220,160);

 set_col(252);
 sprint(p[0],22,22);

 set_col(255);
 sprint(p[1],22,y);

/* print out game performance info */

 printnum(game_data.nstructs_dest,200,y);
 y+=10;

 if(MissionVehicles[game_data.mission] & AIRTARGS)		/* any air targets in mission ? */
 	{sprint(p[2],22,y);
 	 printnum(game_data.nairtarg_dest,200,y);
    y+=10;
 	}

 sprint(p[3],22,y);
 printnum(game_data.ngrdtarg_dest,200,y);
 y+=10;

 if(MissionVehicles[game_data.mission] & TRUCKS)
  	{
 	 sprint(p[4],22,y);
 	 printnum(game_data.perc_trucks,200,y);
 	 sprint("%",200+24,y);
	 y+=10;
	}

 if(nextMissionTypes[game_data.mission] & HOSTAGEMISS)
 	{
 	 sprint(p[5],22,y);
 	 printnum(game_data.perc_host,200,y);
 	 sprint("%",200+24,y);
	 y+=10;
	}

 sprint(p[6],22,y);
 printnum(game_data.perc_obj,200,y);
 sprint("%",200+24,y);
 y+=10;

 sprint(p[7],22,y);
 printnum(game_data.hitacc,200,y);
 sprint("%",200+24,y);
 y+=10;

 sprint(p[8],22,y);
 printnum(game_data.crates_coll,200,y);
 y+=10;

 sprint(p[9],22,y);
 printnum(game_data.score,200,y);
 y+=10;

 sprint(p[10],22,y);
 printnum(game_data.money,200,y);

 img.x=247;
 img.y=80;
 img.w=70;
 img.h=120;
 img.data=tssprs+(frame*70*120);
 copy_image(&img);
 if(mainsel<noptions)
 	print_textbar(optxts[mainsel],-1,188);
 dispexit();
 disp_cursor();
 dump_vram();
}

void endmiss_status_ctrl()
{
 anim_exit();
 if(select_status())
  {
    switch(mainsel)
  		{
	 	 case 0:
			start_exanim();
			return;
		}
  }
}



void	endmission_stats_screen()
{

/* load status screen stuff */


 fade_to_pal(FADEOUT_RATE,fadepal);
 setfn("mstat.spr");
 tssprs=load_sprites(fn);
 setfn("mstt0001.lbm");
 load_iffimage(fn,&backim,backpal);
 settop8cols(backpal);
 backg=backim.data;
 wait_fade();

 noptions=1;
 upgr=0;
 opareas=exitarea;
 optxts=mstattxts[game_data.lang];
 ctrl_func_p=endmiss_status_ctrl;
 disp_func_p=endmiss_display;
 init_vars();
 gen_qtab(0,80,transpal,backpal);
 memcpy(scrptr,backim.data,320*200);
 dump_vram();
 fade_in(backpal);
 expand_3d_transbox(13,10,220,160,NULL);
 endmiss_display();

 for(;;)
	{
	 if(exitflg==TRUE)
		goto msdone;
	 switch(anim)
		{
		 case STAT_START:
			animate1(0,randomr(100,200));
			anim=random(3)+STAT_LOOKR;
			break;
		 case STAT_LOOKR:
			animate(0,3,5);
			animate1(4,randomr(100,200));
			animate(3,0,5);
		   anim=STAT_START;
			break;
		 case STAT_LOOKL:
			animate1(0,5);
			animate(6,7,5);
			animate1(8,randomr(100,200));
			animate1(7,5);
			animate1(6,5);
			animate1(0,5);
		   anim=STAT_START;
			break;
		 case STAT_LOOK_YOU:
			animate1(0,5);
			animate(10,11,5);
			animate1(12,randomr(100,200));
			animate1(11,5);
			animate1(10,5);
			animate1(0,5);
		   anim=STAT_START;
			break;
		 case STAT_LOWER_CBRD:
			animate1(0,5);
			animate(13,19,5);
			anim=random(2)+STAT_CBRD_LOOKR;
			break;
		 case STAT_CBRD:
			animate1(19,randomr(100,200));
			anim=random(2)+STAT_CBRD_LOOKR;
			break;
		 case STAT_CBRD_LOOKR:
			animate1(19,5);
			animate(25,28,5);
			animate1(29,randomr(100,200));
			animate(28,25,5);
			animate1(19,randomr(100,200));
			anim=STAT_CBRD;
			break;
		 case STAT_CBRD_LOOKL:
			animate(19,23,5);
			animate1(24,randomr(100,200));
 			animate(23,19,5);
			anim=STAT_CBRD;
			break;
		 case STAT_CBRD_RAISE:
			animate(19,13,5);
			animate1(0,5);
			anim=STAT_START;
			break;
		}

	}

msdone:
 contract_3d_transbox(13,10,224,160,NULL);
 FreeMem();
}


/********************** Reset mission vars ***********************/

void reset_game(void)
{
	game_data.mission=1;
	game_data.nextmiss = nextMissionTypes[game_data.mission];

	game_data.larmlev = original_game_data.larmlev;
	game_data.larmint = original_game_data.larmint;
	game_data.armlev = original_game_data.armlev;
	game_data.armint = original_game_data.armint;
	game_data.nsams = original_game_data.nsams;
	game_data.mns = original_game_data.mns;
	game_data.imageint = original_game_data.imageint;
	game_data.airsupp = original_game_data.airsupp;
	game_data.engupg = original_game_data.engupg;
	game_data.trkupg = original_game_data.trkupg;
	game_data.relupg = original_game_data.relupg;
	game_data.tarupg = original_game_data.tarupg;
	game_data.cgunupg = original_game_data.cgunupg;
	game_data.money = original_game_data.money;
	game_data.score = original_game_data.score;
	game_data.hitacc = original_game_data.hitacc;
	game_data.bodycount = original_game_data.bodycount;
   select_character_scripts();
}


/********************** Move onto next mission *******************/

void next_mission(void)
{
	game_data.nextmiss = nextMissionTypes[game_data.mission];

	game_data.larmlev = game_data.armlev;
	game_data.larmint = game_data.armint;
}


void my_main()
{
 game_data.missstatus=MISSION_FAILED;
}
