#include "headers.h"

#include "chuck.h"
#include "e_global.h"
#include "shokstrc.h"
#include "enemlogc.h"

/***************************************************************/

/* Gun emplacement logic */

/***************************************************************/


#define MAX_GUNEMPL_TURN_RATE		0X20
#define MIN_GUNEMPL_TURN_RATE		2


void	do_gun_emplacements(void)
{
	int i;
	GUN_EMPLACEMENT *cgunempl=NULL;
	int	relx, relz;
	int	angle2target;
	int	dang, angleTolerance;
	int	turnDirn;
	int	minsqrtdist, sqrtdist;


	targetTank = &pl;	/** assume the target for the gun emplacment is the player */

	for ( i=0, cgunempl=gunempls; i<MAX_GUN_EMPLS; i++, cgunempl++ )
	{
		if ( cgunempl->exist )
		{
			/** Target allied trucks if it's an allied convoy mission **/
			if ( objectiveType==PROTECT_CONVOY_OBJECTIVE )
			{
				if ( (cgunempl->targetTank==NULL) || ((cgunempl->targetTank!=NULL) && !cgunempl->targetTank->def) )
				{
	    		int j;
  	  		ushort	*cmember;
    			TANK	*alliedTruck;
					CONVOY_DATA	*cConvoy;

      		/** find the closest target tank - either an allied convoy truck or the player */
					relx = ((uint)cgunempl->x>>24) - ((uint)pl.x>>24);
					relz = ((uint)cgunempl->z>>24) - ((uint)pl.z>>24);

        	relx *= relx;
        	relz *= relz;

      		/** assume the player tank is the closest target tank */
      		cgunempl->targetTank = targetTank = &pl;
        	minsqrtdist = relx + relz;

      		/** assume their is only one allied convoy (in convoyData[0]) **/

					/** Find the closest tank to lock onto */

      		for ( j=0, cConvoy=convoyData, cmember=cConvoy->members; j<cConvoy->numMembers; j++ )
      		{
  					alliedTruck = enemyTanks+(*cmember++);
      			/** get distance to the  **/
						relx = ((uint)cgunempl->x>>24) - ((uint)alliedTruck->x>>24);
						relz = ((uint)cgunempl->z>>24) - ((uint)alliedTruck->z>>24);

        		relx *= relx;
        		relz *= relz;

      			if ( (sqrtdist=(relx+relz)) < minsqrtdist )
      			{
      				cgunempl->targetTank = targetTank = alliedTruck;
      				minsqrtdist = sqrtdist;
      			}
      		}
				}
				else
				{

					/* Lock onto previously aquired target */
					targetTank = cgunempl->targetTank;

					relx = ((uint)cgunempl->x>>24) - (((uint)targetTank->x)>>24);
					relz = ((uint)cgunempl->z>>24) - (((uint)targetTank->z)>>24);

					relx *= relx;
					relz *= relz;

					minsqrtdist = relx+relz;
				}
			}
			else
			{
				/* Lock onto player tank - not allied convoy mission */

 				relx = ((uint)cgunempl->x>>24) - ((uint)pl.x>>24);
				relz = ((uint)cgunempl->z>>24) - ((uint)pl.z>>24);

				relx *= relx;
				relz *= relz;

				minsqrtdist = relx+relz;
			}




			if ( minsqrtdist <= enemyTriggerRange[E_GUNEMPL] )
			{
				/*Get angle to the target */
				angle2target = (phd_atan((int)( (targetTank->x>>16) - (cgunempl->x>>16)),
																 (int)( (targetTank->z>>16) - (cgunempl->z>>16)) ) &0x7ff);

//				angleDiff = get_angle_difference(cgunempl->startangle, angle2target);

//				if ( abs(angleDiff) < 0x100 )
//				{
  				turnDirn = get_turn_dirn(cgunempl->angle, angle2target);

  				/* Turn towards target */

  				switch ( turnDirn )
  				{
  					case LARGE_RIGHT_TURN:
  						cgunempl->turnRate+=8;
  						break;

  					case SMALL_RIGHT_TURN:
  						cgunempl->turnRate+=4;
  						break;

  					case LARGE_LEFT_TURN:
  						cgunempl->turnRate-=8;
  						break;

  					case SMALL_LEFT_TURN:
  						cgunempl->turnRate-=4;
  						break;
  				}
//				}


				if ( cgunempl->turnRate > MAX_GUNEMPL_TURN_RATE )
				{
					cgunempl->turnRate = MAX_GUNEMPL_TURN_RATE;
				}
				else if ( cgunempl->turnRate < -MAX_GUNEMPL_TURN_RATE )
				{
					cgunempl->turnRate = -MAX_GUNEMPL_TURN_RATE;
				}


				cgunempl->angle += cgunempl->turnRate;
				cgunempl->angle &= 0x7ff;


				if ( cgunempl->turnRate>0 )
				{
					cgunempl->turnRate--;
				}
				else if ( cgunempl->turnRate<0 )
				{
					cgunempl->turnRate++;
				}

				gunempl_fire_bullet(cgunempl, targetTank);

				/* Decide wether to shoot or not */

				angleTolerance = enemyAccuracy[E_GUNEMPL];

				dang = get_angle_difference(cgunempl->angle, angle2target);


				if ( abs(dang)<angleTolerance )
				{
					/* Shoot */
					gunempl_fire_bullet(cgunempl, targetTank);
				}

				if ( cgunempl->shellDelayCount )
				{
					cgunempl->shellDelayCount--;
				}
			}
			else
				cgunempl->targetTank=NULL;	/** No tanks in trigger range */

			if ( objectiveType==PROTECT_CONVOY_OBJECTIVE && targetTank->def==PLAYER_TANK )
			{
				cgunempl->targetTank=NULL;
			}
		}
	}
}
