version=release
#version=debug

.ERASE
# .EXTENSIONS:

obj_release = pc.rel
obj_debug = pc.dbg
obj = $(obj_$(version))
asm = pc
mainbin = $(obj)\main.exe
linkfile = $(obj)\main.lnk
platform_specific_objs = \shok\lib\shell.lib \shok\lib\sosw1cr.lib

C_Compiler = wcc386
Assembler = ml
Linker = wlink
C_Compiler_Options_common = -5r -w4 -zq -DPC_VER $- -fo=$(obj)\$^. $+
C_Compiler_Options_debug = -d2
C_Compiler_Options_release = -oaeil+mnrt -s
Assembler_Options_common = /nologo /c /Fl -DPC_VER=1
Assembler_Options_debug = /Zd
Assembler_Options_release =
Linker_Options_common = option quiet system dos4g $- name $(obj)\$^. $+
Linker_Options_debug = debug all
Linker_Options_release =

C_Compiler_Options = $(C_Compiler_Options_$(version)) $(C_Compiler_Options_common)
Assembler_Options = $(Assembler_Options_$(version)) $(Assembler_Options_common)
Linker_Options = $(Linker_Options_$(version)) $(Linker_Options_common)

Compile = $(C_Compiler) $(C_Compiler_Options) $- $[@ $+
Assemble = $(Assembler) $(Assembler_Options) $- -Fo$(obj)\$^. $[@ $+

common_objs = $(obj)\main.obj $(obj)\shock.obj $(obj)\floor.obj &
		$(obj)\sprite.obj $(obj)\globals.obj $(obj)\cosin.obj &
		$(obj)\mgsetup.obj $(obj)\initlev.obj $(obj)\plyrctrl.obj &
		$(obj)\utils.obj $(obj)\phd_math.obj $(obj)\plyr_det.obj &
		$(obj)\aspr.obj $(obj)\autils.obj $(obj)\afloor.obj &
		$(obj)\org.obj $(obj)\moveanim.obj $(obj)\awaldraw.obj &
		$(obj)\walldraw.obj $(obj)\enemtank.obj $(obj)\enemlogc.obj &
		$(obj)\helicopt.obj $(obj)\hostage.obj $(obj)\gunempl.obj &
		$(obj)\collide.obj $(obj)\spr.obj $(obj)\frames.obj &
		$(obj)\e_global.obj $(obj)\weapons.obj &
		$(obj)\sfx.obj $(obj)\gunboat.obj $(obj)\nine.obj &
		$(obj)\tacmap.obj $(obj)\options.obj $(obj)\objectiv.obj $(obj)\message.obj &
		$(obj)\decrnch.obj $(obj)\wearit.obj &


asmfiles =

make : $(mainbin) .symbolic

debug : $(mainbin) .symbolic
	wd /tr=rsi /swap /lines=50 $[@
	bv 4

$(mainbin) : $(platform_specific_objs) $(common_objs)
	@del $(linkfile)
	@echo linking
	@%make $(linkfile)
	$(Linker) $(Linker_Options) @$(linkfile)

$(linkfile) :
	@%create $^@
	@%append $^@ option eliminate
	@%append $^@ option stack=32768
	@%append $^@ option map=$(obj)\main.map
	@for %i in ($(platform_specific_objs) $(common_objs)) do @%append $^@ FILE %i

$(obj)\main.obj : main.c $(maindep)
	$(Compile)

$(obj)\tacmap.obj : tacmap.c $(maindep)
	$(Compile)

$(obj)\shock.obj : shock.c $(maindep)
	$(Compile)

$(obj)\floor.obj : floor.c $(maindep)
	$(Compile)

$(obj)\sprite.obj : sprite.c $(maindep)
	$(Compile)

$(obj)\globals.obj : globals.c $(maindep)
	$(Compile)

$(obj)\cosin.obj : cosin.c $(maindep)
	$(Compile)

$(obj)\initlev.obj : initlev.c $(maindep)
	$(Compile)

$(obj)\plyrctrl.obj : plyrctrl.c $(maindep)
	$(Compile)

$(obj)\utils.obj : utils.c $(maindep)
	$(Compile)

$(obj)\plyr_det.obj : plyr_det.c $(maindep)
	$(Compile)

$(obj)\mgsetup.obj : mgsetup.c $(maindep)
	$(Compile)

$(obj)\moveanim.obj : moveanim.c $(maindep)
	$(Compile)

$(obj)\walldraw.obj : walldraw.c $(maindep)
	$(Compile)

$(obj)\enemtank.obj : enemtank.c $(maindep)
	$(Compile)

$(obj)\enemlogc.obj : enemlogc.c $(maindep)
	$(Compile)

$(obj)\helicopt.obj : helicopt.c $(maindep)
	$(Compile)

$(obj)\hostage.obj : hostage.c $(maindep)
	$(Compile)

$(obj)\gunempl.obj : gunempl.c $(maindep)
	$(Compile)

$(obj)\gunboat.obj : gunboat.c $(maindep)
	$(Compile)

$(obj)\collide.obj : collide.c $(maindep)
	$(Compile)

$(obj)\spr.obj : spr.c $(maindep)
	$(Compile)

$(obj)\frames.obj : frames.c $(maindep)
	$(Compile)

$(obj)\e_global.obj : e_global.c $(maindep)
	$(Compile)

$(obj)\weapons.obj : weapons.c $(maindep)
	$(Compile)

$(obj)\nine.obj : nine.c $(maindep)
	$(Compile)

$(obj)\aspr.obj : aspr.asm $(maindep)
	$(Assemble)

$(obj)\autils.obj : autils.asm $(maindep)
	$(Assemble)

$(obj)\afloor.obj : afloor.asm $(maindep)
	$(Assemble)

$(obj)\org.obj : org.asm $(maindep)
	$(Assemble)

$(obj)\awaldraw.obj : awaldraw.asm $(maindep)
	$(Assemble)

$(obj)\phd_math.obj : phd_math.asm $(maindep)
	$(Assemble)

$(obj)\decrnch.obj : decrnch.asm $(maindep)
	$(Assemble)

$(obj)\options.obj : options.c $(maindep)
	$(Compile)

$(obj)\objectiv.obj : objectiv.c $(maindep)
	$(Compile)

$(obj)\message.obj : message.c $(maindep)
	$(Compile)

$(obj)\wearit.obj : wearit.c $(maindep)
	$(Compile)




$(obj)\sfx.obj : sfx.c $(maindep)
	$(Compile)

