#include "headers.h"
#include "chuck.h"
#include "walldraw.h"
#include "e_global.h"
#include "rshock.h"
#include "shock.h"

#include "iff.h"
#include "frontend.h"
#include "frontdef.h"
#include "frglobs.h"

#include "enemlogc.h"



#define MINE_OBJECT	10

int	minesInVicinity=FALSE;



void	detect_mines(void)
{
	int	stilex, stilez, etilex, etilez, blkacross;
	uint	plx, plz;
	uchar	*cobjmap;


	/* Draw any water and trees in the vicinity */
	etilex = ( stilex = ((plx = (pl.x>>24)) - 3 )) + 6;
	etilez = ( stilez = ((plz = (pl.z>>24)) - 3 )) + 6;

	if ( obj_map[(plz<<8) + plx] == MINE_OBJECT )
	{
		damage_tank(&pl, 0x100);
		obj_map[(plz<<8) + plx] = 0;
		player_hit_sound(0x100);
		return ;
	}

	minesInVicinity = FALSE;

	if ( etilex > 255 )
	{
		etilex = 255;
	}

	if ( etilez > 255 )
	{
		etilez = 255;
	}

	if ( stilex < 0 )
	{
		stilex = 0;
	}

	if ( stilez < 0 )
	{
		stilez = 0;
	}

	for ( ; stilez <= etilez; stilez++ )
	{
		blkacross=stilex;
		cobjmap = obj_map+((stilez<<8)+blkacross);

		for ( ; blkacross<etilex; blkacross++, cobjmap++ )
		{
			/** draw any relevant floor objects onto tactical **/

			if ( *cobjmap==MINE_OBJECT )
			{
				minesInVicinity = TRUE;
				return;
			}
		}
	}
}




