#ifndef NCOLLECT
#define NCOLLECT

#include "\tanx\list2.h"
#include "\tanx\objects.h"
#include "\tanx\setnet2.h"
#include "\tanx\playnet.h"
#include "\shok\texto.h"

/*-----------------19/10/95 00:44-------------------

	N E T W O R K   C O L L E C T A B L E S

	created to hold all dat special SHELLSHOCK specific
	collectables stuff.

--------------------------------------------------*/

#define COLLECT_TYPES 9


/*Used when STRIPPING OUT CTBLS BEFORE FLOOR SEND*/
#define FIRST_CTBL_SPR 8
#define LAST_CTBL_SPR 8


enum CTBL_NAMES
{
	C_SPEEDUP= 0,
	C_TRIPLE,
	C_SMARTIE,
	C_SHELLSPEED,
	C_SHELLRANGE,
	C_ENERGY,
	C_RELOAD,
	C_RADAR_CLOAK,
	C_INVISIBILITY
};

/*************************************************************


				               G L O B A L S

 *************************************************************/




/*************************************************************
														STRUCTURES
 *************************************************************/

typedef struct
{
	/*Countdown before generation attempt is made*/
	int preg;
	/*Max value of preg*/
	int gestation;
	/*Current ctbl type considered for generation*/
	int type;

} C_GENERATE;

/*
typedef struct
{


} C_DEFN;
*/



/*One entry for each TYPE of collectable*/
typedef struct
{

	/*Message printed when user picks up ctbl*/
	char text[TCW_AUTO_MESSAGE];

	/*Function used to activate ctbl*/
	void (*ctbl_func) (int ctbl_func_arg, char onoff);

	/*Argument for function used by ctbl*/
	int farg;

	/*General type of ctbl. ie INSTANT, TIMED, USES*/
	char gType;


	/*Number of possible ctbl positions*/
	int posnum;
	/*pointer to possible positions*/
	char *pos;
	/*Max allowable to be generated on this level*/
	int max;
	/*Num of this type currently in existence*/
	int num;
	/*most recent slot to have been EMPTIED*/
	int emptied;

	/*Number of items of this type held by LOCAL tank*/
	int held;

	void *affected_val;

	int default_val;
	int max_val;
	int increments;



	/*Only used by collectables which are 'used up' after
		a preset amount of time*/
	int cdown;
	int cdown_max;

	char sprite;

}COLLECT_STAT;




extern C_GENERATE cGen;

/*Stats on each TYPE of collectable for a level*/
extern COLLECT_STAT cStat[COLLECT_TYPES];

//extern char cSprite[];

/*Level one's start positions for all object types*/
extern char cPositions1[];

/*Max countdown values for each object type*/
//extern int cExpiry[COLLECT_TYPES];


/*total ctbls held by player*/
extern int ALL_HELD;

/*Stop 'cant pickup' message being displayed >once for a ctbl*/
extern int PICKUP_TOGGLE;

extern int SWITCHED_PICKUP_TOGGLE;

/*************************************************************


										F U N C T I O N S

 *************************************************************/
/*************************************************************/


/*Clear preset collectables from map*/

void CLEAR_PRESET_COLLECTABLES (void);

/*Initialize a level's collectables stats base on cPositions array*/
void INITIALIZE_COLLECTSTATS (void);

/*Trigger any key-activated collectable which is held.*/
void TRIGGER_COLLECTABLE_EFFECT (void);

/*A fucking test*/
void TEST_GEN_COLLECT_GRID (void);

int GENERATE_COLLECTABLE (void);


/*Move collectable from map into tank*/
char PICKUP_COLLECTABLE (int mpos);


/*When a tank explodes, it drops all its collectables */
/*HOW should these be involved with cStats?*/

void SCATTER_COLLECTABLES (void);



/*Fun! Decrements all collectables countdowns. Destroys 'em
	when cdown is 0, and makes the neccesary change to the
	player's tank*/

/*Hmm. Perhaps this could be extended to ownerless and perhaps
  inaccessable collectables, so they can be relocated after a
	timeout*/

void COLLECTABLES_COUNTDOWN (void);


/*Reset all these to full when the player dies*/
void COLLECTABLES_COUNTDOWN_RESET (void);

/*These functions are called in objects.c using pointers
	GAME_ADDOBJ, GAME_REMOBJ */

void SHOK_ADDOBJ (OBJ_ADD *tAddObj);
void SHOK_REMOBJ (OBJ_REM *tRemObj);
void SHOK_MOVOBJ (OBJ_MOV *tMovObj);


extern int SHOW_CFLIGHT;



/*************************************************************/

/*************************************************************/


enum CTBL_EXPIRY_TYPES
{
	BLOW_JOB= 0,
	TRIGGERED= 1<<1
};

/*	These	functions relate specifically to the effects the
	collectables will have*/


void ctbl_tankStat (int uType, char onoff);

void ctbl_newWeapon (int wType, char onoff);

void ctbl_newSuperWeapon (int wType, char onoff);

void ctbl_upgradeShells (int stype, char onoff);

void ctbl_upgradeTank (int uType, char onoff);

void ctbl_tankStatus (int uType, char onoff);


/********/

void ctbl_resetShells (void);


void plyr_det_collectables (void);



#endif
