/*-----------------13/09/95 13:11-------------------

	-Network functions specific to ShellShock kept out of the
		other modules, so as not to sully Mansoor's divinely
		crafted code.

	-These functions are preceded by the names of
		modules to which they would otherwise belong.


--------------------------------------------------*/
#include <stdlib.h>
#include <stdio.h>

#include "chuck.h"
#include "e_global.h"
#include "frontend.h"
#include "moveanim.h"
#include "netextra.h"




/*************DISSOLVE**************/

/*Holds dissolving screen*/
uchar oscreen [OSCREEN_SIZE];
int dissolveFrame=0;




int ptiltlev;


/*************************************************************


				               G L O B A L S

 *************************************************************/
/*************************************************************/



/*EXPLOSION GLOBAL******/

DEATH_PARAMS dth;



INT rec_destructos= 0;
int send_destructos= 0;

int i,j;

SHELL_DATA *enemyShellPart[MAX_PLAYERS];

char HIT_BITS=0; /*detect which tanks were shot*/


uint GAME_LOOPS= 0;

int FLOOR_DAMAGE_PAKS= 0;
int WALLGROUP_DAMAGE_PAKS= 0;
int UNIWALL_DAMAGE_PAKS= 0;

/**************************************************************

					 				 'moveanim' globals

 *************************************************************/

/*Current human tank being dealt with*/
TANK *ctank;





/**************************************************************

		 (used by)				 SHOCK.C

 **************************************************************/


char SEND_DESTRUCTION;




/**************************************************************
													weapons.c
 **************************************************************/

/*Index after most recent shellslot to be freed*/
char SHELLSLOT_SEARCH=0;







/*************************************************************
								     	collide.c
 *************************************************************/

/*Is shell termination explosion to be transmitted?*/
char EXPLOSION_TRANSMITTER;





/*************************************************************


										F U N C T I O N S

 *************************************************************/
/*************************************************************/



/**************************************************************

							    	SHELL TRANSMISSION

 *************************************************************/




/*Puts local player's shell data into nMob format before
	transmission */
/*Size of each shell= 18*/
void shellsToNmobs (void)
{
	int i;
	char *bufPos= ntanks[myID]->buffer;
	/*Remember to predetermine this sometime*/
	int NMOB_OFS= sizeof(NMOB)- sizeof(short);


	for (i=0;i<MAX_PLAYER_SHELLS;i++)
	{
		if (playerShells[i].fired)
		{
			memcpy(bufPos, (char *) (playerShells+i), NMOB_OFS);
			((NMOB *) bufPos)->def= NMOB_SHELL;
		}
		else
		{
			/*If the NMOB has not been set to _EXPLODE in the main
				gameLoop, mark it as just... empty*/

			if ( ((NMOB *) bufPos)->def < NMOB_EXPLODE)
				((NMOB *) bufPos)->def= NMOB_EMPTY;

		}

		bufPos+=sizeof (NMOB);
	}


}




/*Takes remote player's shell data from nMob format and places
	it in enemyShells list. */

void nMobsToShells (int plr)
{
	int i;
	char *bufPos= ntanks[plr]-> buffer;
	SHELL_DATA *enemyShellPos= enemyShellPart[plr];

	int NMOB_OFS= sizeof (NMOB)- sizeof (short);
	int vectorSz= 3*sizeof (int);

	short *typeOfNmob;

	for (i=0;i<MAX_PLAYER_SHELLS;i++)
	{
		typeOfNmob= (short *) (bufPos+NMOB_OFS);

		if (*typeOfNmob!=NMOB_SHELL)
		{
			if (enemyShellPos->fired)
			{
				/*NMOB is newly EXPLODED or EMPTY*/
				enemyShellPos->fired=0;
				/*Trigger explosion if necc*/
				if ((*typeOfNmob)>=NMOB_EXPLODE)
				{
			 		/*Final vector position of shell is at bufPos*/
			 		trigger_explosion
						((*typeOfNmob)- NMOB_EXPLODE, (POSITION *) bufPos,NULL);
				}
			}
		}
		else
		{
			ALL_SHELLS++;

			/*Copy info for 'fired' shell*/
			enemyShellPos->fired=1;
			memcpy ((char *) enemyShellPos, bufPos,NMOB_OFS);
		  memcpy ((char *) &(enemyShellPos->ox),bufPos,vectorSz);

		}

		enemyShellPos++;
		bufPos+=sizeof (NMOB);

	}

}




/**************************************************************

									  	   MOVEANIM.C

 **************************************************************/

/*Sets up mobs used in network game */

void nv_setup_mobs (void)
{
	cmob= mob;

	get_human_enemy_tanks();
 	get_shells();

	//get_single_shell();

	cmob->m_def = 0xffff;
}


/*duplicated from MOVEANIM.C*/
#define MOB_DISPLAY_RANGE (48<<24)

/*Put Remote Human Players into the mob list*/

void get_human_enemy_tanks(void)
{

	for (i=0; i<myGame.noPlayers; i++ )
	{
		j=playerList.qi[i];

		if (j!=myID)
		{
			ctank= tanks[j];


			if ( ctank->def && (ctank->def!=REGENERATE_OBJECT))
			{
				ctank->sy = -1;

				/*Make sure tank is within visible range*/
		  	if ( (abs(ctank->x-pl.x)<MOB_DISPLAY_RANGE) && ((abs(ctank->z-pl.z)<MOB_DISPLAY_RANGE)) )
				{
   		 		cmob->m_ang = (32 - ((pangle - ctank->angle) >>5) )&0x3f;
			 		/*tank->angle is direction it's TRYING to move in*/

		 			cmob->m_x 	= ctank->x>>16;
   	 	 		cmob->m_y 	= ctank->y;
	 	 	 		cmob->m_z 	= ctank->z>>16;
	 	 	 		cmob->m_def = ROTATING_OBJECT_TAG+ctank->def;
	 	 	 		cmob->m_plyr = (j<<8) + TANK_TAG;
			 		/* Tag to position in enemy tank list. */
	 	 	 		cmob++;
				}
			}
		}
	}
}



/**************************************************************

													COLLIDE.C

 *************************************************************/


/*MARK player shell in ntank output buffer as EXPLODING */
void SHELL_EXPLODE_REMOTE (char i, short eType)
{
	NMOB *eShell= (NMOB *) (ntanks[myID]->buffer);

	(eShell+i)->def=NMOB_EXPLODE+eType;
}





/**************************************************************

 TRANSMISSION OF DESTRUCTION!
											 								(Heavy Metal Band)

 *************************************************************/


/**************************************************************
										SEND OBJECT DESTRUCTION
 **************************************************************/




/*For a wall to be destroyed, makes a REMOBJ packet and adds
	it to the output buffer. Fucking Top. */

void WALLDESTRUCTO_TO_OUTPUT_BUFFER (WALL_DATA *detwall)
{
	OBJ_REM tRemObj;

	if (!(nDef.flags&RDAMAGE_WALLS))
		return;

	tRemObj.type=DT_WALL;
	tRemObj.id= (short) (detwall- wallSfcs);

	REMOBJ_TO_OUTPUT_BUFFER (&tRemObj);
	send_destructos+=TRANSMIT_OBJECT_DATA();

}



void OBJECTDESTRUCTO_TO_OUTPUT_BUFFER (SHELL_DATA *shellptr)
{
	OBJ_REM tRemObj;
	uchar tilePos[2];

	if (!(nDef.flags&RDAMAGE_OBJECTS))
		return;

	tilePos[0] = (uint)shellptr->x>>24;
	tilePos[1] = (uint)shellptr->z>>24;

	tRemObj.type= DT_FLOOR;
	tRemObj.id= * ((short *) tilePos);

	REMOBJ_TO_OUTPUT_BUFFER (&tRemObj);
	send_destructos+=TRANSMIT_OBJECT_DATA();

}





void CRUSHDESTRUCTO_TO_OUTPUT_BUFFER (WALL_DATA *detwall)
{
	OBJ_REM tRemObj;

	if (!(nDef.flags&RDAMAGE_CRUSH))
		return;


	tRemObj.type= DT_CRUSH;
	tRemObj.id= detwall - wallSfcs;

	REMOBJ_TO_OUTPUT_BUFFER (&tRemObj);
	send_destructos+=TRANSMIT_OBJECT_DATA();

}



void FLOORCRUSHDESTRUCTO_TO_OUTPUT_BUFFER (ushort block)
{
	OBJ_REM tRemObj;

	if (!(nDef.flags&RDAMAGE_FLOORCRUSH))
		return;

	tRemObj.type= DT_FLOORCRUSH;
	tRemObj.id= block;

	REMOBJ_TO_OUTPUT_BUFFER (&tRemObj);
	send_destructos+=TRANSMIT_OBJECT_DATA();


}


/*Jeeziz! Bodgy little way of saying one tank killed the others*/
void HUMANTANKDEATH_TO_OUTPUT_BUFFER (char murderer,char murderee)
{
	OBJ_REM tRemObj;
	uchar funny[2];

	funny[0]= murderer;
	funny[1]= murderee;

	tRemObj.type= DT_HUTANKDEATH;
	tRemObj.id= *((short *) funny);

	REMOBJ_TO_OUTPUT_BUFFER (&tRemObj);
	send_destructos+=TRANSMIT_OBJECT_DATA();

}



/*Creates the standard wall detection globals. Returns if it has
	already been destroyed or not*/
int wallStatus (WALL_DATA *aWall)
{

	if (aWall->wallType==TOTALLED_TEXTURE)
		return(1);


	cWallType = aWall->wallType & 0x3;
	cWallHeight = (aWall->wallType>>9)&0xf;
	cWallTexture = (aWall->wallType&0x1f8) >> 3;
	cDetectType =
		(cDestroyable =
			wdetect_info[cWallType].detectType[cWallTexture])&0x3;
	cDestroyable&=4;


	if (!cDetectType)
		/*Wall has been destroyed*/
		return (1);
	else
		return (0);

}



/**************************************************************

									RECEIVE OBJECT DESTRUCTION

 **************************************************************/


/*Reads the REMOBJ info from the input buffer, converts it to
 the appropriate entity, and calls the approp. function to
 destroy the fackah! */

#define SHELL_START_HEIGHT -0X110


/*-----------------02/11/95 20:55-------------------
	Tests implemented, to check if an item is already
	destroyed before attempting to destroy it.
--------------------------------------------------*/

void destructo (OBJ_REM *tRemObj)
{
	WALL_DATA *detwall;
	POSITION shellPos;
	char *tilePos;
	uchar *funny;
	short map_val;
	uchar *map_ptr;


	switch (tRemObj->type)
	{
		case DT_WALL:
			if (tRemObj->id>=numSfcs)
				net_getout("Remote wall out of range, you cunt");
			detwall= wallSfcs+tRemObj->id;
			/*The following includes an 'already destroyed?' test*/
			remote_destroy_group(detwall);
			rec_destructos++;
			break;

		case DT_FLOOR:
			tilePos= (char *) &(tRemObj->id);
			shellPos.x= (uint) *tilePos;
			shellPos.x= shellPos.x<<24;
			shellPos.y= SHELL_START_HEIGHT;
			shellPos.z= (uint) (*(tilePos+1));
			shellPos.z= shellPos.z<<24;

			shellPos.x+=(128<<16);
			shellPos.z+=(128<<16);
			remote_destroy_block (&shellPos);
			rec_destructos++;
			break;

		case DT_CRUSH:
				detwall= wallSfcs + tRemObj->id;
				/*returns '1' if wall already destroyed*/
				if (wallStatus(detwall)) break;
				SEND_DESTRUCTION=0;
				crush_texture(detwall);
				SEND_DESTRUCTION=1;
				rec_destructos++;
				break;



		case DT_FLOORCRUSH:
				map_ptr= obj_map+ tRemObj->id;
				map_val= det_tabs[region][(((*map_ptr)-1)<< 1)+1];

				if (map_val & DET_TANK_D )
					*map_ptr= map_val >>8; /*Replace/remove object*/

				break;

		/*Prints a message saying who killed who*/
		case DT_HUTANKDEATH:
				funny = (uchar *) &tRemObj->id;
				MURDER_MESS ((int) *funny,(int) *(funny+1));
				break;


		default:
			break;

	}


}



/*Blah, Blah, destroy object(if any) at position */
/*analagous to 'shell.det' in plyr_det.c */
/*check_shell does the object destruction*/

void	remote_destroy_block(POSITION	*explpos)
{
	int	relx, relz;
	uint	dist;
	int	ftype;

	/*AH-HAAAA!!!!*/
	/*Output info related to destroyed shell*/

	if (nDef.flags&RFLOOR_OUTPUT)
	{
		fp=fopen ("c:\\rfloor.txt","a+");
 		fprintf (
 		fp,"x %i  y %i  z %i  ",explpos->x,explpos->y,explpos->z);
 		fclose (fp);
	}

	if( !(ftype = check_shell(explpos->x, explpos->y, explpos->z, 0)))	/* Check only block which shell is over. */
		return ;

	if (nDef.flags&RFLOOR_OUTPUT)
	{
		fp=fopen ("c:\\rfloor.txt","a+");
 		fprintf (fp,",type %i...",ftype);
 		fclose (fp);
	}

	/*PROXIMITY CHECK FOR EXPLOSION*/
	relx = abs((pl.x>>16) - (explpos->x>>16));
	relz = abs((pl.z>>16) - (explpos->z>>16));

	if ( relx>relz )
		dist=relx+(relz>>1);
	else
		dist=relz+(relx>>1);
	/***********************************/


	if ( dist<=0x2800 )
	{
		if ( ftype>=9 )
		{
			trigger_fragments(12, explpos, TREE_FRAGMENTS);
			trigger_shroom(explpos, SMALL_SHROOM);
		}
		else
			trigger_fragments(4, explpos, METAL_FRAGMENTS);

		#ifdef PC_VERSION
			shell_explosion_sound(explpos->x, explpos->z);
		#endif


	}

	if (nDef.flags&RFLOOR_OUTPUT)
	{
		fp=fopen ("c:\\rfloor.txt","a+");
		fprintf (fp," finished that. \n");
		fclose (fp);
	}


}







/**************************************************************

							    		U T I L S . C

 *************************************************************/


char	gentempstr[256];


void drawTextBox (int xbox,int ybox,int wbox, uchar bcol)
{
	int y1,y2;
	int x1,x2;
	int x,y;
	uchar *toscr;


	y1= ybox;
	y2= ybox+5;
	x1= xbox;
	x2= xbox+wbox;

	for (y= y1;y<y2;y++)
	{
		toscr= p1screen + x1+y*NSCR_WIDTH;

		for (x= x1;x<x2;x++,toscr++)
		{
			*toscr= interpol_tab[((*toscr)<<8)+bcol];
		}

	}

}


/*Draw highlighting strips under each line of text*/
void drawTextBoxes (int ymess)
{
	int i;

	/*
	draw_transparent_box
	(TPW_MESSAGE_POS,ymess, TPW_MESSAGE_POS+(TCW_AUTO_MESSAGE*4),
		ymess+(8*MAX_SHOW_NET_MESSAGES),240);
	 */


	for (i=0;i<MAX_SHOW_NET_MESSAGES;i++)
	{
		drawTextBox (TPW_MESSAGE_POS,ymess,TCW_AUTO_MESSAGE*4,240);

		ymess+=8;
	}

}


void	draw_netgame_screen(void)
{
	int yoffset;
	int	i, x, y;



	yoffset = (tiltLev>>4)&0x0f;

	scr_ptr = p1screen;


	/*DISPLAY PLAYER NAMES AND SCORES************************/
	x=0;
	y=12;

	for ( i=0; i<MAX_PLAYERS; i++ )
	{

		if (i&1)
			x=251;
		else
		{
			x=0;
			y+=8;
		}


		/*If colour !=0, slot was once occupied*/
		if (playerPaks[i].colour!=0)
		{
			if (playerList.slot[i]==1)
			{
				txt_print_colr= 238;/*YELLER*/
 				if (TEXT_MODE&&TEXT_SLOT[i])
					sprintf(gentempstr,"%i+%10.10s %04d",i, playerPaks[i].name, ntanks[i]->marks);
	 			else
		 			sprintf(gentempstr,"%i %10.10s %04d",i, playerPaks[i].name, ntanks[i]->marks);
			}
			else
			{
				txt_print_colr= 240;/*GREY*/
				sprintf(gentempstr,"%i %10.10s %04d",i, playerPaks[i].name, ntanks[i]->marks);
			}
		_print_string(x, y+yoffset, gentempstr, SINGLE_COLOURED_PRINT);
		}
	}


	/*DISPLAY NETWORK GAME MESSAGES*****************************/

	/*Box lying under each strip of text, to highlight it*/
	drawTextBoxes (20+yoffset);

	displayTextMessages(20+yoffset);

	/*DISPLAY USER'S TEXT MESSAGE ENTRY*************************/

	if (TEXT_MODE)
		displayUserText ();

	if (SHOW_DIAGNOSTICS)
	{
		NETWORK_DIAGNOSTICS();

	}

	scr_ptr = p1screen + 16*320 + (yoffset*320);
	/*_dump_game_screen();*/
}


/*Called at start of level- places indestructable barrier
 around edge of map*/
/*Shit- need to insert 4 points AND 4 surfaces*/


void barrierCreate (void)
{


}





/*dissolve between old screen and new*/
void dissolve2 (void)
{
	int i;
	uchar dval;
	int divide;
	ushort ipol;

	uchar *oldptr;
	uchar *newptr;


	for (i=0;i<320*110;i++)
	{
		oldptr= oscreen+i;
		newptr= p1screen+16*320+i;


		ipol= (ushort) *oldptr;
		ipol=ipol<<8;

		ipol+= (ushort) *newptr;


		/*Get value between old and new.*/
		/*Old gets closer to new with each dissolve frame*/
		dval= interpol_tab[ipol];

		divide= (dissolveFrame&0xf)>>1;

		/*Now move dval as close to old as possible*/
		while (divide>1)
		{
			ipol= (ushort) dval;
			ipol=ipol<<8;

			ipol+= (ushort) *oldptr;

			dval= interpol_tab[ipol];

			divide= divide>>1;
		}

		*oldptr= dval;

	}

	/*dump to video!!!*/
	//debug_msg ("%i",*(oscreen+320*60+160));
	memcpy ((char *) (0xa0000+16*320),oscreen,320*110);

	dissolveFrame--;
}




/*dissolve between old screen and new*/
void dissolve (void)
{
	int i;
	uchar dval;
	int divide;
	ushort ipol;

	uchar *oldptr;
	uchar *newptr;
	int yoffset;

	yoffset = (tiltLev>>4)&0x0f;

	for (i=0;i<320*110;i++)
	{
		newptr= (uchar *) (0xa0000+16*320+i);
		oldptr= (uchar *) (p1screen+(16+yoffset)*320+i);


		ipol= (ushort) *oldptr;
		ipol=ipol<<8;

		ipol+= (ushort) *newptr;


		/*Get value between old and new.*/
		/*Old gets closer to new with each dissolve frame*/
		dval= interpol_tab[ipol];

		//divide= (dissolveFrame&0xf) >>1;

		divide= 1;

		if (dissolveFrame<DISSOLVE_DISSOLVE)
			divide= 2;

		//if (dissolveFrame<9)
			//divide= 9-dissolveFrame;

		/*Now move dval as close to old as possible*/
		while (divide>1)
		{
			ipol= (ushort) dval;
			ipol=ipol<<8;

			ipol+= (ushort) *oldptr;

			dval= interpol_tab[ipol];

			divide= divide>>1;
		}

		*oldptr= dval;

	}

	/*dump to video!!!*/
	//debug_msg ("%i",*(oscreen+320*60+160));

	if (SHOW_DIAGNOSTICS)
	{
		NETWORK_DIAGNOSTICS();
	}

	scr_ptr = p1screen + 16*320 + (yoffset*320);
	_dump_game_screen();
}


#define EXPLOSION_MAX 400


void fire_tank (void)
{
	/*Colours 230 to 239*/
	char *newptr;
	int ECOL;
	uchar dval;
	ushort ipol;
	int yoffset;

	ECOL= 239;

	yoffset = (tiltLev>>4)&0x0f;
	newptr= p1screen+(16+yoffset)*320+i;

	for (i=0;i<110*320;i++)
	{

		ipol= (ushort) *newptr;
		ipol=ipol<<8;

		ipol+= (ushort) ECOL;

		/*Get value between old and new.*/
		/*Old gets closer to new with each dissolve frame*/
		dval= interpol_tab[ipol];
		*newptr= dval;

		newptr++;
	}

	scr_ptr = p1screen + 16*320 + (yoffset*320);
	_dump_game_screen();

}



/*Non-leader picks up on LEADER's game changes*/

void MYGAME_CHANGES (void)
{
	/*LEVEL change*/
	if (myGame.level!=game_data.mission)
	{
		/*Change level, then wait for LEADER to reenter game
			before entering the COOL ZONE*/
		PLAYER_CHLEV_PHASE ();
	}

	MYGAME_CHANGED= 0;
}



/**************************************************************

											 SHOCK.C

 -network only stuff which used to be in shock.c

 **************************************************************/



/*Really shit, annoying little text window*/

void smess (short x,short y,int num, char *text )
{
	char digit[256];

	if (y==0)
	{
		y=MESS_Y;
		MESS_Y+=7;
	}

	sprintf (digit,"%s %d",text,num);
	_print_string (x,y,digit, SINGLE_COLOURED_PRINT);
}



void NETWORK_DIAGNOSTICS (void)
{

	char s1[80];
	char s2[80];
	int yoffset;
	int i;

	yoffset = (tiltLev>>4)&0x0f;


	txt_col+=add_txt_col;

	if (txt_col==230||txt_col==239)
	{
		add_txt_col=0-add_txt_col;
	}


	MESS_Y= 16+yoffset;

	if (dissolveFrame )
		MESS_Y= yoffset;


	txt_print_colr= txt_col;
	/*251==BRIGHT_GREEN*/

	smess (1,0,frames," frames");

	smess (1,0,rec_destructos," rec_destructos");
	smess (1,0,send_destructos," send_destructos");
	smess (1,0,myID," myID");
	smess (1,0,me.node," myNode");
	smess (1,0,WRITE_O," WRITE_O");
	smess (1,0,collectList.els," Ctbls");

	smess (1,0,ALL_HELD," Held");

	smess (1,0,game_data.mission," level");
	//smess (1,0,recwantsame, " recwantsame");
	smess (1,0,worldSends, " wSendTries");
	smess (1,0,initWorldSends," initWorldSends");
	smess (1,0,DAMAGE_ID," DAMAGE_ID");
	smess (1,0,WORLD_ID," WORLD_ID");
	/*smess (1,0,nmsg.num," TEXT MSGS");   */


	smess (1,0,SWITCHED_PICKUP_TOGGLE," SWITCH_PTOG");

	/*
	smess (1,0,tanks[myID]->y," HEIGHT");
	smess (1,0,tanks[myID]->angle," angle");
	mess (1,0,NUM_VAPES," VAPES");
	mess (1,0,NUM_FOBJS," NUM_FOBJS");
	mess (1,0,FOBJS_SENT," FOBJS_SENT");
	mess (1,0,DAMAGE_COUNT," DAMAGE_COUNT");

	mess (1,0,net[0]->REC_SERIAL," got f 0");
	mess (1,0,net[0]->WANT_SERIAL," want f 0");
	mess (1,0,comm[0]->REC_SERIAL," 0 got");
	mess (1,0,comm[0]->WANT_SERIAL," 0 wants");
	mess (1,0,ntanks[myID]->STATUS," mySTATUS");
	mess (1,0,shellkillx," shellkillx");
	mess (1,0,shellkillz," shellkillz");*/

	/*DIAGNOSTIC_TEXT(); */

	/*
	if (myID==LEADER_ID)
	{
		sprintf (digit, "LEADER %d",(char) myGame.UID);
		print (100,1,digit);
	}

	if (IM_A_GOD) print (80,1,"GOD");

	print (244,1,"Version Melt");
	*/

	if (IM_A_GOD)
		sprintf (s2,"%s",
		" myID %d  LEADER_ID %d    -+GOD+-           Version MELT");
	else
		sprintf (s2,"%s",
		" myID %d  LEADER_ID %d                      Version MELT");

	sprintf (s1,s2,myID,LEADER_ID);


	_print_string (0,120+yoffset,s1, SINGLE_COLOURED_PRINT);



}






/**************************************************************
 **************************************************************
 **************************************************************/


/*Shells fired are initially parallel to each other, with a
	gradual spread apart*/
/*This NEEDS better hit detection* * * *********/

char NET_WEAPONS (TANK *tank)
{
	int angle_spread=15;


	if (tank->cWeapon == TRIPLE)
	{
		/*Max 6 shells aloft at once*/
		if (tank->shellDelayCount/*||numShotsFired>=6*/)
			return(1);

		/*LEFT*/
		tank->angle-=angle_spread;
		fire_shell (tank);
		tank->shellDelayCount= 0;

		/*RIGHT*/
		tank->angle+=(2*angle_spread);
		fire_shell (tank);
		tank->shellDelayCount=0;

		/*MIDDLE*/
		tank->angle-=angle_spread;
		fire_shell(tank);
		tank->shellDelayCount= tank->shellDelay*2;

		return (1);
	}
	return (0);
}




/*************************************************************

											KILL_FREQUENCY STUFF

	*************************************************************/

int KILL_FREQ_COUNT=0;
int KILL_FREQ_TOGGLE=1;
ushort RECORDED_MARKS[MAX_PLAYERS];



/*THIS IS DONE
			-by the leader when a new player joins
			-by a player which newly becomes the leader
			-by the leader at the start of a level
			-by the leader after a kill freq update
 */


void RECORD_MARKS (void)
{
	int i,j;

	for (i=0;i<myGame.noPlayers;i++)
	{
		j= playerList.qi[i];

		RECORDED_MARKS[j]= ntanks[j]->marks;
	}


	KILL_FREQ_COUNT= 0;
}


/*Leader compares current marks with previously recorded
	marks, and states which players have the best/worst kill
	frequencies*/

void KILL_FREQUENCY_UPDATE (void)
{
	ushort noteFreq;
	int notePlr;
	ushort tFreq;
	int first=1;
	int tie;

	int i,j;


	if (myGame.noPlayers==1)
		return;


	for (i= 0;i<myGame.noPlayers;i++)
	{
		j= playerList.qi[i];

		tFreq= ntanks[j]->marks- RECORDED_MARKS[j];

		if (first)
		{
			noteFreq= tFreq;
			notePlr= j;
			tie= 1;
		}
		else
		{
			tie= 0;

			if (noteFreq==tFreq)
			{
				/*2 or more players have same score*/
				tie= 1;
				break;
			}

			if (KILL_FREQ_TOGGLE)
			{
				/*Highest freq*/
				if (tFreq>noteFreq)
				{
					noteFreq= tFreq;
					notePlr= j;
				}


			}
			else
			{
				/*Lowest freq*/
				if (tFreq<noteFreq)
				{
					noteFreq= tFreq;
					notePlr= j;
				}

			}

		}

		first= 0;
	}


	/*If no tie, send kill freq status to all*/
	if (!tie)
	{
		if (KILL_FREQ_TOGGLE)
		{
			sendAutoMess
				(AM_HIGH_KILL_FREQ,notePlr,NULL);
		}
		else
		{
			sendAutoMess
				(AM_LOW_KILL_FREQ,notePlr,NULL);
		}

	}

	RECORD_MARKS();
	/*Reset this when a new player becomes leader*/
	KILL_FREQ_TOGGLE= 1- KILL_FREQ_TOGGLE;

}


