	.386

	.MODEL	flat,stdcall


	INCLUDE	aglobals.h

FLOOR_MODE	EQU	2     		; 0 = Normal. 1 = fat pixel X. 2 = fat pixel X & Y.
NSCR_WIDTH	EQU	320
INTERP_DIVIDE	EQU	8		; >>8 FOR 256x256 interpolation table

SPARKLE_COLOUR	EQU	254
SPARKLE_FLAG	EQU	1
RIPPLE_FLAG	EQU	2



	.DATA


FXLOOP		DWORD	0
fyloop		dword	0
yloop1		dWORD	0
sedi		DWORD	0
seax		DWORD	0
xoff		DWORD	0
esioff		DWORD	0
txstart		DWORD	0
ceiling		DWORD	0


;SEAX2		DWORD	0
TRANSOFFSET	DWORD	0
TILEBASE	DWORD	0
FLIPBASE	DWORD	0
PREV_PIXEL	DWORD	0
NEW_PIXEL	DWORD	0

REF_SRC		DWORD	0
RIPPLE_OFF	DWORD	0

xloop		sWORD	0
YLOOP		SWORD	0



ftX	= 	0			; unflipped 0
	REPT	32*32
IFNDEF	FLIPtab
FLIPTAB	DD	FTX
ELSE
	DD	FTX
ENDIF
	FTX=	FTX+1
	ENDM




FTX	=  	31			; unflipped 270
	REPT	32
FTY	=	ftX
	REPT	32
	DD	FTY
	FTY=	FTY+32
	ENDM
	FTX=	FTX-1
	ENDM





ftx	=	(32*32)-1
	rept	32*32
	dd	ftx			; 180.
ftx	=	ftx-1
	ENDM





ftx	=	32*31
	rept	32
fty	=	ftx
	rept	32
	dd	fty			; 90.
fty	=	fty-32
	endm
ftx	=	ftx+1
	endm





ftx	=	31
	rept	32
fty	=	ftx
	rept	32
	dd	fty			; flipped.
fty	=	fty-1
	endm
ftx	=	ftx+32
	endm





ftx	=	(32*32)-1
	rept	32
fty	=	ftx
	rept	32
	dd	fty			; 90 + flipped.
fty	=	fty-32
	endm
ftx	=	ftx-1
	endm





ftx	=	31*32
	rept	32
fty	=	ftx
	rept	32
	dd	fty			; 180 + flipped.
fty	=	fty+1
	endm
ftx	=	ftx-32
	endm





ftx	=	0
	rept	32
fty	=	ftx
	rept	32
	dd	fty			; 270 + flipped.
fty	=	fty+32
	endm
ftx	=	ftx+1
	endm









	.CODE



DRAW_INTERPOL_FLOOR_	PROC C PUBLIC

;
;	floordraw using interpolated fat pixel
;

	PUSHAD

	MOV	FYLOOP,8
	MOV	REF_SRC,0


	mov	edi,scr_ptr

	mov	ebx,odepths
	add	ebx,256*7

@@dcyloop1:
	movsx	ecx,[eax+tvb.t_xstart]
	mov	txstart,ecx
	movsx	ecx,[eax+tvb.t_ystart]
	movsx	edx,[eax+tvb.t_dx]
	movsx	ebp,[eax+tvb.t_dy]

	shl	txstart,13		; X start
	shl	ecx,13			; Y start

	shl	edx,6			; DX
	shl	ebp,6			; DY
	mov	fxloop,NSCR_WIDTH/2

	mov	seax,eax


; Get first calculated pixel in scan and store it

@@DCXLOOP11:
	mov	esi,txstart
	mov	eax,ecx
	and	esi,1fe00000h ;0fe00000h
	and	eax,1fe00000h ;0fe00000h
	shr	esi,20
	shr	eax,12 ; 13 for 128x128 map

;
	ADD	EAX,FLOOR_MAP
	movzx	eax,word ptr [esi+eax];

	PUSH	EAX

	MOV	ESI,TXSTART
	MOV	EAX,ECX

	SHR	ESI,16
	and	eax,1f0000h

	AND	ESI,1FH
	SHR	EAX,11

	ADD	EAX,ESI

	pop	esi

	add	ESI,TILE_LOOKUP		; esi points to offset of tile bitmap

	add	esi,BLOCK_DATA		; ESI POINTS TO START OF TILE BITMAP

	movzx	eax,byte ptr [esi+eax]

	or	eax,eax				; Test for a reflection pixel
	je	@@reflect1

ret1:
	MOV	AL,[EBX+EAX];

	ADD	ECX,EBP

	mov	prev_pixel,eax			;

	ADD	TXSTART,EDX

	INC	REF_SRC				; Update the reflection pointer

;Do rest of scan

@@dcxloop1:
	mov	esi,txstart
	mov	eax,ecx
	and	esi,1fe00000h
	and	eax,1fe00000h
	shr	esi,20
	SHR	EAX,12				; 13 for 128x128 map

	ADD	EAX,FLOOR_MAP
	movzx	eax,word ptr [esi+eax];

; flip and rotate lookups

	push	eax			; store value

	mov	esi,ebx
	mov	eax,ecx

	SHR	ESI,16
	and	eax,1f0000h

	AND	esi,1FH
	SHR	EAX,11

	ADD	EAX,ESI			; eax contains offset into a tile bitmap **

	pop	esi

	add	ESI,TILE_LOOKUP		; esi points to offset of tile bitmap

	add	esi,BLOCK_DATA		; ESI POINTS TO START OF TILE BITMAP

	movzx	eax,byte ptr [esi+eax]


	or	eax,eax				; Test for a reflection pixel
	je	@@reflect2

ret2:
	;XLATB
	MOV	AL,[EBX+EAX];


	mov	esi,eax			; Store calculated pixel for next pair

;Interpolation stuff

	shl	eax,INTERP_DIVIDE
	ADD	EAX,prev_pixel          ; Get interpolation colour index

	MOVZX	EAX,BYTE PTR INTERPOL_TAB[EAX]   ; Get interpolated pixel colour

	SHL	EAX,8			; Move into top byte
	or	eax,prev_pixel		; Get previous pixel into bottom byte

	add	ecx,ebp

	MOV	[EDI],AX		; Store calculated pair

;end of interpolation stuff

	add	txstart,edx
	INC	EDI
	INC	REF_SRC			; Update the reflection pointer
	MOV	prev_pixel,ESI		; Store pixel for next pair
	INC	EDI
	INC	REF_SRC                 ; Update the reflection pointer (skip because of interpolation)

	dec	fxloop
	jnz	@@dcxloop1

	sub	ebx,256

	ADD	dword ptr REF_SRC, 511;

	mov	eax,seax
	add	eax,8


	dec	fyloop
	jnz	@@dcyloop1

; Non depth cued part

@@NDEPTH_CUE:
	movzx  	ebx,scr_height
	sub	ebx,9			; floor draw only 59 scans deep in total : scr_height = 60
	mov	fyloop,ebx

@@yloop:
	movsx	ebx,[eax+tvb.t_xstart]
	movsx	ecx,[eax+tvb.t_ystart]
	movsx	edx,[eax+tvb.t_dx]
	movsx	ebp,[eax+tvb.t_dy]

	shl	ebx,13			; X start
	shl	ecx,13			; Y start

	shl	edx,6			; DX
	SHL	EBP,6			; DY

	mov	fxloop,NSCR_WIDTH/2	; Changed from 288 to 320

	mov	seax,eax

; Get first pixel in scan

@@x1st_pixel:
	mov	esi,ebx
	mov	eax,ecx
	and	esi,1fe00000h		;
	and	eax,1fe00000h           ;
	shr	esi,20                  ;
	shr	eax,12                  ; 13 for 128x128 map

	ADD	EAX,FLOOR_MAP
	MOVZX	EAX,WORD PTR [ESI+EAX];	; Get block value.

	push	eax			; store value

	mov	esi,ebx
	mov	eax,ecx

	SHR	ESI,16
	and	eax,1f0000h

	AND	esi,1FH
	SHR	EAX,11

	ADD	EAX,ESI			; eax contains offset into a tile bitmap **

	pop	esi

	add	ESI,TILE_LOOKUP		; esi points to offset of tile bitmap

	add	esi,BLOCK_DATA		; ESI POINTS TO START OF TILE BITMAP

	movzx	eax,byte ptr [esi+eax]

	or	eax,eax			; Test for a reflection pixel
	je	@@reflect3

ret3:
	MOV	PREV_PIXEL,EAX		; Store 1st pixel

	ADD	EBX,EDX
	ADD	ECX,EBP

	INC	REF_SRC			; Update the reflection pointer

; Do rest of scan

@@xloop:
	mov	esi,ebx
	mov	eax,ecx
	and	esi,1fe00000h		;
	and	eax,1fe00000h           ;
	shr	esi,20                  ;
	shr	eax,12                  ; 13 for 128x128 map

;
	ADD	EAX,FLOOR_MAP
	movzx	eax,word ptr [esi+eax];

	push	eax			; store value

	mov	esi,ebx
	mov	eax,ecx

	SHR	ESI,16
	and	eax,1f0000h

	AND	esi,1FH
	SHR	EAX,11

	ADD	EAX,ESI			; eax contains offset into a tile bitmap **

	pop	esi

	add	ESI,TILE_LOOKUP		; esi points to offset of tile bitmap

	add	esi,BLOCK_DATA		; ESI POINTS TO START OF TILE BITMAP

	movzx	eax,byte ptr [esi+eax]

	or	eax,eax				; Test for a reflection pixel
	je	@@reflect4

ret4:

; Interpolation stuff

	mov	esi,eax			; Store calculated pixel for next pair

	MOV	EAX,PREV_PIXEL

	shl	eax,8
	ADD	EAX,ESI                 ; Get interpolation colour table index

	MOVZX	EAX,BYTE PTR INTERPOL_TAB[EAX]   ; Get interpolated pixel

	SHL	EAX,8			; Move into top byte
	or	eax,PREV_PIXEL		; Get previous pixel into bottom byte

	MOV	[EDI],AX		; Store calculated pair

;end of interpolation stuf

	INC	EDI
	MOV	PREV_PIXEL,ESI		; Store pixel for next pair
	INC	REF_SRC			; Update the reflection pointer

	ADD	EBX,EDX
	INC	EDI
	INC	REF_SRC                 ; Update the reflection pointer

	add	ecx,ebp


	dec	fxloop
	jnz	@@xloop

	ADD	dword ptr REF_SRC, 511	; was 1024

	mov	eax,seax
	add	eax,8


	dec	fyloop
	jnz	@@yloop

	POPAD
	RET

@@REFLECT1:
	MOV	ESI,REFLECT_OFFSET
	ADD	esi,REF_SRC
	MOVZX	EAX,byte ptr[esi]
	JMP	RET1

@@REFLECT2:
	MOV	ESI,REFLECT_OFFSET
	ADD	esi,REF_SRC
	MOVZX	EAX,byte ptr[esi]
	JMP	RET2

@@REFLECT3:
	MOV	ESI,REFLECT_OFFSET
	ADD	esi,REF_SRC
	MOVZX	EAX,byte ptr[esi]
	JMP	RET3

@@REFLECT4:
	MOV	ESI,REFLECT_OFFSET
	ADD	esi,REF_SRC
	MOVZX	EAX,byte ptr[esi]
	JMP	RET4

REFLECTION:
	ret


DRAW_INTERPOL_FLOOR_	ENDP





	END
