#include "headers.h"
#include "chuck.h"
#include "walldraw.h"
#include "e_global.h"
#include "rshock.h"
#include "shock.h"

#include "iff.h"
#include "frontend.h"
#include "frontdef.h"
#include "frglobs.h"

#include "enemlogc.h"


#define TOO_CLOSE_TO_SHOW_DIST	0xa00

void	get_closest_convoy_leader(void);



void	check_objective(void)
{
	int relx, relz;

	if ( !objectiveAchieved )
	{
		/* Check if objective has been achieved */
  	switch ( objectiveType )
  	{
  		case DESTROY_ALL_ENEMIES_OBJECTIVE:
				if ( numObjectiveEnemies<=0 )
				{
					objectiveAchieved = TRUE;
					show_message(RENDEZVOUS_MESSAGE);
				}
				else
				{
					int	i;
					TANK	*closestTank=NULL, *ctank;
					GUN_EMPLACEMENT *cgunempl, *closestgunempl;
					int	gunemplcloser=FALSE;
					int	relx, relz, dist,minDist=0x7fffffff;

					for ( i=0, ctank=enemyTanks; i<MAX_ENEMY_TANKS; ctank++, i++ )
					{
						if ( ctank->def && (ctank->def!=REGENERATE_OBJECT) && (ctank->objectiveTarget) )
						{
							relx = abs((int)(((uint)pl.x>>16) - ((uint)ctank->x>>16)));
							relz = abs((int)(((uint)pl.z>>16) - ((uint)ctank->z>>16)));

							if ( relx>relz )
							{
								dist=relx + (relz>>1);
							}
							else
							{
								dist=relz + (relx>>1);
							}

							if ( dist<minDist )
							{
								closestTank=ctank;
								minDist=dist;
							}
						}
					}

					if ( closestTank!=NULL )
					{
						objectiveX = closestTank->x;
						objectiveZ = closestTank->z;
						showObjectiveDirn=TRUE;
					}

					for ( i=0, cgunempl=gunempls; i<MAX_GUN_EMPLS; i++, cgunempl++ )
					{
						if ( cgunempl->exist )
						{
							relx = abs((int)(((uint)pl.x>>16) - ((uint)cgunempl->x>>16)));
							relz = abs((int)(((uint)pl.z>>16) - ((uint)cgunempl->z>>16)));

							if ( relx>relz )
							{
								dist=relx + (relz>>1);
							}
							else
							{
								dist=relz + (relx>>1);
							}

							if ( dist<minDist )
							{
								closestgunempl=cgunempl;
								minDist=dist;
								gunemplcloser=TRUE;
							}
						}
					}

					if ( gunemplcloser )
					{
						objectiveX = closestgunempl->x;
						objectiveZ = closestgunempl->z;
						showObjectiveDirn=TRUE;
					}


				}
				break;

			case DESTROY_BUILDINGS_OBJECTIVE:
				if ( numObjectiveBuildingsLeft<=0 )
				{
					objectiveAchieved = TRUE;
					show_message(RENDEZVOUS_MESSAGE);
				}
				else
				{
					int i;
					int	relx, relz, dist,minDist=0x7fffffff;
					ushort	*cbtarg;	// current building target
					uint	obx, obz;

					for ( i=0, cbtarg=buildingTargetList; i<numBtargets; i++ )
					{
						if ( *cbtarg>0 )
						{
							cbtarg++;
							obx = *cbtarg++;
							obz = *cbtarg++;

							relx = abs(obx - (pl.x>>16));
							relz = abs(obz - (pl.z>>16));

							dist = (relx>relz) ? (relx+(relz>>1)) : (relz+(relx>>1));

							if ( minDist>dist )
							{
								minDist=dist;
								objectiveX = obx<<16;
								objectiveZ = obz<<16;
								if ( dist<TOO_CLOSE_TO_SHOW_DIST )
								{
									showObjectiveDirn=FALSE;
								}
								else
								{
									showObjectiveDirn=TRUE;
								}
							}
						}
						else
							cbtarg+=3;
					}
				}
				break;

			case DESTROY_CONVOY_OBJECTIVE:	/* mission unsuccessfull - enemy convoy reached destination */
				if ( convoyCompleted )
				{
					game_data.missstatus = MISSION_FAILED;
					//set_exit_game(ENDGAME_FUCKDUP);
				}
				else if ( totalConvoyMembers<=0 )
				{
					objectiveAchieved = TRUE; 	/* mission successfull - convoy destroyed */
					show_message(RENDEZVOUS_MESSAGE);
				}
				else
				{ // point objective indicator at leader of convoy
					get_closest_convoy_leader();
				}
				break;


			case PROTECT_CONVOY_OBJECTIVE:	/* mission successfull - allied convoy reached end */
				if ( convoyCompleted )
				{
					objectiveAchieved = TRUE;
					set_exit_game(ENDGAME_COMPLETED);
					game_data.missstatus = MISSION_SUCC;
				}
				else if ( convoyDestroyed ) 	/* Mission unsuccessfull - convoy destroyed */
				{
					game_data.missstatus = MISSION_FAILED;
					set_exit_game(ENDGAME_FUCKDUP);
				}
				else
				{ // point objective indicator at leader of convoy
					get_closest_convoy_leader();
				}
				break;


			case RESCUE_HOSTAGE_OBJECTIVE:
				if ( numHostagesLeft==0  )
				{
					if ( numHostagesCollected<numHostages )
					{
						game_data.missstatus = MISSION_FAILED;
						gotoRendezvous = TRUE;
					}
					else
					{
						objectiveAchieved = TRUE;
						show_message(RENDEZVOUS_MESSAGE);
					}
				}
				else
				{
					/* point objective indicator towards the nearest hostage */
					int	i;
					HOSTAGE	*chostage;
					int	relx, relz;
					int	dist;
					int	closestHostage=0;
					int	minDist=0x7fffffff;

					for ( i=0, chostage=hostages; i<MAX_HOSTAGES; i++, chostage++ )
					{
						if ( chostage->def )
						{
							relx = abs((int)(((uint)pl.x>>16) - ((uint)chostage->x>>16)));
							relz = abs((int)(((uint)pl.z>>16) - ((uint)chostage->z>>16)));

							if ( relx>relz )
							{
								dist=relx + (relz>>1);
							}
							else
							{
								dist=relz + (relx>>1);
							}

							if ( dist<minDist )
							{
								closestHostage=i;
								minDist=dist;
							}
						}
					}

					objectiveX = hostages[closestHostage].x;
					objectiveZ = hostages[closestHostage].z;

					showObjectiveDirn=TRUE;
				}
				break;
  	}
	}
	else
		start_message(DOG_TXT2);

	if ( objectiveAchieved || gotoRendezvous)
	{
		showObjectiveDirn=TRUE;

		objectiveX = rendezvousPoints[game_data.mission][0]<<24;
		objectiveZ = rendezvousPoints[game_data.mission][1]<<24;


		/* Objective achieved - need to reach rendezvous point */
		relx = (int)((pl.x>>24) - rendezvousPoints[missionNumber][0]);
		relz = (int)((pl.z>>24) - rendezvousPoints[missionNumber][1]);

		if ( (abs(relx)<4) && (abs(relz)<4) )
		{
			game_data.missstatus = MISSION_SUCC;
			set_exit_game(ENDGAME_COMPLETED);		/* Completed mission and reached rendezvous point */
		}
	}
}



void	get_closest_convoy_leader(void)
{
	int	j;
	TANK	*convoyLeaderTruck;
	GUN_BOAT	*convoyLeaderBoat;
	CONVOY_DATA *cConvoy;
	int	relx, relz, dist, minDist=0x7fffffff;

  for ( j=0, cConvoy=convoyData; j<MAX_CONVOYS; j++, cConvoy++ )
  {
		if ( cConvoy->numMembers )
		{
			switch ( cConvoy->convoyType )
			{
				case TRUCK_CONVOY:
					convoyLeaderTruck = enemyTanks+cConvoy->members[0];	// get the convoy leader

					relx = abs((int)(((uint)pl.x>>16) - ((uint)convoyLeaderTruck->x>>16)));
					relz = abs((int)(((uint)pl.z>>16) - ((uint)convoyLeaderTruck->z>>16)));

					if ( relx>relz )
					{
						dist=relx + (relz>>1);
					}
					else
					{
						dist=relz + (relx>>1);
					}

					if ( dist<minDist )
					{
						minDist = dist;
						objectiveX = convoyLeaderTruck->x;
						objectiveZ = convoyLeaderTruck->z;
						showObjectiveDirn = TRUE;
					}
					break;


				case GUNBOAT_CONVOY:
					convoyLeaderBoat = gunboats+cConvoy->members[0];	// get the convoy leader

					relx = abs((int)(((uint)pl.x>>16) - ((uint)convoyLeaderBoat->x>>16)));
					relz = abs((int)(((uint)pl.z>>16) - ((uint)convoyLeaderBoat->z>>16)));

					if ( relx>relz )
					{
						dist=relx + (relz>>1);
					}
					else
					{
						dist=relz + (relx>>1);
					}

					if ( dist<minDist )
					{
						minDist = dist;
						objectiveX = convoyLeaderBoat->x;
						objectiveZ = convoyLeaderBoat->z;
						showObjectiveDirn = TRUE;
					}
					break;
			}
		}
	}
}
