	.386

	.MODEL	flat,stdcall

	INCLUDE	aglobals.h

	.DATA





EXTERN C ctrlPanelBottom:PTR
EXTERN C COMPASS_DATA:PTR
EXTERN C RADAR_RING_DATA:PTR
EXTERN C DRAWFLAGS:PTR
EXTERN C CURRENT_FONT:PTR DWORD
extern c txt_print_colr:BYTE


xloop	SWORD	0
YLOOP	SWORD	0

TBUFSTART	DD 0

TILTBUF		DD 0,0,0,0,0,0,0,0

TILTTYPES	DD 0,   0,   0,   0,   0,   0,   0,   0			; Level
		dd 0,	0,   0,	  320, 0,   0,   0,   -320		; Tilt 1/2 left to right
		dd 0,   320, 0,   320, 0,   320, 0,   -960		; tilt 1/4 left to right
		dd 320, 320, 320, 320, 320, 320, 320, -2240		; tilt 1/8 left to right
		dd 0,	0,   0,   -320,0,   0,   0,   320		; tilt 1/2 right to left
		DD 0,   -320,0,   -320,0,   -320,0,   960		; tilt 1/4 right to left
		DD -320,-320,-320,-320,-320,-320,-320,2240		; tilt 1/8 right to left


CELLMAP         DB 1,0,0,0,0,0,0,0
		DB 1,0,0,0,0,0,0,1
		DB 1,0,0,0,0,0,0,1
		DB 1,0,0,0,0,0,0,1
		DB 1,0,0,0,0,0,0,1
		DB 1,0,0,0,0,0,0,1
		DB 1,0,0,0,0,0,0,1
		DB 1,0,0,0,0,0,0,1
		DB 1,0,0,0,0,0,0,1
		DB 1,0,0,0,0,0,0,1
		DB 1,0,0,0,0,0,0,1
		DB 1,0,0,0,0,0,0,1
		DB 1,0,0,0,0,0,0,1
		DB 1,0,0,0,0,0,0,1
		DB 1,0,0,0,0,0,0,1
		DB 1,0,0,0,0,0,0,1
		DB 1,0,0,0,0,0,0,1
		DB 1,0,0,0,0,0,0,1
		DB 1,0,0,0,0,0,0,1
		DB 1,0,0,0,0,0,0,1



;
; Variables used in the _print_string routine
;

STRING_PTR	DWORD 	0			; Points to the current character in the string
TXTPOS_X	DWORD	0
TXTPOS_Y	DWORD	0
screen_addr	DWORD	0





VIDEO_MEMORY_DESTINATION	EQU	0A1400h	; 16 lines down from top of screen

NSCR_WIDTH		EQU	320
COMPASS_DISPLAY_HEIGHT	EQU	9
COMPASS_DISPLAY_WIDTH	EQU	80
COMPASS_SPRITE_WIDTH	EQU	192
BACKGROUND_HEIGHT       EQU	64
RADAR_SIZE		EQU	56
SPEEDO_WIDTH		EQU	21
SPEEDO_HEIGHT		EQU	20


COMPASS_DISPLAY_X	EQU	122
COMPASS_DISPLAY_Y	EQU	3
RADAR_DISPLAY_X		EQU	132
RADAR_DEST_Y		EQU     139
RADAR_SRC_Y		EQU	142


speedo_DISPLAY_X	EQU	270
SPEEDO_DISPLAY_Y	EQU     159


WEAPON_DISPLAY_X	EQU	211
WEAPON_DISPLAY_Y	EQU	143
WEAPON_DISPLAY_WIDTH	EQU	37
WEAPON_DISPLAY_HEIGHT	EQU	45


SHEILD_SRC_Y		EQU	160
SHEILD_DEST_Y		EQU	134

VIDEO_BOX_X		EQU	27
VIDEO_BOX_Y		EQU	157
VIDEO_BOX_src_Y		EQU	168
VIDEO_BOX_HEIGHT	EQU	24
VIDEO_BOX_WIDTH		EQU	64


MULTICOLOURED_PRINT	EQU	0
SINGLE_COLOURED_PRINT	EQU	1
TRANSPARENT_PRINT	EQU	2
WIDTH_OFFSET		EQU	194

	.CODE

; Values go into EAX, EDX, EBX, ECX.
; After these four, values get pushed onto the stack.




PRINT_STRING_		PROC C PUBLIC

	PUSHAD

	cld

	MOV	STRING_PTR,Ebx			; Save the parameters
	MOV	TXTPOS_X,Eax
	mov	txtpos_y,edx

	MOV	EDI,SCR_PTR
	ADD	EDI,Eax
	IMUL	Edx,NSCR_WIDTH

	ADD	EDI,EdX				; Get the start position on screen

	mov	screen_addr, edi


	CMP	ECX,SINGLE_COLOURED_PRINT

	JZ	@@S_STRING_LOOP
	JG	@@T_STRING_LOOP



; Multi coloured character print

@@m_STRING_LOOP:
	mov	edi, screen_addr

	MOV	EAX, STRING_PTR
	movzx	eax, byte ptr [eax]
	OR	EAX,EAX

	JZ	@@END_STRING

	SUB	EAX,33

	Js	@@M_A_SPACE

	mov	esi,current_font

	MOVzx	EBP,byte ptr [esi+EAX+WIDTH_OFFSET]	; Get width of character

	mov	edx,dword ptr [esi]

	MOVZX	EAX,WORD PTR[ESI+EAX*2+4]
	ADD	ESI,EAX

@@m_CHAR_LOOP:
	MOV	ECX,EBP

@@m_scan_loop:
	MOV	AL,[ESI]
	OR	AL,AL
	jz	short @@m_background_bit
	MOV	[EDI],AL

@@m_background_bit:
	INC	EDI
	INC	ESI
	DEC	CL
	jnz	@@m_scan_loop


	ADD	EDI,NSCR_WIDTH			; Move down a row
	SUB	EDI,EBP

	DEC	EDX
	JNZ	@@m_CHAR_LOOP

	inc	ebp
	ADD	SCREEN_ADDR, EBP		; Move to next character position

	INC	DWORD PTR STRING_PTR

	jmp	@@m_string_loop

@@m_A_SPACE:
	ADD	SCREEN_ADDR, 4			; Have a space as 4 pixels
	inc	DWORD ptr string_ptr

	jmp	@@m_string_loop


; single colour character print

@@s_STRING_LOOP:
	mov	edi, screen_addr

	MOV	EAX, STRING_PTR
	movzx	eax, byte ptr [eax]
	OR	EAX,EAX

	JZ	@@END_STRING

	SUB	EAX,33

	Js	@@S_A_SPACE

	mov	esi,current_font

	MOVzx	EBP,byte ptr [esi+EAX+WIDTH_OFFSET]	; Get width of character

	mov	edx,dword ptr [esi]			; Get height of font



	MOVZX	EAX,WORD PTR[ESI+EAX*2+4]			; Get address of character defintion data
	ADD	ESI,EAX

@@S_CHAR_LOOP:
	MOV	ECX,EBP

@@S_scan_loop:
	MOV	AL,[ESI]
	OR	AL,AL
	JZ	SHORT @@S_BACKGROUND_BIT

	MOV	AL,txt_print_colr
	MOV	[EDI],AL

@@S_background_bit:
	INC	EDI
	INC	ESI
	DEC	CL
	jnz	@@S_scan_loop


	ADD	EDI,NSCR_WIDTH			; Move down a row
	SUB	EDI,EBP

	DEC	EDX
	JNZ	@@S_CHAR_LOOP

	inc	ebp
	ADD	SCREEN_ADDR, ebp		; Move to next character position

	INC	DWORD PTR STRING_PTR

	jmp	@@S_string_loop

@@S_A_SPACE:
	ADD	SCREEN_ADDR, 4			; Have a space as 4 pixels
	inc	DWORD ptr string_ptr

	jmp	@@S_string_loop


;TRANSPARENT MULTI COLOURED CHARACTER PRINT

@@T_STRING_LOOP:
	mov	edi, screen_addr

	MOV	EAX, STRING_PTR
	movzx	eax, byte ptr [eax]
	OR	EAX,EAX

	JZ	@@END_STRING

	SUB	EAX,33

	Js	@@T_A_SPACE

	mov	esi,current_font

	MOVzx	EBP,byte ptr [esi+EAX+WIDTH_OFFSET]	; Get width of character

	mov	edx,dword ptr [esi]

	MOVZX	EAX,WORD PTR[ESI+EAX*2+4]
	ADD	ESI,EAX

@@T_CHAR_LOOP:
	MOV	ECX,EBP

@@T_scan_loop:
	MOVZX	EAX,BYTE PTR [ESI]
	OR	AL,AL
	JZ	SHORT @@T_BACKGROUND_BIT

	SHL	EAX,8
	MOV	AL,[EDI]

	MOV	AL,BYTE PTR INTERPOL_TAB[EAX]   ; Get interpolated pixel colour

	MOV	[EDI],AL

@@T_background_bit:
	INC	EDI
	INC	ESI
	DEC	CL
	jnz	@@T_scan_loop


	ADD	EDI,NSCR_WIDTH			; Move down a row
	SUB	EDI,EBP

	DEC	EDX
	JNZ	@@T_CHAR_LOOP

	inc	ebp
	ADD	SCREEN_ADDR, EBP		; Move to next character position

	INC	DWORD PTR STRING_PTR

	jmp	@@T_string_loop

@@T_A_SPACE:
	ADD	SCREEN_ADDR, 4			; Have a space as 4 pixels
	inc	DWORD ptr string_ptr

	jmp	@@T_string_loop




@@END_STRING:
	POPAD

	ret




print_string_		ENDP

;
; Damp the tactical map
;

TAC_MAP_WIDTH	EQU	202
TAC_MAP_HEIGHT	EQU	158
TAC_MAP_X	EQU  	91
TAC_MAP_Y	EQU	16


DUMP_MAP_SCREEN_	PROC C PUBLIC

	PUSHAD

	MOV	ESI,scr_ptr
	MOV	EDI,0A0000H + TAC_MAP_X + (NSCR_WIDTH*TAC_MAP_Y)
	ADD	ESI,TAC_MAP_X + (NSCR_WIDTH*TAC_MAP_Y)

	MOV	EDX,TAC_MAP_HEIGHT
	cld

@@YLOOP:
	MOV	ECX,TAC_MAP_WIDTH

	REP	MOVSB

	add	esi,(NSCR_WIDTH-TAC_MAP_WIDTH)
	add	edi,(NSCR_WIDTH-TAC_MAP_WIDTH)

	DEC	EDX
	JNZ	@@YLOOP

	POPAD

	ret


DUMP_MAP_SCREEN_	ENDP

;
; Draws the wraparound background
;

draw_background_	PROC C PUBLIC

	pushad

	MOV	EDX,BACKGROUND_HEIGHT
	mov	esi,back_map
	add	esi,eax
	mov	edi,scr_ptr

@@loop:
	mov	ebp,esi
	mov	ecx,NSCR_WIDTH/4

	rep	movsd
	MOV	ESI,EBP
	add	esi,832	; was 1344

	dec	dx
	jnz	@@loop

	popad
	ret

draw_background_	ENDP




DUMP_GAME_SCREEN_	PROC C PUBLIC

	PUSHAD

; Dump the play area

	CLD

; normal dump
	MOV	EAX,TRIPPY

	OR	EAX,EAX
	jnz	short tripfactor

	MOV	ESI,SCR_PTR
	MOV	EDI,VIDEO_MEMORY_DESTINATION
	MOV	ECX,22b0H			; 2300h = 320*111 pixels /4 (double words)
	REP	MOVSD


	jmp	@@compassStuff


;trippy dump
TRIPFACTOR:
	MOV	ESI,SCR_PTR
	MOV	EAX,PREVIOUSSCREEN
	MOV	EDI,VIDEO_MEMORY_DESTINATION
	MOV	ECX,2*22B0H			; 2300h = 320*111 pixels /2 (words)

	lea	EBP,INTERPOL_TAB

	; do 2 pixels at a time



TRIPPYLOOP:

	; shift up the loop counter to store in the top word
	shl	ecx,16

	; 1st pixel

	MOVZX	EBX,BYTE PTR [ESI]		; get current pixel
	ShL	EBX,8				; get line of interpolation table needed

	movzx	cx,byte ptr [eax]
	ADD	BX,cx				; get column of interpolation table needed
						; ie add the previous pixel value
	MOVzx	edx,BYTE PTR [EBP+EBX]

	INC	ESI
	INC	Eax


	; 2nd pixel

	MOVZX	EBX,BYTE PTR [ESI]		; get current pixel
	ShL	EBX,8				; get line of interpolation table needed

	movzx	cx,byte ptr [eax]
	ADD	BX,cx				; get column of interpolation table needed
						; ie add the previous pixel value
	MOV	Dh,BYTE PTR [EBP+EBX]

	INC	ESI
	INC	Eax



	MOV	WORD PTR[EDI], DX		; STORE THE WORD TO VIDEO MEMORY

	INC	EDI
	INC	EDI

	ROR	ECX,16				; get the counter back

	dec	cx
	jnz	trippyLoop


; Now dump the control panel bits

; First do the compass readout area


@@compassStuff:
	MOV	ESI,P1SCREEN
	ADD	ESI,NSCR_WIDTH*COMPASS_DISPLAY_Y + COMPASS_DISPLAY_X

	MOV	EDI,0A0000H + NSCR_WIDTH*COMPASS_DISPLAY_Y + COMPASS_DISPLAY_X

	MOV	EDX,COMPASS_DISPLAY_HEIGHT

	MOV	EBP,COMPASS_DISPLAY_width/4

@@COMPASSLOOP:

	MOV	ECX,EBP
@@TLOOP1:
	MOV	ECX,EBP
	REP	MOVSD

	ADD	EDI,NSCR_WIDTH-COMPASS_DISPLAY_width
	ADD	ESI,NSCR_WIDTH-COMPASS_DISPLAY_width
	DEC	DX
	JNZ	@@COMPASSLOOP


; Then the radar area

	MOV	ESI,P1SCREEN
	ADD	ESI,NSCR_WIDTH*RADAR_SRC_Y + RADAR_DISPLAY_X

	MOV	EDI,0A0000H + NSCR_WIDTH*RADAR_DEST_Y + RADAR_DISPLAY_X

	MOV	EDX,radar_size

	MOV	EBP,radar_size/4

@@radarloop:
	MOV	ECX,EBP
	REP	MOVSD

	ADD	EDI,NSCR_WIDTH-radar_SIZE
	ADD	ESI,NSCR_WIDTH-RADAR_SIZE

	DEC	DX
	JNZ	@@radarloop

; Then the speedo

	MOV	ESI,P1SCREEN
	ADD	ESI,NSCR_WIDTH*speedo_DISPLAY_Y + speedo_DISPLAY_X

	MOV	EDI,0A0000H + NSCR_WIDTH*speedo_DISPLAY_Y + speedo_DISPLAY_X

	MOV	EDX,speedo_height

	MOV	EBP,speedo_width/4

@@speedoloop:
	MOV	ECX,EBP
	REP	MOVSD

	movsb		; Speedo dial is 21 pixels wide.

	ADD	EDI,NSCR_WIDTH-speedo_width
	ADD	ESI,NSCR_WIDTH-speedo_width

	DEC	DX
	JNZ	@@speedoloop



; Draw the weapons display if it needs to be updated

	LEA	Eax,DRAWFLAGS

	MOV	Dl,[EAX]
	or	dl,dl

	JZ	@@SKIP_WEAPONS

	MOV	BYTE PTR [EAX],0
	MOV	ESI, P1SCREEN
	ADD	ESI, NSCR_WIDTH*WEAPON_DISPLAY_Y + WEAPON_DISPLAY_X

	MOV	EDI,0A0000H + NSCR_WIDTH*WEAPON_DISPLAY_Y + WEAPON_DISPLAY_X

	MOV	EDX,WEAPON_DISPLAY_HEIGHT

	MOV	EBP,WEAPON_DISPLAY_WIDTH/4

@@WEAPONSloop:
	MOV	ECX,EBP
	REP	MOVSD

	movsb		; Weapons display 37 pixels wide

	ADD	EDI,NSCR_WIDTH-WEAPON_DISPLAY_WIDTH
	ADD	ESI,NSCR_WIDTH-WEAPON_DISPLAY_WIDTH

	DEC	DX
	JNZ	@@WEAPONSloop


@@SKIP_WEAPONS:
	INC	EAX

	MOV	Dl,[EAX]
	or	dl,dl

	JZ	@@SKIP_SHEILDS
	MOV	BYTE PTR [EAX],0

; Draw the sheilds display if it needs to be updated

	MOV	ESI, P1SCREEN
	ADD	ESI, 30 + SHEILD_SRC_Y*NSCR_WIDTH

	MOV	EDI, 0A0000H + 30 + SHEILD_DEST_Y*NSCR_WIDTH

	MOV	EDX,7
	MOV	EBP,15

@@ARMOURLOOP:
	MOV	ECX,EBP
	REP	MOVSD

	ADD	EDI,NSCR_WIDTH-60
	ADD	ESI,NSCR_WIDTH-60

	DEC	DX
	JNZ	@@ARMOURLOOP

@@SKIP_SHEILDS:

; Draw the message box to the screen

	MOV	ESI,P1SCREEN
	ADD	ESI,VIDEO_BOX_X + VIDEO_BOX_src_Y*NSCR_WIDTH

	MOV	EDI, 0A0000H + VIDEO_BOX_X + VIDEO_BOX_Y*NSCR_WIDTH

	MOV	EDX,VIDEO_BOX_HEIGHT
	MOV 	EBP,VIDEO_BOX_WIDTH

@@MESSAGE_BOX_LOOP:
	MOV	ECX,EBP
	REP	MOVSb

	ADD	EDI,NSCR_WIDTH-VIDEO_BOX_WIDTH
	add	esi,NSCR_WIDTH-VIDEO_BOX_WIDTH

	DEC	DX
	jnz	@@MESSAGE_BOX_LOOP

	POPAD
	RET

DUMP_GAME_SCREEN_	ENDP





;******************************************

DRAW_COMPASS_	PROC C PUBLIC

	PUSHAD

	MOV	EDX,COMPASS_DISPLAY_HEIGHT
	mov	esi,compass_data
	add	esi,eax
	mov	edi,scr_ptr
	cld

@@loop:
	mov	ebp,esi
	mov	ecx,COMPASS_DISPLAY_WIDTH/4

	rep	movsd
	MOV	ESI,EBP
	ADD	ESI,COMPASS_SPRITE_WIDTH
	ADD	EDI,NSCR_WIDTH-COMPASS_DISPLAY_WIDTH

	dec	dx
	jnz	@@loop

	popad
	ret

DRAW_COMPASS_	ENDP




DRAW_RADAR_RINGS_	 PROC C PUBLIC

	PUSHAD

	MOV	EDX,RADAR_SIZE
	MOV	EDI,SCR_PTR
	MOV	ESI,RADAR_RING_DATA

@@LOOP:
	MOV	ECX,RADAR_SIZE/4

	REP	MOVSD
	ADD	EDI,NSCR_WIDTH - RADAR_SIZE

	DEC	DX
	JNZ	@@LOOP

	POPAD
	RET

DRAW_RADAR_RINGS_	 ENDP




CLEAR_BLOCK_		PROC C PUBLIC

	PUSHAD

	MOV	EDI,SCR_PTR
	IMUL	EdX,NSCR_WidTH
	ADD	EDI,EAX
	ADD	EDI,EDX

	CLD

	MOV	EBP,EDI
	MOv	EDX,ECX

	xor	eax,eax

	CLD

@@LOOP:
	MOV	EDI,EBP
	MOV	ECX,EBX

	REP	STOSB

	ADD	EBP,NSCR_WIDTH

	DEC 	EDX
	JNZ	@@LOOP

	POPAD
	RET

CLEAR_BLOCK_		endp








	END

