#include  "typedefs.h"
#include "frontend.h"
#include "iff.h"
#include <stdio.h>
#include "frontdef.h"
#include "frglobs.h"

#ifdef PC_VERSION

#include "shell.h"
#include "types.h"
#include "rad.h"
#include "smack.h"
#include "dosext.h"
#include "radmal.i"
#include "svga.h"
#include "timer.h"

#else

typedef struct
	{
	short	sc_width,sc_height;
	short	mx_sense,my_sense,ms_dthresh;
	void		*scrn_ptr;
	short	col_mode;
	short	dump_x,dump_y,dump_width,dump_height;
	}
	SETUP;


#include "headers.h" /* Platform specific header files */
#include "chuck.h"

#endif


//Smack *smk;

char		*fmvfns[]={
	"fmv\\coresou.smk",
	"fmv\\death4.smk",
	"fmv\\out_eng.smk",
	"fmv\\int_eng2.smk",
  	"fmv\\int_mus2.smk",
   "fmv\\gover1.smk"};

#ifdef PC_VERSION
void disp_transbox(int bx,int by,int bw,int bh)

{char *sp,*ttb;
 int x,mod=SCREEN_WIDTH-bw;

 if(bh<=0 | bw<=0)
	return;
 sp=scrptr+(by*SCREEN_WIDTH)+bx;
 ttb=transpal;	  				  			// trans data at line 224
 for(;bh;--bh)
 	{
	 for(x=0;x<bw;x++,sp++)
		 *sp=*(ttb+*sp);			  			// look up new pix value
	 sp+=mod;									// next line
	}
}
#endif


void fade_out()
{
#ifdef PC_VERSION
 fade_to_pal(FADE_RATE,fadepal);
 wait_fade();
#else
 out_fade();
#endif
}


void fade_in(char *pal)
{
#ifdef PC_VERSION
 fade_to_pal(FADE_RATE,pal);
 wait_fade();
#else
 in_fade(pal);
#endif
}



int print_char(int x,int y,char c)

{char *src;
 char *dst;
 int n,row,col,ncp;

 ncp=SCREEN_WIDTH/fontw;
 n=c%ncp;									// chars per line
 src=gfont+(n*fontw)+((c/ncp)*fonth*SCREEN_WIDTH);
 dst=scrptr+x+(y*SCREEN_WIDTH);							// start addr of screen

#ifdef CONSOLE_VERSION
 mcode_print_char(src, dst, fontw, fonth, SCREEN_WIDTH);	// defined in assembler
#else
 for(row=0;row<fontw;row++)
 	{for(col=0;col<fonth;col++)
 		{if(*(src+col))		  						// set bit and flag col non-empty
			*(dst+col)=gcol;
		}
	 src+=SCREEN_WIDTH;
	 dst+=SCREEN_WIDTH;
	}
#endif
 return char_widths[c];
}

void copy_spr(struct img *im)

{int xc,yc,mod;
 char *src,*dst,c;

 mod=SCREEN_WIDTH-im->w;
 dst=scrptr+(SCREEN_WIDTH*im->y)+im->x;
 src=im->data;
 for(yc=0;yc<im->h;yc++)
		{for(xc=0;xc<im->w;xc++)
			 {if(c=*src++)
			   *dst=c;
			  dst++;
			 }
 	 	 dst+=mod;
		}
}

void copy_image(struct img *im)

{int yc;
 char *src,*dst;

 if(im->x+im->w>SCREEN_WIDTH)
	im->w=SCREEN_WIDTH-im->x;
 if(im->y+im->h>SCREEN_HEIGHT)
	im->h=SCREEN_HEIGHT-im->y;
 dst=scrptr+(SCREEN_WIDTH*im->y)+im->x;
 src=im->data;
 for(yc=0;yc<im->h;yc++)
		{
		 memcpy(dst,src,im->w);
 	 	 src+=im->w;
   	 dst+= SCREEN_WIDTH;
 		}
}

void hline(int x,int y,int l,char c)

{char *sp=(char *)scrptr+x+(y*SCREEN_WIDTH);

 memset(sp,c,l);
// for(;l;--l)
// 	*sp++=c;
}

void vline(int x,int y,int l,char c)

{char *sp=(char *)scrptr+x+(y*SCREEN_WIDTH);

 for(;l;--l)
 	{
	 *sp=c;
    sp+=SCREEN_WIDTH;
	}
}

void gen_qtab(int col,int scale,char *tab,char *game_palette)
{

// NB: Scale in range 0-255

	int	i,j;
	int	r0,g0,b0;
	int	r1,g1,b1;
	int	lastcol,lastval;
	int	comp;

	for(i=0;i<256;i++) {
		r0=game_palette[col*3]+( ((game_palette[(i*3)]-game_palette[(col*3)])*scale)>>8);
		g0=game_palette[(col*3)+1]+(((game_palette[(i*3)+1]-game_palette[(col*3)+1])*scale)>>8);
		b0=game_palette[(col*3)+2]+(((game_palette[(i*3)+2]-game_palette[(col*3)+2])*scale)>>8);
		lastcol=0;
		lastval=0x7fffffff;

		for(j=0;j<256;j++) {
			r1=r0-game_palette[(j*3)];
			g1=g0-game_palette[(j*3)+1];
			b1=b0-game_palette[(j*3)+2];

			if(r1<0) r1=-r1;
			if(g1<0) g1=-g1;
			if(b1<0) b1=-b1;

			if(r1>=g1 && r1>=b1) {
				comp=r1<<8;
				if(g1>b1) {
					comp+=g1<<4;
					comp+=b1;
				} else {
					comp+=b1<<4;
					comp+=g1;
				}
			} else if(g1>=r1 && g1>=b1) {
				comp=g1<<8;
				if(r1>b1) {
					comp+=r1<<4;
					comp+=b1;
				} else {
					comp+=b1<<4;
					comp+=r1;
				}
			} else {
				comp=b1<<8;
				if(r1>g1) {
					comp+=r1<<4;
					comp+=g1;
				} else {
					comp+=g1<<4;
					comp+=r1;				
				}
			}
			if(comp < lastval) {
				lastval=comp;
				lastcol=j;
			}
		}
		tab[i]=lastcol;
	}
}

void read_joypad()
{
 static char selstat=0;
 static char joydeb=0;
 static char joyfdeb=0;

#ifdef PC_VERSION

 key=KeyGet();
 read_mouse();

/* get left mouse butt stat */

 ctrlval=0;
 if(mbut&1)
	{
	 if(!selstat)
		{selstat=1;ctrlval|=CTRL_SELECT;}
	}
 else
	selstat=0;
 if(keydeb(K_LEFT))
  	ctrlval|=CTRL_LEFT;
 if(keydeb(K_RIGHT))
  	ctrlval|=CTRL_RIGHT;
 if(keydeb(K_UP))
  	ctrlval|=CTRL_UP;
 if(keydeb(K_DOWN))
 	ctrlval|=CTRL_DOWN;
 if(keydeb(K_RET))
 	ctrlval|=CTRL_SELECT;
 if(keydeb(K_ESC))
 	ctrlval=CTRL_CANCEL;

 JoyRead();
 if(abs(joy1_x)<24 && abs(joy1_y)<24)
	joydeb=0;
 else
	{	
 	 if(joy1_x>24 && !joydeb)
		{ctrlval=CTRL_RIGHT;joydeb=1;}
 	 else if(joy1_x<-24 && !joydeb)
		{ctrlval=CTRL_LEFT;joydeb=1;}
 	 else if(joy1_y>24 && !joydeb)
		{ctrlval=CTRL_DOWN;joydeb=1;}
 	 else if(joy1_y<-24 && !joydeb)
		{ctrlval=CTRL_UP;joydeb=1;}
	}

 if(joy_fire)
	{if(!joyfdeb)
		{ctrlval=CTRL_SELECT;joyfdeb=1;}
	}
 else
	joyfdeb=0;
#else
extern uint trg1_value;
	uint keyval;

 	ctrlval=0;

	debounce_joy();

	padd = trg1_value;
	keyval = trg1_value;

	if ( keyval & PADLa )
		ctrlval|=CTRL_SELECT;

	if ( keyval & PADLleft )
		ctrlval|=CTRL_LEFT;

	if ( keyval & PADLright )
		ctrlval|=CTRL_RIGHT;

	if ( keyval & PADLup )
		ctrlval|=CTRL_UP;

	if ( keyval & PADLdown )
		ctrlval|=CTRL_DOWN;

	if ( keyval & PADLstart )
		ctrlval=CTRL_CANCEL;
#endif

}

/* (Replaced with password)

int save_games()
{FILE *fp;
 char path[128];

 games[locker]=game_data;
 strcpy(path,installDir);
 strcat(path,"shock.gms");
 if(!(fp=fopen(path,"wb") ))
	return FALSE;
 fwrite(games,sizeof(GAME_IOSTRUCT),4,fp);
 fclose(fp);
 return TRUE;
}

int load_games()
{FILE *fp;
 char path[128];

 strcpy(path,installDir);
 strcat(path,"shock.gms");
 if(!(fp=fopen(path,"rb") ))
	return 1;
 fread(games,sizeof(GAME_IOSTRUCT),4,fp);
 fclose(fp);
 return 0;
}

*/

void get_sample_position()
{
 if(SoundIsDIGIEnabled())
 	{boff=SoundSamplePosition(shandle);
    if(!SoundSampleIsPlaying(shandle))
		boff=0x7fffffff;
	}
 else
	{
	 if(framecnt>=4)
		boff+=800;
	 else
		boff+=500;
	}
 SoundStreamUpdate(shandle);
}


#ifdef PC_VERSION

void fmv(int n)
{
  Smack* smk;
  u32 i;

  i=SoundGetSOSHandle();
  SetSmackSOS4Handle(i,50);
  smk=SmackOpen(fmvfns[n],smackflg,SMACKAUTOEXTRA);
  if (smk) {
    SVGADetect(0);
    if (SVGASetup(smk->Width,smk->Height)) {
      SmackToScreen(smk,0,0,SVGABytesPS(),SVGAWinTbl(),SVGASetBank());
      SVGASetGraph();
      for(i=1;i<=smk->Frames;i++) {
        if (smk->NewPalette)
          PaletteSet((smk->CurPalette==1)?smk->Col1:smk->Col2);

        SmackDoFrame(smk);

        if (i!=smk->Frames)
          SmackNextFrame(smk);
			 do{
			 	 read_joypad();
			 	 if(ctrlval==CTRL_CANCEL || ctrlval==CTRL_SELECT)
					{SmackClose(smk);
					 return;

	   			}
				}while(SmackWait(smk));
      }
    }
    SmackClose(smk);
  }
}
#endif

