;******************************************************************************
;*          		Maths Functions
;*
;*			int	 phd_atan( int x, int y )
;*			int  phd_sin( int angle )
;*			int	 phd_cos( int angle )
;*			int	 phd_sqrt( int num )
;*
;******************************************************************************

	.386

;******************************************************************************

DGROUP	GROUP _DATA

_TEXT	SEGMENT PARA PUBLIC USE32 'CODE'

	ASSUME cs:_TEXT
	ASSUME ds:_DATA



;******************************************************************************
;*      	Int	phd_atan( int x,int y );
;*
;*		Entry EAX: Distance along X axis..
;*			  EDX: Distance along Y axis..
;*		Exit  EAX: Angle ( 0 - 65536 )
;*
;*   25/04/95 15:05 PHD.
;******************************************************************************

NUMSTEPS	EQU		2048
NUMSTEPBITS	EQU		11

phd_atan_	PROC PUBLIC
		push	ebx
		push	ecx
		push	edx
		mov		ebx,eax                     ; copy X into ebx
		xor		ecx,ecx						; clear Octant num
		or		eax,edx
		jz		SHORT @@exit				; if X=Y=0 exit Angle=0
		test	ebx,ebx 					; is X<0
		jns		SHORT @@okx
		add		ecx,4						; Octant 4,5,6 or 7
		neg		ebx                         ; make X positive
@@okx:  test	edx,edx
		jns		SHORT @@oky     			; if Y<0
		add		ecx,2                       ; Add 2 to Octant Num
		neg		edx                         ; make Y positive
@@oky:	xor		eax,eax						; clear out eax
		cmp		edx,ebx						; compare Y with X
		jle		SHORT @@ylex
		inc		ecx                         ; if Y>X inc octant count
		xchg	ebx,edx                     ; swap X and Y
@@ylex:	shrd	eax,edx,(32-NUMSTEPBITS)	; get Y*NUMSTEPS in edx:eax
		shr		edx,(32-NUMSTEPBITS)		;
		idiv	ebx                         ; get Y*NUMSTEPS / X
		mov		ax,phdtantab[eax*2]         ; get Angle 0-45degrees
		add		eax,phdtan2[ecx*4]          ; add on req Octant
		jns		SHORT @@exit
		neg		eax                         ; make Positive..
@@exit:		pop		edx
		pop		ecx
		POP		EBX

		ADD		EAX,4000H	; Convert to my system.
		NEG		EAX
		Shr		EAX,5
		and		eax,7ffh

		ret

phd_atan_ ENDP

;*****************************************************************************
; 		int  phd_cos( int angle )
; 		int  phd_sin( int angle )
;
; angle in range 0-65535
;
;*****************************************************************************

DEG360		EQU		65536

_DATA	SEGMENT PARA PUBLIC USE32 'DATA'

;****************************************************************************
;*		   		ArcTangent Base tables for Octants
;****************************************************************************
			align	DWORD

phdtan2		dd		0				; Left Top Y<X  0-45    Base 0
			dd		-16384			; Left Top Y>X  45-90   Base -90
			dd		-65535          ; Left Bot Y<X  315-360 Base -360
			dd		49152			; Left Bot Y>X  270-315 Base 270
			dd		-32768			;Right Top Y<X  135-180 Base -180
			dd		16384			;Right Top Y>X  90-135  Base 90
			dd		32768			;Right Bot Y<X  180-225 Base 180
			dd		-49152			;Right Bot Y>X  225-270 Base -270

;****************************************************************************
;*		   	ArcTangent table for 0-45  2048 entries
;****************************************************************************
			align	DWORD

phdtantab	dw		0000h,0005h,000Ah,000Fh
			dw		0014h,0019h,001Fh,0024h
			dw		0029h,002Eh,0033h,0038h
			dw		003Dh,0042h,0047h,004Ch
			dw		0051h,0057h,005Ch,0061h
			dw		0066h,006Bh,0070h,0075h
			dw		007Ah,007Fh,0084h,008Ah
			dw		008Fh,0094h,0099h,009Eh
			dw		00A3h,00A8h,00ADh,00B2h
			dw		00B7h,00BCh,00C2h,00C7h
			dw		00CCh,00D1h,00D6h,00DBh
			dw		00E0h,00E5h,00EAh,00EFh
			dw		00F4h,00FAh,00FFh,0104h
			dw		0109h,010Eh,0113h,0118h
			dw		011Dh,0122h,0127h,012Ch
			dw		0131h,0137h,013Ch,0141h
			dw		0146h,014Bh,0150h,0155h
			dw		015Ah,015Fh,0164h,0169h
			dw		016Fh,0174h,0179h,017Eh
			dw		0183h,0188h,018Dh,0192h
			dw		0197h,019Ch,01A1h,01A6h
			dw		01ACh,01B1h,01B6h,01BBh
			dw		01C0h,01C5h,01CAh,01CFh
			dw		01D4h,01D9h,01DEh,01E3h
			dw		01E9h,01EEh,01F3h,01F8h
			dw		01FDh,0202h,0207h,020Ch
			dw		0211h,0216h,021Bh,0220h
			dw		0226h,022Bh,0230h,0235h
			dw		023Ah,023Fh,0244h,0249h
			dw		024Eh,0253h,0258h,025Dh
			dw		0262h,0268h,026Dh,0272h
			dw		0277h,027Ch,0281h,0286h
			dw		028Bh,0290h,0295h,029Ah
			dw		029Fh,02A4h,02A9h,02AFh
			dw		02B4h,02B9h,02BEh,02C3h
			dw		02C8h,02CDh,02D2h,02D7h
			dw		02DCh,02E1h,02E6h,02EBh
			dw		02F0h,02F6h,02FBh,0300h
			dw		0305h,030Ah,030Fh,0314h
			dw		0319h,031Eh,0323h,0328h
			dw		032Dh,0332h,0337h,033Ch
			dw		0341h,0347h,034Ch,0351h
			dw		0356h,035Bh,0360h,0365h
			dw		036Ah,036Fh,0374h,0379h
			dw		037Eh,0383h,0388h,038Dh
			dw		0392h,0397h,039Ch,03A2h
			dw		03A7h,03ACh,03B1h,03B6h
			dw		03BBh,03C0h,03C5h,03CAh
			dw		03CFh,03D4h,03D9h,03DEh
			dw		03E3h,03E8h,03EDh,03F2h
			dw		03F7h,03FCh,0401h,0407h
			dw		040Ch,0411h,0416h,041Bh
			dw		0420h,0425h,042Ah,042Fh
			dw		0434h,0439h,043Eh,0443h
			dw		0448h,044Dh,0452h,0457h
			dw		045Ch,0461h,0466h,046Bh
			dw		0470h,0475h,047Ah,047Fh
			dw		0484h,0489h,048Eh,0494h
			dw		0499h,049Eh,04A3h,04A8h
			dw		04ADh,04B2h,04B7h,04BCh
			dw		04C1h,04C6h,04CBh,04D0h
			dw		04D5h,04DAh,04DFh,04E4h
			dw		04E9h,04EEh,04F3h,04F8h
			dw		04FDh,0502h,0507h,050Ch
			dw		0511h,0516h,051Bh,0520h
			dw		0525h,052Ah,052Fh,0534h
			dw		0539h,053Eh,0543h,0548h
			dw		054Dh,0552h,0557h,055Ch
			dw		0561h,0566h,056Bh,0570h
			dw		0575h,057Ah,057Fh,0584h
			dw		0589h,058Eh,0593h,0598h
			dw		059Dh,05A2h,05A7h,05ACh
			dw		05B1h,05B6h,05BBh,05C0h
			dw		05C5h,05CAh,05CFh,05D4h
			dw		05D9h,05DEh,05E3h,05E8h
			dw		05EDh,05F2h,05F7h,05FCh
			dw		0601h,0606h,060Bh,0610h
			dw		0615h,061Ah,061Fh,0624h
			dw		0629h,062Eh,0633h,0638h
			dw		063Dh,0642h,0647h,064Ch
			dw		0651h,0656h,065Bh,0660h
			dw		0665h,066Ah,066Eh,0673h
			dw		0678h,067Dh,0682h,0687h
			dw		068Ch,0691h,0696h,069Bh
			dw		06A0h,06A5h,06AAh,06AFh
			dw		06B4h,06B9h,06BEh,06C3h
			dw		06C8h,06CDh,06D2h,06D7h
			dw		06DCh,06E1h,06E5h,06EAh
			dw		06EFh,06F4h,06F9h,06FEh
			dw		0703h,0708h,070Dh,0712h
			dw		0717h,071Ch,0721h,0726h
			dw		072Bh,0730h,0735h,0739h
			dw		073Eh,0743h,0748h,074Dh
			dw		0752h,0757h,075Ch,0761h
			dw		0766h,076Bh,0770h,0775h
			dw		077Ah,077Eh,0783h,0788h
			dw		078Dh,0792h,0797h,079Ch
			dw		07A1h,07A6h,07ABh,07B0h
			dw		07B5h,07B9h,07BEh,07C3h
			dw		07C8h,07CDh,07D2h,07D7h
			dw		07DCh,07E1h,07E6h,07EBh
			dw		07EFh,07F4h,07F9h,07FEh
			dw		0803h,0808h,080Dh,0812h
			dw		0817h,081Ch,0820h,0825h
			dw		082Ah,082Fh,0834h,0839h
			dw		083Eh,0843h,0848h,084Ch
			dw		0851h,0856h,085Bh,0860h
			dw		0865h,086Ah,086Fh,0873h
			dw		0878h,087Dh,0882h,0887h
			dw		088Ch,0891h,0896h,089Ah
			dw		089Fh,08A4h,08A9h,08AEh
			dw		08B3h,08B8h,08BDh,08C1h
			dw		08C6h,08CBh,08D0h,08D5h
			dw		08DAh,08DFh,08E3h,08E8h
			dw		08EDh,08F2h,08F7h,08FCh
			dw		0901h,0905h,090Ah,090Fh
			dw		0914h,0919h,091Eh,0922h
			dw		0927h,092Ch,0931h,0936h
			dw		093Bh,093Fh,0944h,0949h
			dw		094Eh,0953h,0958h,095Ch
			dw		0961h,0966h,096Bh,0970h
			dw		0975h,0979h,097Eh,0983h
			dw		0988h,098Dh,0992h,0996h
			dw		099Bh,09A0h,09A5h,09AAh
			dw		09AEh,09B3h,09B8h,09BDh
			dw		09C2h,09C6h,09CBh,09D0h
			dw		09D5h,09DAh,09DEh,09E3h
			dw		09E8h,09EDh,09F2h,09F6h
			dw		09FBh,0A00h,0A05h,0A0Ah
			dw		0A0Eh,0A13h,0A18h,0A1Dh
			dw		0A22h,0A26h,0A2Bh,0A30h
			dw		0A35h,0A39h,0A3Eh,0A43h
			dw		0A48h,0A4Dh,0A51h,0A56h
			dw		0A5Bh,0A60h,0A64h,0A69h
			dw		0A6Eh,0A73h,0A77h,0A7Ch
			dw		0A81h,0A86h,0A8Bh,0A8Fh
			dw		0A94h,0A99h,0A9Eh,0AA2h
			dw		0AA7h,0AACh,0AB1h,0AB5h
			dw		0ABAh,0ABFh,0AC4h,0AC8h
			dw		0ACDh,0AD2h,0AD7h,0ADBh
			dw		0AE0h,0AE5h,0AE9h,0AEEh
			dw		0AF3h,0AF8h,0AFCh,0B01h
			dw		0B06h,0B0Bh,0B0Fh,0B14h
			dw		0B19h,0B1Eh,0B22h,0B27h
			dw		0B2Ch,0B30h,0B35h,0B3Ah
			dw		0B3Fh,0B43h,0B48h,0B4Dh
			dw		0B51h,0B56h,0B5Bh,0B60h
			dw		0B64h,0B69h,0B6Eh,0B72h
			dw		0B77h,0B7Ch,0B80h,0B85h
			dw		0B8Ah,0B8Fh,0B93h,0B98h
			dw		0B9Dh,0BA1h,0BA6h,0BABh
			dw		0BAFh,0BB4h,0BB9h,0BBDh
			dw		0BC2h,0BC7h,0BCBh,0BD0h
			dw		0BD5h,0BD9h,0BDEh,0BE3h
			dw		0BE7h,0BECh,0BF1h,0BF5h
			dw		0BFAh,0BFFh,0C03h,0C08h
			dw		0C0Dh,0C11h,0C16h,0C1Bh
			dw		0C1Fh,0C24h,0C29h,0C2Dh
			dw		0C32h,0C37h,0C3Bh,0C40h
			dw		0C45h,0C49h,0C4Eh,0C53h
			dw		0C57h,0C5Ch,0C60h,0C65h
			dw		0C6Ah,0C6Eh,0C73h,0C78h
			dw		0C7Ch,0C81h,0C86h,0C8Ah
			dw		0C8Fh,0C93h,0C98h,0C9Dh
			dw		0CA1h,0CA6h,0CABh,0CAFh
			dw		0CB4h,0CB8h,0CBDh,0CC2h
			dw		0CC6h,0CCBh,0CCFh,0CD4h
			dw		0CD9h,0CDDh,0CE2h,0CE6h
			dw		0CEBh,0CF0h,0CF4h,0CF9h
			dw		0CFDh,0D02h,0D07h,0D0Bh
			dw		0D10h,0D14h,0D19h,0D1Eh
			dw		0D22h,0D27h,0D2Bh,0D30h
			dw		0D34h,0D39h,0D3Eh,0D42h
			dw		0D47h,0D4Bh,0D50h,0D54h
			dw		0D59h,0D5Eh,0D62h,0D67h
			dw		0D6Bh,0D70h,0D74h,0D79h
			dw		0D7Dh,0D82h,0D87h,0D8Bh
			dw		0D90h,0D94h,0D99h,0D9Dh
			dw		0DA2h,0DA6h,0DABh,0DAFh
			dw		0DB4h,0DB9h,0DBDh,0DC2h
			dw		0DC6h,0DCBh,0DCFh,0DD4h
			dw		0DD8h,0DDDh,0DE1h,0DE6h
			dw		0DEAh,0DEFh,0DF3h,0DF8h
			dw		0DFCh,0E01h,0E05h,0E0Ah
			dw		0E0Fh,0E13h,0E18h,0E1Ch
			dw		0E21h,0E25h,0E2Ah,0E2Eh
			dw		0E33h,0E37h,0E3Ch,0E40h
			dw		0E45h,0E49h,0E4Eh,0E52h
			dw		0E56h,0E5Bh,0E5Fh,0E64h
			dw		0E68h,0E6Dh,0E71h,0E76h
			dw		0E7Ah,0E7Fh,0E83h,0E88h
			dw		0E8Ch,0E91h,0E95h,0E9Ah
			dw		0E9Eh,0EA3h,0EA7h,0EACh
			dw		0EB0h,0EB4h,0EB9h,0EBDh
			dw		0EC2h,0EC6h,0ECBh,0ECFh
			dw		0ED4h,0ED8h,0EDCh,0EE1h
			dw		0EE5h,0EEAh,0EEEh,0EF3h
			dw		0EF7h,0EFCh,0F00h,0F04h
			dw		0F09h,0F0Dh,0F12h,0F16h
			dw		0F1Bh,0F1Fh,0F23h,0F28h
			dw		0F2Ch,0F31h,0F35h,0F3Ah
			dw		0F3Eh,0F42h,0F47h,0F4Bh
			dw		0F50h,0F54h,0F58h,0F5Dh
			dw		0F61h,0F66h,0F6Ah,0F6Eh
			dw		0F73h,0F77h,0F7Ch,0F80h
			dw		0F84h,0F89h,0F8Dh,0F91h
			dw		0F96h,0F9Ah,0F9Fh,0FA3h
			dw		0FA7h,0FACh,0FB0h,0FB5h
			dw		0FB9h,0FBDh,0FC2h,0FC6h
			dw		0FCAh,0FCFh,0FD3h,0FD7h
			dw		0FDCh,0FE0h,0FE5h,0FE9h
			dw		0FEDh,0FF2h,0FF6h,0FFAh
			dw		0FFFh,1003h,1007h,100Ch
			dw		1010h,1014h,1019h,101Dh
			dw		1021h,1026h,102Ah,102Eh
			dw		1033h,1037h,103Bh,1040h
			dw		1044h,1048h,104Dh,1051h
			dw		1055h,105Ah,105Eh,1062h
			dw		1067h,106Bh,106Fh,1073h
			dw		1078h,107Ch,1080h,1085h
			dw		1089h,108Dh,1092h,1096h
			dw		109Ah,109Eh,10A3h,10A7h
			dw		10ABh,10B0h,10B4h,10B8h
			dw		10BCh,10C1h,10C5h,10C9h
			dw		10CEh,10D2h,10D6h,10DAh
			dw		10DFh,10E3h,10E7h,10EBh
			dw		10F0h,10F4h,10F8h,10FDh
			dw		1101h,1105h,1109h,110Eh
			dw		1112h,1116h,111Ah,111Fh
			dw		1123h,1127h,112Bh,1130h
			dw		1134h,1138h,113Ch,1140h
			dw		1145h,1149h,114Dh,1151h
			dw		1156h,115Ah,115Eh,1162h
			dw		1166h,116Bh,116Fh,1173h
			dw		1177h,117Ch,1180h,1184h
			dw		1188h,118Ch,1191h,1195h
			dw		1199h,119Dh,11A1h,11A6h
			dw		11AAh,11AEh,11B2h,11B6h
			dw		11BBh,11BFh,11C3h,11C7h
			dw		11CBh,11CFh,11D4h,11D8h
			dw		11DCh,11E0h,11E4h,11E9h
			dw		11EDh,11F1h,11F5h,11F9h
			dw		11FDh,1202h,1206h,120Ah
			dw		120Eh,1212h,1216h,121Ah
			dw		121Fh,1223h,1227h,122Bh
			dw		122Fh,1233h,1237h,123Ch
			dw		1240h,1244h,1248h,124Ch
			dw		1250h,1254h,1259h,125Dh
			dw		1261h,1265h,1269h,126Dh
			dw		1271h,1275h,127Ah,127Eh
			dw		1282h,1286h,128Ah,128Eh
			dw		1292h,1296h,129Ah,129Fh
			dw		12A3h,12A7h,12ABh,12AFh
			dw		12B3h,12B7h,12BBh,12BFh
			dw		12C3h,12C7h,12CCh,12D0h
			dw		12D4h,12D8h,12DCh,12E0h
			dw		12E4h,12E8h,12ECh,12F0h
			dw		12F4h,12F8h,12FCh,1301h
			dw		1305h,1309h,130Dh,1311h
			dw		1315h,1319h,131Dh,1321h
			dw		1325h,1329h,132Dh,1331h
			dw		1335h,1339h,133Dh,1341h
			dw		1345h,1349h,134Dh,1351h
			dw		1355h,135Ah,135Eh,1362h
			dw		1366h,136Ah,136Eh,1372h
			dw		1376h,137Ah,137Eh,1382h
			dw		1386h,138Ah,138Eh,1392h
			dw		1396h,139Ah,139Eh,13A2h
			dw		13A6h,13AAh,13AEh,13B2h
			dw		13B6h,13BAh,13BEh,13C2h
			dw		13C6h,13CAh,13CEh,13D2h
			dw		13D6h,13DAh,13DEh,13E2h
			dw		13E6h,13E9h,13EDh,13F1h
			dw		13F5h,13F9h,13FDh,1401h
			dw		1405h,1409h,140Dh,1411h
			dw		1415h,1419h,141Dh,1421h
			dw		1425h,1429h,142Dh,1431h
			dw		1435h,1439h,143Dh,1440h
			dw		1444h,1448h,144Ch,1450h
			dw		1454h,1458h,145Ch,1460h
			dw		1464h,1468h,146Ch,1470h
			dw		1473h,1477h,147Bh,147Fh
			dw		1483h,1487h,148Bh,148Fh
			dw		1493h,1497h,149Bh,149Eh
			dw		14A2h,14A6h,14AAh,14AEh
			dw		14B2h,14B6h,14BAh,14BEh
			dw		14C1h,14C5h,14C9h,14CDh
			dw		14D1h,14D5h,14D9h,14DDh
			dw		14E0h,14E4h,14E8h,14ECh
			dw		14F0h,14F4h,14F8h,14FBh
			dw		14FFh,1503h,1507h,150Bh
			dw		150Fh,1513h,1516h,151Ah
			dw		151Eh,1522h,1526h,152Ah
			dw		152Dh,1531h,1535h,1539h
			dw		153Dh,1541h,1544h,1548h
			dw		154Ch,1550h,1554h,1558h
			dw		155Bh,155Fh,1563h,1567h
			dw		156Bh,156Eh,1572h,1576h
			dw		157Ah,157Eh,1581h,1585h
			dw		1589h,158Dh,1591h,1594h
			dw		1598h,159Ch,15A0h,15A4h
			dw		15A7h,15ABh,15AFh,15B3h
			dw		15B7h,15BAh,15BEh,15C2h
			dw		15C6h,15C9h,15CDh,15D1h
			dw		15D5h,15D8h,15DCh,15E0h
			dw		15E4h,15E8h,15EBh,15EFh
			dw		15F3h,15F7h,15FAh,15FEh
			dw		1602h,1606h,1609h,160Dh
			dw		1611h,1614h,1618h,161Ch
			dw		1620h,1623h,1627h,162Bh
			dw		162Fh,1632h,1636h,163Ah
			dw		163Eh,1641h,1645h,1649h
			dw		164Ch,1650h,1654h,1658h
			dw		165Bh,165Fh,1663h,1666h
			dw		166Ah,166Eh,1671h,1675h
			dw		1679h,167Dh,1680h,1684h
			dw		1688h,168Bh,168Fh,1693h
			dw		1696h,169Ah,169Eh,16A1h
			dw		16A5h,16A9h,16ACh,16B0h
			dw		16B4h,16B7h,16BBh,16BFh
			dw		16C2h,16C6h,16CAh,16CDh
			dw		16D1h,16D5h,16D8h,16DCh
			dw		16E0h,16E3h,16E7h,16EBh
			dw		16EEh,16F2h,16F6h,16F9h
			dw		16FDh,1700h,1704h,1708h
			dw		170Bh,170Fh,1713h,1716h
			dw		171Ah,171Dh,1721h,1725h
			dw		1728h,172Ch,1730h,1733h
			dw		1737h,173Ah,173Eh,1742h
			dw		1745h,1749h,174Ch,1750h
			dw		1754h,1757h,175Bh,175Eh
			dw		1762h,1766h,1769h,176Dh
			dw		1770h,1774h,1778h,177Bh
			dw		177Fh,1782h,1786h,1789h
			dw		178Dh,1791h,1794h,1798h
			dw		179Bh,179Fh,17A2h,17A6h
			dw		17AAh,17ADh,17B1h,17B4h
			dw		17B8h,17BBh,17BFh,17C2h
			dw		17C6h,17C9h,17CDh,17D1h
			dw		17D4h,17D8h,17DBh,17DFh
			dw		17E2h,17E6h,17E9h,17EDh
			dw		17F0h,17F4h,17F7h,17FBh
			dw		17FEh,1802h,1806h,1809h
			dw		180Dh,1810h,1814h,1817h
			dw		181Bh,181Eh,1822h,1825h
			dw		1829h,182Ch,1830h,1833h
			dw		1837h,183Ah,183Eh,1841h
			dw		1845h,1848h,184Ch,184Fh
			dw		1853h,1856h,185Ah,185Dh
			dw		1860h,1864h,1867h,186Bh
			dw		186Eh,1872h,1875h,1879h
			dw		187Ch,1880h,1883h,1887h
			dw		188Ah,188Eh,1891h,1894h
			dw		1898h,189Bh,189Fh,18A2h
			dw		18A6h,18A9h,18ADh,18B0h
			dw		18B3h,18B7h,18BAh,18BEh
			dw		18C1h,18C5h,18C8h,18CCh
			dw		18CFh,18D2h,18D6h,18D9h
			dw		18DDh,18E0h,18E3h,18E7h
			dw		18EAh,18EEh,18F1h,18F5h
			dw		18F8h,18FBh,18FFh,1902h
			dw		1906h,1909h,190Ch,1910h
			dw		1913h,1917h,191Ah,191Dh
			dw		1921h,1924h,1928h,192Bh
			dw		192Eh,1932h,1935h,1938h
			dw		193Ch,193Fh,1943h,1946h
			dw		1949h,194Dh,1950h,1953h
			dw		1957h,195Ah,195Dh,1961h
			dw		1964h,1968h,196Bh,196Eh
			dw		1972h,1975h,1978h,197Ch
			dw		197Fh,1982h,1986h,1989h
			dw		198Ch,1990h,1993h,1996h
			dw		199Ah,199Dh,19A0h,19A4h
			dw		19A7h,19AAh,19AEh,19B1h
			dw		19B4h,19B8h,19BBh,19BEh
			dw		19C2h,19C5h,19C8h,19CCh
			dw		19CFh,19D2h,19D5h,19D9h
			dw		19DCh,19DFh,19E3h,19E6h
			dw		19E9h,19EDh,19F0h,19F3h
			dw		19F6h,19FAh,19FDh,1A00h
			dw		1A04h,1A07h,1A0Ah,1A0Dh
			dw		1A11h,1A14h,1A17h,1A1Bh
			dw		1A1Eh,1A21h,1A24h,1A28h
			dw		1A2Bh,1A2Eh,1A31h,1A35h
			dw		1A38h,1A3Bh,1A3Eh,1A42h
			dw		1A45h,1A48h,1A4Bh,1A4Fh
			dw		1A52h,1A55h,1A58h,1A5Ch
			dw		1A5Fh,1A62h,1A65h,1A69h
			dw		1A6Ch,1A6Fh,1A72h,1A76h
			dw		1A79h,1A7Ch,1A7Fh,1A83h
			dw		1A86h,1A89h,1A8Ch,1A8Fh
			dw		1A93h,1A96h,1A99h,1A9Ch
			dw		1A9Fh,1AA3h,1AA6h,1AA9h
			dw		1AACh,1AB0h,1AB3h,1AB6h
			dw		1AB9h,1ABCh,1AC0h,1AC3h
			dw		1AC6h,1AC9h,1ACCh,1ACFh
			dw		1AD3h,1AD6h,1AD9h,1ADCh
			dw		1ADFh,1AE3h,1AE6h,1AE9h
			dw		1AECh,1AEFh,1AF2h,1AF6h
			dw		1AF9h,1AFCh,1AFFh,1B02h
			dw		1B05h,1B09h,1B0Ch,1B0Fh
			dw		1B12h,1B15h,1B18h,1B1Ch
			dw		1B1Fh,1B22h,1B25h,1B28h
			dw		1B2Bh,1B2Eh,1B32h,1B35h
			dw		1B38h,1B3Bh,1B3Eh,1B41h
			dw		1B44h,1B48h,1B4Bh,1B4Eh
			dw		1B51h,1B54h,1B57h,1B5Ah
			dw		1B5Dh,1B61h,1B64h,1B67h
			dw		1B6Ah,1B6Dh,1B70h,1B73h
			dw		1B76h,1B79h,1B7Dh,1B80h
			dw		1B83h,1B86h,1B89h,1B8Ch
			dw		1B8Fh,1B92h,1B95h,1B98h
			dw		1B9Ch,1B9Fh,1BA2h,1BA5h
			dw		1BA8h,1BABh,1BAEh,1BB1h
			dw		1BB4h,1BB7h,1BBAh,1BBDh
			dw		1BC1h,1BC4h,1BC7h,1BCAh
			dw		1BCDh,1BD0h,1BD3h,1BD6h
			dw		1BD9h,1BDCh,1BDFh,1BE2h
			dw		1BE5h,1BE8h,1BEBh,1BEEh
			dw		1BF2h,1BF5h,1BF8h,1BFBh
			dw		1BFEh,1C01h,1C04h,1C07h
			dw		1C0Ah,1C0Dh,1C10h,1C13h
			dw		1C16h,1C19h,1C1Ch,1C1Fh
			dw		1C22h,1C25h,1C28h,1C2Bh
			dw		1C2Eh,1C31h,1C34h,1C37h
			dw		1C3Ah,1C3Dh,1C40h,1C43h
			dw		1C46h,1C49h,1C4Ch,1C4Fh
			dw		1C52h,1C55h,1C58h,1C5Bh
			dw		1C5Eh,1C61h,1C64h,1C67h
			dw		1C6Ah,1C6Dh,1C70h,1C73h
			dw		1C76h,1C79h,1C7Ch,1C7Fh
			dw		1C82h,1C85h,1C88h,1C8Bh
			dw		1C8Eh,1C91h,1C94h,1C97h
			dw		1C9Ah,1C9Dh,1CA0h,1CA3h
			dw		1CA6h,1CA9h,1CACh,1CAFh
			dw		1CB2h,1CB5h,1CB8h,1CBBh
			dw		1CBEh,1CC1h,1CC3h,1CC6h
			dw		1CC9h,1CCCh,1CCFh,1CD2h
			dw		1CD5h,1CD8h,1CDBh,1CDEh
			dw		1CE1h,1CE4h,1CE7h,1CEAh
			dw		1CEDh,1CF0h,1CF3h,1CF5h
			dw		1CF8h,1CFBh,1CFEh,1D01h
			dw		1D04h,1D07h,1D0Ah,1D0Dh
			dw		1D10h,1D13h,1D16h,1D18h
			dw		1D1Bh,1D1Eh,1D21h,1D24h
			dw		1D27h,1D2Ah,1D2Dh,1D30h
			dw		1D33h,1D35h,1D38h,1D3Bh
			dw		1D3Eh,1D41h,1D44h,1D47h
			dw		1D4Ah,1D4Dh,1D4Fh,1D52h
			dw		1D55h,1D58h,1D5Bh,1D5Eh
			dw		1D61h,1D64h,1D66h,1D69h
			dw		1D6Ch,1D6Fh,1D72h,1D75h
			dw		1D78h,1D7Bh,1D7Dh,1D80h
			dw		1D83h,1D86h,1D89h,1D8Ch
			dw		1D8Eh,1D91h,1D94h,1D97h
			dw		1D9Ah,1D9Dh,1DA0h,1DA2h
			dw		1DA5h,1DA8h,1DABh,1DAEh
			dw		1DB1h,1DB3h,1DB6h,1DB9h
			dw		1DBCh,1DBFh,1DC2h,1DC4h
			dw		1DC7h,1DCAh,1DCDh,1DD0h
			dw		1DD3h,1DD5h,1DD8h,1DDBh
			dw		1DDEh,1DE1h,1DE3h,1DE6h
			dw		1DE9h,1DECh,1DEFh,1DF1h
			dw		1DF4h,1DF7h,1DFAh,1DFDh
			dw		1DFFh,1E02h,1E05h,1E08h
			dw		1E0Bh,1E0Dh,1E10h,1E13h
			dw		1E16h,1E19h,1E1Bh,1E1Eh
			dw		1E21h,1E24h,1E26h,1E29h
			dw		1E2Ch,1E2Fh,1E32h,1E34h
			dw		1E37h,1E3Ah,1E3Dh,1E3Fh
			dw		1E42h,1E45h,1E48h,1E4Ah
			dw		1E4Dh,1E50h,1E53h,1E55h
			dw		1E58h,1E5Bh,1E5Eh,1E60h
			dw		1E63h,1E66h,1E69h,1E6Bh
			dw		1E6Eh,1E71h,1E74h,1E76h
			dw		1E79h,1E7Ch,1E7Fh,1E81h
			dw		1E84h,1E87h,1E8Ah,1E8Ch
			dw		1E8Fh,1E92h,1E94h,1E97h
			dw		1E9Ah,1E9Dh,1E9Fh,1EA2h
			dw		1EA5h,1EA8h,1EAAh,1EADh
			dw		1EB0h,1EB2h,1EB5h,1EB8h
			dw		1EBAh,1EBDh,1EC0h,1EC3h
			dw		1EC5h,1EC8h,1ECBh,1ECDh
			dw		1ED0h,1ED3h,1ED5h,1ED8h
			dw		1EDBh,1EDEh,1EE0h,1EE3h
			dw		1EE6h,1EE8h,1EEBh,1EEEh
			dw		1EF0h,1EF3h,1EF6h,1EF8h
			dw		1EFBh,1EFEh,1F00h,1F03h
			dw		1F06h,1F08h,1F0Bh,1F0Eh
			dw		1F10h,1F13h,1F16h,1F18h
			dw		1F1Bh,1F1Eh,1F20h,1F23h
			dw		1F26h,1F28h,1F2Bh,1F2Eh
			dw		1F30h,1F33h,1F36h,1F38h
			dw		1F3Bh,1F3Dh,1F40h,1F43h
			dw		1F45h,1F48h,1F4Bh,1F4Dh
			dw		1F50h,1F53h,1F55h,1F58h
			dw		1F5Ah,1F5Dh,1F60h,1F62h
			dw		1F65h,1F68h,1F6Ah,1F6Dh
			dw		1F6Fh,1F72h,1F75h,1F77h
			dw		1F7Ah,1F7Ch,1F7Fh,1F82h
			dw		1F84h,1F87h,1F8Ah,1F8Ch
			dw		1F8Fh,1F91h,1F94h,1F97h
			dw		1F99h,1F9Ch,1F9Eh,1FA1h
			dw		1FA4h,1FA6h,1FA9h,1FABh
			dw		1FAEh,1FB0h,1FB3h,1FB6h
			dw		1FB8h,1FBBh,1FBDh,1FC0h
			dw		1FC3h,1FC5h,1FC8h,1FCAh
			dw		1FCDh,1FCFh,1FD2h,1FD5h
			dw		1FD7h,1FDAh,1FDCh,1FDFh
			dw		1FE1h,1FE4h,1FE6h,1FE9h
			dw		1FECh,1FEEh,1FF1h,1FF3h
			dw		1FF6h,1FF8h,1FFBh,1FFDh
			dw		2000h,2000h
_DATA	ENDS

_TEXT	ENDS

END
