
#include "headers.h"

#include "shell.h"
#include "chuck.h"
#include "include\sos.h"

#include "iff.h"
#include "frontend.h"
#include "frontdef.h"
#include "frglobs.h"


/*-----------------21/09/95 13:02-------------------
 Sound fx module
--------------------------------------------------*/

/**********************************************************************/
/** Externs **/
extern	int	reloadSoundPlayed;
extern 	int	normalCD;

extern 	int	soundPitchUsed;
extern 	int	soundVolumeUsed;

#define MySoundPlaySample(a,b,c,d) SoundPlaySample(a,b,c,d);soundPitchUsed=c
#define MySoundPlaySampleLooped SoundPlaySampleLooped


/**********************************************************************/

/** Constants and macros **/


// General fx constants



// FX specific constants

#define PITCH_VALUE_1							30
#define PITCH_VALUE_2							35
#define PITCH_VALUE_3							40
#define PITCH_VALUE_4							50
#define PITCH_VALUE_5							60
#define SHELL_EXPLOSION_PITCH			25
#define MIN_ENGINE_PITCH					20
#define HELI_ROTOR_AUDIBLE_RANGE	0x1000
#define HELICOPTER_SOUND_PITCH		50



// frigged to get it in
void	SoundSetSampleVolume(uint handle, int newVolume);



/**********************************************************************/
/** Sound globals **/


static	short	turretSoundPlaying=FALSE;

static	dword	engineSampleHandle;
static	dword turretSampleHandle;
//static	int	enginePitch=MIN_ENGINE_PITCH;
static	int	warningSoundPlaying=0;
static	char	*sfxFiles[]=
{
	"sfx\\EXPL2FAR.wav",			/* Far explosion */
	"sfx\\EXPNEAR.wav",				/* Near explosion */
	"sfx\\HELIGUN2.wav",			/* Helicopter guns */
	"sfx\\HELIBLAD.wav",			/* Helicopter rotor blades */
	"sfx\\PL1CAN.wav",				/* Player gun firing */
	"sfx\\PL1ENRT.wav",				/* Player energy warning */
	"sfx\\P1_PSHEL.wav",			/* Shell reload */
	"sfx\\PL1CHAIN.wav",			/* Player chain gun */
	"sfx\\PL1HIT1.wav",				/* Player hit by bullet */
	"sfx\\PL1HIT2.wav",       /*  ..  */
	"sfx\\PL1HIT3.wav",				/*  ..  */
	"sfx\\PL1HIT4.wav",       /*  ..  */
	"sfx\\PL1THROU.wav",      /* Player through fence */
	"sfx\\TANKEN1.wav",				/* Tank engine sound */
	"sfx\\ENEFIR2.wav",				/* Enemy chaingun fire */
	"sfx\\collect.wav",				/* Sound for going over a collectable crate */
	"SFX\\PMISSILE.WAV",				/* Sound for SAM */

	/** Character in game speech - basic stuff */

	/* Dtour */

	"sfx\\dtwhat.wav",				// 17
	"sfx\\dtgtded.wav",				// 18
	"sfx\\dtgthel.wav",       // 19
	"sfx\\dtthway.wav",				// 20
	"sfx\\dtyo.wav",					// 21
	"sfx\\dteat.wav",					// 22
	"sfx\\dtsafe.wav",				// 23
	"sfx\\dtsafbd.wav",				// 24	(decked)

	/* Earshot */

	"sfx\\eahead.wav",				// 25
	"sfx\\egorht.wav",				// 26
	"sfx\\egolft.wav",        // 27
	"sfx\\ewrongw.wav",       // 28
	"sfx\\ewarn.wav"          // 29	(decked)

	/* Dog tag */

	"sfx\\dgabort2.wav",			// 30
	"sfx\\dggood.wav",        // 31


	/* 911 */

	"sfx\\9bite.wav",         // 32
	"sfx\\9onmyw.wav",				// 33
	"sfx\\tmove8.wav",				// turret moving sound
	"sfx\\tlock8.wav"					// turret locking sound
//	"sfx\\9noway.wav",        // 34 (decked)
//	"sfx\\9hit.wav",          // 35 (decked)
};



void	load_level_samples(int i)
{
	SoundLoadSamples(sfxFiles,arraysize(sfxFiles));
}

/**********************************************************************/

void	start_engine(void)
{
//	SampleInfo pSInfo;
//
//	SoundGetSampleInfo(PLYR_ENGN,&pSInfo);
	/** Start off the engine sound - looped sample */

//	engineSampleHandle = MySoundPlaySampleLooped(PLYR_ENGN,	set_actual_volume(SOUND_QUIET), MIN_ENGINE_PITCH,	SOUND_CENTRE,
//				SOUND_FOREVER, SOUND_FROM_START, pSInfo.dwSamples);
	engineSampleHandle = MySoundPlaySampleLooped(PLYR_ENGN,	set_actual_volume(SOUND_LOUD), MIN_ENGINE_PITCH,	SOUND_CENTRE,
				SOUND_FOREVER, SOUND_FROM_START, -1);
}

/**********************************************************************/

void	stop_engine_sound(void)
{
	SoundStopSample(engineSampleHandle);
}


/**********************************************************************/

void	adjust_engine(void)
{
	SoundSetPitch(engineSampleHandle, MIN_ENGINE_PITCH + (abs(pl.speed)>>8) );
	SoundSetSampleVolume(engineSampleHandle,set_actual_volume(SOUND_LOUD));
}

/**********************************************************************/


void	shell_explosion_sound(uint	x, uint z)
{
	int	relx,relz;
	int	explosionVolume;
	int	explosionFx;
	int	explDist;

	relx=abs(((uint)pl.x>>16)-(x>>16));
	relz=abs(((uint)pl.z>>16)-(z>>16));

	if ( relx>relz )
	{
		explDist=(relz>>1)+relx;
	}
	else
	{
		explDist=(relx>>1)+relz;
	}

	if ( explDist >0x1a00 ) 								/* Too far away to hear an explosion */
	{
		return ;
	}

	if ( explDist >= 0x1800)						/* Explosion very far */
	{
		explosionVolume=SOUND_QUIET;
		explosionFx = FAR_EXPLOSION;
	}
	else
	if ( explDist <= 0x200)							/* Explosion very near */
	{
		explosionVolume=0x4000;
		explosionFx = NEAR_EXPLOSION;
	}
	else																/* Work out volume of explosion */
	{
		explosionVolume= 0x4000 - ((explDist-0x200) <<1);
		if ( explosionVolume<=0x2000 )
		{
			explosionFx = FAR_EXPLOSION;
		}
		else
			explosionFx = NEAR_EXPLOSION;

	}

	MySoundPlaySample(explosionFx, set_actual_volume(explosionVolume), SHELL_EXPLOSION_PITCH, SOUND_CENTRE);
}


/**********************************************************************/


void	reload_sample(void)
{
	MySoundPlaySample(PLYR_RELOAD_SHELL, set_actual_volume(0x3000), SOUND_ORIGINAL_PITCH, SOUND_CENTRE);
	reloadSoundPlayed=TRUE;
}



/**********************************************************************/

void	fire_shell_sound(TANK *tank)
{


	if ( tank==&pl )
	{
 		MySoundPlaySample(PLYR_CANNON, set_actual_volume(SOUND_LOUD), PITCH_VALUE_4, SOUND_CENTRE);
 		reloadSoundPlayed = FALSE;
	}
	else
	{
  	int	relx,relz;
  	int	explosionVolume;
  	int	explDist;

  	relx=abs(((uint)pl.x>>16)-(tank->x>>16));
  	relz=abs(((uint)pl.z>>16)-(tank->z>>16));

  	if ( relx>relz )
  	{
  		explDist=(relz>>1)+relx;
  	}
  	else
  	{
  		explDist=(relx>>1)+relz;
  	}

  	if ( explDist >0x1a00 ) 								/* Too far away to hear an explosion */
  	{
  		return ;
  	}

  	if ( explDist >= 0x1800)						/* Explosion very far */
  	{
  		explosionVolume=SOUND_QUIET;
  	}
  	else
  	if ( explDist <= 0x200)							/* Explosion very near */
  	{
  		explosionVolume=0x4000;
  	}
  	else																/* Work out volume of explosion */
  	{
  		explosionVolume= 0x4000 - ((explDist-0x200) <<1);
  	}

  	MySoundPlaySample(PLYR_CANNON, set_actual_volume(explosionVolume), PITCH_VALUE_3, SOUND_CENTRE);
	}

}


/**********************************************************************/

void	player_hit_sound(int damageVal)
{

	if ( damageVal<0x40 ) /* Hit by bullet */
	{
		if ( !(rand()&7))
		{
			MySoundPlaySample(PLYR_HIT_SND1+(rand()&3), set_actual_volume(0x4000), PITCH_VALUE_5, SOUND_CENTRE);
		}
	}
	else									/* Hit by shell */
		MySoundPlaySample(NEAR_EXPLOSION, set_actual_volume(SOUND_V_LOUD), PITCH_VALUE_1, SOUND_CENTRE);
}

/**********************************************************************/

void	enemy_hit_sound(uint	x, uint z, int damageVal)
{
	int	relx,relz;
	int	explosionVolume;
	int	explosionFx;
	int	explDist;

	relx=abs(((uint)pl.x>>16)-(x>>16));
	relz=abs(((uint)pl.z>>16)-(z>>16));

	if ( relx>relz )
	{
		explDist=(relz>>1)+relx;
	}
	else
	{
		explDist=(relx>>1)+relz;
	}


	if ( explDist >0x1a00 ) 								/* Too far away to hear an explosion */
	{
		return ;
	}

	if ( explDist >= 0x1800)						/* Explosion very far */
	{
		explosionVolume=SOUND_QUIET;
		explosionFx = FAR_EXPLOSION;
	}
	else
	if ( explDist <= 0x200)							/* Explosion very near */
	{
		explosionVolume=0x4000;
		explosionFx = NEAR_EXPLOSION;
	}
	else																/* Work out volume of explosion */
	{
		explosionVolume= 0x4000 - ((explDist-0x200) <<1);
		if ( explosionVolume<=0x2000 )
		{
			explosionFx = FAR_EXPLOSION;
		}
		else
			explosionFx = NEAR_EXPLOSION;
	}


	if ( damageVal<0x40 )
	{
		if ( !(rand()&7) )
		{
			explosionVolume-=((explosionVolume>>1)+(explosionVolume>>2));
			MySoundPlaySample(PLYR_HIT_SND1+(rand()&3), set_actual_volume(explosionVolume), PITCH_VALUE_3, SOUND_CENTRE);
		}
	}
	else
	{
		MySoundPlaySample(explosionFx, set_actual_volume(explosionVolume), PITCH_VALUE_1, SOUND_CENTRE);
	}
}

/**********************************************************************/

void	enemy_destroyed_sound(uint def, uint x, uint z)
{
	int	relx,relz;
	int	explosionVolume;
	int	explosionFx;
	int	explDist;

	relx=abs(((uint)pl.x>>16)-(x>>16));
	relz=abs(((uint)pl.z>>16)-(z>>16));

	if ( relx>relz )
	{
		explDist=(relz>>1)+relx;
	}
	else
	{
		explDist=(relx>>1)+relz;
	}

	if ( explDist >0x1a00 ) 						/* Too far away to hear an explosion */
	{
		return ;
	}

	if ( explDist >= 0x1800)						/* Explosion very far */
	{
		explosionVolume=SOUND_QUIET;
		explosionFx = FAR_EXPLOSION;
	}
	else
	if ( explDist <= 0x200)							/* Explosion very near */
	{
		explosionVolume=0x7fff;
		explosionFx = NEAR_EXPLOSION;
	}
	else																/* Work out volume of explosion */
	{
		explosionVolume= 0x7fff - ((explDist-0x200)*5);
		if ( explosionVolume<=0x4000 )
		{
			explosionFx = FAR_EXPLOSION;
		}
		else
			explosionFx = NEAR_EXPLOSION;
	}

	if ( (explosionVolume>0x1000) && (def==E_GUNEMPL || def==ALLIED_TRUCK || def==ENEMY_TRUCK) )
	{
		explosionVolume-=0x1000;
	}

	MySoundPlaySample(explosionFx, set_actual_volume(explosionVolume), PITCH_VALUE_2, SOUND_CENTRE);
}

/**********************************************************************/

#define CHAIN_GUN_HEARING_DISTANCE		0x2000

void	chaingun_sound(TANK *stank)
{
	int	relx,relz;
	uint	dist;
	int	fxVolume;
	int	fxid;

	if ( stank->chaingunSound )
	{
		stank->chaingunSound--;
		return ;
	}

	if ( stank->def==PLAYER_TANK )
	{
		MySoundPlaySample(PLYR_CHAIN_GUN, set_actual_volume(SOUND_NORMAL_VOLUME), SOUND_ORIGINAL_PITCH+10, SOUND_CENTRE);
		stank->chaingunSound=6;
		cgunBurstCount=4;
	}
	else
	{
		relx=abs(((uint)pl.x>>16)-(stank->x>>16));
		relz=abs(((uint)pl.z>>16)-(stank->z>>16));

		if ( relx>relz )
		{
			dist=relx+(relz>>1);
		}
		else
			dist=relz+(relx>>1);

		if ( dist > CHAIN_GUN_HEARING_DISTANCE )
		{
			return ;
		}

		if ( stank->def == ENEMY_APC )
		{
			fxid=ENEM_CHAINGUN_FIRE;
			fxVolume = 0x1e00 - (dist-0x200);
		}
		else
		if ( stank->def == E_HELICOPTER )
		{
			fxid=ENEM_CHAINGUN_FIRE;
			fxVolume = 0x1e00 - (dist-0x200);
		}
		else
		if ( stank->def == E_GUNSHIP )
		{
			fxid=ENEM_CHAINGUN_FIRE;
			fxVolume = 0x1e00 - (dist-0x200);
		}

		MySoundPlaySample(fxid, set_actual_volume(fxVolume), PITCH_VALUE_5, SOUND_CENTRE);
		stank->chaingunSound = 6;
	}
}


/**********************************************************************/

void	gunempl_chaingun_sound(GUN_EMPLACEMENT *sgunempl)
{
	int		relx,relz;
	uint	dist;
	int		fxVolume;

	if ( sgunempl->chaingunSound )
	{
		sgunempl->chaingunSound--;
		return ;
	}

	relx=abs(((uint)pl.x>>16)-(sgunempl->x>>16));
	relz=abs(((uint)pl.z>>16)-(sgunempl->z>>16));

	if ( relx>relz )
	{
		dist=relx+(relz>>1);
	}
	else
		dist=relz+(relx>>1);

	if ( dist > CHAIN_GUN_HEARING_DISTANCE )
	{
		return ;
	}

	fxVolume = 0x1e00 - (dist-0x200);

	MySoundPlaySample(ENEM_CHAINGUN_FIRE, set_actual_volume(fxVolume), PITCH_VALUE_5, SOUND_CENTRE);
	sgunempl->chaingunSound = 6;
}


void	gunboat_chaingun_sound(GUN_BOAT *fgunboat)
{
	int		relx,relz;
	uint	dist;
	int		fxVolume;

	if ( fgunboat->chaingunSound )
	{
		fgunboat->chaingunSound--;
		return ;
	}

	relx=abs(((uint)pl.x>>16)-(fgunboat->x>>16));
	relz=abs(((uint)pl.z>>16)-(fgunboat->z>>16));

	if ( relx>relz )
	{
		dist=relx+(relz>>1);
	}
	else
		dist=relz+(relx>>1);

	if ( dist > CHAIN_GUN_HEARING_DISTANCE )
	{
		return ;
	}

	fxVolume = 0x1e00 - (dist-0x200);

	MySoundPlaySample(ENEM_CHAINGUN_FIRE, set_actual_volume(fxVolume), PITCH_VALUE_5, SOUND_CENTRE);
	fgunboat->chaingunSound = 6;
}


/**********************************************************************/


void	play_death_sound(void)
{
	MySoundPlaySample(NEAR_EXPLOSION, set_actual_volume(0x7000), PITCH_VALUE_2, SOUND_CENTRE);
	MySoundPlaySample(FAR_EXPLOSION, set_actual_volume(0x7800), PITCH_VALUE_1, SOUND_CENTRE);
}

/**********************************************************************/

void	large_building_explosion_snd(uint x, uint z)
{
	int	relx,relz;
	int	explosionVolume;
	int	explDist;

	relx=abs(((uint)pl.x>>16)-x);
	relz=abs(((uint)pl.z>>16)-z);

	if ( relx>relz )
	{
		explDist=(relz>>1)+relx;
	}
	else
	{
		explDist=(relx>>1)+relz;
	}

	if ( explDist >0x1a00 ) 						/* Too far away to hear an explosion */
	{
		return ;
	}

	if ( explDist >= 0x1800)						/* Explosion very far */
	{
		explosionVolume=SOUND_QUIET;
	}
	else
	if ( explDist <= 0x200)							/* Explosion very near */
	{
		explosionVolume=0x7000;
	}
	else																/* Work out volume of explosion */
	{
		explosionVolume= 0x7000 - ((explDist-0x200)*5);
	}

	MySoundPlaySample(FAR_EXPLOSION, set_actual_volume((explosionVolume+0xfff)), PITCH_VALUE_2, SOUND_CENTRE);
	MySoundPlaySample(NEAR_EXPLOSION, set_actual_volume(explosionVolume), PITCH_VALUE_2, SOUND_CENTRE);
	MySoundPlaySample(FAR_EXPLOSION, set_actual_volume(explosionVolume+0x100), PITCH_VALUE_3, SOUND_CENTRE);
}

/**********************************************************************/

void	normal_building_explosion_snd(uint x, uint z)
{
	int	relx,relz;
	int	explosionVolume;
	int	explDist;

	relx=abs(((uint)pl.x>>16)-x);
	relz=abs(((uint)pl.z>>16)-z);

	if ( relx>relz )
	{
		explDist=(relz>>1)+relx;
	}
	else
	{
		explDist=(relx>>1)+relz;
	}

	if ( explDist >0x1a00 ) 						/* Too far away to hear an explosion */
	{
		return ;
	}

	if ( explDist >= 0x1800)						/* Explosion very far */
	{
		explosionVolume=SOUND_QUIET;
	}
	else
	if ( explDist <= 0x200)							/* Explosion very near */
	{
		explosionVolume=0x7000;
	}
	else																/* Work out volume of explosion */
	{
		explosionVolume= 0x7000 - ((explDist-0x200)*5);
	}

	MySoundPlaySample(FAR_EXPLOSION, set_actual_volume(explosionVolume+0xfff), PITCH_VALUE_2, SOUND_CENTRE);
	MySoundPlaySample(NEAR_EXPLOSION, set_actual_volume(explosionVolume), PITCH_VALUE_2, SOUND_CENTRE);
}

/**********************************************************************/

void	small_building_explosio_snd(uint x, uint z)
{
	int	relx,relz;
	int	explosionVolume;
	int	explosionFx;
	int	explDist;

	relx=abs(((uint)pl.x>>16)-x);
	relz=abs(((uint)pl.z>>16)-z);

	if ( relx>relz )
	{
		explDist=(relz>>1)+relx;
	}
	else
	{
		explDist=(relx>>1)+relz;
	}

	if ( explDist >0x1a00 ) 						/* Too far away to hear an explosion */
	{
		return ;
	}

	if ( explDist >= 0x1800)						/* Explosion very far */
	{
		explosionVolume=SOUND_QUIET;
		explosionFx = FAR_EXPLOSION;
	}
	else
	if ( explDist <= 0x200)							/* Explosion very near */
	{
		explosionVolume=0x7000;
		explosionFx = NEAR_EXPLOSION;
	}
	else																/* Work out volume of explosion */
	{
		explosionVolume= 0x7000 - ((explDist-0x200)*5);
		explosionFx = FAR_EXPLOSION;
	}

	MySoundPlaySample(explosionFx, set_actual_volume(explosionVolume), PITCH_VALUE_2, SOUND_CENTRE);
}

/**********************************************************************/

void	fuel_tank_explosion_snd(uint x, uint z)
{
	int	relx,relz;
	int	explosionVolume;
	int	explDist;

	relx=abs(((uint)pl.x>>16)-x);
	relz=abs(((uint)pl.z>>16)-z);

	if ( relx>relz )
	{
		explDist=(relz>>1)+relx;
	}
	else
	{
		explDist=(relx>>1)+relz;
	}

	if ( explDist >0x1a00 ) 						/* Too far away to hear an explosion */
	{
		return ;
	}

	if ( explDist >= 0x1800)						/* Explosion very far */
	{
		explosionVolume=SOUND_QUIET;
	}
	else
	if ( explDist <= 0x200)							/* Explosion very near */
	{
		explosionVolume=0x7fff;
	}
	else																/* Work out volume of explosion */
	{
		explosionVolume= 0x7fff - ((explDist-0x200)*5);
	}

	MySoundPlaySample(FAR_EXPLOSION, set_actual_volume((explosionVolume+0xfff)), PITCH_VALUE_2, SOUND_CENTRE);
	MySoundPlaySample(NEAR_EXPLOSION, set_actual_volume(explosionVolume), PITCH_VALUE_2, SOUND_CENTRE);
	MySoundPlaySample(FAR_EXPLOSION, set_actual_volume((explosionVolume+0x100)), PITCH_VALUE_3, SOUND_CENTRE);
	MySoundPlaySample(NEAR_EXPLOSION, set_actual_volume((explosionVolume+0X80)), PITCH_VALUE_3, SOUND_CENTRE);
}

/**********************************************************************/


void	reset_player_warning_sounds(void)
{
	warningSoundPlaying=0;
}

/**********************************************************************/


void	play_armour_warning_sound(void)
{
	if ( !warningSoundPlaying )
	{
		MySoundPlaySample(PLYR_NRG_WARNING, set_actual_volume(SOUND_NORMAL_VOLUME), SOUND_ORIGINAL_PITCH, SOUND_CENTRE);
		warningSoundPlaying = 0x30;
		armourDisplayColour=ARMOUR_FUCKED_COLOUR;
		draw_armour_display();
	}
	else
	{
		warningSoundPlaying--;
		if ( (warningSoundPlaying<0x18) && armourDisplayColour==ARMOUR_FUCKED_COLOUR)
		{
			armourDisplayColour=ARMOUR_OK_COLOUR;
			draw_armour_display();
		}
	}
}


/**********************************************************************/

void	play_fence_crunch_sound(void)
{
	MySoundPlaySample(PLYR_THR_FENCE, set_actual_volume(SOUND_NORMAL_VOLUME), SOUND_ORIGINAL_PITCH, SOUND_CENTRE);
}

/**********************************************************************/


void	play_picked_up_collectable_sound(void)
{
	MySoundPlaySample(COLLECTABLE_SOUND, set_actual_volume(SOUND_NORMAL_VOLUME), SOUND_ORIGINAL_PITCH, SOUND_CENTRE);
}

/**********************************************************************/



extern	char		ignoreHits;


void	start_helicopter_rotor_sound(TANK *heli)
{
	int	relx,relz;
	int	heliDist;
//	SampleInfo pSInfo;

	relx=abs(((uint)pl.x>>16)-(heli->x>>16));
	relz=abs(((uint)pl.z>>16)-(heli->z>>16));

	if ( relx>relz )
	{
		heliDist=(relz>>1)+relx;
	}
	else
	{
		heliDist=(relx>>1)+relz;
	}

	if ( heliDist > HELI_ROTOR_AUDIBLE_RANGE ) 		/* helicopter too far to be heard */
	{
		return ;
	}



	//SoundGetSampleInfo(HELI_ROTOR_BLADES,&pSInfo);

//	heli->soundHandle = MySoundPlaySampleLooped(HELI_ROTOR_BLADES,	set_actual_volume(SOUND_QUIET), HELICOPTER_SOUND_PITCH,	SOUND_CENTRE,
//				SOUND_FOREVER, SOUND_FROM_START, pSInfo.dwSamples);
	heli->soundHandle = MySoundPlaySampleLooped(HELI_ROTOR_BLADES,	set_actual_volume(SOUND_QUIET), HELICOPTER_SOUND_PITCH,	SOUND_CENTRE,
				SOUND_FOREVER, SOUND_FROM_START, -1);
}



void	update_helicopter_sound_rotor_sound(TANK *heli)
{
	int	relx,relz;
	int	heliDist;
	int	heliVolume;

	relx=abs(((uint)pl.x>>16)-(heli->x>>16));
	relz=abs(((uint)pl.z>>16)-(heli->z>>16));

	if ( relx>relz )
	{
		heliDist=(relz>>1)+relx;
	}
	else
	{
		heliDist=(relx>>1)+relz;
	}

	if ( heliDist > HELI_ROTOR_AUDIBLE_RANGE ) 		/* helicopter too far to be heard */
	{
		SoundStopSample(heli->soundHandle);					/* stop the sample */
		heli->soundHandle = 0XFFFFFFFF;							/* Signify that the helicopter can no longer be heard */
		return ;
	}

	heliVolume = 0x7fff - (heliDist<<3);

	SoundSetSampleVolume(heli->soundHandle, heliVolume);
}



void	stop_helicopter_sample(TANK *heli)
{
	if ( heli->soundHandle != 0XFFFFFFFF )
	{
		SoundStopSample(heli->soundHandle);					/* stop the sample */
		heli->soundHandle = 0XFFFFFFFF;							/* Signify that the helicopter can no longer be heard */
	}
}



/**************************************************/

void	SoundSetSampleVolume(uint handle, int newVolume)
{
	if (!digi_inst || !sfx_on)
		return;
	if (newVolume<=0 || newVolume>0x7fff)
		return;

	sosDIGISetSampleVolume( SoundGetSOSHandle(), handle, newVolume );
}


/**********************************************************************/

void	play_launch_sam_sound(void)
{
	MySoundPlaySample(SAM_LAUNCH_SOUND, set_actual_volume(SOUND_NORMAL_VOLUME), 80, SOUND_CENTRE);
}



/**********************************************************************/

void	play_crunch_sound(void)
{
	MySoundPlaySample(PLYR_THR_FENCE, set_actual_volume(SOUND_NORMAL_VOLUME), SOUND_ORIGINAL_PITCH-10, SOUND_CENTRE);
}

/**********************************************************************/

void	play_click_sound(void)
{
	MySoundPlaySample(TURRET_LOCKED_SOUND, set_actual_volume(SOUND_NORMAL_VOLUME), SOUND_ORIGINAL_PITCH+70, SOUND_CENTRE);
}



void	play_turret_locked_sound(void)
{
	MySoundPlaySample(TURRET_LOCKED_SOUND, set_actual_volume(SOUND_NORMAL_VOLUME), SOUND_ORIGINAL_PITCH-10, SOUND_CENTRE);
}



void	initialise_turret_sound(void)
{
	turretSoundPlaying = FALSE;
}



void	start_turret_moving_sound(void)
{
//	SampleInfo pSInfo;

	if ( turretSoundPlaying )
	{
		return ;
	}

//	SoundGetSampleInfo(TURRET_MOVE_SOUND,&pSInfo);

//	turretSampleHandle = MySoundPlaySampleLooped(TURRET_MOVE_SOUND,	set_actual_volume(SOUND_LOUD), SOUND_ORIGINAL_PITCH-10,	SOUND_CENTRE,
//				SOUND_FOREVER, SOUND_FROM_START, pSInfo.dwSamples);

	turretSampleHandle = MySoundPlaySampleLooped(TURRET_MOVE_SOUND,	set_actual_volume(SOUND_LOUD), SOUND_ORIGINAL_PITCH-10,	SOUND_CENTRE,
				SOUND_FOREVER, SOUND_FROM_START, -1);

	turretSoundPlaying = TRUE;
}



void	stop_turret_moving_sound(void)
{
	if ( !turretSoundPlaying )
	{
		return ;
	}

	SoundStopSample(turretSampleHandle);
	turretSoundPlaying = FALSE;
}


/**********************************************************************/
/** MUSIC STUFF **/
void	play_me_a_song(int snmbr)
{
	if (normalCD) CDPlay(snmbr+1);
}

