#ifndef SHOCK_HEADER
#define SHOCK_HEADER

#include "typedefs.h"
#include "frames.h"
#include "shokstrc.h"

#ifdef PC_VERSION
#include "netextra.h"
#endif


//#define FULL_GAME

enum { no_wadds, build_wadds, load_wadds };

extern	uint waddStatus;

/***********************************************/
/** general debug stuff ****/

extern char	debugMessage[256];
extern short	displayDebug;

extern	unsigned int	totalMalloced;


#define message(a) {sprintf(debugMessage,"%s",a); displayDebug=1;}
#define clr_message displayDebug=0;

extern	int	recordRollingDemo;
extern	int	rollingDemo;
extern	char	rollingDemoFilename[320];
extern	FILE	*rollingDemoFile;
extern	ushort	*rollingDemoData;
extern	ushort	*crollData;
extern 	ushort	networkGame;
extern	ushort	showStats;
extern 	ushort 	fullArmourMent;


/************************************/

/*-----------------03/01/96 12:41-------------------
 WAD GLOBALS
--------------------------------------------------*/

extern	uchar	*basic_wadd_pointer;
extern	uchar	*level_wadd_pointer;


/***********************************************/
extern	int		gameSong;
extern	int		pan_offset;

/*-----------------06/10/95 11:53-------------------
	Air support variables
--------------------------------------------------*/

extern	ushort	asmsAlive;
extern	int airSupportTriggerd;
extern 	NINE_11		nine;

extern	int			objectiveX, objectiveZ;
extern	int			showObjectiveDirn;
extern	int			checkExitGame;
extern	int			setoptions;


/*-----------------21/12/95 09:39-------------------
 message stuff
--------------------------------------------------*/

extern 	uchar		*messageStringList[];
extern 	ushort	messageStringPos[MAX_MENU_TXT_MESSAGES][2];
extern	uchar		*ingameText[];
extern	uchar		gentempString[320];
extern 	uchar		*characterText[];
extern	uchar		*textfile;

extern	KOKPIT_MESSAGE	*currentMessage;
extern	short	messagePlaying;
extern	short		messageLength;



extern 	uchar		optionTypes[MAX_OPTION_ITEMS];
extern	ushort	optionLimits[MAX_OPTION_ITEMS];

extern	int			optionItem;
extern	int			optionSettings[];

/***********************************************/
/** Macros used */

#define show_message(a) (messageId=a)
#define clear_messages	messageId=0

#define set_exit_game(a)	game_on=0;endgameStatus=a


/*
 * 	Global variables used
 */


extern	uchar	level;

#define 	VIDEO_START_ADRESS					0XA0000

#define 	NUMBER_OF_REGIONS						20
#define 	MAX_MISSIONS			 					26



/***********************************************/
/** Message variables - for main game screen  **/

extern	int	messageId;
extern	int	msgFlash;
extern 	int	passFlag;


#define	CATCHMENTS_ACROSS					15

/***********************************************/
extern	ushort	catchTable[32];			/* Catchment index table */

extern	uint	cgunBurstCount;
extern	uint	flashValue;
extern	uint	armourDisplayColour;
extern	int		playerChainCount;
extern 	int		playerChainReset;
extern 	int		playerCoolDelay;

/***********************************/
/* Objective variables */

extern	ushort	*objectivData;
extern	ushort	objectiveType;
extern	ushort	*objectiveBuildings;
extern	ushort	numObjectiveEnemies;
extern	ushort	objectiveAchieved;
extern	ushort	numObjectiveBuildings;
extern	ushort	numObjectiveBuildingsLeft;
extern	ushort	convoyCompleted;
extern 	ushort	convoyDestroyed;
extern	int	totalConvoyMembers;

extern	char		exitGameString[];
extern	ushort	numHostages;
extern	ushort	numHostagesCollected;
extern	ushort	numHostagesLeft;
extern	int			totalObjectiveEnemies;

extern	int			missionNumber;

extern	uint	numShotsFired;
extern	uint	numShotsHit;
extern 	int		endgameStatus;
extern	ushort	rendezvousPoints[MAX_MISSIONS][2];

/***********************************/
/* Pickup variables */

extern ushort		moneyCollected;

/* Mission objective variables */

extern	ushort	*objectivData;
extern	ushort	objectiveType;
extern	ushort	*objectiveBuildings;
extern	ushort	numObjectiveEnemies;
extern	ushort	numObjectiveBuildings;
extern	ushort	numObjectiveBuildingsLeft;
extern	ushort	objectiveAchieved;
extern	ushort	convoyCompleted;
extern	ushort	convoyDestroyed;
extern	ushort	numHostages;
extern	ushort	numHostagesCollected;
extern	ushort	numHostagesLeft;
extern	ushort	gotoRendezvous;
extern	char		exitGameString[256];
extern	int			debounce;
extern	int			messageAnimCounter;



/***********************************/
/* Enemy characteristic */

extern short	enemyHitpoints[MAX_MISSIONS][MAX_ROTATING_OBJECTS];
extern short	enemyShellDelays[MAX_ROTATING_OBJECTS];
extern short	enemyShellDamage[MAX_ROTATING_OBJECTS];
extern short	enemyShellRanges[MAX_ROTATING_OBJECTS];
extern short	enemyShellSpeed[MAX_ROTATING_OBJECTS];

extern int	objectDetectSizes[];





/****************************************************/
/**  Tank control and movement variables **/
/****************************************************/

extern ASM							*asms;
extern SHELL_DATA 			*playerShells;//[];   /* Data about the shells the player has recently fired */
extern SHELL_DATA				*enemyShells;//[];
extern ANIM_TXTR_DATA 	*animating_txtr_data;	/* The animation information for the animating walls */
extern WALL_DATA 				*wallSfcs;						/* Wall data - p1,p2,walltype */
extern WORKING_POINT 		*workPoints;					/* Temporary workspace for storing transformed wall points. */
extern short 						*wallHitList;					/* The hitpoints for each wall */
extern ushort						*wallHitPoints[];			/* The hitpoint list for all walls */

extern FX_SPRITE				*fxSprites;//[];			/* List of fx sprites available */
extern FRAGMENT_DATA		*fragments;//[];			/* List of fragments available */
extern DELAYED_FX				*delayedFX;//[];			/* List of delayed fx slots */
extern uchar						fxlistTypes[MAX_FX_GROUPS][MAX_DELAY_FX];
extern uchar						fxlistDelays[MAX_FX_GROUPS][MAX_DELAY_FX];

extern WALL_DETECTION_INFO wdetect_info[];

extern CONTROL_INPUT	cinp;

extern int	numSams;

extern ushort currentIgnoreValue;
extern int		mapscale;


extern int	pitchFactor;


extern ushort	weaponsAvailable[];



/***************************************************/
/** Wall data **/
/***************************************************/


extern ushort *wallData;						/* Start of point and wall data */
extern POINT_DATA *wallPoints;			 /* point data - x,z */

extern POINT_DATA *wallMids;				/* Wall midpoints midx,midy */
extern POINT_DATA *wallMidStart;		/* an indexed start point in list of walls */
extern uchar 	*wallTextures;				/* Wall texturemaps */
extern uint		*txmtrans;						/* Texture map address translation buffer */
extern int	 	numPoints;						/* Number of points loaded */
extern int	 	numSfcs;							/* Number of surfaces loaded */
extern ushort	*destroyableBuildingList;
extern ushort	*destroyableBuildingGroups;
extern ushort	*buildingTargetList;
extern ushort	numBtargets;



extern unsigned int	*animTxtrOffs;	/* The start frame of each of the animating textures */
extern unsigned int	*animTxtrData;	/* Temp pointer for loading in animating texture data */
extern unsigned int	*numAnimFrames;	/* The number of frames of each animating texture */
extern unsigned	int	numAnims;				/* The number of animating textures */

extern uchar	*workPointsCheck;			/* Check list of the points that have already been transformed */
extern uchar	currentCheckVal;			/* Current 'tick' value of checklist */
extern uint		currentResetIndex;		/* Portion of checklist that will be 'reset' */

extern ushort	 	wall_z_index[];



/****************************************************/

extern uint		camera_angle;
extern int		turret_angle;
extern int		turretVelocity;
extern int		turretCentering;


extern uchar	animations[MAX_ANIMATIONS][2];
extern int		sprite_y_clip;
extern int		tiltLev;




/****************************************************/
/** Enemy data **/
/****************************************************/

extern TANK		*enemyTanks, *helicopters;
extern HOSTAGE	*hostages;
extern ENEMY_TANK_CTRL	*enemyTankCtrl;
extern ENEMY_TANK_CTRL	*enemyHeliCtrl;
extern ENEMY_TANK_CTRL	*gunboatCtrl;

extern GUN_EMPLACEMENT	*gunempls;
extern GUN_BOAT	*gunboats;

extern ATTACKING_TANK_DATA	attackData[MAX_ATTACKING_TANKS+MAX_CONVOY_MEMBERS];
extern ATTACKING_TANK_DATA	playerDetectdata;

/****************************************************/
/** Convoy data **/
/****************************************************/

extern ushort		*pathBuffer;
extern ushort		*pathOffsets;
extern ushort		*pathData;
extern ushort		numPaths;
extern CONVOY_DATA		convoyData[MAX_CONVOYS];


extern uchar 	*compass_data;										/* Pointer to the compass graphics data */
extern uchar  *turret_angle_data;
extern uchar	*radar_ring_data;

extern uchar		drawFlags[];


extern	uchar		*current_font;			/* The font that will be used by the print routines. */
extern	uchar		*tiny_font;
extern	uchar		*medium_font;

extern	uchar		txt_print_colr;


extern	short		mapmode;
extern 	short		drawCockpit;
extern	short		drawMapScreen;



extern	uchar		lightsTurnedOff;



/************************************************************************/
/** Macros */

#define start_flash(a) flashValue=a


/************************************************************************/
/* Function prototypes */
/************************************************************************/

/************************************************************************/

/************************************************************************/
/** walldraw.c **/
void	animate_wall_textures(void);




/************************************************************************/
/** floor.c **/
void	do_floor(void);



/************************************************************************/
/**  mgsetup.c **/
void		mg_setup();


/************************************************************************/
/** afloor.asm **/
#ifdef PC_VERSION
void	_draw_interpol_floor(TVBTAB *);
#endif



/************************************************************************/
/** aspr.asm **/
#ifdef PC_VERSION
void	_spr_14_trans(SPRBLOCK *);
void	_fsize_sprite(SPRBLOCK *);
void	_spr_14_trans_ndc(SPRBLOCK *);
void	_fsize_sprite_trans(SPRBLOCK *);
void	_size_sprite_trans(SPRBLOCK *);
void 	_spr_14(short *);
void 	_spr_14_ndc(short *);
void 	_shrink_spr(short *);
void 	_size_sprite(short *);
#endif



/************************************************************************/
/** sprite.c */
void sprite(void);



/************************************************************************/
/** Plyr_det.c **/
int		plyr_det(void);
void	shell_detect(void);
void 	shell_det(SHELL_DATA *shellptr, int maxshells);
int 	check_shell(uint	x, int y, uint	z, int allblocks);



/************************************************************************/
/* Weapons.c */
void	gunempl_fire_bullet(GUN_EMPLACEMENT *fgunempl, TANK *entank);
void	gunboat_fire_bullet(GUN_BOAT *fgunboat, TANK *entank);
void	fire_weapons(TANK *);
void	fire_shell(TANK *tank);
void 	do_weapons_1(void);
void 	do_weapons_2(void);
void	process_visible_enemies(void);



/************************************************************************/
/* plyrctrl.c - physical control of movement of tanks */
void	move_tank(TANK *, int, int, int, int, int);
void	move_helicopter(TANK *, int , int , int , int , int , int);
void	player_control(void);



/************************************************************************/
/* moveanim.c */
void	trigger_wall_explosion(ushort *, int);
void	trigger_shroom(POSITION *shroomPos, int);
void	trigger_fx_sprite(int	animNum, int animx, int animy, int animz, int looping, int spriteType, int scaling, int rising);

void	anim_sprs(void);
void	move_sprs(void);
void	setup_mobs(void);



/************************************************************************/
/* collide.c */

int		objective_building(int sfcindx);

void	generate_z_index(void);
void	bullet_detection(struct	bullets	*bullets, int maxbullets);

void 	detect_sams(void);
int		detect_collision(TANK *coltank, int heightLimit);
int		check_4_object_collision(TANK *coltank);
int		second_detect_collision(TANK *detectTank, int heightLimit);
int		second_check_4_object_collision(TANK *coltank);
int		detect_helicopter_collision(TANK *detHeli, int heightLimit);
void	damage_tank(TANK *damagedTank, int	damageVal );
void	get_bullet_detectable_enemies(void);
void	get_detectable_enemies(void);
void	crush_texture(WALL_DATA *detwall);
void	shunt_tank(TANK *, SHELL_DATA *, int recoil);


FX_SPRITE* 			find_free_fx_slot(void);
FRAGMENT_DATA* 	find_free_fragment_slot(void);

void	trigger_explosion(int, POSITION *, POSITION *);
void	trigger_fragments(int, POSITION *, int);



/************************************************************************/
/* spr.c */
#ifdef PC_VERSION
void	scale_sprite(int xpos,int ypos,int scale,int def,uchar shade,uchar flip,uchar trans,uchar *gfx,uchar *net);
void	_generic_spr(SPRBLOCK *);
void	network_tank_scale_sprite(int x1,int y1,int scale,int def,uchar shade,uchar flip,uchar trans,uchar *gfx,uchar *net);
#endif


/************************************************************************/
/* Utils.c */
#ifdef PC_VERSION
void	redraw_cockpit(void);
void	flash_palette(void);

#define put_pixel(px,py,pc) p1screen[(py*320)+px]=pc
void	put_pixel_c(int px, int py, int pc);

void	draw_line(short x1, short y1, short x2, short y2, short colr);
void	draw_line_c(short x1, short y1, short x2, short y2, short colr);
void	draw_weapon_display(int	weaponId);
void	get_floor_pickup(int i);
void	put_images(int xpos, int ypos, int def, uchar *gfx, uchar *net);
void	draw_armour_display(void);
void	draw_panel_bits(void);
void	draw_game_screen(void);
void	photo(void);
void 	convert_pal(void);
void	draw_transparent_box(int x1, int y1, int x2, int y2, int colr);
void	rotate(void);
void	make_night_palette(void);
void	get_nightsight_palette(void);
void	restore_normal_palette(void);

void 	turn_on_lights(void);
void 	turn_off_lights(void);

void	line_draw(long x1,long y1,long x2,long y2,uchar col);		/* Maybe take this out - shouldn't need two line draw functions */

uchar *open_wad_file(char *wadFilename);
void* load_wad_file(char *filename, void *buffer);
void	close_wad_file(void);

void 	update_pickups(void);
void	extend_reflection(void);
void	extend_background(void);

void	draw_poly_flat( short *iptr );
void	_flatA(int ystart, int yend, char triangle);
void 	draw_view_cone(void);

#endif



/************************************************************************/
/* tacmap.c */
void	draw_map(void);
void	draw_vtank(uint x, uint z, int rotangle, int defnum, int objcolour, int highlight, int showstats);



/************************************************************************/
/* Autils.asm */
#ifdef PC_VERSION
void	_draw_compass(int);						/* Draws the compass given a value between 0-127 */
void	_draw_turret_angle(int);			/* draws the turret angle */
void	_print_string(int, int, char*, int);
void	_dump_game_screen(void);
void	_draw_radar_rings(void);
void	_clear_block(int	x1, int y1, int width, int height);
void	_dump_map_screen(void);
void	_draw_background(int);
void	_fast_memset(void	*, int, int);
#endif



/************************************************************************/
/** org.asm **/
#ifdef PC_VERSION
void	_rot_single_point(struct single_point *);
void	_sprite_origin(void);
#endif



/************************************************************************/
/* Pauls maths routines - phd_math.asm */
#ifdef PC_VERSION
int		phd_atan( int x,int y );
#endif



/************************************************************************/
/* enemtank.c - enemy tank control functions */
void	init_tank_control(TANK *);
void	move_tanks(void);
void	move_helicopters(void);
void	do_gun_emplacements(void);
void	do_hostages(void);

void	clear_waypoint_check(TANK *destroyedTank);
void	destroy_tank(TANK	*destroyedTank);
int		get_angle_difference(int ang1, int ang2);



/************************************************************************/
/** shock.c **/
void	my_main(void);
int		start_message(int	msgId);
void	reset_message_status(void);
void	redraw_cockpit(void);



/************************************************************************/
/** sfx.c - sound fx functions **/
void		load_level_samples(int i);
void		shell_explosion_sound(uint	x, uint z);
void		player_hit_sound(int);
void		fire_shell_sound(TANK *tank);
void		enemy_destroyed_sound(uint def, uint x, uint z);
void		chaingun_sound(TANK *stank);
#define update_chaingun_count(a) if(a->chaingunSound)a->chaingunSound--
#define reset_chaingun_count(a) a->chaingunSound=0
void		gunempl_chaingun_sound(GUN_EMPLACEMENT *sgunempl);
void		gunboat_chaingun_sound(GUN_BOAT *fgunboat);
#define reset_gunempl_chaingun(a) a->chaingunSound=0
#define update_gunempl_chaingun_count(a) if(a->chaingunSound)a->chaingunSound--
void		enemy_hit_sound(uint	x, uint z, int damageVal);

void		reset_player_warning_sounds(void);
void		reload_sample(void);
void		stop_engine_sound(void);
void		start_engine(void);
void		adjust_engine(void);

void		play_launch_sam_sound(void);
void		play_fence_crunch_sound(void);
void		play_picked_up_collectable_sound(void);
void		play_armour_warning_sound(void);
void		play_death_sound(void);
void		play_crunch_sound(void);
void		stop_turret_moving_sound(void);
void		start_turret_moving_sound(void);
void		initialise_turret_sound(void);
void		play_click_sound(void);
void		play_turret_locked_sound(void);





void		large_building_explosion_snd(uint x, uint z);
void		normal_building_explosion_snd(uint x, uint z);
void		small_building_explosio_snd(uint x, uint z);
void		fuel_tank_explosion_snd(uint x, uint z);
void		start_helicopter_rotor_sound(TANK *heli);
void		update_helicopter_sound_rotor_sound(TANK *heli);
void		stop_helicopter_sample(TANK *heli);

void		play_click_sound(void);


void		play_me_a_song(int);



/************************************************************************/
/** gunboat.c **/
void	damage_gunboat(GUN_BOAT	*dboat, int damageVal);
void	destroy_gunboat_convoy_member(GUN_BOAT *dboat);
void	move_gunboats(void);
void	init_gunboat(GUN_BOAT *initboat);
GUN_BOAT	*	get_boat_infront(GUN_BOAT *boat);



/************************************************************************/
/** nine.c **/
void	nine_air_support(void);
void	init_nine_air_support(void);



/************************************************************************/
/** Frontend.c **/
void	dave_main(void);



/************************************************************************/
/** initlev.c **/
void	initialise_level(void);
void	cleanup_after_level(void);



/************************************************************************/
/** message.c **/
void	update_message_window(void);
void	reset_message_status(void);
void	update_available_messages(int	msgid);
void	remove_old_earshot_messages(void);



/************************************************************************/
/** options.c **/
void	set_options();
void	init_cheat_checks(void);
void	reset_cheat_checks(void);

/************************************************************************/
/** objectiv.c **/
void	check_objective(void);



/************************************************************************/
/************************************************************************/
/************************************************************************/
/************************************************************************/
/************************************************************************/



#ifdef PC_VERSION



/************************************************************************/
/** wearit.c - Del's handy hsv conversion stuff **/
void		alter_palette(char *palin, char *palout, int deltaS, int deltaV);

/************************************************************************/
/** decrunch.asm **/
long _cdecl UnpackM2(void *input,void *output);


void	reset_msg_file(void);
void	debug_msg(char *format, ...);


/************************************************************************/
// various network titbits
void	net_main(void);



void	MAKE_LEADER_BROADCAST(void);
/************************************************************************/
/** texto.c **/
void displayUserText (void);


/************************************************************************/
/** ncollect.h **/
void USE_COLLECTABLE (int cType);


#endif


#include "mg.h"

#endif

