#include "headers.h"

#include "chuck.h"
#include "shock.h"
#include "e_global.h"
#include "enemlogc.h"

#include "iff.h"
#include "frontend.h"
#include "frontdef.h"
#include "frglobs.h"



/*-----------------23/10/95 20:12-------------------
 Type definitions and constants
--------------------------------------------------*/
enum {TANK_ENEMY, HELICOPTER_ENEMY, GUN_EMPLACEMENT_ENEMY, GUNBOAT_ENEMY};
void	display_enemy_stats(int enemyType, int enemyNumber);
extern	int showStatType=HELICOPTER_ENEMY;

#define MAP_SCREEN_X		192
#define MAP_SCREEN_Y		96

#define OBJECTIVE_TEXT_X			100
#define OBJECTIVE_TEXT_Y			20

#define MAP_RANGE							0x2000

#define TAC_SOLID_OVL_X				91
#define TAC_SOLID_OVL_Y				16


enum { VLINE=0, VCIRCLE, VFINISH };

enum { SAM_ICON = 14, ASM_ICON, TREE_ICON, TREE_STUMP_ICON, WATER_1_ICON, WATER_2_ICON, PLAYER_TURRET_ICON, RENDEZVOUS_ICON };


typedef struct
{
	short	*points;
	char	*elements;
}VECTOR_DEFINITION;


char	enemyTypes[4][64] =
{
	"TANK",
	"HELICOPTER",
	"GUN EMPLACEMENT",
	"GUN BOAT"
};


/*-----------------23/10/95 23:49-------------------
 extern
--------------------------------------------------*/
extern	int			cosang;
extern	int			sinang;
extern	int			normalCD;


int	mapscale=4;

/*-----------------23/10/95 20:12-------------------
 Defitions of objects in vector terms (kinda)
--------------------------------------------------*/

static	short		vectorPointsBuffer[64];



static	short		playerTankPoints[] =
{
	-0xd0,	0x70,
	-0xa0,	0xc0,
	0x60,		0xc0,
	0xc0,		0x50,
	0xc0,		-0x50,
	0x60,		-0xC0,
	-0xa0,	-0xc0,
	-0xd0,	-0x70,
	0,			0xc0,
	0,			-0xc0,
	0x50,		0,
	0x100,	0,
	-1
};


static	short		enemyTankPoints[] =
{
	-0xd0,	0x80,
	-0xb0,	0xa0,
	0x80,		0xa0,
	0xc0,		0,
	0x80,		-0xa0,
	-0xb0,	-0xa0,
	-0xd0,	-0x80,
	0,			0xa0,
	0,			-0xa0,
	0x40,			0,
	0x100,		0,
	-1
};


static	short		battleTankPoints[] =
{
	-0xf0,	0xa0,
	-0xa0,	0xf0,
	0x70,		0xf0,
	0xe0,		0x80,
	0xe0,		-0x80,
	0x70,		-0xf0,
	-0xa0,	-0xf0,
	-0xf0,	-0xa0,
	0x50,		0xa0,
	0xa0,		0x50,
	0xa0,		-0x50,
	0x50,		-0xa0,
	-0X50,	0XF0,
	-0X50,	0XA0,
	-0X50,	-0XA0,
	-0X50,	-0XF0,
	0x50,		0,
	0x110,	0,
	-1
};


static	short		apcPoints[] =
{
	-0xf0,	0,
	-0xc0,	0x90,
	0x80,		0x90,
	0xe0,		0,
	0x80,		-0x90,
	-0xc0,	-0x90,
	0,			0,
	0x90,		0,
	-1
};


static	short		afvPoints[] =
{
	-0xa0,	0x50,
	-0x50,	0xa0,
	0,			0xa0,
	0xa0,		0x50,
	0xa0,		-0x50,
	0,			-0xa0,
	-0x50,	-0xa0,
	-0xa0,	-0x50,
	0x50,		0,
	0xa0,		0,
	-1
};


static	short		gunboatPoints[] =
{
	-0x2d0, 0xa0,
	-0x230,	0x100,
	0,		0x100,
	0x1e0,	0xa0,
	0x300,	0,
	0x1e0,	-0xa0,
	0x0,		-0x100,
	-0x230,	-0x100,
	-0x2d0,	-0xa0,
	0,0,
	-1
};

static	short		gunemplPoints[] =
{
	0,			0,
	0x80,		0,
	-1
};


static	short		helicopterPoints[] =
{
	-0x160, 0,
	-0x100,	0x20,
	-0xa0,	0x20,
	0,			0x80,
	0xa0,		0x80,
	0x120,	0x30,
	0x120,	-0x30,
	0xa0,		-0x80,
	0,			-0x80,
	-0xa0,	-0x20,
	-0x100,	-0x20,
	0x60,		0,
	-1
};


static	short		gunshipPoints[] =
{
	-0x260,	0x10,
	-0x210,	0x20,
	-0xa0,	0x30,
	-0x50,	0x80,
	0x60,		0x80,
	0x80,		0x50,
	0x110,	0x30,
	0x130,	0,
	0x110,	-0x30,
	0x80,		-0x50,
	0x60,		-0x80,
	-0x50,	-0x80,
	-0xa0,	-0x30,
	-0x210,	-0x20,
	-0x260,	-0x10,
	-0x30,	0xB0,
	0,			0xb0,
	0x50,		0xb0,
	-0x30,	0x80,
	0x30,		0x80,
	-0x30,	-0xB0,
	0,			-0xb0,
	0x50,		-0xb0,
	-0x30,	-0x80,
	0x30,		-0x80,
	0x20,		0,
	-1
};


static	short		truckPoints[] =
{
	-0xd0,	0x70,
	0x70,		0x70,
	0x70,		-0x70,
	-0xd0,	-0x70,

	0x70,		0x50,
	0xf0,		0x50,
	0xf0,		-0x50,
	0x70,		-0x50,

	0XA0,		0X50,
	0XA0,		-0X50,

	-0X50,	0X20,
	-0X20,	0X20,
	-0X20,	0X50,
	0X20,		0X50,
	0X20,		0X20,
	0X50,		0X20,

	0X50,		-0X20,
	0X20,		-0X20,
	0X20,		-0X50,
	-0X20,	-0X50,
	-0X20,	-0X20,
	-0X50,	-0X20,
	-1
};


static	short		hostagePoints[] =
{
	-0x20,	0x80,
	0x20,		0x80,
	0x20,		0x40,
	-0x20,	0x40,
	0,			0x40,
	0,			-0x50,
	-0x50,	0,
	0x50,		0,
	-0x40,	-0xa0,
	0x40,		-0xa0,
	-1
};


static	short		samPoints[] =
{
	-0x40,	0,
	-0x30,	0x10,
	0x20,		0x10,
	0x40,		0,
	0x20,		-0x10,
	-0x30,	-0x10,
	-1
};



static	short		asmPoints[] =
{
	-0x40,	0x10,
	0,			0x10,
	0x40,		0,
	0,			-0x10,
	-0x40,	-0x10,
	-1
};


static	short		treePoints[] =
{
	-0x40, -0x40,
	0x40,	-0x40,
	0x40,	0x40,
	-0x40,	0x40,
	-0x80,	0,
	0,		-0x80,
	0x80,		0,
	0,		0x80,
	-1
};


static	short		waterBlockPoints[] =
{
	-0x80, -0x80,
	0,		-0x80,
	-0x80,	0,
	0x80,	0,
	0,		0x80,
	0x80,	0x80,
	-1
};


static	short		rendezvoursTargetPoints[] =
{
	-0x200,	0x200,		//	0
	0x200,	0x200,		//	1
	0x200,	-0x200,		//  2
	-0x200,	-0x200,		//  3

	0,0,							//	4
	-1
};

static	uchar		playerTankElements[] =
{
	VLINE, 	0,1,
	VLINE, 	1,2,
	VLINE,	2,3,
	VLINE,	3,4,
	VLINE,	4,5,
	VLINE,	5,6,
	VLINE,	6,7,
	VLINE,	7,0,
	VFINISH
};


static	uchar		playerTurretElements[] =
{
	VLINE,	1,8,
	VLINE,	6,9,
	VLINE,	1,6,
	VLINE,	8,10,
	VLINE,	9,10,
	VLINE,	10,11,
	VFINISH
};


static	uchar		enemyTankElements[] =
{
	VLINE, 	0,1,
	VLINE, 	1,2,
	VLINE,	2,3,
	VLINE,	3,4,
	VLINE,	4,5,
	VLINE,	5,6,
	VLINE,	6,0,
	VLINE,	7,9,
	VLINE,	8,9,
	VLINE,	9,10,
	VFINISH
};

static	uchar		battleTankElements[] =
{
	VLINE, 	0,1,
	VLINE, 	1,2,
	VLINE,	2,3,
	VLINE,	3,4,
	VLINE,	4,5,
	VLINE,	5,6,
	VLINE,	6,7,
	VLINE,	7,0,
	VLINE,	0,8,
	VLINE,	7,11,
	VLINE,	8,9,
	VLINE,	9,10,
	VLINE,	10,11,
	VLINE,	12,13,
	VLINE,	14,15,
	VLINE,	16,17,
	VFINISH
};


static	uchar		apcElements[] =
{
	VLINE, 	0,1,
	VLINE, 	1,2,
	VLINE,	2,3,
	VLINE,	3,4,
	VLINE,	4,5,
	VLINE,	5,0,
	VLINE,	6,7,
	VFINISH
};


static	uchar		afvElements[] =
{
	VLINE,	0,1,
	VLINE,	1,2,
	VLINE,	2,3,
	VLINE,	3,4,
	VLINE,	4,5,
	VLINE,	5,6,
	VLINE,	6,7,
	VLINE,	7,0,
	VLINE,	2,8,
	VLINE,	5,8,
	VLINE,	8,9,
	VFINISH
};


static	uchar		gunboatElements[] =
{
	VLINE, 	0,1,
	VLINE, 	1,2,
	VLINE,	2,3,
	VLINE,	3,4,
	VLINE,	4,5,
	VLINE,	5,6,
	VLINE,	6,7,
	VLINE,	7,8,
	VLINE,	8,0,
	VCIRCLE, 9,1,16,
	VFINISH
};


static	uchar		gunemplElements[] =
{
	VCIRCLE,	0,1,32,
	VLINE,	0,1,
	VFINISH
};


static	uchar		helicopterElements[] =
{
	VLINE, 	0,1,
	VLINE, 	1,2,
	VLINE,	2,3,
	VLINE,	3,4,
	VLINE,	4,5,
	VLINE,	5,6,
	VLINE,	6,7,
	VLINE,	7,8,
	VLINE,	8,9,
	VLINE,	9,10,
	VLINE,	10,0,
	VCIRCLE,	11,3,16,
	VFINISH
};


static	uchar		gunshipElements[] =
{
	VLINE, 	0,1,
	VLINE, 	1,2,
	VLINE,	2,3,
	VLINE,	3,4,
	VLINE,	4,5,
	VLINE,	5,6,
	VLINE,	6,7,
	VLINE,	7,8,
	VLINE,	8,9,
	VLINE,	9,10,
	VLINE,	10,11,
	VLINE,	11,12,
	VLINE,	12,13,
	VLINE,	13,14,
	VLINE,	14,0,
	VLINE,	15,17,
	VLINE,	15,18,
	VLINE,	16,19,
	VLINE,	23,20,
	VLINE,	20,22,
	VLINE,	21,24,
	VCIRCLE,	25,4,16,
	VFINISH
};



static	uchar		alliedTruckElements[] =
{
	VLINE,	0,1,
	VLINE,	1,2,
	VLINE,	2,3,
	VLINE,	3,0,
	VLINE,	4,5,
	VLINE,	5,6,
	VLINE,	6,7,
	VLINE,	8,9,
	VLINE,	10,11,
	VLINE,	11,12,
	VLINE,	12,13,
	VLINE,	13,14,
	VLINE,	14,15,
	VLINE,	15,16,
	VLINE,	16,17,
	VLINE,	17,18,
	VLINE,	18,19,
	VLINE,	19,20,
	VLINE,	20,21,
	VLINE,	21,10,
	VFINISH
};



static	uchar		hostageElements[] =
{
	VLINE,	0,1,
	VLINE,	1,2,
	VLINE,	2,3,
	VLINE,	3,0,
	VLINE,	4,5,
	VLINE,	6,7,
	VLINE,	5,8,
	VLINE,	5,9,
	VFINISH
};



static	uchar		samElements[] =
{
	VLINE,	0,1,
	VLINE,	1,2,
	VLINE,	2,3,
	VLINE,	3,4,
	VLINE,	4,5,
	VLINE,	5,0,
	VFINISH
};


static	uchar		asmElements[] =
{
	VLINE,	0,1,
	VLINE,	1,2,
	VLINE,	2,3,
	VLINE,	3,4,
	VLINE,	4,0,
	VFINISH
};


static	uchar		treeElems[] =
{
	VLINE, 	0,2,
	VLINE,	1,3,
	VLINE,	4,6,
	VLINE,	5,7,
	VFINISH
};

static	uchar		treestumpElems[] =
{
	VLINE, 	0,2,
	VLINE,	1,3,
	VFINISH
};



static	uchar		water1BlockElems[] =
{
	VLINE,	1,3,
	VLINE,	2,4,
	VFINISH
};


static	uchar		water2BlockElems[] =
{
	VLINE,	0,5,
	VLINE,	1,3,
	VLINE,	2,4,
	VFINISH
};


static	uchar		rendezvoursTargetElems[] =
{
	VLINE, 	0,1,
	VLINE,	1,2,
	VLINE,	2,3,
	VLINE,	3,0,

	VCIRCLE,	4,2,3,
	VCIRCLE,	4,3,16,

	VFINISH
};


static	VECTOR_DEFINITION vectorDefinitions[] =
{
	NULL, NULL,																/* SHELL */
	playerTankPoints, playerTankElements,			/* PLAYER_TANK */
	enemyTankPoints, enemyTankElements,				/* ENEMY_TANK */
	battleTankPoints, battleTankElements,			/* BATTLE_TANK */
	afvPoints,	afvElements,									/* AMOURED_FIGHTER */
	apcPoints,	apcElements,									/* ENEMY APC */
	gunboatPoints,	gunboatElements,					/* ENEMY_GUNBOAT */
	gunemplPoints,	gunemplElements,					/* E_GUNEMPL */
	truckPoints,	alliedTruckElements,				/* ALLIED TRUCK */
	truckPoints,	alliedTruckElements,				/* ENEMY_TRUCK */
	hostagePoints,	hostageElements,					/* HOSTAGE_1 */
	hostagePoints,	hostageElements,					/* HOSTAGE_2 */
	helicopterPoints,	helicopterElements,			/* E_HELICOPTER */
	gunshipPoints, gunshipElements,						/* E_GUNSHIP */
	samPoints,	samElements,									/* sam */
	asmPoints,	asmElements,									/* asms */
	treePoints, treeElems,
	treePoints,	treestumpElems,
	waterBlockPoints, water1BlockElems,
	waterBlockPoints, water2BlockElems,
	playerTankPoints, playerTurretElements,
	rendezvoursTargetPoints, rendezvoursTargetElems
};


// TAKE_THIS_OUT
// TEMP VARS

int		showEnemyStats=FALSE;
int		currentEnemyStats=0;

/*-----------------23/10/95 20:13-------------------
 Prototypes
--------------------------------------------------*/

void	draw_vtank(uint x, uint z, int rotangle, int defnum, int objcolour, int highlight, int showstats);


/*-----------------23/10/95 20:13-------------------
 Functions
--------------------------------------------------*/
void	draw_vtank(uint x, uint z, int rotangle, int defnum, int objcolour, int highlight, int stats_id)
{
	int		n;
	int		relx, relz;
	int		tx1, tz1;
	short	*cpoint;
	short	*ctranPoint;
	uchar	*celement;
	short	el1,el2,el3,crcx,crcz;

	relx =(int)(((uint)x>>(mapscale+16)) - ((uint)pl.x>>(mapscale+16)));
	relz =(int)(((uint)z>>(mapscale+16)) - ((uint)pl.z>>(mapscale+16)));

	cosang = (int)sintab[rotangle];
	sinang = (int)sintab[rotangle+512];

	ctranPoint = vectorPointsBuffer;

	cpoint = vectorDefinitions[defnum].points;
	celement = vectorDefinitions[defnum].elements;

	if ( cpoint==NULL ) 	/* No defintion for that object */
	{
		return ;
	}

	/* Calculate all the points first */

	while ( *cpoint!=-1 )
	{
		tx1 = *cpoint++;		/* Get x part of vector point */
		tz1 = *cpoint++;		/* Get z part of vector point */

		*ctranPoint++ =	(short)(MAP_SCREEN_X + relx + ( ((int)(tx1*cosang - tz1*sinang)) >> (15+mapscale) ) ); /* Get rotated screen point */
		*ctranPoint++ =	(short)(MAP_SCREEN_Y + relz + ( ((int)(tz1*cosang + tx1*sinang)) >> (15+mapscale) ) ); /* Get rotated screen point */
	}


	while ( *celement!=VFINISH  )
	{
		switch ( *celement++ )
		{
			case VLINE:
				el1 = *celement++;
				el2 = *celement++;

				draw_line_c(vectorPointsBuffer[el1<<1], vectorPointsBuffer[(el1<<1)+1], vectorPointsBuffer[el2<<1], vectorPointsBuffer[(el2<<1)+1], objcolour);
				break;

			case VCIRCLE:
				el1 = *celement++;		/* Index to centre point of circle */
				el2 = *celement++;		/* Radius of circle (in units of 0x80 )*/
				el2 <<= 7;
				el3	= *celement++;		/* Number of segments in circle */

				crcx = vectorPointsBuffer[el1<<1];
				crcz = vectorPointsBuffer[(el1<<1)+1];

				for ( n=0; n<=0x200; n+=el3 )
				{
					tx1 = (el2*sintab[n+512]) >> (15+mapscale);
					tz1 = (el2*sintab[n]) >> (15+mapscale);

					put_pixel_c(crcx+tx1, crcz-tz1, objcolour);
					put_pixel_c(crcx+tx1, crcz+tz1, objcolour);
					put_pixel_c(crcx-tx1, crcz-tz1, objcolour);
					put_pixel_c(crcx-tx1, crcz+tz1, objcolour);
				}
				break;
		}
	}



#ifdef DEBUG_VERSION
/*-----------------07/11/95 09:58-------------------
 displays details of specified tank
--------------------------------------------------*/
//	if ( !normalCD )
//	{
//		txt_print_colr = T_YELLOW;
//		sprintf(tstring,"%02d",stats_id);
//		if ( (abs(relx)<150) && (abs(relz)<95) )
//			_print_string(MAP_SCREEN_X + relx, MAP_SCREEN_Y + relz, tstring, SINGLE_COLOURED_PRINT);
//	}

////////////////
#endif
}


/***************************************************************/



void	draw_map(void)
{
	int		mapstz, mapstx, mapez, mapex;
	int		mapx, mapz;
	int		indsz;
	int		indez;
	int		n;
	int		drawWalls = TRUE;
	POINT_DATA	*cwallmid, *pt1, *pt2;
	WALL_DATA *cwall;
	int		scrx1, scrx2, scrz1, scrz2;
	int		gridStart, gridScr;
	TANK	*detank;
	GUN_EMPLACEMENT *cgunempl;
	GUN_BOAT	*dboat;
	HOSTAGE	*chostage;
	ASM		*casm;
	struct	sams *csam;
	uint		map_val, objectOnmap;


	int		objtxtx=OBJECTIVE_TEXT_X, objtxty=OBJECTIVE_TEXT_Y;
	char	tempstring[256];
	int		cWallType, cWallTexture, cDetectType, cWallcolour;

	SHELL_DATA	*dshell;
	POINT	pta,ptb;
	struct bullets *dbull;
	int		tilex, tilez;
	int		stilex, stilez, etilex, etilez, blkacross;
	uint	tile32x, tile32z;
	uchar	*cobjmap;
	ushort	*cfloormap;
	int		waterBlock;




	#ifdef PC_VERSION
	_fast_memset(p1screen, 0, 320*200);
	#endif

	tilex = (mapx = pl.x>>16) >> 8;
	tilez = (mapz = pl.z>>16) >> 8;

	mapstz = ( (int)(mapz - MAP_RANGE) <0) ? 0 : (mapz - MAP_RANGE);

	mapstx = ( (int)(mapx - MAP_RANGE) <0) ? 0 : (mapx - MAP_RANGE);

	mapez = ( (int)(mapz + MAP_RANGE) > 0xffff ) ? 0xffff : (mapz + MAP_RANGE);

	mapex = ( (int)(mapx + MAP_RANGE) > 0xffff ) ? 0xffff : (mapx + MAP_RANGE);


	indsz = mapstz >> 8;
	indez = mapez >> 8;

	/* Draw map grid */

	/* Draw the vertical lines first */

	gridStart = (-mapx)&0x1ff;

	while ( TRUE )
	{
		gridScr = gridStart>>mapscale;

		if ( gridScr>=320 )
			break;

		draw_line_c(gridScr, 4, gridScr, 190, MAP_GRID_COLR);

		gridStart += 0x200;
	}

	/* Draw the horizontal lines. */

	gridStart = (-mapz)&0x1ff;

	while ( TRUE )
	{
		gridScr = gridStart>>mapscale;

		if ( gridScr>=320 )
			break;

		draw_line_c(0, gridScr, 319, gridScr, MAP_GRID_COLR);

		gridStart += 0x200;
	}


	/* Draw any water and trees in the vicinity */
	etilex = ( stilex = tilex - (4<<(mapscale-3)) ) + (8<<(mapscale-3));
	etilez = ( stilez = tilez - (3<<(mapscale-3)) ) + (6<<(mapscale-3));

	if ( etilex > 255 )
	{
		etilex = 255;
	}

	if ( etilez > 255 )
	{
		etilez = 255;
	}

	if ( stilex < 0 )
	{
		stilex = 0;
	}

	if ( stilez < 0 )
	{
		stilez = 0;
	}

	for ( ; stilez <= etilez; stilez++ )
	{
		blkacross=stilex;
		cfloormap = floor_map + ((stilez<<8)+blkacross);
		cobjmap = obj_map+((stilez<<8)+blkacross);

		for ( ; blkacross<etilex; blkacross++, cobjmap++, cfloormap++ )
		{
			tile32x = (blkacross<<24)+0x800000;
			tile32z = (stilez<<24)+0x800000;


			/** draw any relevant floor objects onto tactical **/

			if ( objectOnmap=*cobjmap )
			{
				map_val = det_tabs[region][(( objectOnmap - 1) << 1)+1];

				if ( map_val & DET_SOLID )
				{
					if ( map_val & DET_SHELL_D )
					{
						draw_vtank(tile32x, tile32z, 0, TREE_ICON, T_GRAD_GREEN, FALSE, FALSE);
					}
					else
						draw_vtank(tile32x, tile32z, 0, TREE_STUMP_ICON, T_GRAD_GREEN, FALSE, FALSE);
				}
			}

			/** draw any prescence of water tiles onto tactical map **/

			waterBlock = grip_tab[((*cfloormap)>>3) & 0xff];

			if ( waterBlock == -1 )
			{
				draw_vtank(tile32x, tile32z, 0, WATER_2_ICON, T_GRAD_BLUE+4, FALSE, FALSE);
			}
			else
			if ( waterBlock == -2 )
			{
				draw_vtank(tile32x, tile32z, 0, WATER_1_ICON, T_GRAD_BLUE+4, FALSE, FALSE);
			}


		}
	}



	/** Draw the rendezvous point **/

	cWallcolour = (msgFlash&16) ? T_BLUE : T_GREEN;

	draw_vtank(	rendezvousPoints[game_data.mission][0]<<24,
							rendezvousPoints[game_data.mission][1]<<24,
							0,
							RENDEZVOUS_ICON,
							cWallcolour,
							FALSE,
							FALSE
							);





	/* Draw any walls in the vicinity */
	while ( TRUE )
	{
		if ( wall_z_index[indsz] != NO_POINTS ) 	/* Find first wall in z range */
		{
			cwallmid = wallMids + (n = wall_z_index[indsz]);
			cwall = wallSfcs + wall_z_index[indsz];

			break;
		}

		indsz++;

		if ( indsz>indez ) /* No walls to test against */
		{
			drawWalls = FALSE;
			break;
		}
	}

	scr_ptr = p1screen;

	if ( drawWalls )
	{
  	for ( ; n<numSfcs; n++, cwallmid++, cwall++ )
  	{
  		if ( cwallmid->z > mapez )
  		{
  			break; /* Reached end of map detection area */
  		}

  		if ( cwallmid->x >=mapstx && cwallmid->x<=mapex )
  		{
				/* Find out if wall has been destroyed etc... */

				if ( cwall->wallType==TOTALLED_TEXTURE )
				{
					continue;
				}


				cWallType = cwall->wallType & 0x3;
				cWallTexture = (cwall->wallType&0x1f8) >> 3;
				cDetectType = (wdetect_info[cWallType].detectType[cWallTexture])&0x3;

				if ( !cDetectType )
				{
					cWallcolour = T_GRAD_GREEN + T_SHADE_1;		/* Destroyed/crushed wall */
				}
				else
				{
					cWallcolour = T_GRAD_GREEN + T_SHADE_4;		/* Intact */

					if ( is_tree_texture(n) ) 								/* don't draw any tree walls on the tactical map */
					{
						continue;
					}
					else
					/** check to see if its an objective building **/
					if ( objectiveType == DESTROY_BUILDINGS_OBJECTIVE )
					{
						if ( is_objective_building(n) )
						{
							cWallcolour = (msgFlash&16) ? T_RED : T_YELLOW;
						}
					}
				}

  			/* Draw the wall */
  			pt1 = wallPoints + cwall->p1;
  			pt2 = wallPoints + cwall->p2;

  			scrx1 = ((pt1->x - mapx) >> mapscale) + MAP_SCREEN_X;
  			scrz1 = ((pt1->z - mapz) >> mapscale) + MAP_SCREEN_Y;

  			scrx2 = ((pt2->x - mapx) >> mapscale) + MAP_SCREEN_X;
  			scrz2 = ((pt2->z - mapz) >> mapscale) + MAP_SCREEN_Y;

  			draw_line_c(scrx1, scrz1, scrx2, scrz2, cWallcolour);

  		}

  	}

	}


	/* Draw the player shells */
	for ( n=0, dshell=playerShells; n<MAX_PLAYER_SHELLS; n++, dshell++)
	{
		if ( !dshell->fired )
		{
			continue;
		}

		pta.x = dshell->ox>>16;
		pta.z = dshell->oz>>16;

		ptb.x = dshell->x>>16;
		ptb.z = dshell->z>>16;

		scrx1 = ((pta.x - mapx) >> mapscale) + MAP_SCREEN_X;
		scrz1 = ((pta.z - mapz) >> mapscale) + MAP_SCREEN_Y;

		scrx2 = ((ptb.x - mapx) >> mapscale) + MAP_SCREEN_X;
		scrz2 = ((ptb.z - mapz) >> mapscale) + MAP_SCREEN_Y;

		draw_line_c(scrx1, scrz1, scrx2, scrz2, SHELL_COLR);
	}


	/* Draw the enemy shells */
	for ( n=0, dshell=enemyShells; n<MAX_ENEMY_SHELLS; n++, dshell++)
	{
		if ( !dshell->fired )
		{
			continue;
		}

		pta.x = dshell->ox>>16;
		pta.z = dshell->oz>>16;

		ptb.x = dshell->x>>16;
		ptb.z = dshell->z>>16;

		scrx1 = ((pta.x - mapx) >> mapscale) + MAP_SCREEN_X;
		scrz1 = ((pta.z - mapz) >> mapscale) + MAP_SCREEN_Y;

		scrx2 = ((ptb.x - mapx) >> mapscale) + MAP_SCREEN_X;
		scrz2 = ((ptb.z - mapz) >> mapscale) + MAP_SCREEN_Y;

		draw_line_c(scrx1, scrz1, scrx2, scrz2, SHELL_COLR);
	}

	/* Draw the enemy bullets */
	for ( n=0, dbull=en_bullets; n<(MAX_ENEMY_SHELLS<<2); n++, dbull++ )
	{
		if ( dbull->on )
		{
			pta.x = dbull->oldx>>16;
			pta.z = dbull->oldz>>16;

			ptb.x = dbull->x>>16;
			ptb.z = dbull->z>>16;

  		scrx1 = ((pta.x - mapx) >> mapscale) + MAP_SCREEN_X;
  		scrz1 = ((pta.z - mapz) >> mapscale) + MAP_SCREEN_Y;

  		scrx2 = ((ptb.x - mapx) >> mapscale) + MAP_SCREEN_X;
  		scrz2 = ((ptb.z - mapz) >> mapscale) + MAP_SCREEN_Y;

  		draw_line_c(scrx1, scrz1, scrx2, scrz2, SHELL_COLR);

		}
	}


	/** Draw the player bullets */
	for ( n=0, dbull=pl_bullets; n<(MAX_PLAYER_SHELLS<<2); n++, dbull++ )
	{
		if ( dbull->on )
		{
			pta.x = dbull->oldx>>16;
			pta.z = dbull->oldz>>16;

			ptb.x = dbull->x>>16;
			ptb.z = dbull->z>>16;

  		scrx1 = ((pta.x - mapx) >> mapscale) + MAP_SCREEN_X;
  		scrz1 = ((pta.z - mapz) >> mapscale) + MAP_SCREEN_Y;

  		scrx2 = ((ptb.x - mapx) >> mapscale) + MAP_SCREEN_X;
  		scrz2 = ((ptb.z - mapz) >> mapscale) + MAP_SCREEN_Y;

  		draw_line_c(scrx1, scrz1, scrx2, scrz2, SHELL_COLR);
		}
	}


	/* Draw the player tank */
	draw_vtank(pl.x, pl.z, pl.angle, PLAYER_TANK, PLAYER_TANK_COLR, FALSE, FALSE);
	draw_vtank(pl.x, pl.z, (pl.angle+turret_angle)&0X7FF, PLAYER_TURRET_ICON, PLAYER_TANK_COLR, FALSE, FALSE);



	/* Draw the hostages */
	for ( n=0, chostage=hostages; n<MAX_HOSTAGES; n++, chostage++ )
	{
		if ( chostage->def )
		{
			draw_vtank(chostage->x, chostage->z, 0x600, chostage->def, HOSTAGE_COLR, FALSE, FALSE);
		}
	}

	/* Draw the enemy tanks */
	for ( n=0, detank=enemyTanks; n<MAX_ENEMY_TANKS; n++, detank++ )
	{
		if ( detank->def && detank->def!=REGENERATE_OBJECT)
		{
			draw_vtank(detank->x, detank->z, detank->angle, detank->def, ENEMY_TANK_COLR, FALSE, n);

			#ifdef PC_VERSION
			#ifdef DEBUG_VERSION
			if ( (n==currentEnemyStats) && showEnemyStats && (showStatType==TANK_ENEMY) )
			{
				display_enemy_stats(TANK_ENEMY, n);
			}
			#endif
			#endif
		}
	}

	/* Draw the helicopters */
	for ( n=0, detank=helicopters; n<MAX_HELICOPTERS; n++, detank++ )
	{
		if ( detank->def && detank->def!=REGENERATE_OBJECT && detank->flying)
		{
			draw_vtank(detank->x, detank->z, detank->angle, detank->def, ENEMY_HELI_COLR, ((n==currentEnemyStats)&&showEnemyStats), FALSE);

			#ifdef PC_VERSION
			#ifdef DEBUG_VERSION
			if ( (n==currentEnemyStats) && showEnemyStats && (showStatType==HELICOPTER_ENEMY) )
			{
				display_enemy_stats(HELICOPTER_ENEMY, n);
			}
			#endif
			#endif
		}
	}

	/* Draw the gunboats */
	for ( n=0, dboat=gunboats; n<MAX_GUN_BOATS; n++, dboat++ )
	{
		if ( dboat->exist )
		{
				draw_vtank(dboat->x, dboat->z, dboat->angle, ENEMY_GUNBOAT, ENEMY_TANK_COLR, FALSE, FALSE);

			#ifdef PC_VERSION
			#ifdef DEBUG_VERSION
			if ( (n==currentEnemyStats) && showEnemyStats && (showStatType==GUNBOAT_ENEMY) )
			{
				display_enemy_stats(GUNBOAT_ENEMY, n);
			}
			#endif
			#endif
		}
	}


	/** Draw the gun emplacements onto the map */
	for ( n=0, cgunempl=gunempls; n<MAX_GUN_EMPLS; n++, cgunempl++ )
	{
		if ( cgunempl->exist )
		{
			if ( ( ((abs(cgunempl->x-pl.x)) >> (16+mapscale)) < MAP_SCREEN_X ) &&
					 ( ((abs(cgunempl->z-pl.z)) >> (16+mapscale)) < MAP_SCREEN_Y ) )
			{
				draw_vtank(cgunempl->x, cgunempl->z, cgunempl->angle,	E_GUNEMPL, ENEMY_HELI_COLR, FALSE, FALSE);

			#ifdef PC_VERSION
			#ifdef DEBUG_VERSION
			if ( (n==currentEnemyStats) && showEnemyStats && (showStatType==GUN_EMPLACEMENT_ENEMY) )
			{
				display_enemy_stats(GUNBOAT_ENEMY, n);
			}
			#endif
			#endif

			}
		}
	}



	/* Draw the sams */
	for ( n=0, csam = sam; n<MAX_SAMS; n++, csam++)
	{
		if ( csam->fired )
		{
			if ( ( ((abs(csam->x-pl.x)) >> (16+mapscale)) < MAP_SCREEN_X ) &&
					 ( ((abs(csam->z-pl.z)) >> (16+mapscale)) < MAP_SCREEN_Y ) )
			{
				draw_vtank(csam->x, csam->z, csam->angle,	SAM_ICON, ENEMY_HELI_COLR, FALSE, FALSE);
			}
		}
	}


	/* Draw the asms */
	for ( n=0, casm=asms; n<MAX_ASMS; n++, casm++ )
	{
		if ( casm->fired )
		{
			if ( ( ((abs(casm->x-pl.x)) >> (16+mapscale)) < MAP_SCREEN_X ) &&
					 ( ((abs(casm->z-pl.z)) >> (16+mapscale)) < MAP_SCREEN_Y ) )
			{
				draw_vtank(casm->x, casm->z, casm->angle,	ASM_ICON, ENEMY_HELI_COLR, FALSE, FALSE);
			}
		}
	}


	/* Print up mission objective information */
	txt_print_colr = T_GREEN;

	switch(objectiveType)
	{
		case DESTROY_ALL_ENEMIES_OBJECTIVE:
			_print_string(objtxtx, objtxty+=12, ingameText[DESTROY_HOSTILES_TXT], SINGLE_COLOURED_PRINT);
			if ( numObjectiveEnemies )
			{
				sprintf(tempstring,"%s%d", ingameText[TARGETS_LEFT_TXT], numObjectiveEnemies);
				_print_string(objtxtx,objtxty+=12,tempstring, SINGLE_COLOURED_PRINT);
			}
			else
				_print_string(objtxtx,objtxty+=12, ingameText[RENDEZVOUS_MSG_TXT], SINGLE_COLOURED_PRINT);
			break;


		case DESTROY_BUILDINGS_OBJECTIVE:
			_print_string(objtxtx, objtxty+=12, ingameText[DESTROY_COMPOUNDS_TXT1], SINGLE_COLOURED_PRINT);
			if ( numObjectiveBuildingsLeft )
			{
				sprintf(tempstring,"%s%d", ingameText[TARGETS_LEFT_TXT], numObjectiveBuildingsLeft);
				_print_string(objtxtx,objtxty+=12,tempstring, SINGLE_COLOURED_PRINT);
			}
			else
				_print_string(objtxtx,objtxty+=12, ingameText[RENDEZVOUS_MSG_TXT], SINGLE_COLOURED_PRINT);
			break;


		case RESCUE_HOSTAGE_OBJECTIVE:
			_print_string(objtxtx, objtxty+=12, ingameText[HOSTAGE_RESCUE_TXT], SINGLE_COLOURED_PRINT);
			if ( numHostagesLeft )
			{
				sprintf(tempstring,"%s%d", ingameText[HOSTAGEES_LEFT_TXT], numHostagesLeft);
				_print_string(objtxtx,objtxty+=12,tempstring, SINGLE_COLOURED_PRINT);
			}
			break;


		case DESTROY_CONVOY_OBJECTIVE:
			_print_string(objtxtx, objtxty+=12, ingameText[DESTROY_CONVOY_TXT], SINGLE_COLOURED_PRINT);
			if ( convoyDestroyed )
			{
				_print_string(objtxtx,objtxty+=12, ingameText[RENDEZVOUS_MSG_TXT], SINGLE_COLOURED_PRINT);
			}
			break;


		case PROTECT_CONVOY_OBJECTIVE:
			_print_string(objtxtx, objtxty+=12, ingameText[PROTECT_CONVOY_TXT], SINGLE_COLOURED_PRINT);
			break;
	}

	txt_print_colr = T_BLUE;
	sprintf(tempstring,"%s:%d", enemyTypes[showStatType],currentEnemyStats);
	_print_string(100, 120, tempstring, SINGLE_COLOURED_PRINT);


	/* Draw the overlaying sprites */
	scale_sprite(TAC_SOLID_OVL_X, TAC_SOLID_OVL_Y, ONE_2_ONE_SPRITE,  TAC_MAP_SOLID_OVL, 32, 0, 0, (uchar*)panel_display_graphics, (uchar*)panel_display_net);
}



/***************************************************************/

typedef struct funcnames
{
	void	*func;
	char	funcname[256];
}FUNCTION_NAMES;


FUNCTION_NAMES functionNames[] =
{
	gunboat_start_convoy, "GUNBOAT START CONVOY",
	gunboat_follow_convoy, "GUNBOAT FOLLOW CONVOY",
	gunboat_reached_end, "GUNBOAT REACHED END",
	enemy_tank_stationary, "ENEMY TANK STATIONARY",
	enemy_tank_pursue, "ENEMY TANK PURSUE",
	enemy_tank_targetting, "ENEMY TANK TARGETTING",
	enemy_wait_for_space, "ENEMY WAIT FOR SPACE",
	enemy_tank_restricted_targeting, "ENEMY TANK RESTRICTED TARGETING",
	enemy_helicopter_patroling, "ENEMY HELICOPTER PATROLING",
	enemy_helicopter_start_tracking, "ENEMY HELICOPTER START TRACKING",
	enemy_helicopter_tracking, "ENEMY HELICOPTER TRACKING",
	enemy_helicopter_targetting, "ENEMY HELICOPTER TARGETTING",
	truck_start_convoy, "TRUCK START CONVOY",
	truck_follow_convoy, "TRUCK FOLLOW CONVOY",
	leader_reached_end, "LEADER REACHED END",
	NULL, "No function associated"
};




char defnames[MAX_ROTATING_OBJECTS][32] =
{
	"SHELL",
	"PLAYER_TANK",
	"ENEMY_TANK",
	"BATTLE_TANK",
	"AMOURED_FIGHTER",
	"ENEMY APC",
	"ENEMY_GUNBOAT",
	"E_GUNEMPL",
	"ALLIED TRUCK",
	"ENEMY_TRUCK",
	"HOSTAGE_1",
	"HOSTAGE_2",
	"E_HELICOPTER",
	"E_GUNSHIP",
	"RADAR_EMPL"
};




void	display_enemy_stats(int enemyType, int enemyNumber)
{
	uint	x,z;
	int	statx, staty, relx, relz;
	char	statbuffer[256];
	int	n;
	TANK *dtank;
	GUN_BOAT *dboat;
	GUN_EMPLACEMENT *dgun;



	statx=100; staty=128;

	switch ( enemyType )
	{
/**************************************************************/
		case TANK_ENEMY:
			dtank = enemyTanks+enemyNumber;
			x = dtank->x;
			z = dtank->z;

			txt_print_colr = T_BLUE;
			sprintf(statbuffer, "TANK:%02d  DEF:%s", enemyNumber, defnames[dtank->def]);
			_print_string(statx, staty, statbuffer, SINGLE_COLOURED_PRINT);

			staty+=8;

			for ( n=0; n<15; n++ )
			{
				if ( dtank->ectrl->control_func==functionNames[n].func )
				{
					_print_string(statx, staty, functionNames[n].funcname, SINGLE_COLOURED_PRINT);
					break;
				}
			}

			staty+=8;

			sprintf(statbuffer, "MODE:%d", dtank->ectrl->tank_mode);
			_print_string(statx, staty, statbuffer, SINGLE_COLOURED_PRINT);

			staty+=8;
			sprintf(statbuffer,"TARGET TANK TYPE:%d  id:%d",dtank->ectrl->targetTank->def, dtank->ectrl->targetTank-enemyTanks);
			_print_string(statx, staty, statbuffer, SINGLE_COLOURED_PRINT);

			staty+=8;
			sprintf(statbuffer,"TARGET WAYPT:%d NEXT_TARGET:%d  LEADER:%d",dtank->ectrl->target_waypoint, dtank->ectrl->next_target_waypoint, dtank->ectrl->convoyLeader);
			_print_string(statx, staty, statbuffer, SINGLE_COLOURED_PRINT);
			break;



/**************************************************************/
		case HELICOPTER_ENEMY:
			dtank = helicopters+enemyNumber;

			x = dtank->x;
			z = dtank->z;

			txt_print_colr = T_BLUE;
			sprintf(statbuffer, "HELI:%02d  def:%s", enemyNumber, defnames[dtank->def]);
			_print_string(statx, staty, statbuffer, SINGLE_COLOURED_PRINT);

			staty+=8;

			for ( n=0; n<15; n++ )
			{
				if ( dtank->ectrl->control_func==functionNames[n].func )
				{
					_print_string(statx, staty, functionNames[n].funcname, SINGLE_COLOURED_PRINT);
					break;
				}
			}

			staty+=8;

			sprintf(statbuffer, "MODE:%d", dtank->ectrl->tank_mode);
			_print_string(statx, staty, statbuffer, SINGLE_COLOURED_PRINT);

			staty+=8;
			sprintf(statbuffer,"TARGET TANK TYPE:%d  id:%d",dtank->ectrl->targetTank->def, dtank->ectrl->targetTank-enemyTanks);
			_print_string(statx, staty, statbuffer, SINGLE_COLOURED_PRINT);

			staty+=8;
			sprintf(statbuffer,"TARGET WAYPT:%d    NEXT_TARGET:%d",dtank->ectrl->target_waypoint, dtank->ectrl->next_target_waypoint);
			_print_string(statx, staty, statbuffer, SINGLE_COLOURED_PRINT);

			break;


/**************************************************************/
		case GUN_EMPLACEMENT_ENEMY:
			dgun = gunempls + enemyNumber;

			x = dgun->x;
			z = dgun->z;

			break;

/**************************************************************/
		case GUNBOAT_ENEMY:
			dboat = gunboats + enemyNumber;
			x = dboat->x;
			z = dboat->z;

			break;
	}


	// draw cross hairs

	relx =(int)(((uint)x>>(mapscale+16)) - ((uint)pl.x>>(mapscale+16)));
	relz =(int)(((uint)z>>(mapscale+16)) - ((uint)pl.z>>(mapscale+16)));

	if ( (abs(relx)<160) && (abs(relz)<100) )
	{
		draw_line_c(MAP_SCREEN_X+relx, 0, MAP_SCREEN_X + relx, 199, T_DBLUE);
		draw_line_c(64, MAP_SCREEN_Y+relz, 319, MAP_SCREEN_Y + relz, T_DBLUE);
	}
}





#ifdef PC_VERSION
/*-----------------05/12/95 14:29-------------------
 debug display functions
--------------------------------------------------*/

void	print_control_data(ENEMY_TANK_CTRL *pctrl)
{
	int	i;

	i=0;

//	debug_msg("Control details");

	while ( TRUE )
	{
		if (	functionNames[i].func==pctrl->control_func )
		{
			debug_msg("Function:%s",functionNames[i].funcname);
			break;
		}
		else
		if ( functionNames[i].func==NULL )
		{
			debug_msg("Function:%s",functionNames[i].funcname);
			return ;
		}
		i++;
	}


	debug_msg("Mode:%d",pctrl->tank_mode);
	debug_msg("Waypoints: target=%d, last=%d, rejoin=%d, next=%d",
		pctrl->target_waypoint,
		pctrl->last_waypoint,
		pctrl->rejoin_waypoint,
		pctrl->next_target_waypoint);
}


void	print_tank_data(TANK *ptank)
{
	if ( !ptank->def )
	{
		return ;
	}

	if ( ptank==&pl )
	{
		debug_msg("Player tank");
	}
	else
	{
		debug_msg("\nVehicle %d",ptank-enemyTanks);
	}


	if ( ptank->def==REGENERATE_OBJECT )
	{
		debug_msg("Tank = regenerating object");
	}
	else
		debug_msg("Def number :%d", ptank->def);

	debug_msg("Coords : [%04X,%04X,%04X]",ptank->x>>16, ptank->y, ptank->z>>16);
	debug_msg("Angle = %d, direction=%d", ptank->angle, ptank->dir);
	debug_msg("Speed = %d", ptank->speed);

	print_control_data(ptank->ectrl);

}


void	print_boat_data(GUN_BOAT *pboat)
{
	if ( !pboat->exist )
	{
		return ;
	}

	debug_msg("\nBoat %d",pboat-gunboats);
	debug_msg("Coords : [%4X,%04X]",pboat->x>>16, pboat->z>>16);
	debug_msg("Angle = %d, speed=%d", pboat->angle, pboat->speed);

	print_control_data(pboat->ectrl);
}



void	display_enemy_data(void)
{
	int i;

	debug_msg("\n\nEnemy data:\n--------------------------------\n");

	/*-----------------05/12/95 14:54-------------------
	 dump the enemy tanks first
	--------------------------------------------------*/

	debug_msg("\nTanks:\n--------------------------------\n");

	for ( i=0; i<MAX_ENEMY_TANKS; i++ )
	{
		print_tank_data(enemyTanks+i);
	}

	/*-----------------05/12/95 14:55-------------------
	 dump the helicopter data next
	--------------------------------------------------*/
	debug_msg("\nHelicopters:\n--------------------------------\n");

	for ( i=0; i<MAX_HELICOPTERS; i++ )
	{
		print_tank_data(helicopters+i);
	}

	debug_msg("\nGunboats:\n--------------------------------\n");

	for ( i=0; i<MAX_GUN_BOATS; i++ )
	{
		print_boat_data(gunboats+i);
	}
}
#endif

