#ifndef TELEPH
#define TELEPH

#include "typedefs.h"
#include "shock.h"

#define TELE_WIDTH  5
#define TELE_HEIGHT 5

#define DISSOLVE_MAX 150

/*When dissolve becomes less prominent*/
#define DISSOLVE_DISSOLVE 0


#define MAX_TELE_TYPES 5

/*Num of telePod types used in this level*/
extern int TELE_TYPES;

#define EO_TPODS 101

/*The RANDOMIZER teleport is always type 0*/
#define TELE_RANDOMIZER 0

#define PLANET_WARP 1


extern uchar telePods[][2];


/*Can't teleport while this is !0*/
extern int TELE_MODE;



/**************************************************************

										F U N C T I O N S

 *************************************************************/

/*Calculate the num of teleTypes used in the current level*/
void getNumTeleTypes (void);

/*Plant telepads in virgin soil*/
void plantTelePods (void);

/*YES, if this particular tank is on radar*/
char thisTankOnRadar (TANK *ttank);

/*YES, if another tank is within the RADAR_TILE_RADIUS */
char tankOnRadar (void);

/*Set player's initial x,y,angle*/
char telePortZap (TANK *tTank, uchar podType, uchar podNo);

/*Is player over teleport's central square?*/
char DETECT_TELEPORT (void);



#endif
