#ifndef TEXTOH
#define TEXTOH


#include "\tanx\objects.h"

#define ZOWT 0

/*JOLLY Text Alignment on screen**************/

/*Screen width: 320 pixels, 80 characters*/

/*Maximum character width of automatically generated
 messages, with one CW clearance of L and R scorelines*/
#define TCW_AUTO_MESSAGE	44

/*A measly 38 character width MAX for user*/
#define TCW_USER_MESSAGE 38


/*Position of all messages*/
#define TPW_MESSAGE_POS 72





/**************************************************************

												G L O B A L S

 *************************************************************/


extern char TEXT_MODE;
extern char USER_TEXT  [TCW_USER_MESSAGE];
extern int USER_TEXT_POS;
extern int USER_TEXT_MAXW;

/*Standard AUTO_MESSAGE text buffer*/
extern char amText [TCW_AUTO_MESSAGE];


extern char key_to_ascii [256][3];


/*Number of text messages which can be buffered*/
#define MAX_NET_MESSAGES 10

/*Max no of text messages which can be displayed at a time*/
#define MAX_SHOW_NET_MESSAGES 3


#define FULL_MESSAGE_DURATION  300
#define BRIEF_MESSAGE_DURATION  20

typedef struct
{
	int dwindow;		/*Sliding display window*/
	int curr;				/*destination slot for new message*/
	int cdown;			/*countdown before it disappears*/
	int num;    		/*number of messages in buffer*/

	char buff[MAX_NET_MESSAGES][MAX_TXTOBJ_LENGTH];
}N_MESSAGE;

extern N_MESSAGE nmsg;



extern char TEXT_SLOT[MAX_PLAYERS];

/*Placed at beginning of any transmitted text message*/
typedef struct
{
	uchar sender;
	uchar receivers;
}TEXT_HEADER;

/**************************************************************/



/**************************************************************
						 A U T O M A T I C   M E S S A G E S
 **************************************************************/


/*Strings of same AUTOMESS_TYPE may have diff. formats*/
enum AUTOMESS_FORMATS
{
	NORMAL= 0,
	ONE_NAME,
	MURDERER_MURDEREE,
	MURDEREE_MURDERER
};

enum AUTOMESS_TYPES
{
	AM_DEFAULTS=0,
	AM_YOU_KILLED,
	AM_KILLED_YOU,
	AM_X_KILLED_Y,
	AM_X_JOINED,
	AM_X_LEFT,
	AM_HIGH_KILL_FREQ,
	AM_LOW_KILL_FREQ,

	AM_TERMINATOR=99
};

typedef struct
{
	char msg[TCW_AUTO_MESSAGE];
	char format;/*eg ordering of murderer/murderee*/
	void *next; /*Sibling, if any*/
} AUTOMESS_CHILD;


typedef struct
{
	int choices;
	AUTOMESS_CHILD *first;

} AUTOMESS_PARENT;

#define MAX_AUTOMESS_TYPES 20
extern int NUM_AUTOMESS_TYPES;

extern AUTOMESS_CHILD autoMess[];

/*Need a function to form this using 'autoMess[]*/
extern AUTOMESS_PARENT autoMessTypes[MAX_AUTOMESS_TYPES];




/**************************************************************

											F U N C T I O N S

 *************************************************************/

void SET_ALL_TEXT_SLOTS (void);

/*Function keys toggle which players are to receive the text*/
void TEXT_RECEIVERS_SELECTOR(uint keyb);

/*Enter text mode when user selects it*/
void initiateTextMode (int max_cw);


/*Reads next character of text from keyboard*/
int textEntry (void);

void sendTextMessage (char *tTxtObj);

/*
 char receiveTextMessage (char *tTxtObj)
		currently declared in \tanx\objects.h*/
void sendAutoMess (int amType, uchar name1, uchar name2);

void receiveAutoMess (void);

/*Insert message in current empty slot*/
char newTextMessage (char *tTxtObj);


/*Display the current selection of messages at ymess*/
void displayTextMessages (int ymess);

/*Display the textline where the message is being entered*/
void displayUserText (void);

/*Notify the populace of the murder*/
void MURDER_MESS (int murderer, int murderee);



/*Form autoMess which may contain 1 or 2 names. If 2 names have
	been included, the name of the performer of the action must
	precede the recipient of the action's effect. (Sorry - I
	don't know the proper English Grammatical terms.)*/

char *fam (int amType, char *name1,char *name2);


/***Forms 'autoMessTypes[] using 'autoMess[]*****/
/***Each 'autoMessType[] entry has a pointer to a linked list
 of messages, which are all of the same type, and include
 formatting info*/

void formAutoMessTypes (void);


#endif
