#include "headers.h"

#include "shell.h"
#include "chuck.h"
#include "shock.h"
#include "e_global.h"

#include "iff.h"
#include "frontend.h"
#include "frontdef.h"
#include "frglobs.h"

/***************************************************************/

#define	CLPX1	000
#define	CLPY1	000
#define	CLPX2	319
#define	CLPY2	100

/***************************************************************/
/***************************************************************/

#define	NSCR_WIDTH						320
#define	CATCHMENTS_ACROSS			15

#define WEAPON_NAME_XPOS			213
#define WEAPON_NAME_YPOS			182
#define WEAPON_STAT_YPOS			145


#define COLR_1								108
#define COLR_2								150
#define COLR_3								131
#define COLR_4								66

enum { TRIANGLE_SLIDER, BOX_SLIDER };

/***************************************************************/

// take_this_out
static	int		clipleft=10, clipright=309, cliptop=10, clipbottom=189;
#define LINE_STEP	1
/////////////////

/* Linedraw variables */
static	short	incx, incy;
static	short	dx,dy;
static	short	xerr, yerr;
static	short	currentx, currenty;
static	short	start,finish;
static	short	distance;

char	weaponNames[MAX_WEAPONS][16] =
		{"MAIN GUN", "CHAIN GUN", "SAM'S", "9-1-1", "9-1-1"};

void	draw_tank(int x, int z, int rotangle, int dcolr, char*ctrlFunc, int defnum);

void	draw_waypoint(int target);
void	draw_waypoints(uint x, uint z);

void	put_pixel_c(int px, int py, int pc);
void	draw_slider(int x, int y, int volume, int highlight, int shape);

//#define put_pixel(px,py,pc) {p1screen[py*NSCR_WIDTH+px]=pc;}

// take_this_out
////////////////

void rotate(void)
{
	int	camx, camz;

	pangle = 	camera_angle;

	camz = -(((cam_dist) * sintab[pangle + 512]) >> 14);
	camx = -(((cam_dist) * sintab[pangle]) >> 14);

	pxpos = (pl.x >> 16) + (short) camx;
	pzpos = (pl.z >> 16) + (short) camz;

  spxpos = (pl.x >> 16) + 256;
	spzpos = (pl.z >> 16);

	alt = pl.y + TANK_VIEW_HEIGHT + (sink_add>>1);

	if (alt > -32)
	{
		set_exit_game(ENDGAME_DROWNED);
		objectiveAchieved=FALSE;
	}
}

/***************************************************************/

#define BACKGROUND_WIDTH		512
#define BACKGROUND_DEPTH		64
#define REFLECTION_DEPTH		64

void extend_background()
{
	int i,j;
	uchar *source1,*source2,*dest;

	dest = back_map;

	for(i=0; i<BACKGROUND_DEPTH; i++)
	{
		source1 = source2 = ((char*)floor_map)+(BACKGROUND_WIDTH*i);

		for (j=0; j<BACKGROUND_WIDTH; j++)
		{
			*dest++ = *source1++;
		}
		for (j=0; j<320; j++)   // j<288
		{
			*dest++ = *source2++;
		}
	}
}

/***************************************************************/

void extend_reflection(void)
{
	int i,j;
	uchar *source1,*source2,*dest;

	dest = reflect_map;

	for(i=0; i<REFLECTION_DEPTH; i++)
	{
		source1 = source2 = ((char*)floor_map)+(BACKGROUND_WIDTH*i);

		for (j=0; j<BACKGROUND_WIDTH; j++)
		{
			*dest++ = *source1++;
		}
		for (j=0; j<320; j++)   // j<288
		{
			*dest++ = *source2++;
		}
	}
}

/***************************************************************/

void convert_pal(void)
{
	int	i;
	for (i=0;i<768;i++)
	{
		palette[i]>>=2;
	}
}

/***************************************************************/

#define RADAR_DISPLAY_X				132
#define RADAR_DISPLAY_Y				142

#define SPEEDO_DISPLAY_X			270
#define SPEEDO_DISPLAY_Y			160

#define RADAR_RING_X					136
#define RADAR_RING_Y					146
#define RADAR_MIDDLE					28
#define RADAR_MIDDLE_X				159
#define RADAR_MIDDLE_Y				169

#define COMPASS_DISPLAY_X			128
#define COMPASS_DISPLAY_Y			7

#define NEEDLE_SIZE						12
#define NEEDLE_X							280
#define NEEDLE_Y							170

/** Radar colours */

#define ENEMY_TANK_COLOUR			248
#define SHELL_COLOUR					238
#define HELICOPTER_COLOUR			246
#define GUN_EMPL_COLR         247
#define GUN_BOAT_COLR					245


#define NEEDLE_COLOUR					238

/***************************************************************/

#define LEFT_OBJECTIVE_ARROW_X		122
#define RIGHT_OBJECTIVE_ARROW_X		198
#define	OBJECTIVE_ARROW_Y					7
#define COMPASS_UNIT_Y						3


void	draw_panel_bits(void)
{
	int	n;
	SHELL_DATA *ashell;
	TANK	*atank;
	GUN_EMPLACEMENT *cgunempl;
	GUN_BOAT	*cboat;
	int	tx,tz;
	int	rx,rz;
	int	plcos, plsine;
	int	needle;
	int	compassAngle;
	int	objectiveAngle;
	uint	objectiveDist;

	plcos = (int)sintab[pl.angle+512];
	plsine = (int)sintab[pl.angle];


	/* Remove the old readings by drawing over in black */
//	cliptop = OBJECTIVE_ARROW_Y;

	cliptop = 0;

	scr_ptr = p1screen;

	for ( n=0; n<9; n++ )
	{
		draw_line_c(LEFT_OBJECTIVE_ARROW_X, COMPASS_UNIT_Y+n, LEFT_OBJECTIVE_ARROW_X+80, COMPASS_UNIT_Y+n, 0);
	}

	/* Draw the compass */
	compassAngle = ( ( ( (0x3ff-pl.angle) &0x7ff ) >>4 )&0x7f );
	scr_ptr = p1screen + COMPASS_DISPLAY_Y*320 + COMPASS_DISPLAY_X;
	_draw_compass( compassAngle );


	/* Remove the image of the right old arrow */

	for ( n=0; n<6; n++ )
	{
		draw_line_c(RIGHT_OBJECTIVE_ARROW_X-1, OBJECTIVE_ARROW_Y+n, RIGHT_OBJECTIVE_ARROW_X+4, OBJECTIVE_ARROW_Y+n, 0);
	}

	scr_ptr = p1screen;


	if ( showObjectiveDirn )
	{
		tx = abs((pl.x>>16) - (objectiveX>>16));
		tz = abs((pl.z>>16) - (objectiveZ>>16));

		if ( tx>tz )
		{
			objectiveDist = (tz>>1)+tx;
		}
		else
			objectiveDist = (tx>>1)+tz;

		objectiveAngle = phd_atan((int)(((uint)objectiveX>>16) - ((uint)pl.x>>16)), (int)(((uint)objectiveZ>>16) - ((uint)pl.z>>16)) );

		objectiveAngle = 0x400-((objectiveAngle-pl.angle)&0x7ff);

		if ( abs(objectiveAngle)<=0X200 )/* Roughly ahead */
		{
			put_images(LEFT_OBJECTIVE_ARROW_X, OBJECTIVE_ARROW_Y, OBJECTIVE_IND_LEFT, (uchar*)panel_display_graphics, (uchar*)panel_display_net);
			put_images(RIGHT_OBJECTIVE_ARROW_X, OBJECTIVE_ARROW_Y, OBJECTIVE_IND_RIGHT, (uchar*)panel_display_graphics, (uchar*)panel_display_net);
			put_images(160+(objectiveAngle>>4), 3, OBJECT_IND_PIN_PT, (uchar*)panel_display_graphics, (uchar*)panel_display_net);

			if ( (abs(objectiveAngle)<=0X10) && (objectiveDist>0x1800) )
			{
				start_message(EAR_MSG1);
			}

		}
		else
		{
			if ( objectiveAngle<(-0x200) )
			{
				put_images(LEFT_OBJECTIVE_ARROW_X, OBJECTIVE_ARROW_Y, OBJECTIVE_IND_RIGHT, (uchar*)panel_display_graphics, (uchar*)panel_display_net);
				put_images(RIGHT_OBJECTIVE_ARROW_X, OBJECTIVE_ARROW_Y, OBJECTIVE_IND_RIGHT, (uchar*)panel_display_graphics, (uchar*)panel_display_net);

				if ( objectiveDist>0x1800 )
					start_message(EAR_MSG3);
			}
			else
			{
				put_images(LEFT_OBJECTIVE_ARROW_X, OBJECTIVE_ARROW_Y, OBJECTIVE_IND_LEFT, (uchar*)panel_display_graphics, (uchar*)panel_display_net);
				put_images(RIGHT_OBJECTIVE_ARROW_X, OBJECTIVE_ARROW_Y, OBJECTIVE_IND_LEFT, (uchar*)panel_display_graphics, (uchar*)panel_display_net);

				if ( objectiveDist>0x1800 )
					start_message(EAR_MSG2);

			}
		}
	}

	/**** Radar bit ****/

	/* Draw the radar scanner rings */
	scr_ptr = p1screen + ((NSCR_WIDTH*RADAR_DISPLAY_Y) + (RADAR_DISPLAY_X));
	_draw_radar_rings();

	scr_ptr = p1screen + (NSCR_WIDTH*RADAR_DISPLAY_Y);

	draw_view_cone();

	/* First do the enemy tanks */
	for ( n=0, atank=enemyTanks; n<MAX_ENEMY_TANKS; n++, atank++ )
	{
		if ( (atank->def) && (!(atank->def==REGENERATE_OBJECT)) )
		{
			tx=(int)((pl.x>>16) - (atank->x>>16));
			tz=(int)((pl.z>>16) - (atank->z>>16));

			rx=tx*plcos - tz*plsine;
			rz=tz*plcos + tx*plsine;

			tx=rx>>RADAR_SCALE_SHIFT;
			tz=rz>>RADAR_SCALE_SHIFT;
			if(abs(tx)<RADAR_MIDDLE && abs(tz)<RADAR_MIDDLE)
				p1screen[RADAR_MIDDLE_X+tx + (tz+RADAR_MIDDLE_Y)*NSCR_WIDTH]=ENEMY_TANK_COLOUR;
		}
	}

	/* Do the enemy helicopters */
	for ( n=0, atank=helicopters; n<MAX_HELICOPTERS; n++, atank++ )
	{
		if ( atank->def && atank->def!=REGENERATE_OBJECT && atank->flying)
		{
			tx=(int)(pl.x - atank->x) >> 16;
			tz=(int)(pl.z - atank->z) >> 16;

			rx=tx*plcos - tz*plsine;
			rz=tz*plcos + tx*plsine;

			tx=rx>>RADAR_SCALE_SHIFT;
			tz=rz>>RADAR_SCALE_SHIFT;

			if(abs(tx)<RADAR_MIDDLE && abs(tz)<RADAR_MIDDLE)
				p1screen[RADAR_MIDDLE_X+tx + (tz+RADAR_MIDDLE_Y)*NSCR_WIDTH]=HELICOPTER_COLOUR;
		}
	}


	/** Plot the gun emplacements */
	for ( n=0, cgunempl=gunempls; n<MAX_GUN_EMPLS; n++, cgunempl++)
	{
		if ( cgunempl->exist )
		{
			tx=(int)(pl.x - cgunempl->x) >> 16;
			tz=(int)(pl.z - cgunempl->z) >> 16;

			rx=tx*plcos - tz*plsine;
			rz=tz*plcos + tx*plsine;

			tx=rx>>RADAR_SCALE_SHIFT;
			tz=rz>>RADAR_SCALE_SHIFT;

			if(abs(tx)<RADAR_MIDDLE && abs(tz)<RADAR_MIDDLE)
				p1screen[RADAR_MIDDLE_X+tx + (tz+RADAR_MIDDLE_Y)*NSCR_WIDTH]=GUN_EMPL_COLR;
		}
	}

	/** Plot the gun boats **/
	for ( n=0, cboat=gunboats; n<MAX_GUN_BOATS; n++, cboat++)
	{
		if ( cboat->exist )
		{
			tx=(int)(pl.x - cboat->x) >> 16;
			tz=(int)(pl.z - cboat->z) >> 16;

			rx=tx*plcos - tz*plsine;
			rz=tz*plcos + tx*plsine;

			tx=rx>>RADAR_SCALE_SHIFT;
			tz=rz>>RADAR_SCALE_SHIFT;

			if(abs(tx)<RADAR_MIDDLE && abs(tz)<RADAR_MIDDLE)
				p1screen[RADAR_MIDDLE_X+tx + (tz+RADAR_MIDDLE_Y)*NSCR_WIDTH]=GUN_BOAT_COLR;
		}
	}

	/* Player shells */
	for ( n=0, ashell=playerShells; n<MAX_PLAYER_SHELLS; n++, ashell++ )
	{
		if ( ashell->fired )
		{
			tx=(int)(pl.x - ashell->x) >> 16;
			tz=(int)(pl.z - ashell->z) >> 16;

			rx=tx*plcos - tz*plsine;
			rz=tz*plcos + tx*plsine;

			tx=rx>>RADAR_SCALE_SHIFT;
			tz=rz>>RADAR_SCALE_SHIFT;

			if(abs(tx)<RADAR_MIDDLE && abs(tz)<RADAR_MIDDLE)
				p1screen[RADAR_MIDDLE_X+tx + (tz+RADAR_MIDDLE_Y)*NSCR_WIDTH]=SHELL_COLOUR;
		}
	}

	/* Enemy shells */
	for ( n=0, ashell=enemyShells; n<MAX_ENEMY_SHELLS; n++, ashell++ )
	{
		if ( ashell->fired )
		{
			tx=(int)(pl.x - ashell->x) >> 16;
			tz=(int)(pl.z - ashell->z) >> 16;

			rx=tx*plcos - tz*plsine;
			rz=tz*plcos + tx*plsine;

			tx=rx>>RADAR_SCALE_SHIFT;
			tz=rz>>RADAR_SCALE_SHIFT;

			if(abs(tx)<RADAR_MIDDLE && abs(tz)<RADAR_MIDDLE)
				p1screen[RADAR_MIDDLE_X+tx + (tz+RADAR_MIDDLE_Y)*NSCR_WIDTH]=SHELL_COLOUR;
		}
	}


	/* 911 */

	if ( airSupportTriggerd )
	{
		tx=(int)(pl.x - nine.x) >> 16;
		tz=(int)(pl.z - nine.z) >> 16;

		rx=tx*plcos - tz*plsine;
		rz=tz*plcos + tx*plsine;

		tx=rx>>RADAR_SCALE_SHIFT;
		tz=rz>>RADAR_SCALE_SHIFT;

		if(abs(tx)<RADAR_MIDDLE && abs(tz)<RADAR_MIDDLE)
			p1screen[RADAR_MIDDLE_X+tx + (tz+RADAR_MIDDLE_Y)*NSCR_WIDTH]=COCKPIT_PURPLE;
	}



	/* Draw the radar overlay */
	scr_ptr = p1screen;
	sprite_y_clip=200;
	scale_sprite(RADAR_DISPLAY_X, RADAR_DISPLAY_Y, ONE_2_ONE_SPRITE, RADAR_SURROUNDS, 32, 0, 0, (uchar*)panel_display_graphics, (uchar*)panel_display_net);

	/* Draw the speedo */
	scale_sprite(SPEEDO_DISPLAY_X, SPEEDO_DISPLAY_Y, ONE_2_ONE_SPRITE, SPEEDO_DIAL, 32, 0, 0, (uchar*)panel_display_graphics, (uchar*)panel_display_net);

	needle=((abs(pl.speed)>>1) + 192)&0x7ff;

	tz = ( NEEDLE_SIZE * (int)sintab[needle+512]) >>16;
	tx = -( ( NEEDLE_SIZE * (int)sintab[needle]) >>16);

	draw_line(NEEDLE_X, NEEDLE_Y, NEEDLE_X+tx, NEEDLE_Y+tz, NEEDLE_COLOUR);
}

/***************************************************************/

uchar*	get_sprite_graphics_address(int sprnum, int netnum, uchar *gdata, short *netdata, short *sprwidth, short *sprheight, short *xoff, short *yoff)
{
	short *tnetptr;
	short	netoffset;
	uchar	*gfx_addr;

	netoffset = (*(netdata + sprnum + 1)) ;
	netoffset >>= 1;

	tnetptr  = netdata + netoffset;

	tnetptr++;	// skip over number of nets in sprite

	tnetptr+=(netnum*5); // Skip to the required net

	if ( xoff!=NULL )
	{
		*xoff = *tnetptr;
	}
	tnetptr++;

	if ( yoff!=NULL )
	{
		*yoff = *tnetptr;
	}
	tnetptr++;

	gfx_addr = gdata + *((int*)(tnetptr));

	if ( sprwidth!=NULL )
	{
		*sprwidth = *((short*)gfx_addr);
	}
	gfx_addr+=2;

	if ( sprheight!=NULL )
	{
		*sprheight = *((short*)gfx_addr);
	}
	gfx_addr+=2;


	return(gfx_addr);
}

/***************************************************************/

void	draw_line(short x1, short y1, short x2, short y2, short colr)
{
	int n;

	xerr=0;
	yerr=0;

	if(x1==x2 && y1==y2) put_pixel(x1,y1,colr); // No line just a point
	else
	if(x1==x2)							// Vertical line
		{
		start=min(y1,y2);
		finish=max(y1,y2);
		currentx=x1;
		for(n=start; n<=finish; n++)
			put_pixel(currentx, n, colr);
		}
	else
	if(y1==y2)						// Horizontal line
		{
		start=min(x1,x2);
		finish=max(x1,x2);
		currenty=y1;
		for(n=start; n<=finish; n++)
			put_pixel(n, currenty, colr);
		}
	else
	{								// All other lines using bresenhams algorithm
		dx=x2-x1;
		dy=y2-y1;

		if(dx>0) incx=1;
		else incx=-1;

		if(dy>0) incy=1;
		else incy=-1;

		dx=abs(dx);
		dy=abs(dy);

		if(dx>dy) distance=dx;
		else distance=dy;

		currentx= x1;
		currenty= y1;

		for(n=0; n<=distance+1; n++)
			{
			put_pixel(currentx, currenty, colr);
			xerr+=dx;
			yerr+=dy;
			if (xerr>distance)
			{
				xerr-=distance;
				currentx+=incx;
			}
			if (yerr>distance)
			{
				yerr-=distance;
				currenty+=incy;
			}
		}
	}
}

/***************************************************************/

void	draw_line_c(short x1, short y1, short x2, short y2, short colr)
{
	int	n;

	xerr=0;
	yerr=0;

	if ( x1<clipleft && x2<clipleft )
	{
		return;
	}

	if ( x1>clipright && x2>clipright )
	{
		return;
	}

	if ( y1<cliptop && y2<cliptop )
	{
		return;
	}

	if ( y1>clipbottom && y2>clipbottom )
	{
		return;
	}

	if(x1==x2 && y1==y2) put_pixel_c(x1,y1,colr);// No line just a point
	else
	if(x1==x2)		// Vertical line
	{
		if (x1>=clipleft && x1<=clipright)
		{
			start=min(y1,y2);
			finish=max(y1,y2);
			currentx=x1;
			if(start<cliptop)start=cliptop;
			if(finish>clipbottom)finish=clipbottom;
			for(n=start; n<=finish; n++)
				put_pixel_c(currentx, n, colr);
			return;
		}
		else
			return;
	}
	else
	if(y1==y2)						// Horizontal line
	{
		if (y1>=cliptop && y1<=clipbottom)
		{
			start=min(x1,x2);
			finish=max(x1,x2);
			currenty=y1;
			if(start<clipleft)start=clipleft;
			if(finish>clipright)finish=clipright;
			for(n=start; n<=finish; n++)
				put_pixel_c(n, currenty, colr);
			return;
		}
		else
			return;
	}
	else
	{								// All other lines using bresenhams algorithm

		dx=(x2-x1)/LINE_STEP;
		dy=(y2-y1)/LINE_STEP;

		if(dx>0) incx=LINE_STEP;
		else incx=-LINE_STEP;

		if(dy>0) incy=LINE_STEP;
		else incy=-LINE_STEP;

		dx=abs(dx);
		dy=abs(dy);

		if(dx>dy) distance=dx;
		else distance=dy;

		currentx=x1;
		currenty=y1;

		for(n=0; n<=distance+1; n++)
		{

			if (currentx>=clipleft && currentx<=clipright && currenty>=cliptop && currenty<=clipbottom)
				put_pixel_c(currentx, currenty, colr);

			xerr+=dx;
			yerr+=dy;
			if (xerr>distance)
			{
				xerr-=distance;
				currentx+=incx;
			}

			if (yerr>distance)
			{
				yerr-=distance;
				currenty+=incy;
			}
		}
	}
}

/***************************************************************/

void	put_pixel_c(int px, int py, int pc)
{
	if ( px < clipleft )
	{
		return ;
	}

	if ( px> clipright )
	{
		return ;
	}

	if ( py <cliptop )
	{
		return ;
	}

	if ( py> clipbottom )
	{
		return ;
	}

	p1screen[py*NSCR_WIDTH + px] = pc;
}

/***************************************************************/

uchar	weaponSprite[MAX_WEAPONS] = {MAIN_GUN_READOUT, CHAINGUN_READOUT, SAM_READOUT, PLANE_AIRSTRIKE, HELI_AIRSTRIKE };

#define WEAPON_DISPLAY_X			211
#define WEAPON_DISPLAY_Y			139
#define WEAPON_DIPLAY_WIDTH		37
#define WEAPON_DISPLAY_HEIGHT	50
#define CHAINGUN_HEAT_DISPL_Y	WEAPON_DISPLAY_Y+16
#define CGUN_HEAT_STRIP_LEN		3
#define LOCKED_STRING_X				WEAPON_NAME_XPOS+4
#define LOCKED_STRING_Y				WEAPON_DISPLAY_Y+5
#define NSAMS_X								WEAPON_NAME_XPOS+24

void	draw_weapon_display(int	weaponId)
{
	int	n;
	char	nsamStr[4];

	scr_ptr=p1screen;
	sprite_y_clip=200;
	scale_sprite(WEAPON_DISPLAY_X, WEAPON_DISPLAY_Y, ONE_2_ONE_SPRITE, weaponSprite[weaponId], 32, 0, 0, (uchar*)panel_display_graphics, (uchar*)panel_display_net);

	drawFlags[DRAW_WEAPONS_DISPLAY]=1;

	txt_print_colr = SHELL_COLOUR;

	_print_string(WEAPON_NAME_XPOS, WEAPON_NAME_YPOS, weaponNames[weaponId], SINGLE_COLOURED_PRINT);

	switch ( weaponId )
	{
		case WCHAIN_GUN:
			/* If locked then print locked string */
			if ( targ.locked )
			{
				_print_string(LOCKED_STRING_X, LOCKED_STRING_Y, "LOCKED", SINGLE_COLOURED_PRINT);
			}

			if ( !pl.chaingunHeat )
			{
				break;
			}
			/* Draw the overheat bars */
			for ( n=0; n<= ((pl.chaingunHeat>>2)&0xf); n++ )
			{
				draw_line_c(WEAPON_NAME_XPOS+(n<<1), CHAINGUN_HEAT_DISPL_Y, WEAPON_NAME_XPOS+(n<<1), CHAINGUN_HEAT_DISPL_Y+CGUN_HEAT_STRIP_LEN, SHELL_COLOUR);
			}
			break;

		case WSAMS:
			sprintf(nsamStr,"%02d",game_data.nsams);
			_print_string(NSAMS_X, WEAPON_NAME_YPOS, nsamStr, SINGLE_COLOURED_PRINT);
			break;
	}
}

/***************************************************************/

#define ARMOUR_UNIT_WIDTH	8
#define ARMOUR_DISPLAY_Y	160
#define ARMOUR_DISPLAY_X	30

void	draw_armour_display(void)
{
	short	n,y,armourLevel;

	scr_ptr=p1screen;
	sprite_y_clip=200;

	armourLevel = pl.armour>>5;

	/* Draw the armour units */

	for ( n=(pl.max_armour>>8); n>0; n-- )
	{
		scale_sprite(ARMOUR_DISPLAY_X + (n-1)*ARMOUR_UNIT_WIDTH, ARMOUR_DISPLAY_Y, ONE_2_ONE_SPRITE, ARMOUR_UNIT, 32, 0, 0, (uchar*)panel_display_graphics, (uchar*)panel_display_net);
	}

	/* Draw the amount of armour left */

	for ( n=0, y=ARMOUR_DISPLAY_Y+2; n<3; n++,y++ )
	{
		draw_line(ARMOUR_DISPLAY_X, y, ARMOUR_DISPLAY_X+50, y, 0);
		draw_line(ARMOUR_DISPLAY_X, y, ARMOUR_DISPLAY_X+armourLevel, y, armourDisplayColour);
	}

	drawFlags[DRAW_SHEILDS]=1;
}

/***************************************************************/

#define MAP_SCREEN_X		192
#define MAP_SCREEN_Y		96

extern SIZE_INFO sizes[];
extern int objectDetectSizes[];

extern int	wallsCollided;

/***************************************************************/

// take_this_out
extern int smallestAngDiff;
////////////////

/******************************/

#define QUIT_BOX_Y1					44
#define QUIT_BOX_Y2					74

#define OPTION_BOX_Y1				8
#define OPTION_BOX_Y2				102

#define TRANSPARENT_BOX_X1  20
#define	TRANSPARENT_BOX_X2	300

#define CHAR_TEXTBOX_Y1			12
#define CHAR_TEXTBOX_Y2			22

#define WARNING_MESSAGE_Y		90

#define TURRET_ANGLE_BAR_Y	(320*(96+10))
#define TURRET_ANGLE_BAR_X	128
#define TURRET_ARROW_X			156
#define TURRET_ARROW_Y			100

void	draw_game_screen(void)
{
	int	yshift;
	int	i;
	int	turretDisplayAngle;

	yshift = (tiltLev>>4)&0x0f;

	txt_print_colr = txt_col = COCKPIT_YELLOW;

	scr_ptr = currentScreen + TURRET_ANGLE_BAR_Y + TURRET_ANGLE_BAR_X + (yshift*320);
	turretDisplayAngle = 32-(turret_angle>>5);

	if ( turretDisplayAngle<0 )
	{
		turretDisplayAngle+=64;
	}
	if ( turretDisplayAngle>=64 )
	{
		turretDisplayAngle-=64;
	}

	_draw_turret_angle(turretDisplayAngle);

	scr_ptr = currentScreen + (yshift*320);

	if ( turret_angle==0 )
	{
		put_images(TURRET_ARROW_X, TURRET_ARROW_Y, 23, (uchar*)panel_display_graphics, (uchar*)panel_display_net);
	}
	else
	{
		put_images(TURRET_ARROW_X, TURRET_ARROW_Y, 24, (uchar*)panel_display_graphics, (uchar*)panel_display_net);
	}

	if ( checkExitGame )
	{
		draw_transparent_box(TRANSPARENT_BOX_X1, QUIT_BOX_Y1, TRANSPARENT_BOX_X2, QUIT_BOX_Y2, 243);

		current_font = medium_font;

		_print_string(messageStringPos[QUIT_REQUEST_MESSAGE][0],
					messageStringPos[QUIT_REQUEST_MESSAGE][1],
					messageStringList[QUIT_REQUEST_MESSAGE], MULTICOLOURED_PRINT);

		current_font = tiny_font;
	}
	else
	if ( setoptions )
	{
		int printType=MULTICOLOURED_PRINT;
		char	trackNumberString[4];

		draw_transparent_box(TRANSPARENT_BOX_X1, OPTION_BOX_Y1, TRANSPARENT_BOX_X2, OPTION_BOX_Y2, 243);

		for ( i=0; i<=MAX_OPTION_ITEMS; i++ )
		{
			txt_col = COCKPIT_YELLOW;

			current_font = medium_font;

			if ( i==(optionItem+1) )
			{
				printType = SINGLE_COLOURED_PRINT;

				txt_print_colr = COCKPIT_WHITE;
			}
			else
				printType = MULTICOLOURED_PRINT;


			// print the option name
			_print_string(messageStringPos[OPTION_HEADING+i][0],
				messageStringPos[OPTION_HEADING+i][1],
				messageStringList[OPTION_HEADING+i], printType);


			// print the current value of the option
			if ( i>0 && i!=7 )
			{
				switch ( optionTypes[i-1] )
				{
					case ON_OFF:
						if ( optionSettings[i-1] )
						{
							_print_string(200,
														messageStringPos[OPTION_HEADING+i][1],
														"ON", printType);
						}
						else
							_print_string(200,
														messageStringPos[OPTION_HEADING+i][1],
														"OFF", printType);
						break;


					case NUMBER_TYPE:
						sprintf(trackNumberString,"%d",optionSettings[i-1]);
						_print_string(200,
													messageStringPos[OPTION_HEADING+i][1],
													trackNumberString, printType);
						break;


					case SLIDER_TYPE:
						if ( i==3 )
						{
							draw_slider(200, messageStringPos[OPTION_HEADING+i][1]-1, optionSettings[i-1], (printType==SINGLE_COLOURED_PRINT), TRIANGLE_SLIDER);
						}
						else
						if ( i==5 || i==6 )
						{
							draw_slider(200, messageStringPos[OPTION_HEADING+i][1]-1, optionSettings[i-1], (printType==SINGLE_COLOURED_PRINT), BOX_SLIDER);
						}
						break;
				}
			}

			current_font = tiny_font;
		}
	}
	else
	if ( messagePlaying )
	{
		draw_transparent_box(TRANSPARENT_BOX_X1, CHAR_TEXTBOX_Y1, TRANSPARENT_BOX_X2, CHAR_TEXTBOX_Y2, 243);
		_print_string(TRANSPARENT_BOX_X1+4, CHAR_TEXTBOX_Y1+3, characterText[currentMessage->messageText], SINGLE_COLOURED_PRINT );
	}




	if ( messageId && (msgFlash&16) && (!setoptions) && (!checkExitGame))
	{
		current_font = medium_font;
		_print_string(10, WARNING_MESSAGE_Y, ingameText[AWOL_WARNING_TXT+messageId-1], SINGLE_COLOURED_PRINT);
		current_font = tiny_font;
	}

	if ( !setoptions & !paused )
	{
		trippy = tripFactor;
	}
	else
		trippy = FALSE;

	put_images(0, 91, 0, (uchar*)panel_display_graphics, (uchar*)panel_display_net);
	put_images(304, 92, 1, (uchar*)panel_display_graphics, (uchar*)panel_display_net);

	_dump_game_screen();

	previousScreen = scr_ptr;
}

/***************************************************************/

void update_pickups(void)
{
		/* Upgrade engine. (Value = engine_upg) */

	 	pl.accelr =	td[PLAYER_TANK].accelr + eu[engine_upg].accelr;
		pl.accelc =	td[PLAYER_TANK].accelc + eu[engine_upg].accelc;

		/* Upgrade tracks. (Value = track_upg) */

		pl.trak_grip = td[PLAYER_TANK].trak_grip + tu[track_upg].trak_grip;
		pl.top_brake = td[PLAYER_TANK].top_brake + tu[track_upg].top_brake;

		/* Effects of both pickups. */

		pl.maxturn = td[PLAYER_TANK].maxturn + eu[engine_upg].maxturn + tu[track_upg].maxturn;
		pl.pre_accel = td[PLAYER_TANK].pre_accel + eu[engine_upg].pre_accel + tu[track_upg].pre_accel;
		pl.top_speed = td[PLAYER_TANK].top_speed + eu[engine_upg].top_speed + tu[track_upg].top_speed;
}

/***************************************************************/

void turn_off_lights(void)
{
	palette[(221*3)+0] = 18;
	palette[(221*3)+1] = 18;
	palette[(221*3)+2] = 18;

	palette[(222*3)+0] = 22;
	palette[(222*3)+1] = 22;
	palette[(222*3)+2] = 22;

	palette[(223*3)+0] = 26;
	palette[(223*3)+1] = 26;
	palette[(223*3)+2] = 28;

	lightsTurnedOff=TRUE;

	fade_to_pal(8,palette);
}

/***************************************************************/

void turn_on_lights(void)
{
	if ( !(game_data.mission==9 || game_data.mission==4 ||
				 game_data.mission==22 ) )	/** ONLY TURN LIGHTS ON DURING A NIGHT MISSION **/
	{
		lightsTurnedOff=TRUE;
		return ;
	}

	palette[(221*3)+0] = 55;
	palette[(221*3)+1] = 45;
	palette[(221*3)+2] = 14;

	palette[(222*3)+0] = 61;
	palette[(222*3)+1] = 57;
	palette[(222*3)+2] = 24;

	palette[(223*3)+0] = 63;
	palette[(223*3)+1] = 61;
	palette[(223*3)+2] = 36;

	lightsTurnedOff=FALSE;
}

/***************************************************************/

// take_this_out

#ifdef DEBUG_VERSION
void photo(void)
{
	uchar		fname[13];
	FILE		*neo_file;
	uchar		tempBuff[4];
	int			photo_no = 0;

	sprintf(fname,"c:\\photo%d.neo",photo_no++);

	while ( (neo_file=fopen(fname,"rb"))!=NULL )
	{
		fclose(neo_file);
		sprintf(fname,"c:\\photo%d.neo",photo_no++);
	}

	neo_file=fopen(fname,"wb");

	memset(tempBuff, 0, 4);

	fwrite(tempBuff, sizeof(char), 4, neo_file);

	fwrite(palette, sizeof(char), 768, neo_file);

	fwrite((char*)VIDEO_START_ADRESS, sizeof(char), 320*200, neo_file);

	fclose(neo_file);
}
#endif

/***************************************************************/


void	line_draw(long x1,long y1,long x2,long y2,uchar col)
{

	long	dx ,dy;
	long 	count , stepflag , xstep;
	uchar	*scrpointer1 , *scrpointer2;

	if ( x1 == x2 && y1 == y2 )
	{
		if ( !(x1<CLPX1 || x1>CLPX2 || y1<CLPY1 || y1>CLPY2) )
		{
			scrpointer1 = currentScreen + (x1) + (y1*NSCR_WIDTH);
			//*scrpointer1 = interpol_tab[col+(*scrpointer1<<8)];
			*scrpointer1 = col;
		}
		return;
	}

	if ( x1>x2 )
	{
		dx = x1;
		dy = y1;
		x1 = x2;
		y1 = y2;
		x2 = dx;
		y2 = dy;
	}

	if ( ( x1<CLPX1 && x2<CLPX1 ) || ( x1>CLPX2 && x2>CLPX2 ) )
		return;

	if ( x1<CLPX1 )
	{
		y1 = y2 + ( ((y2-y1)*(CLPX1-x2)) / (x2-x1) );
		x1 = CLPX1;
	}

	if ( x2>CLPX2 )
	{
		y2 = y1 + ( ((y2-y1)*(CLPX2-x1)) / (x2-x1) );
		x2 = CLPX2;
	}

	if ( y1>y2 )
	{
		dx = x1;
		dy = y1;
		x1 = x2;
		y1 = y2;
		x2 = dx;
		y2 = dy;
	}

	if ( ( y1<CLPY1 && y2<CLPY1 ) || ( y1>CLPY2 && y2>CLPY2 ) )
		return;

	if ( y1<CLPY1 )
	{
		x1 = x2 + ( ((x2-x1)*(CLPY1-y2)) / (y2-y1) );
		y1 = CLPY1;
	}

	if ( y2>CLPY2 )
	{
		x2 = x1 + ( ((x2-x1)*(CLPY2-y1)) / (y2-y1) );
		y2 = CLPY2;
	}

	scrpointer1 = currentScreen + (x1) + (y1*NSCR_WIDTH);
	scrpointer2 = currentScreen + (x2) + (y2*NSCR_WIDTH);

	dx = x2-x1;
	dy = y2-y1;

	xstep = 1;
	if ( dx<0 )
	{
		xstep = -1;
		dx = -dx	;
	}

	if ( dx>dy )
	{
		stepflag = count = dx/2;

		while ( count>=0 )
		{
			*scrpointer1 = col;
			scrpointer1 += xstep;
			*scrpointer2 = col;
			scrpointer2 -= xstep;
			stepflag += dy;

			if ( stepflag>=dx )
			{
				scrpointer1 += NSCR_WIDTH;
				scrpointer2 -= NSCR_WIDTH;
				stepflag -= dx;
			}
			count--;
		}
	}
	else
	{
		stepflag = count = dy>>1;

		while ( count>=0 )
		{
			*scrpointer1 = col;
			scrpointer1 += NSCR_WIDTH;
			*scrpointer2 = col;
			scrpointer2 -= NSCR_WIDTH;
			stepflag += dx;

			if ( stepflag>=dy )
			{
				scrpointer1 += xstep;
				scrpointer2 -= xstep;
				stepflag -= dy;
			}
			count--;
		}
	}
}

/*********************************/

void	get_floor_pickup(int i)
{
	moneyCollected+=500;
	game_data.crates_coll++;
	play_picked_up_collectable_sound();
	debug_msg("Picked up cash bonus! ($500)\n");

}

/*********************************/

void	put_images(int xpos, int ypos, int def, uchar *gfx, uchar *net)
{
	int		numspr , xoff , yoff ;
	int		*netptrl ;
	short	*netptrs ;

	netptrs = (short*)( net + (def*2) + 2 ) ;
	netptrs = (short*)( net + *netptrs ) ;

	numspr = *netptrs++ ;

	xoff = *netptrs++ ;
	yoff = *netptrs++ ;

	netptrl = (int*)netptrs ;
 	g_addr =  (uchar*)(*netptrl + gfx ) ;

	spb.t_scr_xpos = xpos + xoff ;
	spb.t_scr_ypos = ypos + yoff ;

	_generic_spr(&spb);
}

/*********************************/

void	draw_transparent_box(int x1, int y1, int x2, int y2, int colr)
{
	int	x,y;
	uchar	*transcr;

	for ( y=y1; y<=y2; y++ )
	{
		transcr = scr_ptr + x1 + y*NSCR_WIDTH;
		for ( x=x1; x<=x2; x++,transcr++ )
		{
			*transcr = interpol_tab[((*transcr)<<8)+colr];
		}
	}
}

/*********************************/

uchar	nightPalette[768];
uchar	normalPalette[768];
int		nightSightOn=FALSE;


void	make_night_palette(void)		/** MAKES THE NIGHTSIGHT PALETTE */
{
	uint	r,g,b, brgtval;
	uint	i;

	memcpy(normalPalette,palette,768);

	for ( i=0; i<256; i++ )
	{
		r=palette[i*3];
		g=palette[i*3+1];
		b=palette[i*3+2];

		brgtval = (r+g+b)/3;

		palette[i*3] >>=	4;
		palette[i*3+1] =	(brgtval&63);
		palette[i*3+2] >>=	4;
	}

	memcpy(nightPalette,palette,768);
	memcpy(palette, normalPalette, 768);
}

/*********************************/

void	get_nightsight_palette(void) /** TURNS NIGHT SIGHT PALETTE ON */
{
	if ( nightSightOn )
	{
		return ;
	}
	nightSightOn = TRUE;
	memcpy(palette, nightPalette, 768);
	fade_to_pal(4,palette);
}

/*********************************/

void	restore_normal_palette(void)
{
	if ( !nightSightOn )
	{
		return ;
	}

	nightSightOn = FALSE;
	memcpy(palette, normalPalette, 768);
	fade_to_pal(4,palette);
}

/*********************************/

#define COLOUR_GRADIENT		238


void	draw_slider(int x, int y, int volume, int highlight, int sliderShape)
{
	int i, j, colr;

	if ( sliderShape==TRIANGLE_SLIDER )
	{	// triangular slider
		for ( i=0; i<64; i++ )
		{
			if ( (i<=volume) || i==63 )
			{
				for ( j=0; j <= (i>>3); j++ )
				{
					if ( highlight )
					{
						colr=255;
					}
					else
						colr = COLOUR_GRADIENT-j;
					scr_ptr[x+i+ ((y+8-j)*320)] = colr;
				}
			}
			else
			{
				if ( highlight )
				{
					scr_ptr[x+i+ ((y+8)*320)] = 255;
					scr_ptr[x+i+ (((y+8-(i>>3)))*320)] = 255;
				}
				else
				{
					scr_ptr[x+i+ ((y+8)*320)] = 238;
					scr_ptr[x+i+ (((y+8-(i>>3)))*320)] = COLOUR_GRADIENT-(i>>3);
				}
			}
		}
	}
	else
	{	// rectangular slider box
		for ( i=0; i<64; i++ )
		{
			if ( (i<=volume) || i==63 )
			{
				for ( j=0; j <= 8; j++ )
				{
					if ( highlight )
					{
						colr=255;
					}
					else
						colr = COLOUR_GRADIENT-j;
					scr_ptr[x+i+ ((y+8-j)*320)] = colr;
				}
			}
			else
			{
				if ( highlight )
				{
					scr_ptr[x+i+ ((y+8)*320)] = 255;
					scr_ptr[x+i+ (y*320)] = 255;
				}
				else
				{
					scr_ptr[x+i+ ((y+8)*320)] = 238;
					scr_ptr[x+i+ (y*320)] = COLOUR_GRADIENT-(i>>3);
				}
			}
		}
	}
}

/***********************************************************/

void	redraw_cockpit(void)
{
//	dump_pal(palette, 0, 256);

	memset((char*)VIDEO_START_ADRESS, 0, 320*200);	/* Clear video page */
	memset(p1screen,1,320*200);					/* Clear screen in memory */

	UnpackM2(cmprPanelTop, (char*)VIDEO_START_ADRESS);
	UnpackM2(cmprPanelBottom, (char*)(VIDEO_START_ADRESS + 127*320));

	draw_armour_display();
	draw_weapon_display(pl.cWeapon);

	dump_pal(palette, 0, 256);

	drawCockpit = FALSE;
}

/***********************************************************/

void	redraw_mapscreen(void)
{
	scr_ptr = p1screen;

	sprite_y_clip = 199;

	UnpackM2(cmprTacmap, (char*)VIDEO_START_ADRESS);

	drawMapScreen = FALSE;

	dump_pal(tacpal, 0, 256);

	/** Reset the targeting info */
	memset(tp, 0, sizeof(struct target_points)*128);
	targ.locked = FALSE;
	targ.x = targ.dest_x = 160;
	targ.y = targ.dest_y = 64;
}

/*************************************************************************/

void	flash_palette(void)
{
	int	i;

	if ( flashValue )
	{
		switch ( flashValue )
		{
			case VBRIGHT_FLASH:

				if ( mapmode )
				{
					for ( i=0; i<768; i++ )
					{
						flashpal[i]=tacpal[i]+32;
						if ( flashpal[i]>63 )
						{
							flashpal[i]=63;
						}
					}
				}
				else
				{
					for ( i=0; i<768; i++ )
					{
						flashpal[i]=palette[i]+32;
						if ( flashpal[i]>63 )
						{
							flashpal[i]=63;
						}
					}
				}

				dump_pal(flashpal, 0, 256);
				break;

			case BRIGHT_FLASH:
				if ( mapmode )
				{
					for ( i=0; i<768; i++ )
					{
						flashpal[i]=tacpal[i]+16;
						if ( flashpal[i]>63 )
						{
							flashpal[i]=63;
						}
					}
				}
				else
				{
					for ( i=0; i<768; i++ )
					{
						flashpal[i]=palette[i]+16;
						if ( flashpal[i]>63 )
						{
							flashpal[i]=63;
						}
					}
				}

				dump_pal(flashpal, 0, 256);
				break;


			case RETURN_2_NORMAL:
				if ( mapmode )
				{
					dump_pal(tacpal, 0, 256);
				}
				else
					dump_pal(palette, 0, 256);
				break;
		}

		flashValue--;
	}
}

/*************************************************************************/

#define CONE_ORIGIN_X		160
#define CONE_ORIGIN_Y		28
#define CONE_COLOUR			179

void draw_view_cone(void)
{
	short	conePoints[] = { 4,
													0, 0, 	// centre of cone
													-16,-24, // left top of cone
													0, -28,
													16,-24,		// right top of cone
													CONE_COLOUR				// colour of cone
	};

	int	n;
	int	rx, rz;
	int	plcos, plsine;
	short *tranConePoints;
	int	camangle;

	camangle = turret_angle;
	camangle &= 0X7FF;

	plcos = (int)sintab[camangle+512];
	plsine = (int)sintab[camangle];

	tranConePoints = conePoints + 3;

	// rotate the triangle

	for ( n=0; n<3; n++ )
	{
		rx=(tranConePoints[n<<1]*plcos + tranConePoints[(n<<1)+1]*plsine)>>15;
		rz=(tranConePoints[(n<<1)+1]*plcos - tranConePoints[n<<1]*plsine)>>15;

		tranConePoints[n<<1] = rx + CONE_ORIGIN_X;
		tranConePoints[(n<<1)+1] = rz + CONE_ORIGIN_Y;
	}

	conePoints[1] = CONE_ORIGIN_X;
	conePoints[2] = CONE_ORIGIN_Y;

	draw_poly_flat(conePoints);
}

/*************************************************************************/

#define 	phd_winwidth		320
#define 	phd_winheight		200

int		xgen_ymin, xgen_ymax;

typedef struct phd_xbuf {
	int	Xleft;
	int Xright;
} PHD_XBUF;

PHD_XBUF	xbuffer[200];


short	* xgen_x( short *iptr );

/****************************************************************************
 *				Draw Flat Shaded Polygon..
 ***************************************************************************/
void	_flat_wank( int, int, char );

void	draw_poly_flat( short *iptr )
{
	if ( (iptr = xgen_x(iptr)) )
		_flat_wank( xgen_ymin, xgen_ymax, (char)*(iptr) );
}

/****************************************************************************/

short	* xgen_x( short *iptr )
{
	int     	fcoords[16][2];			/* coords in clockwise order .....*/
	int			*lptr,*rptr;
	PHD_XBUF	*xptr;
	int			min_x,min_y;
	int			max_x,max_y;
	int			xadd,ydif;
	int			i,x1,y1,y2;
	int			numcoords;

	numcoords = (int)*(iptr++);						   /* Get Number Coords*/
	min_x = max_x = fcoords[numcoords][0] = fcoords[0][0] = (int)*(iptr);
	min_y = max_y = fcoords[numcoords][1] = fcoords[0][1] = (int)*(iptr+1);
	rptr = fcoords;
	iptr += 2;
	for ( i=1; i<numcoords; i++,iptr+=2 ) 	   		   /* find min,max X and Y*/
	{
		x1 = fcoords[i+numcoords][0] = fcoords[i][0] = (int)*(iptr);
		y1 = fcoords[i+numcoords][1] = fcoords[i][1] = (int)*(iptr+1);
		if ( x1<min_x )
			min_x = x1;
		else if ( x1>max_x )
			max_x = x1;
		if ( y1<min_y )
		{
			min_y = y1;
			rptr = &fcoords[i][0];
		}
		else if ( y1>max_y )
			max_y = y1;
	}
	if ( max_x<0 || max_y<0 || min_y==max_y || min_x>=phd_winwidth || min_y>=phd_winheight )
		return( NULL );

	if ( min_y<0 )
		min_y=0;
	if ( max_y>phd_winheight )
		max_y=phd_winheight;
	xgen_ymin = min_y;				// Insert Global Y bounds..
	xgen_ymax = max_y;


	lptr = rptr + (numcoords*2);

	xptr = xbuffer;
	for ( ;; lptr-=2 )  			/* for Left Hand Side.. */
	{
		y1 = *(lptr+1);       		/* get top y... */
		if ( y1>=max_y )
			break;
		y2 = *(lptr-1);     		/* get next y dowm */
		ydif = y2-y1;               /* calc y difference */

		if ( ydif>0 && y2>=0 ) 		/* if difference in Y */
		{
			x1 = *(lptr);							/* get top x... */
			xadd = ((*(lptr-2)-x1)<<16)/ydif;       /* Get Xadder */
			x1 = (x1<<16) + 0x00001;
			if ( y1<0 )
			{
				x1 -= y1*xadd;
				y1 = 0;
			}
			if ( y2>phd_winheight )
				y2 = phd_winheight;

  			for ( ; y1<y2; y1++,xptr++)
			{
   				x1 += xadd;
				xptr->Xleft = x1;
	   		}
  		}
	}

	xptr = xbuffer;
	for ( ;; rptr+=2 )  			/* for Right Hand Side... */
	{
		y1 = *(rptr+1);       		/* get top y... */
		if ( y1>=max_y )
			break;
		y2 = *(rptr+3);     		/* get next y dowm */
		ydif = y2-y1;               /* calc y difference */

		if ( ydif>0 && y2>=0 ) 		/* if difference in Y */
		{
			x1 = *(rptr);							/* get top x... */
			xadd = ((*(rptr+2)-x1)<<16)/ydif;
			x1 = (x1<<16) + 0x0ffff;

			if ( y1<0 )
			{
				x1 -= y1*xadd;
				y1 = 0;
			}
			if ( y2>phd_winheight )
				y2 = phd_winheight;

  			for ( ; y1<y2; y1++,xptr++)
			{
   				x1 += xadd;
				xptr->Xright = x1;
	   		}
  		}
	}
	return( iptr );
}

/***********************************************************/

/*-----------------14/11/95 10:15-------------------
 wad functions
--------------------------------------------------*/

#define MAX_NAME_LENGTH				48

typedef	struct header_info
{
	uint	size;
	uint	offset;
	char	filename[MAX_NAME_LENGTH];
}HEADER_INFO;

uint	numWadFiles = 0;
uint	wadTotalSize = 0;
HEADER_INFO	*wadHeaderBlock, *currentHeaderItem;
uint	currentHeaderItemNumber=0;

uchar	*wadd_pointer;
uchar	*wadd_data;
FILE	*wadFile=NULL;

/*********************************************************/

uchar	*open_wad_file(char *wadFilename)
{
	if ( wadFile!=NULL )
	{
		debug_msg("Can't have multiple wad files!\n");
		getout("No");
	}

	debug_msg("Opening WAD file %s\n",wadFilename);

	if ( waddStatus==load_wadds )
	{
		wadFile = fopen(wadFilename, "rb");

		if ( wadFile == NULL )
		{
			debug_msg("Error - Wad file '%s' not found\n", wadFilename);
			getout("Uh oh. Couldn't find wad.");
		}

		fread(&numWadFiles, 1, sizeof(uint), wadFile);		// get the number of files in the wad
		fread(&wadTotalSize, 1, sizeof(uint), wadFile);		// get the total size of wad data

		debug_msg("Wad header loaded.\n");

		currentHeaderItemNumber=0;

		// use the screen buffer as temp work space for the header info
		currentHeaderItem = wadHeaderBlock = (HEADER_INFO*)p1screen;

		// get the header info into workspace
		fread(wadHeaderBlock, sizeof(HEADER_INFO), numWadFiles, wadFile);

		debug_msg("Wad internal directory loaded.\n");

		// allocate room for wadd
		wadd_pointer = get_mem((wadTotalSize+8));
		debug_msg("Wad data allocated successfully.\n");

		if ( wadd_pointer==NULL )
		{
			debug_msg("Error - couldn't allocate memory for wad file:\n");
			debug_msg("Wad size = %d\n",wadTotalSize+8);
			getout("Oh dear - not enough memory.");
		}

		memset(wadd_pointer, 0XFE, (wadTotalSize+8));
		debug_msg("Wadd memory cleared out.\n");

		wadd_data = wadd_pointer;

		// allign the wadd on a long word boundary
		while( ((uint)wadd_data&3) )
			wadd_data++;

		debug_msg("Wadd pointer alligned.\n");

		// read in wadd data
		fread(wadd_data, sizeof(char), wadTotalSize, wadFile);
		debug_msg("Wadd data loaded successfully.\n");


		// check that the wad didn't write beyond its allocated space
		if ( *(wadd_data+wadTotalSize)!=0XFE )
		{
			debug_msg("The wad fucked up.\n");
			getout("Wad file corrupted.");
		}

		debug_msg("The wad loaded successfully.\n");
		return (wadd_pointer);
	}
	else
	if ( waddStatus==build_wadds )
	{
		wadFile = fopen(wadFilename, "w");
	}
	return (NULL);
}

/*********************************************************/

void* load_wad_file(char *filename, void *buffer)
{
	void	*retval;

	if ( waddStatus==load_wadds )
	{
		/** first check if the current header item is the one required **/

		if ( strcmp(currentHeaderItem->filename, filename)==0 )
		{
			debug_msg("wad component file %s (offset:%d) (size:%d) loaded\n", filename, currentHeaderItem->offset, currentHeaderItem->size);

			retval = wadd_data + currentHeaderItem->offset;
			currentHeaderItem++;
			currentHeaderItemNumber++;

			return (retval);
		}
		else
		{
			/** scan through the header from the beginning **/
			debug_msg("Wadd component file (%s) not found in incremental load\n", filename);
			getout("Wad element not found.");
		}
	}
	else
	if ( waddStatus==build_wadds )
	{
		fprintf(wadFile,"%s\n",filename);
		return (load_file(filename, buffer));
	}
	else
		return (load_file(filename, buffer));
}

/*********************************************************/

void	close_wad_file(void)
{
	if ( waddStatus!=no_wadds )
	{
		fclose(wadFile);
	}

	wadFile = NULL;
}
