#include "headers.h"

#include "shock.h"
#include "chuck.h"
#include "walldraw.h"
#include "e_global.h"

#ifdef MEMCHK
#include <memcheck.h>
#endif


void	apply_wallpoint_perspective(WORKING_POINT *cwpt);
int		rotate_wall_point(WORKING_POINT *cwpt, POINT_DATA *wpt);





extern int			depthCueTrigger;
extern int 			currentWallHeight;
;


/**********************************************************************************
 *				Draw Wall Thingy With Optional Perspective
 *
 *********************************************************************************/

#define SYMETRICAL_TRANSPARENT_WALL	2
#define	ANIMATING_WALL							4

#define	MIN_PERSPECTIVE		8					/* Minimum width at which perspective horizontal scaling is used */

#define WINDOWYMIN				0
#define	TEXTURE_SIZE			0x400000	/* texture size of 64x64 (64 << 16) */
#define	TEXTURE_WIDTH			0X40


#define WALL_DATA_SIZE		3					/* 0=p1 index, 1=p2 index, 3=wall type */
#define WORKPOINT_ELEMENT_SIZE 6
#define WALL_POINT_SIZE		2         /* 0=x, 1=y */





#define	WALL_UNIT_HEIGHT	-128			/* Y Scaling factor for smallest texture */


#define swap(a,b)	{ swapVar=a;\
										a=b;\
										b=swapVar;}

#define swapPoint(a,b) { swapPt=a;\
										a=b;\
										b=swapPt;}

ushort	swapVar;
void 	*swapPt;


int		windowxmax=319;
int   windowymax=GSCRYHT;



int		depthCueTrigger=HORIZON_Y_POS-8;			/* Level below the horizon when walls are depth cued */
WALLDRAW_DATA	polybuff[320];								/* The buffer used for the wall draw */






/*-----------------21/03/95 11:25-------------------
 General Variables used in this module
--------------------------------------------------*/
static	int 		xScale,sx,n;
static	int			cScale;	   									/* Scaling factor for each vertical collumn */
static	int			cyt,yAddt,cyb,yAddb;				/* Used to work out top and bottom of walls */
static	int 		deltaX;			 								/* difference in x (width) */
static	int			ttop,tbot,strtScale; 				/* Actual top and bottom positions of wall collumn after clipping */
static	int 		ctop,cbot;									/* Gradient of top intersection line */
static	int			vpx,dv,dadd,dvn;						/* Vanishing point x */
static	int			Mp,Cp;
static	int			perScale;										/* Flag indicating use of perspective horizontal scaling */
static	WALLDRAW_DATA			*cbuffptr;


static	int	txtrstrt;
static	int	txtrend;


int			currentWallHeight;



/*-----------------21/03/95 14:34-------------------
 Prototypes of functions used in this module
--------------------------------------------------*/

short*	transform_point(short ptindex);









void	draw_wall( int x1, int x2,		// X1 and X2
				   int y1t, int y1b,				// y1 top/bottom
				   int y2t, int y2b,        // y2 top/bottom
				   char *txtptr,					 	// pointer to texture
				   uint wallType,						// Solid=0, ragged=1, transparent=2, animated=3
					 int	txtw, int txtoff, 	// actual width of texture to be drawn, offset (in x) into texture (due to clipping against viewplane)
					 int	flip )

{
	perScale = 1;

	deltaX = x2-x1+1; 			   				// Xdif+1
	cyt = (y1t<<16) + 0x8000;					// Fractional y pos for top of wall
	cyb = (y1b<<16) + 0x8000;					// Fractional y pos for Bottom of wall
	yAddt = ((y2t-y1t)<<16)/deltaX;		// make sure ydif is
	yAddb = ((y2b-y1b)<<16)/deltaX;

	xScale = ((txtw-1)<<16)/deltaX;				// Normal linear horizontal step
 	if( deltaX < MIN_PERSPECTIVE )
		perScale=0;											// Use Linear scaling



	/*-----------------13/01/95 11:53-------------------
	 Horizontal perspective scaling calculations
	--------------------------------------------------*/

	if ( perScale )
	{																	// is perspective shite on...
		if( yAddt==yAddb ) 							// if gradients same then
			perScale=0;										// Use linear scaling.
		else
		{
			ctop = cyt - yAddt*x1;
			cbot = cyb - yAddb*x1;
			vpx=(cbot-ctop)/(yAddt-yAddb);// Vanishing point x;

			if ( vpx>x1 )
			{
				dv = vpx-x1;                // distance to vanishing point
				dvn = vpx-x2;               // nearer distance to v.point
				dadd = -1;                  // vanishing point to right

				txtrstrt = txtw-1;
				txtrend = 0;

			}
			else
			{
				dv = x1-vpx;
				dvn = x2-vpx;
				dadd = 1;   								// vanishing point to left

				txtrstrt = TEXTURE_WIDTH-1;
				txtrend = txtrstrt-txtw+1;
			}


			if ( flip )
			{
				Mp=((txtw-1)*dv*dvn)/(dvn-dv);
				Cp=(txtrend)-(Mp/dvn);
				if( ( (Mp/dvn+Cp) !=(txtrend)) || ( (Mp/dv+Cp) !=(txtrstrt)) )
					perScale=0;

			}
			else
			{
				Mp=((txtw-1)*dv*dvn)/(dvn-dv);
				Cp=(txtw-1)-(Mp/dv);
				if( ( (Mp/dvn+Cp) !=0) || ( (Mp/dv+Cp) !=(txtw-1)) )
					perScale=0;

			}
		}
	}                                	// End Perspective shite


/* Clip to left and right of windows */


	if ( x1>=0 )
	{         												// clip to left hand edge
		if ( flip )
		{
			sx = (txtw-1)<<16;
		}
		else
		{
			sx = 0;
		}
	}
	else
	{
		cyt -= yAddt * x1;             	// modify top and bottom coords
		cyb -= yAddb * x1;

		if ( flip )
			sx = ((txtw-1)<<16) + (xScale * x1);
		else
			sx = -(xScale * x1);    // modify texture X pos

		dv -= dadd * x1;
		x1 = 0;                         // make Xleft=0
	}



	if ( x2>windowxmax ) 							// clip to right hand side of
		x2=windowxmax;                	// window



	deltaX = x2-x1;


	cbuffptr = &polybuff[0];

	for ( n=0; n<=deltaX; n++,dv+=dadd, cbuffptr++)
	{
		tbot = (cyb>>16);
 		ttop = (cyt>>16);								// get the Y values...

 		cScale = TEXTURE_SIZE/(tbot-ttop);// Vertical scaling for current collumn

		strtScale=0;
		if( ttop<0 )
		{																// Clip top edge
			strtScale = -cScale*ttop; 		// Make note of start of source data in collumn if clipped
			ttop = 0;
		}

		if( tbot>windowymax )						// Clip bottom edge
			tbot = windowymax;						// make bottom End of Screen

		if ( tbot<WINDOWYMIN )
			ttop = WINDOWYMIN;						// if both off top make height neg.
		if ( ttop>windowymax ) 					// if both off bottom make height neg.
			tbot = 0;


		if ( perScale )
		{               								// Find Column using perspective
			if ( flip )
			{
				sx = (Mp/dv+Cp);
			}
			else
			{
				sx = (txtw-1)-(Mp/dv+Cp)+txtoff;
			}

			cbuffptr->x_txt = (sx<<6) + (int)(txtptr);
		}
		else
		{                          			// Find Column without perspective
			cbuffptr->x_txt = ((sx>>16)<<6) + (int)(txtptr);

			if ( flip )
			{
				sx -= xScale;
			}
			else
			{
				sx += xScale;
			}
		}


		cbuffptr->y_txt_add = cScale;
		cbuffptr->y_screen	= ttop;
		cbuffptr->height		=	(tbot-ttop)-1;
		cbuffptr->y_txt			=	strtScale;

		cyt += yAddt;
		cyb += yAddb;
	}

	switch ( wallType )
	{
		case 1:
			_dump_ragged_wall_buffer( x1, deltaX, &polybuff[0] );// now output the wall
			break;

	 	case 2:															// now output the wall
			_dump_transparent_wall_buffer( x1, deltaX, &polybuff[0] );
			break;

	 	case 3:															// now output the wall
			_dump_transparent_wall_buffer( x1, deltaX, &polybuff[0] );
			break;

		case 4:

		default:														// now output the wall
			_dump_wall_buffer( x1, deltaX, &polybuff[0] );
	}
}



/*********************************************************************************/



void	draw_wall_dc( int x1, int x2,		// X1 and X2
				   int y1t, int y1b,				// y1 top/bottom
				   int y2t, int y2b,        // y2 top/bottom
				   char *txtptr,					 	// pointer to texture
				   int wallType, 						// Solid=0, ragged=1, transparent=2, animated=3
					 int flip )

{
	int	dqval;


	perScale = 1;

	deltaX = x2-x1+1; 			   				// Xdif+1
	cyt = (y1t<<16) + 0x8000;					// Fractional y pos for top of wall
	cyb = (y1b<<16) + 0x8000;					// Fractional y pos for Bottom of wall
	yAddt = ((y2t-y1t)<<16)/deltaX;		// make sure ydif is
	yAddb = ((y2b-y1b)<<16)/deltaX;

	xScale = ((TEXTURE_WIDTH-1)<<16)/deltaX;				// Normal linear horizontal step
 	if( deltaX < MIN_PERSPECTIVE )
		perScale=0;											// Use Linear scaling


	/*-----------------13/01/95 11:53-------------------
	 Horizontal perspective scaling calculations
	--------------------------------------------------*/

	if ( perScale )
	{																	// is perspective shite on...
		if( yAddt==yAddb ) 							// if gradients same then
			perScale=0;										// Use linear scaling.
		else
		{
			ctop = cyt - yAddt*x1;
			cbot = cyb - yAddb*x1;
			vpx=(cbot-ctop)/(yAddt-yAddb);// Vanishing point x;

			txtrstrt = TEXTURE_WIDTH-1;
			txtrend = 0;


			if ( vpx>x1 )
			{
				dv = vpx-x1;                // distance to vanishing point
				dvn = vpx-x2;               // nearer distance to v.point
				dadd = -1;                  // vanishing point to right


			}
			else
			{
				dv = x1-vpx;
				dvn = x2-vpx;
				dadd = 1;                   // vanishing point to left
			}

			Mp=((txtrstrt)*dv*dvn)/(dvn-dv);
			Cp=(txtrend)-(Mp/dvn);
			if( ( (Mp/dvn+Cp) !=(txtrend)) || ( (Mp/dv+Cp) !=(txtrstrt)) )
				perScale=0;

		}
	}                                	// End Perspective shite


	if ( x1>=0 )
	{         												// clip to left hand edge
		if ( flip )
		{
			sx = (TEXTURE_WIDTH-1)<<16;
		}
		else
			sx = 0;
	}
	else
	{
		cyt -= yAddt * x1;             	// modify top and bottom coords
		cyb -= yAddb * x1;

		if ( flip )
			sx = ((TEXTURE_WIDTH-1)<<16) + (xScale * x1);
		else
			sx = -(xScale * x1);    // modify texture X pos

		dv -= dadd * x1;
		x1 = 0;                         // make Xleft=0
	}

	if ( x2>windowxmax ) 							// clip to right hand side of
		x2=windowxmax;                	// window

	deltaX = x2-x1;


	cbuffptr = &polybuff[0];

	for ( n=0; n<=deltaX; n++,dv+=dadd, cbuffptr++)
	{
		tbot = (cyb>>16);
 		ttop = (cyt>>16);								// get the Y values...

		cScale = TEXTURE_SIZE/(tbot-ttop+1);// Vertical scalling for current collumn

		strtScale=0;
		if( ttop<0 )
		{																// Clip top edge
			strtScale = -cScale*ttop; 		// Make note of start of source data in collumn if clipped
			ttop = 0;
		}

		if( tbot>windowymax )						// Clip bottom edge
			tbot = windowymax;						// make bottom End of Screen

		if ( tbot<WINDOWYMIN )
			ttop = WINDOWYMIN;						// if both off top make height neg.
		if ( ttop>windowymax ) 					// if both off bottom make height neg.
			tbot = 0;

		if ( perScale )
		{               								// Find Column using perspective
			if ( flip )
			{
				sx = (Mp/dv+Cp);
			}
			else
			{
				sx = (TEXTURE_WIDTH-1)-(Mp/dv+Cp);
			}

			cbuffptr->x_txt = (sx<<6) + (int)(txtptr);
		}
		else
		{                          			// Find Column without perspective
			cbuffptr->x_txt = ((sx>>16)<<6) + (int)(txtptr);

			if ( flip )
			{
				sx -= xScale;
			}
			else
				sx += xScale;
		}


		cbuffptr->y_txt_add = cScale;
		cbuffptr->y_screen	= ttop;
		cbuffptr->height		=	(tbot-ttop)-1;
		cbuffptr->y_txt			=	strtScale;


		if ( tbot<depthCueTrigger )				 // Need to depth cue
		{
			dqval = depthCueTrigger-tbot;

			if ( dqval>7 )
			{
				dqval=7;
			}

			cbuffptr->dc_table = (dqval)<<8;
		}
		else
			cbuffptr->dc_table = -1;


		cyt += yAddt;
		cyb += yAddb;
	}

	switch ( wallType )
	{
		case 1:
			_dump_ragged_wall_buffer_dc( x1, deltaX, &polybuff[0] );// now output the wall
			break;

	 	case 2:															// now output the wall
			_dump_transparent_wall_buffer_dc( x1, deltaX, &polybuff[0] );
			break;

	 	case 3:															// now output the wall
			_dump_transparent_wall_buffer_dc( x1, deltaX, &polybuff[0] );
			break;

		default:														// now output the wall
			_dump_wall_buffer_dc( x1, deltaX, &polybuff[0] );
	}
}



/************************************************************************/



void	draw_the_fucking_wall(int wallindex)
{
	WORKING_POINT		*wpt1, *wpt2, *cwpt;
	WALL_DATA	*wall2draw;
	int	swapCount;
	char		*pointCheck;
	POINT_DATA		*wpt;
	int			dex,dez,zc;
	int			t1, txtw, txtoff, otxtw;
	char		*drawTexture;
	unsigned int			wallType;
	unsigned int			textureNumber;
	int			flipval;
	short		noClip1,noClip2;
	short		canDraw;
	short 	fpt;



	/* Point to the specified wall data */
	wall2draw=&(wallSfcs[wallindex]);

	if ( wall2draw->wallType == TOTALLED_TEXTURE )
		return;

	currentWallHeight=WALL_UNIT_HEIGHT * ( ( (wall2draw->wallType >>9)&0xf )+1);
	flipval = ( wall2draw->wallType >>13 )&1;


	wallType=wall2draw->wallType &0x7;

	otxtw = txtw = TEXTURE_WIDTH;
	txtoff = canDraw=0;

	/* Find out if the first point has already been transformed */
	pointCheck=workPointsCheck + wall2draw->p1;

	/* If it hasn't then transform it */
	if ( *pointCheck != currentCheckVal)
	{
		cwpt=workPoints + wall2draw->p1;
		wpt=wallPoints + wall2draw->p1;

		if(noClip1=_rotate_point(cwpt, wpt))
		{
			*pointCheck=currentCheckVal;
			_apply_perspective(cwpt);
		}
		wpt1=cwpt;
	}
	else
	{
		wpt1=workPoints + wall2draw->p1;
		noClip1=TRUE;
	}

	/* Find out if the second point has already been transform */
	pointCheck=workPointsCheck + wall2draw->p2;

	if ( *pointCheck != currentCheckVal)
	{
		cwpt=workPoints + wall2draw->p2;
		wpt=wallPoints + wall2draw->p2;

		if(noClip2=_rotate_point(cwpt, wpt))
		{
			*pointCheck=currentCheckVal;
			_apply_perspective(cwpt);
		}
		wpt2=cwpt;
	}
	else
	{
		wpt2=workPoints + wall2draw->p2;
		noClip2=TRUE;
	}


	swapCount=0;

	if( wallType==SYMETRICAL_TRANSPARENT_WALL)
	{
		if(wpt1->x > wpt2->x )
		{
			swapPoint(wpt1,wpt2)
			swap(noClip1, noClip2);
			swapCount++;
		}
	}

	switch ( noClip1 + noClip2 )
	{
		case 0:               /* Both points behind clip plane, can't see it */
			canDraw=FALSE;
			break;


		case 1:								/* One of the points infront of the clip plane */
			if ( noClip1 ) 			/* Point 2 is behind the clip point */
			{
				dex				=		wpt2->x - wpt1->x;
				dez				=		wpt1->z_depth - wpt2->z_depth;
				zc				=		wpt1->z_depth - Z_CLIP_DEPTH;
				wpt2->x		= 	(short)(wpt1->x + ( (zc*dex)/dez ) );		/* Clipped x */
				wpt2->z		=   Z_CLIP_DEPTH ;

				t1 = (zc<<16)/dez;
				txtw = (TEXTURE_WIDTH*t1)>>16;

				_apply_perspective(wpt2);

				if ( (wpt1->scrn_x > wpt2->scrn_x ) )
				{
					txtoff = otxtw - txtw;
				}

				canDraw=TRUE;
			}
			else
			{										/* Point 1 behind clip point */
				dex				=		wpt1->x - wpt2->x;
				dez				=		wpt2->z_depth - wpt1->z_depth;
				zc				=		wpt2->z_depth - Z_CLIP_DEPTH;
				wpt1->x		= 	(short)(wpt2->x + ( (zc*dex)/dez ) );	/* Clipped x */
				wpt1->z 	= 	Z_CLIP_DEPTH ;//+ 512;								/* clipped z */

				t1 = (zc<<16)/dez;								// ratio of original texture length to new clipped texture length

				txtw = (TEXTURE_WIDTH*t1)>>16;

				txtoff = otxtw - txtw;

				_apply_perspective(wpt1);

				if ( wpt1->scrn_x > wpt2->scrn_x )
				{
					txtoff=0;
				}

				canDraw=TRUE;
			}
			break;


		case 2:          			/* Both points infront of the clip plane */
			canDraw=TRUE;
			break;
	}

	if( wallType==SYMETRICAL_TRANSPARENT_WALL)
	{
		if(wpt1->scrn_x > wpt2->scrn_x )
		{
			swapPoint(wpt1,wpt2)
		}
	}

	if ( canDraw )
	{
		if ( (wpt2->scrn_x<0 || wpt1->scrn_x>windowxmax) || (wpt1->scrn_x > wpt2->scrn_x) )
		{
			return ;
		}

		fpt = (wpt1->z_depth >= wpt2->z_depth) ? wpt1->floor_y : wpt2->floor_y;	// Get the further of the two points

		textureNumber = (wall2draw->wallType >>3)&63;

		if ( wallType==ANIMATING_WALL )
		{
			drawTexture = (uchar*)(wallTextures + txmtrans[(wallType<<6) + textureNumber ] + ( animating_txtr_data[textureNumber].currFrame <<12) );
		}
		else
		{
			drawTexture = (uchar*)(wallTextures + txmtrans[(wallType<<6) + textureNumber]);
		}

		if(fpt<depthCueTrigger)
			draw_wall_dc
							 (wpt1->scrn_x, wpt2->scrn_x,
								wpt1->top_y, 	wpt1->floor_y,
								wpt2->top_y,	wpt2->floor_y,
								drawTexture, 	/* 2^12=4096=size of texture map */
								wallType, flipval);
		else
			draw_wall(wpt1->scrn_x, wpt2->scrn_x,
								wpt1->top_y, 	wpt1->floor_y,
								wpt2->top_y, 	wpt2->floor_y,
								drawTexture,
								wallType,
								txtw, txtoff, flipval );
	}
}



/************************************************************************/



void	animate_wall_textures(void)
{
	int n;
	ANIM_TXTR_DATA *currAnimTxtr;

	for ( n=0; n<numAnims; n++ )
	{
		currAnimTxtr=&(animating_txtr_data[n]);

		currAnimTxtr->frmCnt++;
		if(currAnimTxtr->frmCnt>currAnimTxtr->frmRate)
		{
			currAnimTxtr->frmCnt=0;
			currAnimTxtr->currFrame++;
			if(currAnimTxtr->currFrame>=numAnimFrames[n])
				currAnimTxtr->currFrame=0;
		}
	}
}



/************************************************************************/


void	reset_point_check_list(void)
{
	_fast_memset(workPointsCheck+currentResetIndex, currentCheckVal, POINT_RESET_BLOCK_SIZE);
	//memset(workPointsCheck+currentResetIndex, currentCheckVal, POINT_RESET_BLOCK_SIZE);
	currentCheckVal++;
	if(!currentCheckVal) currentCheckVal++;				/* Never have a check value of zero */

	currentResetIndex+=POINT_RESET_BLOCK_SIZE;
	if(currentResetIndex>=numPoints) currentResetIndex=0;
}








