#include <sys/types.h>
#include <fcntl.h>
#include <stdio.h>
#include <io.h>
#include <dos.h>
#include <math.h>

/*


 Del's handy "screen-fill fader" converted from the Amiga original

 Basic screen filler (solid in & out) working at 14:00pm 29/06/94.


 Inserted all the loader + pic & palette crap at 15:15pm (harsh!)
 updated old routines to use a picture instead of just a single colour
 and everything is so funky...!

 DELS HANDY FADER THING WORKS! 10:20am 30/06/94!!
 I WONDER WHAT IT IS LIKE ON OTHER PC'S?????????

 Sorted RGB to HSV colour values...! (30-06-94 - 15:16pm)

 Completed my roundme(); function...!

 SORTED!!!

 RGB TO HSV
 HSV TO RGB

 Code looks a bit more sorted at 10:20am 4th July 1994.
 Code IS sorted! (11:08am 4th July 1994)!!!!!

*/

void		main(void);
void		set_mode(int num);
int			getmode(void);
void		set_palette(char *palptr, int firstreg, int numcols);
void		fill_screen(char val);
void		super_trip(void);
void		pic_trip(char *picbuf);
void		draw_circle(int xc, int yc, int radius,int col);
void		plot_circle_points(int x, int y, int xc, int yc,int col);
void		setpixel(int x, int y, int col);
void		draw_circle_pic(int xc, int yc, int radius,char *picbuf);
void		plot_circle_points_pic(int x, int y, int xc, int yc,char *picbuf);
void		setpixel_pic(int x, int y,char *picbuf);
long int		find_length(char filename[]);
void		save_file(char filename[], char address[], int size);
void		load_file(char filename[], char address[], int size);
char *		allocate_ram( int size );
void		clearbuf(char *address, int size);


void		fademe(char *picbuf, char *palbuf, char *fadebuf);
void		calcfade(char *palbuf, char *fadebuf, int fadeval);

void		convert_palette_to_hsv(char *palbuf, float *hsvbuf, int numcols);
void		convert_rgb_to_hsv(int red, int green, int blue, float *hsvpal);
void		make_palette_from_hsv(float *hsvbuf, char *palbuf, int numcols);
void		convert_hsv_to_rgb(float h, float s, float v, char *palbuf);
void		print_palette(char *palbuf1, float *hsvbuf, char *palbuf2, int numcols);


int			sortcol(int val);
int			unsortcol(int val);
int			roundme(float num);
float		max(float v1, float v2, float v3);
float		min(float v1, float v2, float v3);


#define	 	S_AREA 0xa000				/* Screen address */
#define	 	SCREEN_LIN_ADDR ((S_AREA) << 4)
#define	 	SCREEN_SIZE (320*200)


/****************/
/* THIS IS MAIN */
/****************/

void		main(void)
{

char		*rawbuf;					/* picture buffer */
char		*palbuf1;					/* original palette buffer */
char		*palbuf2;					/* hsv to rgb buffer */
char		*fadebuf;					/* faded palette buffer! */

float		*hsvbuf;

char		picname[]="RAW\\WANK.RAW";
char		palname[]="RAW\\WANK.PAL";
char		picname2[]="RAW\\PUEBLO.RAW";
char		palname2[]="RAW\\PUEBLO.PAL";

int			modestash;
int			i;


	modestash = getmode();				/* stash DOS screen mode */
	rawbuf = allocate_ram(320*200);		/* allocate buffer for picture */
	palbuf1 = allocate_ram(768);			/* allocate buffer for palette */
	palbuf2 = allocate_ram(768);			/* allocate buffer for palette */
	fadebuf = allocate_ram(768);			/* allocate buffer for palette */
	hsvbuf = (float *)allocate_ram( 768*(sizeof(float)) );	/* allocate 768*float */


	load_file(picname, rawbuf, 320*200);	/* load picture into buffer */
	load_file(palname, palbuf1, 768);		/* load palette into buffer */

	set_mode(0x13);					/* mode $13 for DEL! */

	fill_screen(0);					/* cls */
//	super_trip();						/* do fade fill (with solid) */


//	fill_screen(0);					/* cls */
//	set_palette(palbuf1, 0, 256);			/* init palette */
//	pic_trip(rawbuf);					/* do fade fill (with picture) */


//	load_file(picname2, rawbuf, 320*200);	/* load picture into buffer */
//	load_file(palname2, palbuf1, 768);		/* load palette into buffer */



	fademe(rawbuf,palbuf1,fadebuf);		/* demo the fade routine */

	convert_palette_to_hsv(palbuf1, hsvbuf, 256);
	make_palette_from_hsv(hsvbuf, palbuf2, 256);

	fademe(rawbuf,palbuf2,fadebuf);		/* demo the fade routine */


	set_mode(modestash);				/* restore DOS screen mode */
//	print_palette(palbuf1, hsvbuf, palbuf2, 256);


	free(hsvbuf);						/* free HSV buffer */
	free(fadebuf);						/* free faded palette buffer */
	free(palbuf2);						/* free palette buffer2 */
	free(palbuf1);						/* free palette buffer1 */
	free(rawbuf);						/* free picture buffer */
	return;							/* return back to DOS */
}



/**********************/
/**** SETMODE(num) ****/
/**********************/


void		set_mode(int num)
{

union	REGS		r;
struct	SREGS	sr;

	r.x.eax = 0x40;
	sr.ds = r.x.eax;
	r.h.ah = 0x00;				/* Function number ($0=setmode) */
	r.h.al = num;				/* Mode number in AL */
	int386( 0x10, &r, &r );
	return;
}

/**********************/
/****** GETMODE! ******/
/**********************/

int		getmode(void)
{

union	REGS		r;
struct	SREGS	sr;

	r.h.ah = 0x0f;				/* Function number ($f=getmode) */
	int386( 0x10, &r, &r );
	return( (int)r.x.eax );
}


/***************/
/* set_palette */
/***************/


void 	set_palette(char *palptr, int firstreg, int numcols)

{

union	REGS		r;
struct	SREGS	sr;

	r.h.ah = 0x10;					/* Function no ($10=palette cack) */
	r.h.al = 0x12;					/* Function no ($12=update cols) */
	r.x.ebx = firstreg;				/* first register */
	r.x.ecx = numcols;				/* number of colours */
	r.x.edx = palptr;				/* DX points to palette */
	int386( 0x10, &r, &r );			/* Go Go BIOS! */
	return;
}


/************************************/
/* FILL_SCREEN (what a top routine) */
/************************************/

void		fill_screen(char val)

{
char		*ptr;
int			i;

    /* Set the pointer to the screen's linear address */

    ptr = (char *)SCREEN_LIN_ADDR;
    for( i = 0; i < SCREEN_SIZE; i++ )
		{
		*ptr++ = val;
   		}

}

/**************/
/* super trip */
/**************/

void		super_trip(void)


{

int			size;
int			col;


	col = 4;

	for (size=231; size>=0; size--)
		{
		draw_circle(160,100,size,col);		/* in */
		delay(15);
		}

   	delay(1000);
	col = 0;

		for (size=0; size<232; size++)
		{
		draw_circle(160,100,size,col);		/* out */
		delay(15);
		}


}



/************/
/* PIC trip */
/************/
/* pass the address of the picture buffer to this routine... */
/*************************************************************/

void		pic_trip(char *picbuf)

{

int			size;

	for (size=231; size>=0; size--)
		{
		draw_circle_pic(160,100,size,picbuf);		/* in (with pic) */
		delay(15);
		}

	delay(1000);


		for (size=0; size<232; size++)
		{
		draw_circle(160,100,size,0);				/* out (to col 0) */
		delay(15);
		}
}



/********************************/
/* bresenham's circle algorithm */
/********************************/
/* twatted to do a screen fill nicer! */
/* sorted in C 29/06/94 at 11:51am (I'm starved!) */

void		draw_circle(int xc, int yc, int radius,int col)
{

int			x = 0;
int			y = radius;
int			p = 3 - (2*radius);

	do
		{
		plot_circle_points(x,y,xc,yc,col);

		if (p<0)
			{
			p = (p + (4*x) + 6);
			}
		else
			{
			p = (p + 4 * (x - y) + 10);
			}

		x++;
//		y--;						/** this looks coolish (remove)?? **/
		if (p < 0)
			{
			y--;
			}
		}

	while (x < y);

	if (x == y)
		{
		plot_circle_points(x,y,xc,yc,col);
		}

	return;
}


/***********************************************/
/* plot circle points (8way reflection method) */
/***********************************************/

void		plot_circle_points(int x, int y, int xc, int yc,int col)
{
	setpixel(xc + x, yc + y, col);
	setpixel(xc - x, yc + y, col);
	setpixel(xc + x, yc - y, col);
	setpixel(xc - x, yc - y, col);
	setpixel(xc + y, yc + x, col);
	setpixel(xc - y, yc + x, col);
	setpixel(xc + y, yc - x, col);
	setpixel(xc - y, yc - x, col);
	return;
}

/************/
/* SETPIXEL */
/************/

void		setpixel(int x, int y, int col)

{

char		*screenaddr;

	if ( (x>=0) && (x<320) && (y>=0) && (y<200) )		/* clipping! */

		{
		screenaddr = (char *)(SCREEN_LIN_ADDR+(x+(y*320)));
		*screenaddr = col;
		}

	return;
}






/********************************/
/* bresenham's circle algorithm */
/********************************/
/* updated to run with pictures at 15:30pm 29/06/94 */
/****************************************************/

void		draw_circle_pic(int xc, int yc, int radius,char *picbuf)
{

int			x = 0;
int			y = radius;
int			p = 3 - (2*radius);

	do
		{
		plot_circle_points_pic(x,y,xc,yc,picbuf);

		if (p<0)
			{
			p = (p + (4*x) + 6);
			}
		else
			{
			p = (p + 4 * (x - y) + 10);
			}

		x++;
//		y--;						/** this looks coolish (remove)?? **/
		if (p < 0)
			{
			y--;
			}
		}

	while (x < y);

	if (x == y)
		{
		plot_circle_points_pic(x,y,xc,yc,picbuf);
		}

	return;
}


/***********************************************/
/* plot circle points (8way reflection method) */
/***********************************************/
/* updated to use picture! */

void		plot_circle_points_pic(int x, int y, int xc, int yc,char *picbuf)
{
	setpixel_pic(xc + x, yc + y, picbuf);
	setpixel_pic(xc - x, yc + y, picbuf);
	setpixel_pic(xc + x, yc - y, picbuf);
	setpixel_pic(xc - x, yc - y, picbuf);
	setpixel_pic(xc + y, yc + x, picbuf);
	setpixel_pic(xc - y, yc + x, picbuf);
	setpixel_pic(xc + y, yc - x, picbuf);
	setpixel_pic(xc - y, yc - x, picbuf);
	return;
}

/****************/
/* SETPIXEL_PIC */
/****************/
/* updated to work with pictures! */
/**********************************/

void		setpixel_pic(int x, int y, char *picbuf)

{

char		*screenaddr;
int			offset;

	if ( (x>=0) && (x<320) && (y>=0) && (y<200) )		/* clipping! */

		{
		offset = (x+(y*320));						/* calc offset */
		screenaddr = (char *)(SCREEN_LIN_ADDR+offset);
		picbuf += offset;
		*screenaddr = *picbuf;						/* copy byte */
		}

	return;
}


/*********************************************************************/
/* find_length - Finds the length of a file
/*********************************************************************/

long int		find_length(char filename[])

{

int			handle;
long int		filelen=-1;

	handle = open( filename, O_RDONLY | O_BINARY );
	if( handle != -1)
		{
		filelen = ( filelength(handle) );
		close ( handle );
		}
	return ( filelen );
}

/*********************************************************************/
/* save_file - Saves a file (filename,address,size)
/*********************************************************************/


void		save_file(char filename[], char address[], int size)

{

int 		handle;
int			size_written=0;

	handle = open(filename,O_WRONLY|O_CREAT|O_TRUNC|O_BINARY, S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP);

	if (handle!=-1)
		{
		size_written=write(handle, address, size);

		if (size_written!=size)
			{
			printf("\nError writing file \"%s\" - Only wrote %d bytes\n",filename,size_written);
			}
		else
			{
			printf("\nSaved file \"%s\" (%d bytes)\n",filename,size_written);
			}

		close ( handle );
		}
	else
		{
		printf("Error opening file \"%s\" for save\n",filename);
		}

}

/*********************************************************************/
/* load_file - Loads a file (filename, address, max size)
/*********************************************************************/


void		load_file(char filename[], char address[], int size)

{

int			handle;
int			size_read;

	if ((handle = open (filename,O_RDONLY|O_BINARY)) != -1)
		{
		size_read=read(handle,address,size);
		if (size_read==-1)
			{
			printf("Error reading file \"%s\"\n",filename);
			}
		else
			{
			printf("Loaded file \"%s\" (%d bytes)\n",filename,size_read);
			}
		close ( handle );
		}
	else
		{
		printf("Error opening file \"%s\" for load\n",filename);
		}

}


/***************************************************************************/
/* Allocate_ram(size) - << just allocates ram and returns the pointer! */
/***************************************************************************/
/* Yo DEL! always prototype functions that return addresses..??! */


char *		allocate_ram( int size )
{

char 		*mem;

	mem = (char*)malloc( size );					/* allocate ram */

	if ( mem == NULL )							/* did we get it? */
		{
		printf("Failed to allocate $%0x bytes of RAM!\n",size);
		exit();
		}

	clearbuf(mem,size);							/* clear buffer */

	return( mem );								/* return ram address */

}


/*********************************************************************/
/** clearbuf(address,size) **/
/*********************************************************************/


void		clearbuf(char *address, int size)
{
int			i;


	for (i=0; i<size; i++)
		{
		*(address++) = 0;					/* fill buffer with 0's */
		}

	return;
}



/*****************************************************************/
/************* DELS HANDY FADER TYPE THING (IN C) ****************/
/*****************************************************************/
/* works (with a glitchy update) at 10:20am 30/06/94 */


void		fademe(char *picbuf, char *palbuf, char *fadebuf)
{

char		*screenaddr;
int			i;


	calcfade(palbuf,fadebuf,0);				/* set palette to black */

	screenaddr = (char *)SCREEN_LIN_ADDR;
	for (i=0; i<SCREEN_SIZE; i++)
		{
		*screenaddr++ = *picbuf++;			/* copy pic onto screen */
		}


	for (i=0; i<64; i++)					/* fade up loop */
		{
		calcfade(palbuf,fadebuf,i);			/* calc & update fade */
		delay(10);						/* a little pause */
		}

	delay(1500);

	for (i=63; i>=0; i--)					/* fade down loop */
		{
		calcfade(palbuf,fadebuf,i);			/* calc & update fade */
		delay(10);						/* a little pause */
		}

	return;
}


/**************************/
/******** calcfade ********/
/**************************/

void		calcfade(char *palbuf, char *fadebuf, int fadeval)
{
int			stash;
int			count;
char		*fadedpal = fadebuf;		/* stash address of fadebuf */

	for (count=0; count<768; count++)
		{
		stash = *palbuf++;				/* grab colour byte (R,G,B) */
		stash *= fadeval;  				/* multiply by fadevalue */
		*fadebuf++ = (char)(stash>>6);	/* stash colour ( >>6 ) */
		}

	set_palette(fadedpal, 0, 256);		/* update palette */

	return;
}


/************************************************************************/
/* convert_palette_to_hsv(palbuffer,hsvbuffer,numcols)                  */
/************************************************************************/
/* palbuf is a (char)buffer containing original palette data (R,G,B)    */
/* hsvbuffer is a (float)buffer to stash data into (H,S,V)              */
/* numcols should be obvious!                                           */
/************************************************************************/

void		convert_palette_to_hsv(char *palbuf, float *hsvbuf, int numcols)
{
int			i;
int			r,g,b;

	for (i=0; i<numcols; i++)
	 	{
		r = sortcol( *(palbuf++) );		/* get RED as value 0-100 */
		g = sortcol( *(palbuf++) );		/* get GREEN as value 0-100 */
		b = sortcol( *(palbuf++) );		/* get BLUE as value 0-100 */
		convert_rgb_to_hsv(r,g,b, hsvbuf);	/* convert to HSV */
		hsvbuf += 3;					/* next position in hsvbuf */
		}

	return;
}



/**************************************/
/** Convert RGB values to HSV values **/
/**************************************/
/** Converted from some CACK pascal code in my RED COMPUTER GFX BOOK! */
/** after about 35 mins of pissing around (I don't actually know pascal!) */
/** I sussed what the fuck was going on! (DEL - 30/06/94) */
/**********************************************************/
/* convert_rgb_to_hsv(red,green,blue) */
/* RGB values must be 0-100 */


void		convert_rgb_to_hsv	(int red, int green, int blue, float *hsvbuf)

{
float		r,g,b;
float		h,s,v;
float		m,rl,gl,bl;

	r = (float) red/100;
	g = (float) green/100;
	b = (float) blue/100;

	v = max(r,g,b);					/* set V */
	m = min(r,g,b);

	if (v != 0)
		{
		s = (v-m)/v;
		}
	else
		{
		s = 0;	  					/* set S */
		}


	if (s != 0)
		{
		rl = (v - r) / (v - m);			/* distance of col from red */
		gl = (v - g) / (v - m);			/* distance of col from green */
		bl = (v - b) / (v - m);			/* distance of col from blue */

		if (v == r)
			{
			if (m == g)
				{
				h = (5.0 + bl);
				}
			else
				{
				h = (1.0 - gl);
				}
			}

		if (v == g)
			{
			if (m == b)
				{
				h = (1.0 + rl);
				}
			else
				{
				h = (3.0 - bl);
				}
			}

		if ( (v != r) && (v != g) )		/* if above two cases not met */
			{
			if (m == r)
				{
				h = (3.0 + gl);
				}
			else
				{
				h = (5.0 - rl);
				}
			}


		h *= 60.0;					/* convert to degrees */
		if ( h == 360)					/* 360 degrees? */
			{
			h = 0;					/* zero degrees! */
			}
		}

	else
		{
		h = 0;						/* h is undefined */
		}

	*hsvbuf++ = h;						/* stash HUE */
	*hsvbuf++ = s;						/* stash SATURATION */
	*hsvbuf++ = v;						/* stash VALUE */

	return;
}



/************************************************************************/
/* make palette from HSV values!                                        */
/************************************************************************/
/* hsvbuffer is a (float)buffer containing HSV data!                    */
/* palbuf is a (char)buffer to stash RGB palette in!                    */
/* numcols should be obvious!                                           */
/************************************************************************/


void		make_palette_from_hsv(float *hsvbuf, char *palbuf, int numcols)

{
float		h,s,v;
int			i;

	for (i=0; i<numcols; i++)
		{

		h = *(hsvbuf++);			/* get HUE */
		s = *(hsvbuf++);			/* get SATURATION */
		v = *(hsvbuf++);			/* get VALUE */

		s=s*0.5;					/* QUARTER SATUARTION! */

		v += .25;
		if (v>1)
			{
			v=1;
			}

		h = h+240;
		if (h>=360)
			{
			h -= 360;				/* fuck with HUE! */
			}

		convert_hsv_to_rgb(h, s, v, palbuf);
		palbuf += 3;

		}

	return;
}



/***********************/
/** HSV TO RGB VALUES **/
/***********************/
/*** Ok... Del is really on form now..! let's see if we can convert the */
/*** values back from HSV to RGB... (sounds easy...? well it is actually) */
/**************************************************************************/
/** working at 09:43am 01/07/94 **/
/*********************************/

void		convert_hsv_to_rgb(float h, float s, float v, char *palbuf)

{
float		r,g,b;
float		p1,p2,p3;
float		f;
int			i;

int		cock;


	if ( h == 360 )
		{
		h = 0;
		}
	h = h / 60.0;	  			/* convert h from degrees */

	i = floor(h);				/* i = greatest integer <=h */
	f = (float) (h - i);		/* f = fractional part of h */

	p1 = v * (1.0 - s);
	p2 = v * (1.0 - (s * f));
	p3 = v * (1.0 - (s * (1.0 - f)));


	switch (i)
		{

		case (0):
			{
			r = v;
			g = p3;
			b = p1;
			break;
			}

		case (1):
			{
			r = p2;
			g = v;
			b = p1;
			break;
			}

		case (2):
			{
			r = p1;
			g = v;
			b = p3;
			break;
			}

		case (3):
			{
			r = p1;
			g = p2;
			b = v;
			break;
			}

		case (4):
			{
			r = p3;
			g = p1;
			b = v;
			break;
			}

		case (5):
			{
			r = v;
			g = p1;
			b = p2;
			break;
			}

		}


	cock = roundme(r*100);
	cock = unsortcol(cock);
	*palbuf++ = (char)cock;

	cock = roundme(g*100);
	cock = unsortcol(cock);
	*palbuf++ = (char)cock;

	cock = roundme(b*100);
	cock = unsortcol(cock);
	*palbuf++ = (char)cock;				/* stash cols in buffer */

//	printf("GOT RGB VALUE %d,%d,%d\n\n\n",roundme(r*100), roundme(g*100), roundme(b*100) );

	return;
}




/***************************************************************************/
/***************************************************************************/
/***************************************************************************/


void		print_palette(char *palbuf1, float *hsvbuf, char *palbuf2, int numcols)
{
int			i;
float		r,g,b;
float		r2,g2,b2;
float		h,s,v;

	for (i=0; i<numcols; i++)
		{

		r = sortcol( *(palbuf1++) );		/* get RED as value 0-100 */
		g = sortcol( *(palbuf1++) );		/* get GREEN as value 0-100 */
		b = sortcol( *(palbuf1++) );		/* get BLUE as value 0-100 */

		r2 = sortcol( *(palbuf2++) );		/* get RED as value 0-100 */
		g2 = sortcol( *(palbuf2++) );		/* get GREEN as value 0-100 */
		b2 = sortcol( *(palbuf2++) );		/* get BLUE as value 0-100 */

		h = *(hsvbuf++);				/* get HUE */
		s = *(hsvbuf++);				/* get SATURATION */
		v = *(hsvbuf++);				/* get VALUE */

		h = (h*100)/360;				/* sort into percentage value! */
		s *= 100;
		v *= 100;

		printf("RGB = %3d,%3d,%3d",roundme(r),roundme(g),roundme(b));
		printf("\tHSV = %3d,%3d,%3d",roundme(h),roundme(s),roundme(v));
		printf("\tRGB = %3d,%3d,%3d\n",roundme(r2),roundme(g2),roundme(b2));

		if ( roundme(r) != roundme(r2) )
			{
			printf("ERROR!\n");			/* red error? */
			exit();
			}

		if ( roundme(g) != roundme(g2) )
			{
			printf("ERROR!\n");			/* green error? */
			exit();
			}

		if ( roundme(b) != roundme(b2) )
			{
			printf("ERROR!\n");			/* blue error? */
			exit();
			}

		}

	return;
}


/***********************************************************/
/* SORTCOL(val)                                            */
/***********************************************************/
/* sorts colours to be DPAINT 0-100 style from 0-63        */
/***********************************************************/

int			sortcol(int val)

{

float	piss;

	if (val != 0)					/* colour not zero? */
		{
		val++;					/* colour + 1 */
		}
	piss = (float)val;
	piss = (piss*100.0)/64.0;		/* multiply by 100 and divide by 64 */
	val = roundme(piss);			/* round colour to nearest! */

	return(val);					/* return colour as 0-100 */

}


/***********************************************************/
/* UNSORTCOL(val)                                          */
/***********************************************************/
/* sorts colours to be 0-63 from DPAINT 0-100 style        */
/***********************************************************/

int			unsortcol(int val)

{

	if (val != 0)					/* colour not zero? */
		{
		val--;					/* colour - 1 */
		}
	val *= 64;					/* multiply by 64 */
	val /= 100;					/* divide by 100 */

	return(val);					/* return colour as 0-63 */
}

/***************************************************/
/* round floating point figure to nearest integer! */
/***************************************************/
/* not built for minus numbers really is it DEL??! */
/***************************************************/

int			roundme(float num)
{

int			i;
float		f;

	i = floor(num);				/* i = greatest integer <=num */
	f = num - i;					/* f = fractional part of num */
	if ( f >= 0.5 )
		{
		i++;						/* round int up a digit! */
		}
	return(i);					/* return integer */
}

/****************************/
/* Del's handy max routine? */
/****************************/

float		max(float v1, float v2, float v3)

{
float		max;

	max = (v1 > v2) ? v1 : v2;		/* max = biggest v1 or v2 */
	max = (max > v3) ? max : v3;		/* max = biggest max or v3 */
	return(max);
}

/****************************/
/* Del's handy min routine? */
/****************************/

float		min(float v1, float v2, float v3)

{
float		min;

	min = (v1 < v2) ? v1 : v2;		/* min = smallest v1 or v2 */
	min = (min < v3) ? min : v3;		/* min = smallest min or v3 */
	return(min);
}
