#include	"shell.h"
#include	"frames.h"

typedef	signed	short	sword;	/* Signed word 16 bits		*/
typedef	signed	long		sdword;	/* Signed longword 32 bits 	*/
typedef	unsigned 	short	word; 	/* Unsigned word 16 bits   	*/
typedef	unsigned 	long		dword;	/* Unsigned longword 32 bits */

typedef	signed	short	sint16;	/* PHD.def signed word 		*/
typedef 	signed	int		sint32;	/* PHD.def signed longword 	*/
typedef	unsigned 	short	uint16;	/* PHD.def unsigned word 	*/
typedef	unsigned 	int		uint32;	/* PHD.def unsigned longword 	*/

typedef	unsigned 	char		uchar;
typedef	unsigned 	short	ushort;
typedef	unsigned 	int		uint;
typedef	unsigned 	long 	ulong;

#define	MAX_ANG	0x7ff

#define	SCRXSZ	320
#define	SCRYSZ	200

#define	SCRXORG	160
#define	SCRYORG	64

#define	CLPX1	16
#define	CLPY1	000
#define	CLPX2	303
#define	CLPY2	127

#define	GSCRYST	0
#define	GSCRYHT	128

#define	PERSP	256
#define	PERSP2	8

#define	VIEWD	64
#define	FLRSIZE	VIEWD*256
#define	MAPSIZE	128

#define	YSCL		8

#define	TEXTPOLY	0
#define	TEXTTRI	1
#define	FLATPOLY	2
#define	FLATTRI	3
#define	SPRITE	4

#define	MAXOBJ	256

#define 	DEP_LOW	94

/************************************/
/* Animation and movement commands. */
/************************************/

#define 	AFRAME   	1
#define 	ACOUNT 	2
#define 	MSPEED 	3
#define 	MCOUNT 	4
#define  	AJUMP	5
#define 	MJUMP	6
#define 	KILL_TRIG 7
#define 	END_MOVE 	8
#define 	END_ANIM	9

extern	long		dl_objs,dl_text0;


extern	long		globx;
extern	long		globy;
extern	long		globscale;
extern	long		globsprs;
extern	long		globflip;


extern	SETUP	game_setup;

extern	sint16	*boardobject;
extern	sint16	*boardanim;

extern	long		ranstore6,ranstore7;

extern	long		scaletab[];

extern 	uchar 	black[768];
extern 	uchar 	palette[768];
extern 	uchar	*screen;
extern 	uchar	*graphics;
extern	uchar	*simplify_map;

extern	short	level;
extern	short	sintab[];

struct	camera_vars
{
	int	p_xpos;
	int	p_ypos;
	int	p_zpos;
	int	p_xang;
	int	p_yang;
	int	p_zang;
};

struct flrptsstr
{
	long	flrx;
	long	flry;
	long	flrz;
	long flrsx;
	long flrsy;
	long	flrh;
	long	flrout;
	long	flrshade;
	long	flrshade2;
	long	flrtexptr;
};

struct drawliststr
{
	uchar	dltype;	// 0=Text4; 1=Text3; 2=Flat4 ; 3=Flat3; 4=Sprite
	long		dlrot;
	//long		dldistx;
	//long		dldistz;
	long		dlx1;
	long		dlx2;
	long		dlx3;
	long		dlx4;
	long		dly1;
	long		dly2;
	long		dly3;
	long		dly4;
	uchar	dlgval1;
	uchar	dlgval2;
	uchar	dlgval3;
	uchar	dlgval4;
	long		dlcol;
};

struct sortliststr
{
	long	slptr;
	long	slz;
};

struct outpolystr
{
	short	xy[8];
	char		type;
	char		tn;
	char		gourrad[4];
};

struct objliststr
{
	short	objon;   		/* 0 - not triggered, 1 - triggered. */
	long		objx;         	/* X position. */
	long		objy;          /* Y position. */
	long		objz;          /* Z position. */
	long		objox;         /* Old X position. */
	long		objoy;         /* Old Y position. */
	long		objoz;         /* Old Z position. */
	long		objxv;         /* X velocity. */
	long		objyv;         /* Y velocity. */
	long		objzv;         /* Z velocity. */
	short	obj_def;      	/* Graphics animation frame. */
	short	obj_amptr;    	/* Animation / movement routine. */
	short	obj_aoff;     	/* Offset into animation table. */
	short	obj_acnt;      /* Anim frame count. */
	short	obj_moff;     	/* Offset into movement table. */
	short	obj_mcnt;      /* Movement count. */
	long		obj_work1;     /* Work variable 1. */
	long		obj_work2;     /* Work variable 2. */
	long		obj_work3;     /* Work variable 3. */
	long		obj_work4;     /* Work variable 4. */
	uchar	*obj_trigptr;	/* Pointer to trigger flag byte. */

};

struct sprblock
{
		ushort 	t_xsize;				/* X size (in pixels). */
		short  	t_scr_xpos;  		/* Screen X position. */
		short  	t_scr_ypos;  		/* Screen Y position. */
	  uint   	t_xscale;	 			/* X Scaling factor. */
	  uint   	t_yscale;  			/* Y Scaling factor. */
	  ushort  t_xloop;  			/* X loop count. */
	  ushort  t_yloop;  			/* Y loop count. */
		uint		t_init_xscale;	/* Clipped start X scale value. */
		uint		t_init_yscale;	/* Clipped start Y scale value. */
		uint		t_dataoff;			/* Sprite graphic data offset. */
		ushort	t_ylines;				/* Sprite graphic data offset. */
};

extern	long		base_alt;
extern	long		yscale;
extern	short	vbls;

extern	struct	objliststr	objlist[];
extern	struct	camera_vars	cam;
extern 	struct	flrptsstr 	flrpts[];
extern 	struct	outpolystr 	outpolyg[];
extern 	struct	drawliststr 	drawlist[];
extern 	struct	sortliststr 	sortlist[];
extern	struct	objliststr	objlist[];
extern	struct	sprblock		spb;

extern 	uchar	*floormap;
extern 	long		*textmap;
extern 	uchar	*textmem;

extern	uchar	*spr_data;
extern	uchar	*spr_nets;
extern	uchar	*trigger_map;
extern	uchar	*obj_map;
extern	uchar	*draw_line_tb;
extern	uchar	*draw_line1;
extern	uchar	*draw_line2;
extern	uchar	*graphics_addr;
extern	uchar	*depth_tab;

extern	long		dumpdta;
extern	long		dumplen;
extern	long		nolines;
extern	uchar	*dumpsrc;
extern	uchar	*dumpdst;
extern	uchar	*backdropgfx;

extern	long		downhillang;

extern 	long		speed;
extern 	long		floorang;
extern 	long		altitude;
extern 	long		floorheight;
extern 	long		updownang;
extern 	long		udang;

extern 	long		flrxoff;
extern 	long		flrzoff;
extern 	long		flrxpos;
extern 	long		flrzpos;

extern	long		viewd;

extern 	long		dlptr;
extern 	long		slptr;

extern 	int		windowwidth;
extern 	int		windowheight;
extern 	int		windowxmax;
extern 	int		windowymax;
extern 	int		screenwidth;
extern 	uchar	*windowptr;

extern 	short	coord[];
extern 	int		rotatab[];

extern 	char		sprite_xs[];
extern 	char		sprite_ys[];
extern 	char		sprite_ox[];
extern 	char		sprite_oy[];
extern 	char		*sprite_mem[];

extern 	int		tx_st_tab[];
extern 	int		ty_st_tab[];
extern 	int		txadd_tab[];
extern 	int		tyadd_tab[];

extern 	int		xtab_x[];
extern 	int		xtab_tx[];
extern 	int		xtab_ty[];
extern 	int		xtab_gx[];

extern 	uchar	depthq[];
extern 	uchar	int_tab[];

extern 	char		*scrbase , *rad_mem;

extern 	int		px , py , pz;
extern 	short	min_x , max_x , min_y , max_y;
extern 	int		xclip , yclip , tri_rev;

extern 	uchar	*texture_lookup[];

extern	long		cam_ang_vel,cam_vel_vel,ludang,tudang,cam_diff,pturn;


/*********************************/
/*****  FUNCTION PROTOTYPES  *****/
/*********************************/

/* 	MAIN.C	*/

void main(void);

/* 	INITLEV.C	*/

void init_lev(void);

/* 	UTILS.C	*/

void convert_pal(uchar *pal_ptr);
void fade_to_black(void);
void	load_maps(void);
long get_angle(long x1, long y1, long x2, long y2);
void	line_draw(long x1,long y1,long x2,long y2,uchar col);

/* 	PLYRCTRL.C	*/

void	player_control(void);
long	get_floorheight(long xpos , long zpos);

/* 	FLOOR.C	*/

void calc_floortext(void);
void	draw_polygons(void);
void	sortpoly_list_backtofront(void);
void	sortpoly_list_fronttoback(void);
void	do_quickysort1(long left,long right);
void	do_quickysort2(long left,long right);

/* 	WPRSETUP.C	*/

void wpr_setup(void);
void	init_tex_lookup(void);

/* 	WPR.C	*/

void my_main(void);

/* 	SPRITE.C	*/

void	scale_sprite(int xpos,int ypos,int scale,int def,uchar shade,uchar flip,uchar *gfx,uchar *net);

/* 	OBJECTS.C	*/

void 	calc_objlist(void);
void 	anim_sprs(void);
void 	move_sprs(void);
short	find_free_slot(long start, long end);
void 	kill_trigger(void);
void 	trigger_from_objmap(void);
void 	table_anim(short *aptr);
void 	table_move(short *mptr);
void 	trigger_object(short type,long txpos,long tzpos);

/*	AUTILS.ASM	*/

long	_random(void);

/*************************************************/
/*************************************************/
/**                                             **/
/**           PAUL'S 3D SYSTEM STUFF.           **/
/**                                             **/
/*************************************************/
/*************************************************/

#define	ZCLIP  		(16*65536)
#define 	ZCLIPDIV		(ZCLIP/256)
#define	MAX_VERTICES	8000                // maximum vertices
#define 	MAX_POLYGONS	8000                // maximum number of polygons

#define 	MAX_SCANLINES	482				// maximum height of screen

extern	long		game_on;

extern	char	*windowptr;                 	// pointer to 3d window

extern	sint32	my_perspective;		// perspective...

extern	sint32	windowxmax,windowymax;	// window size vars...
extern	sint32	windowxorg,windowyorg;
extern	sint32	windowxmid,windowymid;
extern	sint32	windowwidth,windowheight;
extern	sint32	screenwidth;

extern	sint32	on_screen;				// flags to note if object is visible
extern	sint32	need_z_clip;				// or object needs Z-clipping

extern	sint16	*objptr;					// pointer to 3D object structure

extern	sint32	w2v_matrix[3][4];			//  these are global matrices
extern	sint32	obj_matrix[3][4];
extern	sint32	o2v_matrix[3][4];
extern	sint32	ani_matrix[3][4];

extern	sint32	ls_vector_world[3];			// unit length light source vectors
extern	sint32	ls_vector_view[3];

extern  	sint32	gourxbuf[MAX_SCANLINES][4];
extern	sint32	vertice_buffer[MAX_VERTICES][6];


extern	sint32	surfacenum;				// polygon list sorting stuff...
extern	sint16	*info3dptr;
extern	sint32	*sort3dptr;

extern	sint32	sort3d_buffer[MAX_POLYGONS][2];
extern	sint16	info3d_buffer[MAX_POLYGONS*8];

struct 	phdtexturestruct
{
		char	*ptr;
		sint32	width;
		sint32	height;
};

extern	struct	phdtexturestruct phdtextinfo[];

extern	char		depthq_table[][256];

/*****************************************************************************
******************************************************************************
* 			  Surface Drawing definitions here......
******************************************************************************
*****************************************************************************/

extern	void draw_poly_null( sint16 *iptr );  // polygon drawing routines..
extern	void draw_flat_poly( sint16 *iptr );
extern	void	draw_poly_t3( sint16 *iptr );
extern	void	draw_poly_t4( sint16 *iptr );
extern	void	draw_poly_g3( sint16 *iptr );
extern	void	draw_poly_g4( sint16 *iptr );
extern	void	draw_poly_tm3( sint16 *iptr );
extern	void	draw_poly_tm4( sint16 *iptr );
extern	void	draw_poly_gtm3( sint16 *iptr );
extern	void	draw_poly_gtm4( sint16 *iptr );
extern	void	draw_poly_igtm3( sint16 *iptr );
extern	void	draw_poly_igtm4( sint16 *iptr );
extern	void	draw_poly_line( sint16 *iptr );
extern	void	draw_poly_tmphd4( sint16 *iptr );
extern  	void	draw_poly_tmphd4lit( sint16 *iptr );

extern	void ins_poly_null( void );      // polygon insertion routines..
extern	void ins_poly_f3( void ); 	   // these all assume no z-clipping
extern	void	ins_poly_f4( void );
extern	void	ins_poly_t3( void );
extern	void	ins_poly_t4( void );
extern	void	ins_poly_g3( void );
extern	void	ins_poly_g4( void );
extern	void	ins_poly_tm3( void );
extern	void	ins_poly_tm4( void );
extern	void	ins_poly_gtm3( void );
extern	void	ins_poly_gtm4( void );
extern	void	ins_poly_igtm3( void );
extern	void	ins_poly_igtm4( void );
extern	void	ins_poly_line( void );
extern	void	ins_poly_hideline( void );
extern	void	ins_poly_tmphd4( void );
extern	void	ins_poly_tmphd4lit( void );

extern	void ins_polyz_null( void);      // polygon insertion routines..
extern	void ins_polyz_f3( void ); 	   // these all z-clipping
extern	void	ins_polyz_f4( void );
extern	void	ins_polyz_t3( void );
extern	void	ins_polyz_t4( void );
extern	void	ins_polyz_g3( void );
extern	void	ins_polyz_g4( void );
extern	void	ins_polyz_tm3( void );
extern	void	ins_polyz_tm4( void );
extern	void	ins_polyz_gtm3( void );
extern	void	ins_polyz_gtm4( void );
extern	void	ins_polyz_igtm3( void );
extern	void	ins_polyz_igtm4( void );
extern	void	ins_polyz_line( void );
extern	void	ins_polyz_hideline( void );
extern	void	ins_polyz_tmphd4( void );
extern	void	ins_polyz_tmphd4lit( void );

#define	POLY_NULL					0
#define	POLY_FLAT3				1		// types of polygon surfaces....
#define	POLY_FLAT4				2
#define	POLY_TRANSPARENT3			3
#define	POLY_TRANSPARENT4			4
#define 	POLY_GOURAUD3				5
#define	POLY_GOURAUD4				6
#define	POLY_TEXTUREMAP3	   		7
#define	POLY_TEXTUREMAP4	   		8
#define	POLY_GOURAUDTEXTUREMAP3		9
#define	POLY_GOURAUDTEXTUREMAP4		10
#define	POLY_INTGOURAUDTEXTUREMAP3	11
#define	POLY_INTGOURAUDTEXTUREMAP4	12
#define	POLY_LINE					13
#define 	POLY_HIDELINE				14
#define 	POLY_TMPHD4				15
#define 	POLY_TMPHD4LIT				16

extern	void	(*poly_draw_routines[])();			// Jump tables for different
extern	void	(*poly_insert_routines[])();        // polygon types
extern	void	(*poly_insert_routineszclip[])();


