Stunts by Broderbund: How to Tune a Car?

A car consists of four files in this game: CAR????.RES, STDA????.PVS,
STDB????.PVS, and ST????.P3S. The CAR file contains the technical data.
The STDA files hold the dashboard, steering wheel, and gear shifter base
plate graphics. The STDB files contain only the gear shifter knobs.
Finally, the ST files contain the vector data used to draw each 3D car
image. These files exist for each car (the ???? stands for VETT, COUN,
AUDI, ANSX, ... - ie. the car name abbreviations).

I examined the CAR files a bit last night, and found out quite a bit of
the way Stunts makes up a car. The following is a list of the easily
figured bytes and bits in the CAR*.RES files, and what they do. All
combinations do not work - for example, if you want to lift max. rpm up
to 12.000, you'll need to fix the power curve up there, too, or the
thing won't work. (BTW, max. rpm top is 13000, and no more gears than 6
are allowed - there's no room for more in the car config file... *sob*)

A couple of interesting tips: drop the aerodynamic resistance to 1 and
see what happens! Or, change byte 29H to F0 or the like, and try to
brake...

The ratios are expressed as 10.000 to x - ie. first gear might be
something like 29000 (in decimal), meaning 1:2.9 ratio. I'm not quite
sure of the meanings of all figures, but the listing below shows what I
would assume them to be.

So, here they are - examine and have fun! (And if someone ends up
writing a proper editor for these, I would appreciate a copy :)

Hex
offset
on file     Purpose
-----------------------------------
00-19       Don't touch!
1A-1B       rpm?
1E-1F       rpm?
26-27       # of gears (5 or 6)
28-29       aerodynamic resistance
2A-2B       braking effectiveness
2C-2D       idle rpm
2E-2F       max. torque rpm
30-31       max. power rpm
32-33       max. rpm
36-37       gear #1 ratio
38-39       gear #2 ratio
3A-3B       gear #3 ratio
3C-3D       gear #4 ratio
3E-3F       gear #5 ratio
40-41       gear #6 ratio (if avail.)
42-45       #1 shifter position
46-49       #2 shifter position
4A-4D       #3 shifter position
4E-51       #4 shifter position
52-55       #5 shifter position
56-59       #6 shifter position (i.a.)
5A-5F       ???
60-C7       power curve
            (1 byte/ 125 rpm)
C8-10F      ???
110-223     speedometer needle movement
224-229     ???
22A-32D     rev meter needle movement
32E-3A2     text data (']' == CR)
