#include <stdlib.h>
#include <stdio.h>
#include <string.h>


#define MIN_ROMSIZE 2*1024*1024
#define MAX_ROMSIZE 4*1024*1024

#define MAX_NUM 16

char buf[MAX_ROMSIZE];	
int buf_pos = 0;

int fsize[MAX_NUM];

int main(int argc, char *argv[])
{
	int sum = 0;

	if(argc < 3)
	{
		printf("Usage: ./gbrominjector output.vb rom0.gb rom1.gb ... romX.gb\n");
		return 0;
	}
	if(argc > MAX_NUM + 2)
	{
		fprintf(stderr, "Too many files specified!\n");
		return 0;
	}



	FILE* input = fopen("gbemu.bin","rb");
	if(input == NULL){
		fprintf(stderr, "Can't open gbemu.bin !\n");
		exit(1); 
	}

	fseek(input, 0 , SEEK_END);
	int file_size = ftell(input);
	if(file_size > MAX_ROMSIZE){
		fprintf(stderr, "Max file size exceeded!\n");
		exit(1); 
	}
	rewind(input);
	
	int r = fread(buf, 1, file_size, input);
	if(file_size != r){
		fprintf(stderr, "Failed reading file gbemu.bin! %i bytes read, but %i expected!\n",r,file_size);
		exit(1); 
	}
	fclose(input);
	fsize[0] = file_size;
	sum += file_size;

	for(int i=2; i<argc; i++)
	{
		input = fopen(argv[i],"rb");
		if(input == NULL){
			fprintf(stderr, "Can't open file %s!\n", argv[i]);
			exit(1); 
		}
		fseek(input, 0 , SEEK_END);
		fsize[i-1] = file_size = ftell(input);

		if(sum > MAX_ROMSIZE){
			fprintf(stderr, "Max file size exceeded!\n");
			exit(1); 
		}
		rewind(input);

		int r = fread((buf+sum), 1, file_size, input);
		if(file_size != r){
			fprintf(stderr, "Failed reading file %s! %i bytes read, but %i expected!\n",argv[i],r,file_size);
			exit(1); 
		}
		fclose(input);
		
		sum += file_size;
	}

	sum += 544; // vb header

	while(sum & (sum -1)) sum++;

	if(sum < MIN_ROMSIZE)
		sum = MIN_ROMSIZE;


	if(sum > MAX_ROMSIZE){
			fprintf(stderr, "Max file size exceeded!\n");
			exit(1); 
	}


	memcpy(buf+sum-544,buf+fsize[0]-544,544); //copy header

	int tmp_s = 0x07000000;
	int i;
	char* p;
	for(i=0; i< argc - 2; i++)
	{
		tmp_s += fsize[i];

		p = buf+sum-544-4-i*4;
	
		p[0] =  tmp_s 		 & 0xFF;
		p[1] = (tmp_s >>  8) & 0xFF;
		p[2] = (tmp_s >> 16) & 0xFF;
		p[3] = (tmp_s >> 24) & 0xFF;
	}

	p = buf+sum-544-4-i*4;
	p[0] = p[1] = p[2] = p[3] = 0;


	FILE* output = fopen(argv[1],"wb+");
	if(output == NULL){
		fprintf(stderr, "Can't open output file %s!\n", argv[1]);
		exit(1); 
	}
	
	if(sum != fwrite(buf, 1, sum, output)){
		fprintf(stderr, "Write to output file %s failed!\n", argv[1]);
		exit(1); 
	}
	fclose(output);


	return 0;
}
